
CREATE DATABASE mymusic;

GRANT SELECT,INSERT,UPDATE,DELETE,CREATE,DROP 
   ON mymusic.* 
   TO mymusic@localhost 
   IDENTIFIED BY 'mymusic';

USE mymusic;

CREATE TABLE artists (id int not null default 0 auto_increment primary key,
                      name char(60) not null);

CREATE TABLE albums(id int not null default 0 auto_increment primary key, 
                    artist int not null, 
                    name char(60) not null);

CREATE TABLE songs (id int not null default 0 auto_increment primary key, 
                    artist int not null, 
                    album int not null, 
                    title char(60) not null, 
                    comment char(60), 
                    filename varchar(255) not null, 
                    length TIME not null, 
                    votes int(10) unsigned NOT NULL default 0, 
                    album_index int not null default 0);

CREATE TABLE history(id int not null default 0 auto_increment primary key, 
                     song int not null, 
                     played datetime);


CREATE TABLE queue(time DATETIME,song_id INT NOT NULL);

CREATE TABLE nowplaying(song_id INT UNSIGNED NOT NULL);

CREATE TABLE control (state ENUM('playing','stopped','off') NOT NULL DEFAULT 'off');

INSERT INTO control VALUES('playing');
