/*
WebAd 1.11        adgoto.c
Copyright (c) 1999, Mittenda AB. - All rights reserved
webmaster@finechoice.com
http://www.finechoice.com/wa

License Agreement
-------------------------------------------------------------------------
You should carefully read all of the following terms and conditions before
using this software. Your use of this software indicates your acceptance
of this license agreement and warranty.
This software is owned by Mittenda AB and is protected by copyright laws
and international treaty provisions. You may not remove the copyright
notice from any copy of the software or any copy of the materials
accompanying the software.

Permitted Uses
-------------------------------------------------------------------------
You may use the evaluation version only at one server for a time limited of
30 days. After that, however, you must either obtain a registered copy, or
discontinue use of the product.
You may use the licensed version on one domain and on one server into a
single cgi-bin directory only.

Evaluation Version Limitations
-------------------------------------------------------------------------
The evaluation version is limited to a maximum of 2 zones and will display
a banner back to the WebAd site every 30th time one of your banners are
supposed to be displayed.

Modification
-------------------------------------------------------------------------
You are not permitted to modify or copy any segment of the code provided,
except for the "config.h" file, without consent from Mittenda AB.

Distribution
-------------------------------------------------------------------------
You may not charge or request any form of payment from any copies you may
make of this program. You may not distribute this product alone or with any
other products without written permission from Mittenda AB.

Disclaimer of Warranty
-------------------------------------------------------------------------
THE INFORMATION AND CODE PROVIDED IS PROVIDED AS IS WITHOUT WARRANTY OF ANY
KIND, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. IN NO
EVENT SHALL MITTENDA AB BE LIABLE FOR ANY DAMAGES WHATSOEVER INCLUDING
DIRECT, INDIRECT, INCIDENTAL, CONSEQUENTIAL, LOSS OF BUSINESS PROFITS OR
SPECIAL DAMAGES, EVEN IF MITTENDA AB HAS BEEN ADVISED OF THE POSSIBILITY OF
SUCH DAMAGES.
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include "config.h"

char zfile[100];
char z[9], b[9] , bannername[13], zonename[13];

struct tm *current_time;
struct zonfile
{
  char banner[9];
  unsigned long totexp;
  unsigned long totclick;
  unsigned long dayexp;
  unsigned int dayclick;
  char active[2];
  int lastday;
  int lastyear;
};

struct bannerdata
{
  char name[9];
  char redirecturl[201];
  char extrafunc[61];
  char alt[61];
  int border;
  char location[201];
  int width;
  int height;
  char text[61];
  int textsize;
} banner;         


typedef struct
{
  char name[128];
  char val[1024];
} entry;

entry entries[1000];
int NUM_ENTRIES;
int VIA_SHELL;

void getword(char *word, char *line, char stop)
{
  int x, y;
  
  for(x = 0; ((line[x]) && (line[x] != stop)); x++)
    word[x] = line[x];
  
  word[x] = '\0';
  if (line[x])
    ++x;
  y=0;
  
  while (line[y++] = line[x++]);
}

char *makeword(char *line, char stop)
{
  int x,y;
  char *word = (char *) malloc(sizeof(char) * (strlen(line) + 1));

  for(x = 0; ((line[x]) && (line[x] != stop)); x++)
    word[x] = line[x];

  word[x] = '\0';
  if (line[x])
    ++x;
  y=0;

  while (line[y++] = line[x++]);

  return word;
}

char *fmakeword(FILE *f, char stop, int *cl)
{
  int wsize;
  char *word;
  int ll;
  
  wsize = 102400;
  ll=0;
  word = (char *) malloc(sizeof(char) * (wsize + 1));
  
  while (1)
    {
      word[ll] = (char)fgetc(f);
      if (ll==wsize)
	{
	  word[ll+1] = '\0';
	  wsize += 102400;
	  word = (char *)realloc(word,sizeof(char)*(wsize+1));
        }
      --(*cl);
      if ((word[ll] == stop) || (feof(f)) || (!(*cl)))
	{
	  if (word[ll] != stop)
	    ll++;
	  word[ll] = '\0';
	  return word;
        }
      ++ll;
    }
}

char x2c(char *what)
{
  register char digit;
  
  digit = (what[0] >= 'A' ? ((what[0] & 0xdf) - 'A')+10 : (what[0] - '0'));
  digit *= 16;
  digit += (what[1] >= 'A' ? ((what[1] & 0xdf) - 'A')+10 : (what[1] - '0'));
  return (digit);
}

void unescape_url(char *url)
{
  register int x,y;

  for (x=0, y=0; url[y]; ++x, ++y)
    {
      if ((url[x] = url[y]) == '%')
	{
	  url[x] = x2c(&url[y+1]);
	  y+=2;
        }
    }
  url[x] = '\0';
}

void plustospace(char *str)
{
  register int x;

  for (x=0; str[x]; x++)
    if (str[x] == '+')
      str[x] = ' ';
}

void cgiinit(void)
{
  register int x;
  int cl;
  char * qcl;

  if (getenv("REQUEST_METHOD") == NULL)
    {
      VIA_SHELL = 1;
      NUM_ENTRIES = 0;
    }
  else
    {
      VIA_SHELL = 0;

      if (strcmp(getenv("REQUEST_METHOD"),"POST") == 0)
	{
	  if(strcmp(getenv("CONTENT_TYPE"),
		    "application/x-www-form-urlencoded"))
	    {
	      printf("Content-type: text/html\n\n");
	      printf("<h1>Incorrect Type</h1>\n");
	      printf("Type must be 'application/x-www-form-urlencoded'.\n");

	      exit(0);
	    }

	  cl = atoi(getenv("CONTENT_LENGTH"));

	  for (x = 0; cl && (!feof(stdin)); x++)
	    {
	      NUM_ENTRIES = x;
	      strcpy(entries[x].val, fmakeword(stdin,'&',&cl));
	      plustospace(entries[x].val);
	      unescape_url(entries[x].val);
	      strcpy(entries[x].name, makeword(entries[x].val,'='));
	    }
	}
      else if (strcmp(getenv("REQUEST_METHOD"),"GET") == 0)
	{
	  qcl = getenv("QUERY_STRING");
	  if (qcl == NULL)
	    exit(0);

	  for (x = 0; qcl[0] != '\0'; x++)
	    {
	      NUM_ENTRIES = x;
	      getword(entries[x].val, qcl, '&');
	      plustospace(entries[x].val);
	      unescape_url(entries[x].val);
	      getword(entries[x].name, entries[x].val, '=');
	    }
	}
      else
	{
	  printf("Content-type: text/html\n\n");
	  printf("<h1>Unknown method</h1>\n");
	  printf("The form was submitted with an unknown method!\n");

	  exit(0);
	}
    }
}

void getentry(char * buf, char *s)
{
  int x;

  strcpy(buf,"");

  if (VIA_SHELL == 0)
    {
      for (x = 0; x <= NUM_ENTRIES; x++)
	if (strcmp(entries[x].name,s) == 0)
	  strcpy(buf,entries[x].val);
    }
  else
    {
      printf("CGI: \"%s\" ? ", s);
      fgets(buf, 512, stdin);
      buf[strlen(buf) - 1] = '\0';
    }
}



void main()
{
  struct zonfile zones[100];
  int lastban=0, f, j=1, clickedban, datc;
  char dat[40];
  FILE *fi, *ba;

  /* get todays date */
  time_t now;
  time(&now);
  current_time = localtime(&now);

  cgiinit();
  getentry(z, "z");
  getentry(b, "b");

  strcpy(zonename, z);
  strcat(zonename, ".zon");          /* add .zon file extension */
  strcpy(bannername, b);
  strcat(bannername, ".ban");           /* add file extension */

  strcpy(zfile, datadir);
  strcat(zfile, zonename);

  /* ---------- read and update zone file ---------- */
  fi = fopen(zfile, "r+b");
  if (fi != NULL)
  {
	 if (!feof(fi))
    {
		fread(&lastban, sizeof(lastban),1,fi);
      fread(&datc, sizeof(datc),1,fi);
      fread(&dat, sizeof(dat),1,fi);
    }
	 while (fread(&zones[j], sizeof(zones[j]),1,fi))
	 {
		j++;
	 }
	 j--;

	 rewind(fi);

    for (clickedban=1; clickedban<=j; clickedban++)
    {

	   if (current_time->tm_yday > zones[clickedban].lastday)
	   {
		  zones[clickedban].dayclick=0;  /* newday */
		  zones[clickedban].dayexp=0;
		  zones[clickedban].lastday=current_time->tm_yday;
	   }
	   if (current_time->tm_year > zones[clickedban].lastyear)
	   {
		  zones[clickedban].dayclick=0;  /* newyear */
        zones[clickedban].dayexp=0;
		  zones[clickedban].lastday=current_time->tm_yday;
        zones[clickedban].lastyear=current_time->tm_year;
	   }

      if (strcmp(zones[clickedban].banner, b)==0)
      {
	     zones[clickedban].totclick++;
	     zones[clickedban].dayclick++;
      }
    }


	 fwrite(&lastban, sizeof(lastban),1,fi); /* write last displayed banner */
    fwrite(&datc, sizeof(datc),1,fi);
    fwrite(&dat, sizeof(dat),1,fi);
	 for (f=1; f<=j; f++)
	 {
	  fwrite(&zones[f], sizeof(zones[f]),1,fi);
	 }
	 fclose(fi);
  }
  else
	 exit(1);         /* unable to open zone file */


  /* ---------- read banner file ---------- */
  strcpy(zfile, datadir);
  strcat(zfile, bannername);

  ba = fopen(zfile, "rb");    /* read banner file */
  if (ba != NULL)
  {
	fread(&banner, sizeof(banner),1,ba);
	fclose(ba);
  }
  else
	 exit(1);         /* unable to open banner file */

  /* ---------- print to browser ----------  */
  printf("Location: ");
  printf("%s\n\n", banner.redirecturl);

  exit(0);
}

