/*
WebAd 1.11        admin.c
Copyright (c) 1999, Mittenda AB. - All rights reserved
webmaster@finechoice.com
http://www.finechoice.com/wa

License Agreement
-------------------------------------------------------------------------
You should carefully read all of the following terms and conditions before
using this software. Your use of this software indicates your acceptance
of this license agreement and warranty.
This software is owned by Mittenda AB and is protected by copyright laws
and international treaty provisions. You may not remove the copyright
notice from any copy of the software or any copy of the materials
accompanying the software.

Permitted Uses
-------------------------------------------------------------------------
You may use the evaluation version only at one server for a time limited of
30 days. After that, however, you must either obtain a registered copy, or
discontinue use of the product.

Evaluation Version Limitations
-------------------------------------------------------------------------
You may use the evaluation version only at one server for a time limited of
30 days. After that, however, you must either obtain a registered copy, or
discontinue use of the product.
You may use the licensed version on one domain and on one server into a
single cgi-bin directory only

Modification
-------------------------------------------------------------------------
You are not permitted to modify or copy any segment of the code provided,
except for the "config.h" file, without consent from Mittenda AB.

Distribution
-------------------------------------------------------------------------
You may not charge or request any form of payment from any copies you may
make of this program. You may not distribute this product alone or with any
other products without written permission from Mittenda AB.

Disclaimer of Warranty
-------------------------------------------------------------------------
THE INFORMATION AND CODE PROVIDED IS PROVIDED AS IS WITHOUT WARRANTY OF ANY
KIND, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. IN NO
EVENT SHALL MITTENDA AB BE LIABLE FOR ANY DAMAGES WHATSOEVER INCLUDING
DIRECT, INDIRECT, INCIDENTAL, CONSEQUENTIAL, LOSS OF BUSINESS PROFITS OR
SPECIAL DAMAGES, EVEN IF MITTENDA AB HAS BEEN ADVISED OF THE POSSIBILITY OF
SUCH DAMAGES.
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <dirent.h>
#include <time.h>
#include "config.h"

char codeurl[] = "code.dat";     /* url to script code.dat file */
char admincgi[] = "admin.cgi";   /* url back to script */

char zone[13], banner[13], task[14], pass[11];
char errors[50]="", displayflag[]="y";
char zfile[100], bfile[100];

struct tm *current_time;
struct dirstruct
{
  char file[20];
} dirlist[150];

struct zonfile
{
  char banner[9];
  unsigned long totexp;
  unsigned long totclick;
  unsigned long dayexp;
  unsigned int dayclick;
  char active[2];
  int lastday;
  int lastyear;
};
struct bannerdata
{
  char name[9];
  char redirecturl[201];
  char extrafunc[61];
  char alt[61];
  int border;
  char location[201];
  int width;
  int height;
  char text[61];
  int textsize;
};

void displaystats(void);
int scandirr(char *dirname, char *extention);
void editbanners(void);
void editzones(void);
void newbanner(void);

/* +++++++++++++++++++ */
typedef struct
{
  char name[128];
  char val[1024];
} entry;

entry entries[1000];
int NUM_ENTRIES;
int VIA_SHELL;

void getword(char *word, char *line, char stop)
{
  int x, y;
  
  for(x = 0; ((line[x]) && (line[x] != stop)); x++)
    word[x] = line[x];
  
  word[x] = '\0';
  if (line[x])
    ++x;
  y=0;
  
  while (line[y++] = line[x++]);
}

char *makeword(char *line, char stop)
{
  int x,y;
  char *word = (char *) malloc(sizeof(char) * (strlen(line) + 1));

  for(x = 0; ((line[x]) && (line[x] != stop)); x++)
    word[x] = line[x];

  word[x] = '\0';
  if (line[x])
    ++x;
  y=0;

  while (line[y++] = line[x++]);

  return word;
}

char *fmakeword(FILE *f, char stop, int *cl)
{
  int wsize;
  char *word;
  int ll;
  
  wsize = 102400;
  ll=0;
  word = (char *) malloc(sizeof(char) * (wsize + 1));
  
  while (1)
    {
      word[ll] = (char)fgetc(f);
      if (ll==wsize)
	{
	  word[ll+1] = '\0';
	  wsize += 102400;
	  word = (char *)realloc(word,sizeof(char)*(wsize+1));
        }
      --(*cl);
      if ((word[ll] == stop) || (feof(f)) || (!(*cl)))
	{
	  if (word[ll] != stop)
	    ll++;
	  word[ll] = '\0';
	  return word;
        }
      ++ll;
    }
}

char x2c(char *what)
{
  register char digit;
  
  digit = (what[0] >= 'A' ? ((what[0] & 0xdf) - 'A')+10 : (what[0] - '0'));
  digit *= 16;
  digit += (what[1] >= 'A' ? ((what[1] & 0xdf) - 'A')+10 : (what[1] - '0'));
  return (digit);
}

void unescape_url(char *url)
{
  register int x,y;

  for (x=0, y=0; url[y]; ++x, ++y)
    {
      if ((url[x] = url[y]) == '%')
	{
	  url[x] = x2c(&url[y+1]);
	  y+=2;
        }
    }
  url[x] = '\0';
}

void plustospace(char *str)
{
  register int x;

  for (x=0; str[x]; x++)
    if (str[x] == '+')
      str[x] = ' ';
}

void cgiinit(void)
{
  register int x;
  int cl;
  char * qcl;

  if (getenv("REQUEST_METHOD") == NULL)
    {
      VIA_SHELL = 1;
      NUM_ENTRIES = 0;
    }
  else
    {
      VIA_SHELL = 0;

      if (strcmp(getenv("REQUEST_METHOD"),"POST") == 0)
	{
	  if(strcmp(getenv("CONTENT_TYPE"),
		    "application/x-www-form-urlencoded"))
	    {
	      printf("Content-type: text/html\n\n");
	      printf("<h1>Incorrect Type</h1>\n");
	      printf("Type must be 'application/x-www-form-urlencoded'.\n");

	      exit(0);
	    }

	  cl = atoi(getenv("CONTENT_LENGTH"));

	  for (x = 0; cl && (!feof(stdin)); x++)
	    {
	      NUM_ENTRIES = x;
	      strcpy(entries[x].val, fmakeword(stdin,'&',&cl));
	      plustospace(entries[x].val);
	      unescape_url(entries[x].val);
	      strcpy(entries[x].name, makeword(entries[x].val,'='));
	    }
	}
      else if (strcmp(getenv("REQUEST_METHOD"),"GET") == 0)
	{
	  qcl = getenv("QUERY_STRING");
	  if (qcl == NULL)
	    exit(0);

	  for (x = 0; qcl[0] != '\0'; x++)
	    {
	      NUM_ENTRIES = x;
	      getword(entries[x].val, qcl, '&');
	      plustospace(entries[x].val);
	      unescape_url(entries[x].val);
	      getword(entries[x].name, entries[x].val, '=');
	    }
	}
      else
	{
	  printf("Content-type: text/html\n\n");
	  printf("<h1>Unknown method</h1>\n");
	  printf("The form was submitted with an unknown method!\n");

	  exit(0);
	}
    }
}

void getentry(char * buf, char *s)
{
  int x;

  strcpy(buf,"");

  if (VIA_SHELL == 0)
    {
      for (x = 0; x <= NUM_ENTRIES; x++)
	if (strcmp(entries[x].name,s) == 0)
	  strcpy(buf,entries[x].val);
    }
  else
    {
      printf("CGI: \"%s\" ? ", s);
      fgets(buf, 512, stdin);
      buf[strlen(buf) - 1] = '\0';
    }
}

int getentryasint(char *s)
{
  char buf[512];
  int x, v;
  
  v = 0;
  
  if (VIA_SHELL == 0)
    {
      for (x = 0; x <= NUM_ENTRIES; x++)
	if (strcmp(entries[x].name,s) == 0)
	  v = atoi(entries[x].val);
    }
  else
    {
      printf("CGI-UTIL: \"%s\" ? ", s);
      fgets(buf, 512, stdin);
      buf[strlen(buf) - 1] = '\0';
      v = atoi(buf);
    }
  
  return(v);
}
/* +++++++++++++++++++ */

void main()
{
  /* get todays date */
  time_t now;
  time(&now);
  current_time = localtime(&now);

  cgiinit();
  getentry(pass, "pass");
  getentry(zone, "zone");
  getentry(banner, "banner");
  getentry(task, "task");
  strcat(zone, ".zon");          /* add .zon file extension */
  strcat(banner, ".ban");        /* add .ban file extension */

  printf("Content-type: text/html\n\n");
  printf("<html><head><title>stats</title>\n");
  printf("<script LANGUAGE=\"JavaScript\">\n");
  printf("\nfunction cd() {\n"); /* confirm delete */
  printf("if (confirm(\"Are you sure you want to delete?\"))\n");
  printf(" {}\nelse {\n");
  printf(" document.write(\"resuming\");\nhistory.go(-1); }\n}\n");
  printf("\nfunction cr() {\n");  /* confirm reset */
  printf("if (confirm(\"Are you sure you want to reset?\"))\n");
  printf(" {}\nelse {\n");
  printf(" document.write(\"resuming\");\nhistory.go(-1); }\n}\n");
  printf("\n</script>\n</head><body>\n");

  if (strcmp(pass, passw)==0)  /* check if password is matching */
  {
    if ((strcmp(task, "deleteban")==0) || (strcmp(task, "createbanner")==0))
      editbanners();          /* delete or add banner */
    else if (strcmp(task, "edit")==0)
      editbanners();          /* edit a banner */
    else if ((strcmp(task, "addbanner")==0) || (strcmp(task, "removebanner")==0))
      editzones();            /* add or remove a banner from zone */
    else if ((strcmp(task, "activate")==0) || (strcmp(task, "deactivate")==0))
      editzones();            /* activate or deactivate a banner in zone */
    else if ((strcmp(task, "resetstats")==0) || (strcmp(task, "resetallstats")==0))
      editzones();            /* reset stats in zone */
    else if ((strcmp(task, "createzone")==0) || (strcmp(task, "delzone")==0))
      editzones();            /* create a new zone */
    else if (strcmp(task, "newbanner")==0)
      newbanner();          /* step two in creating a new banner */
  }
  else     /* if password not is matching */
  {
    printf("<br>Enter password:<br><br>\n");
	 printf("<form action=\"%s\" method=\"POST\">\n",admincgi);
	 printf("<input type=\"password\" name=\"pass\"");
    printf(" size=\"10\" maxlength=\"10\">\n");
	 printf("<input type=\"submit\" value=\"Submit\">\n");
    printf("<input type=\"reset\" value=\"Reset\">\n");
	 printf("</form>\n");
    strcpy(displayflag, "n");   /* set flag for not displaying stats */
  }

  if (strcmp(errors, "")!=0)
  {
	 printf("Error: %s<br><br>\n", errors);
  }

  if (strcmp(displayflag, "y")==0)
	 displaystats();
  printf("</body></html>\n");
}

void displaystats(void)
{
  struct zonfile zones[100];
  int i,j,f,g,dispactive, lastban=0, datc, nrzones;
  double perc;
  char zonename[13], dat[40];

  FILE *fi;
  printf("<h2 align=center>ZONES</h2>\n");

  /* update button */
  printf("<form action=\"%s\" method=\"POST\">\n",admincgi);
  printf("<input type=\"hidden\" name=\"pass\" value=\"");
  printf("%s\">\n",passw);
  printf("<input type=\"submit\" value=\"Update info\">");
  printf("</form><br>\n");

  /* print zones */
  i=scandirr(datadir,".zon");      /* scans a datadir for .zon files */
  nrzones=i;
  for (f=0; f<i; f++)           /* write a table for each zone */
  {
	 dirlist[f].file[strlen(dirlist[f].file)-4] = NULL; /* remove .zon exten. */
	 printf("\n<div align=\"left\">\n<table border=\"1\" cellpadding=\"2\"");
	 printf(" cellspacing=\"0\" width=\"100%s\" >\n", "%");
	 printf("<tr><td><strong>Zone:<br>\n");
	 printf("%s</strong></td>\n",dirlist[f].file);

	 printf("<td align=\"center\">Expos.<br>total</td>\n");
	 printf("<td align=\"center\">Clicked<br>total</td>\n");
	 printf("<td align=\"center\">Percent<br>total</td>\n");
	 printf("<td align=\"center\">Expos.<br>today</td>\n");
	 printf("<td align=\"center\">Clicked<br>today</td>\n");
	 printf("<td align=\"center\">Percent<br>today</td>\n");
	 printf("<td align=\"center\">Change<br>Status<br></td>\n");
	 printf("<td align=\"center\" colspan=\"2\">\n");
	 printf("<form action=\"%s\" method=\"POST\">\n",admincgi);
	 printf("<input type=\"hidden\" name=\"task\" value=\"resetallstats\">\n");
	 printf("<input type=\"hidden\" name=\"zone\" value=\"");
	 printf("%s\">\n",dirlist[f].file);
 	 printf("<input type=\"hidden\" name=\"pass\" value=\"");
	 printf("%s\">\n",passw);
	 printf("<input type=\"submit\" value=\"Reset stats for all\"");
	 printf(" onClick=\"cr()\">\n</td></form></tr>\n");

	 strcpy(zonename, dirlist[f].file);
	 strcat(zonename, ".zon");     /* add .zon file extension */
    strcpy(zfile, datadir);       /* copy the full path */
    strcat(zfile, zonename);      /* add the file name to the path */

	 j=1;                        /* j is the number of banners in each zone */
	 fi = fopen(zfile, "rb");
	 if (fi != NULL)
	 {
		if (!feof(fi))
      {
		  fread(&lastban, sizeof(lastban),1,fi);
    	  fread(&datc, sizeof(datc),1,fi);
        fread(&dat, sizeof(dat),1,fi);
      }
		while (fread(&zones[j], sizeof(zones[j]),1,fi))
		{
		  j++;
		}
		j--;
		fclose(fi);
	 }

	 for (dispactive=1; dispactive<=2; dispactive++)
	 {        /* run through it twice to get the active banners listed first */
		for (g=1; g<=j; g++)  /* write in the table for each banner in the zone */
		{
		  if (((dispactive==1) && (zones[g].active[0]=='y')) ||
			  ((dispactive==2) && (zones[g].active[0]=='n')))
		  {
			 printf("<tr><td>%s</td>\n", zones[g].banner);
			 printf("<td align=\"right\">%u</td>\n", zones[g].totexp);
			 printf("<td align=\"right\">%u</td>\n", zones[g].totclick);
			 printf("<td align=\"right\">");
			 perc=0;
			 if (zones[g].totexp!=0)
				perc=100*((double) zones[g].totclick/ (double) zones[g].totexp);
			 printf("%.3lf</td>\n", perc);
			 printf("<td align=\"right\">%u</td>\n", zones[g].dayexp);
			 printf("<td align=\"right\">%u</td>\n", zones[g].dayclick);
			 printf("<td align=\"right\">");
			 perc=0;
			 if (zones[g].dayexp!=0)
				perc=100*((double) zones[g].dayclick/ (double) zones[g].dayexp);
			 printf("%.3f</td>\n", perc);
			 printf("<td align=\"center\">\n");

			 printf("<form action=\"%s\" method=\"POST\">\n", admincgi);
			 printf("<input type=\"hidden\" name=\"banner\" ");
			 printf("value=\"%s\">\n<input type=\"hidden\"", zones[g].banner);
			 printf(" name=\"zone\" value=\"%s\">\n", dirlist[f].file);
 	       printf("<input type=\"hidden\" name=\"pass\" value=\"");
	       printf("%s\">\n",passw);
			 if (zones[g].active[0]=='n')      /* if banner is not active in zone */
			 {
				printf("<input type=\"hidden\" name=\"task\" value=\"activate\">\n");
				printf("<input type=\"submit\" value=\"Activate\">\n");
			 }
			 else if (zones[g].active[0]=='y') /* if banner is active in zone */
			 {
				printf("<input type=\"hidden\" name=\"task\" value=\"deactivate\">\n");
				printf("<input type=\"submit\" value=\"DeActivate\">\n");
			 }
			 printf("</td></form>\n\n");

			 printf("<td align=\"center\">\n");
			 printf("<form action=\"%s\" method=\"POST\">\n", admincgi);
			 printf("<input type=\"hidden\" name=\"task\" value=\"resetstats\">\n");
     	    printf("<input type=\"hidden\" name=\"pass\" value=\"");
	       printf("%s\">\n",passw);
			 printf("<input type=\"hidden\" name=\"banner\"");
			 printf(" value=\"%s\">\n", zones[g].banner);
			 printf("<input type=\"hidden\" name=\"zone\"");
			 printf(" value=\"%s\">\n", dirlist[f].file);
			 printf("<input type=\"submit\" value=\"Reset stats\"");
          printf(" onClick=\"cr()\">\n</td></form>\n");
			 printf("<td align=\"center\">\n");
			 printf("<form action=\"%s\" method=\"POST\">\n", admincgi);
			 printf("<input type=\"hidden\" name=\"task\" value=\"removebanner\">\n");
        	 printf("<input type=\"hidden\" name=\"pass\" value=\"%s\">\n",passw);
			 printf("<input type=\"hidden\" name=\"banner\"");
			 printf(" value=\"%s\">\n<input type=\"hidden\" ", zones[g].banner);
			 printf("name=\"zone\" value=\"%s\">\n", dirlist[f].file);
			 printf("<input type=\"submit\" value=\"Remove\"");
          printf(" onClick=\"cd()\">\n</td></form></tr>\n");
        }
      }
	 }

	 printf("<tr><td align=\"center\" colspan=\"3\">\n");
	 printf("<form action=\"%s\" method=\"POST\">\n", admincgi);
    printf("<input type=\"hidden\" name=\"pass\" value=\"%s\">\n",passw);
	 printf("<input type=\"hidden\" name=\"task\" value=\"delzone\">\n");
	 printf("<p><input type=\"hidden\" name=\"zone\" ");
	 printf("value=\"%s\">\n", dirlist[f].file);
	 printf("<input type=\"submit\" value=\"Delete this zone\"");
    printf(" onClick=\"cd()\"><p></form></td>\n");

	 printf("<td align=\"center\" colspan=\"7\">\n");
	 printf("<form action=\"%s\" method=\"POST\">\n", admincgi);
	 printf("<p>Add a banner to this zone:\n");
	 printf("<input type=\"text\" size=\"10\" name=\"banner\">\n");
    printf("<input type=\"hidden\" name=\"pass\" value=\"%s\">\n",passw);
	 printf("<input type=\"hidden\" name=\"task\" value=\"addbanner\">\n");
	 printf("<input type=\"hidden\" name=\"zone\" ");
	 printf("value=\"%s\">\n", dirlist[f].file);
	 printf("<input type=\"submit\" value=\"Add\">\n");
	 printf("</p></form></td></tr></table></div><br><br>\n");
  }

  printf("<form action=\"%s\" method=\"POST\">\n", admincgi);
  printf("<p align=\"center\">Create a new zone:\n");
  printf("<input type=\"text\" size=\"8\" maxlength=\"8\" name=\"zone\">\n");
  printf("<input type=\"hidden\" name=\"task\" value=\"createzone\">\n");
  printf("<input type=\"hidden\" name=\"pass\" value=\"%s\">\n",passw);
  printf("<input type=\"hidden\" name=\"banner\" value=\"\">\n");
  printf("<input type=\"submit\" value=\"Add\"></p></form>\n");

  /* ---------- print banners ---------- */
  printf("\n<hr><h2 align=\"center\">BANNERS</h2>\n");
  i=scandirr(datadir,".ban");      /* scans a datadir for .ban files */
  printf("<div align=\"left\">\n");
  printf("<table border=\"1\" cellpadding=\"2\"");
  printf(" cellspacing=\"0\" width=\"100%s\" >\n", "%");

  for (f=0; f<i; f++)           /* write a tablerow for each banner */
  {
	 dirlist[f].file[strlen(dirlist[f].file)-4] = NULL; /* remove .ban exten. */
	 printf("<tr><td align=\"center\">");
	 printf("%s",dirlist[f].file);
	 printf("</td><td align=\"center\">\n");
	 printf("<form action=\"%s\" method=\"POST\">\n",admincgi);
	 printf("<input type=\"hidden\" name=\"task\" value=\"edit\">\n");
    printf("<input type=\"hidden\" name=\"pass\" value=\"%s\">\n",passw);
	 printf("<input type=\"hidden\" name=\"banner\" value=\"");
	 printf("%s\">", dirlist[f].file);
	 printf("<input type=\"hidden\" name=\"zone\" value=\"\">\n");
	 printf("<input type=\"submit\" value=\"Edit\">\n");
	 printf("</td></form><td align=\"center\">\n");
	 printf("<form action=\"%s\" method=\"POST\">", admincgi);
    printf("<input type=\"hidden\" name=\"pass\" value=\"%s\">\n",passw);
	 printf("<input type=\"hidden\" name=\"task\" value=\"deleteban\">\n<input ");
	 printf("type=\"hidden\" name=\"banner\" value=\"%s\">\n",dirlist[f].file);
	 printf("<input type=\"hidden\" name=\"zone\" value=\"\">\n");
	 printf("<input type=\"submit\" value=\"Delete\"");
    printf(" onClick=\"cd()\"></td></form></tr>\n\n");
  }
  printf("</table></div>\n");
  printf("<form action=\"%s\" method=\"POST\">\n", admincgi);
  printf("<p align=\"center\">Create a new banner:\n");
  printf("<input type=\"text\" size=\"8\" maxlength=\"8\" name=\"banner\">\n");
  printf("<input type=\"hidden\" name=\"pass\" value=\"%s\">\n",passw);
  printf("<input type=\"hidden\" name=\"zone\" value=\"\">\n");
  printf("<input type=\"hidden\" name=\"task\" value=\"createbanner\">\n");
  printf("<input type=\"submit\" value=\"Add\"></p></form>\n");

  if (nrzones>0)
    printf("\n\n<script LANGUAGE=\"JavaScript\" SRC=\"%sjs\"></script>\n", dat);

}

int scandirr(char *dirname, char *extention)  /* scans a directory for files */
{                              /* returns the number of matching files found */
  DIR *dir;       /* the files that are found are listed in  dirlist[].file */
  struct dirent *ent;
  char exten[5];
  int i=0;

  if ((dir = opendir(dirname)) == NULL)
  {
	 perror("Unable to open data directory");
	 exit(1);
  }
  while ((ent = readdir(dir)) != NULL)
  {
	 exten[0]=ent->d_name[strlen(ent->d_name)-4];
	 exten[1]=ent->d_name[strlen(ent->d_name)-3];
	 exten[2]=ent->d_name[strlen(ent->d_name)-2];
	 exten[3]=ent->d_name[strlen(ent->d_name)-1];
	 exten[4]=ent->d_name[strlen(ent->d_name)];
	 if   (strncmp(extention, exten,4)==0)
	 {
		strcpy(dirlist[i++].file, ent->d_name);
	 }
  }
  if (closedir(dir) != 0)
	 perror("Unable to close  data directory");
  return i;
}

void editbanners(void)
{
  FILE *fi;
  int i, j, f, g, existflag, lastban=1,datc;
  char bannername[13], zonename[13], dat[40];
  strcpy(bannername, banner);
  bannername[strlen(bannername)-4] = NULL; /* remove .ban exten. */

  /* ---------- delete a banner ---------- */
  if (strcmp(task, "deleteban")==0)
  {
	 struct zonfile zones[100];
	 existflag=0;
	 i=scandirr(datadir,".zon");      /* scans a datadir for .zon files */
	 for (f=0; f<i; f++) /* scan each zone if the selected banner is in use */
	 {
		strcpy(zonename, dirlist[f].file);
      strcpy(zfile, datadir);       /* copy the full path */
      strcat(zfile, zonename);      /* add the file name to the path */

		j=1;                          /* j is the number of banners in each zone */
		fi = fopen(zfile, "rb");      /* open .zon file */
		if (fi != NULL)
		{
			if (!feof(fi))
         {
			  fread(&lastban, sizeof(lastban),1,fi);
        	  fread(&datc, sizeof(datc),1,fi);
           fread(&dat, sizeof(dat),1,fi);
         }
			while (fread(&zones[j], sizeof(zones[j]),1,fi))
			{
			  j++;
		  }
		  j--;
		  fclose(fi);
		}
		for (g=1; g<=j; g++)  /* compare all banner names in the zone */
		{
		  if (strcmp(zones[g].banner, bannername)==0)
		  {
			 existflag=1;
			 strcpy(errors, "Banner is in use in any of the zones");
		  }
		}
	 }
	 if (existflag==0)
	 {
      strcpy(bfile, datadir);     /* copy the full path */
      strcat(bfile, banner);      /* add the file name to the path */

		if (remove(bfile)!=0)
		  strcpy(errors, "error deleting banner file");
	 }
  }

  /* ---------- create or edit a banner ---------- */
  if ((strcmp(task, "createbanner")==0) || (strcmp(task, "edit")==0))
  {
	 struct bannerdata bandata;        /*  create a banner struct */
	 if (strcmp(task, "createbanner")==0)
		strcpy(bandata.name, bannername);
	 else if (strcmp(task, "edit")==0)
	 {                             /* read from banner file to banner struct */
      strcpy(bfile, datadir);       /* copy the full path */
      strcat(bfile, banner);      /* add the file name to the path */
		fi = fopen(bfile, "rb");   /* read banner file */
		if (fi != NULL)
		{
		  fread(&bandata, sizeof(bandata),1,fi);
		  fclose(fi);
		}
		else
		  strcpy(errors, "could not open the banner file");
		  /* unable to open banner file */
	 }
	 /* print html code */
	 if (strcmp(task, "createbanner")==0)
		printf("<h2 align=\"center\">Add a new banner</h2>\n");
	 else if (strcmp(task, "edit")==0)
	 {
		printf("<h2 align=\"center\">Edit a banner</h2>\n");
		printf("<br><img src=\"%s\"><br>\n", bandata.location);
    }
	 printf("<form action=\"%s\" method=\"POST\">\n",admincgi);
	 printf("<div align=\"center\"><center><table border=\"0\"");
	 printf(" cellpadding=\"5\" cellspacing=\"0\" width=\"100%s\">\n\n", "%");

	 printf("<tr><td width=\"170\">Name (max 8 char)</td>\n");
	 printf("<td><input type=\"text\" size=\"8\" maxlength=\"8\" ");
	 printf("name=\"name\" value=\"%s\"></td></tr>\n\n", bandata.name);

	 printf("<tr><td>Url banner points to</td>\n");
	 printf("<td><input type=\"text\" size=\"87\" maxlength=\"200\"\n");
	 printf("name=\"redirecturl\" value=\"");
	 if (strcmp(task, "createbanner")==0)
		printf("http://\"></td></tr><tr>\n\n");
	 else if (strcmp(task, "edit")==0)
		printf("%s\"></td></tr><tr>\n\n", bandata.redirecturl);

	 printf("<td>Extra javascript</td>\n");
	 printf("<td><input type=\"text\" size=\"30\" maxlength=\"60\"");
	 printf("name=\"extrafunc\" value=\"");
	 if (strcmp(task, "edit")==0)
	 {
		i=0;
		while(bandata.extrafunc[i]!= '\0')
		{
		  if (bandata.extrafunc[i]=='"')
          printf("&quot;");
		  else
			 printf("%c", bandata.extrafunc[i]);
		  i++;
		}
	 }
	 printf("\"> onClick=\"exit=false\" or target=\"_new\"</td></tr>\n\n");

	 printf("<tr><td width=\"170\">Alt text</td>\n<td><input type=\"text\"\n");
	 printf(" size=\"57\" maxlength=\"60\" name=\"alt\" value=\"");
	 if (strcmp(task, "edit")==0)
		printf("%s", bandata.alt);
	 printf("\"></td></tr>\n\n");

	 printf("<tr><td width=\"170\">Border size</td>\n<td><input type=\"text\"\n");
	 printf(" size=\"1\" maxlength=\"1\" name=\"border\" value=\"");
	 if (strcmp(task, "edit")==0)
		printf("%d", bandata.border);
	 printf("\"></td></tr>\n\n");

	 printf("<tr><td width=\"170\">Location of banner</td>\n");
	 printf("<td><input type=\"text\" size=\"87\" maxlength=\"200\" \n");
	 if (strcmp(task, "createbanner")==0)
		printf("name=\"location\" value=\"/banners/\">\n");
	 else if (strcmp(task, "edit")==0)
		printf("name=\"location\" value=\"%s\">\n", bandata.location);
	 printf("<br> leave this field empty if you only want ");
	 printf("to have a text link</td></tr>\n\n");

	 printf("<tr><td width=\"170\">Banner width</td>\n<td><input type=\"text\"");
	 printf(" size=\"3\" maxlength=\"3\" name=\"width\" value=\"");
	 if (strcmp(task, "edit")==0)
		printf("%d", bandata.width);
	 printf("\"></td></tr>\n\n");

	 printf("<tr><td width=\"170\">Banner height</td>\n");
	 printf("<td><input type=\"text\" size=\"3\" \n");
	 printf("maxlength=\"3\" name=\"height\" value=\"");
	 if (strcmp(task, "edit")==0)
		printf("%d", bandata.height);
	 printf("\"></td></tr>\n\n");

	 printf("<tr><td width=\"170\">Text</td>\n<td><input type=\"text\" ");
	 printf("size=\"57\" maxlength=\"60\" name=\"text\" value=\"");
	 if (strcmp(task, "edit")==0)
		printf("%s", bandata.text);
	 printf("\">\n<br> leave this field empty if you dont want to have");
	 printf(" text to the banner</td></tr>\n\n");

	 printf("<tr><td width=\"170\">Text size</td>\n");
	 printf("<td><input type=\"text\" size=\"1\" maxlength=\"1\" \n");

	 printf("name=\"textsize\" value=\"");
	 if (strcmp(task, "createbanner")==0)
      printf("3");
	 else if (strcmp(task, "edit")==0)
		printf("%d", bandata.textsize);
    printf("\"><input type=\"hidden\" name=\"pass\" value=\"%s\">\n",passw);
	 printf("<input type=\"hidden\" name");
    printf("=\"task\" value=\"newbanner\">\n</td></tr>\n\n");
	 printf("<tr><td width=\"170\"></td>\n");
	 printf("<td><input type=\"submit\" name=\"B1\" value=\"Submit\"></td>\n");
	 printf("</tr></table></center></div></form>\n\n");
                                                         
	 strcpy(displayflag, "n");   /* set flag for not displaying stats */
  }

}

void editzones(void)
{
  int i, j, f, existflag, lastban=1, datc=1;
  char bannername[13], dat[40];

  FILE *fi;
  strcpy(bannername, banner);
  /* ---------- create a new zone ---------- */
  if (strcmp(task, "createzone")==0)
  {
	 /* make sure that the new .zon file doesnt exist */
	 i=scandirr(datadir,".zon");   /* scans a datadir for .zon files */
  	 for (f=0; f<i; f++)           /* compare existing .zon files */
	 {
		if (strcmp(dirlist[f].file, zone)==0)
		{
		  strcpy(errors, ".zon file already exists");
		  return;
		}
	 }
    if (f>1)
    {
		  strcpy(errors, "Only 2 zones are allowed in the evaluation version");
		  return;
    }

	 fi = fopen(codeurl, "rb");
	 if (fi != NULL)
	 {
		if (!feof(fi))
        fread(&dat, sizeof(dat),1,fi);
      fclose(fi);
	 }
	 else
		strcpy(errors, "could not open the code.dat file");
    f=0;
    while (dat[f]!=NULL)
    {
      dat[f]=dat[f]-90;
      f++;
      if (f>50)
        exit(1);
    }

    datc=1;
    strcpy(zfile, datadir);       /* copy the full path */
    strcat(zfile, zone);      /* add the file name to the path */
	 fi = fopen(zfile, "wb");    /* create a new .zon file */
	 if (fi != NULL)
	 {

		fwrite(&lastban, sizeof(lastban),1,fi);
      fwrite(&datc, sizeof(datc),1,fi);
      fwrite(&dat, sizeof(dat),1,fi);
		fclose(fi);
	 }
  }
  /* ---------- add a new banner to the zone ---------- */
  if (strcmp(task, "addbanner")==0)
  {
	 struct zonfile newzone[100];
    strcpy(zfile, datadir);       /* copy the full path */
    strcat(zfile, zone);      /* add the file name to the path */
	 fi = fopen(zfile, "r+b");
	 if (fi != NULL)
	 {
		/* make sure that the .ban file exist */
		existflag=0;
		j=scandirr(datadir,".ban");   /* scans a datadir for .ban files */
		for (f=0; f<j; f++)           /* compare existing .ban files */
		{
			if (strcmp(dirlist[f].file, bannername)==0)
			{
			 existflag=1;
		  }
		}
		if (existflag==0)
		{
		  strcpy(errors, "the requested banner file doesnt exist");
		  fclose(fi);
		  return;
		}
 		if (!feof(fi))    /* check if the banner already has been added */
      {
		  fread(&lastban, sizeof(lastban),1,fi);
        fread(&datc, sizeof(datc),1,fi);
        fread(&dat, sizeof(dat),1,fi);
      }
		i=0;
      bannername[strlen(bannername)-4] = NULL; /* remove .ban exten. */
		while (!feof(fi))
		{
        i++;
		  fread(&newzone[i], sizeof(newzone[i]),1,fi);
		  if (strcmp(newzone[i].banner, bannername)==0)
		  {
			 strcpy(errors, "this banner has already been added to this zone");
			 fclose(fi);
			 return;
		  }
		}
		rewind(fi);

		if (i<99)    /* add the new banner if less than 100 in .zon file */
		{
        strcpy(newzone[i].banner, bannername);
		  newzone[i].totexp=0;
		  newzone[i].totclick=0;
		  newzone[i].dayexp=0;
		  newzone[i].dayclick=0;
		  strcpy(newzone[i].active, "y");
		  newzone[i].lastday=current_time->tm_yday;
		  newzone[i].lastyear=current_time->tm_year;

		  fwrite(&lastban, sizeof(lastban),1,fi);
        fwrite(&datc, sizeof(datc),1,fi);
        fwrite(&dat, sizeof(dat),1,fi);
		  for (f=1; f<=i; f++)
		  {
			 fwrite(&newzone[f], sizeof(newzone[f]),1,fi);
		  }
		}
		else
		  strcpy(errors, "to many banners in zone file");
		fclose(fi);
	 }
	 else
		strcpy(errors, "could not open the zone file");
  }

  /* ---------- activate or deactivate a banner in the zone ---------- */
  if ((strcmp(task, "deactivate")==0) || (strcmp(task, "activate")==0))
  {
	 struct zonfile newzone[100];
	 bannername[strlen(bannername)-4] = NULL; /* remove .ban exten. */
    strcpy(zfile, datadir);       /* copy the full path */
    strcat(zfile, zone);      /* add the file name to the path */
	 fi = fopen(zfile, "r+b");
	 if (fi != NULL)
	 {
		if (!feof(fi))
      {
		  fread(&lastban, sizeof(lastban),1,fi);
        fread(&datc, sizeof(datc),1,fi);
        fread(&dat, sizeof(dat),1,fi);
      }
		i=1;
		while (fread(&newzone[i], sizeof(newzone[i]),1,fi))
		{
		  if ((strcmp(task, "deactivate")==0)&&(strcmp(newzone[i].banner, bannername)==0))
          {
			 newzone[i].active[0]='n'; /* deactivate banner */
          newzone[i].dayexp=0;      /* reset daily stats for the banner */
			 newzone[i].dayclick=0;
          }
        if ((strcmp(task, "activate")==0)&&(strcmp(newzone[i].banner, bannername)==0))
			 newzone[i].active[0]='y'; /* activate banner */
		  i++;
		}
		i--;
		rewind(fi);

		fwrite(&lastban, sizeof(lastban),1,fi);
      fwrite(&datc, sizeof(datc),1,fi);
      fwrite(&dat, sizeof(dat),1,fi);      
		for (f=1; f<=i; f++)
		{
		 fwrite(&newzone[f], sizeof(newzone[f]),1,fi);
		}
		fclose(fi);
	 }
	 else
		strcpy(errors, "could not open the zone file");
  }

  /* ---------- reset stats in the zone ---------- */
  if ((strcmp(task, "resetstats")==0) || (strcmp(task, "resetallstats")==0))
  {
	 struct zonfile newzone[100];
	 bannername[strlen(bannername)-4] = NULL; /* remove .ban exten. */
    strcpy(zfile, datadir);       /* copy the full path */
    strcat(zfile, zone);      /* add the file name to the path */
	 fi = fopen(zfile, "r+b");
	 if (fi != NULL)
	 {
		if (!feof(fi))
      {
		  fread(&lastban, sizeof(lastban),1,fi);
        fread(&datc, sizeof(datc),1,fi);
        fread(&dat, sizeof(dat),1,fi);
      }
		i=1;
		while (fread(&newzone[i], sizeof(newzone[i]),1,fi))
		{            /* reset stats for a particular banner in the zone */
		  if ((strcmp(task, "resetstats")==0)&&(strcmp(newzone[i].banner, bannername)==0))
		  {
			 newzone[i].totexp=0;   /* reset stats for the banner */
			 newzone[i].totclick=0;
			 newzone[i].dayexp=0;
			 newzone[i].dayclick=0; 
		  }
		  if ((strcmp(task, "resetallstats")==0))
		  {         /* reset stats for all the banners in the zone */
			 newzone[i].totexp=0;   /* reset stats for the banner */
			 newzone[i].totclick=0;
			 newzone[i].dayexp=0;
			 newzone[i].dayclick=0;
		  }
		  i++;
		}
		i--;
		rewind(fi);

		fwrite(&lastban, sizeof(lastban),1,fi);
      fwrite(&datc, sizeof(datc),1,fi);
      fwrite(&dat, sizeof(dat),1,fi);      
		for (f=1; f<=i; f++)
		{
		 fwrite(&newzone[f], sizeof(newzone[f]),1,fi);
		}
		fclose(fi);
	 }
	 else
		strcpy(errors, "could not open the zone file");
  }

  /* ---------- delete this zone ---------- */
  if (strcmp(task, "delzone")==0)
  {
    strcpy(zfile, datadir);       /* copy the full path */
    strcat(zfile, zone);      /* add the file name to the path */
    if (remove(zfile)!=0)
      strcpy(errors, "could not delete the zone file");
  }

  /* ---------- remove a banner from the zone ---------- */
  if ((strcmp(task, "removebanner")==0))
  {
	 struct zonfile newzone[100];
	 bannername[strlen(bannername)-4] = NULL; /* remove .ban exten. */

    strcpy(zfile, datadir);       /* copy the full path */
    strcat(zfile, zone);      /* add the file name to the path */
	 fi = fopen(zfile, "rb");  /* read from zone file */
	 if (fi != NULL)
	 {
		if (!feof(fi))
      {
		  fread(&lastban, sizeof(lastban),1,fi);
        fread(&datc, sizeof(datc),1,fi);
        fread(&dat, sizeof(dat),1,fi);
      }
		i=1;
		while (fread(&newzone[i], sizeof(newzone[i]),1,fi))
		{
		  i++;
		}
		i--;
		fclose(fi);

      strcpy(zfile, datadir);       /* copy the full path */
      strcat(zfile, zone);      /* add the file name to the path */
		fi = fopen(zfile, "wb"); /* write to zone file */
		if (fi != NULL)
		{
		  rewind(fi);
		  fwrite(&lastban, sizeof(lastban),1,fi);
        fwrite(&datc, sizeof(datc),1,fi);
        fwrite(&dat, sizeof(dat),1,fi);
		  for (f=1; f<=i; f++)
		  {  /* do not write if this is the banner to be removed */
			 if (strcmp(newzone[f].banner, bannername)!=0)
				fwrite(&newzone[f], sizeof(newzone[f]),1,fi);
		  }
		  fclose(fi);
		}
		else
		  strcpy(errors, "could not open the zone file");
	 }
	 else
		strcpy(errors, "could not open the zone file");
  }
}

void newbanner(void)
{
  FILE *fi;
  char filename[13];
  struct bannerdata bandata;  /* create a banner struct */

  getentry(bandata.name, "name");
  getentry(bandata.redirecturl, "redirecturl");
  getentry(bandata.extrafunc, "extrafunc");
  getentry(bandata.alt, "alt");
  bandata.border = getentryasint("border");
  getentry(bandata.location, "location");
  bandata.width = getentryasint("width");
  bandata.height = getentryasint("height");
  getentry(bandata.text, "text");
  bandata.textsize = getentryasint("textsize");


  strncpy(filename,bandata.name,9);
  strcat(filename, ".ban");           /* add file extension */

  if (strcmp(filename,".ban")!=0)  /* make sure a filename has been entered */
  {
    strcpy(bfile, datadir);       /* copy the full path */
    strcat(bfile, filename);      /* add the file name to the path */
	 fi = fopen(bfile, "wb");      /* write to file */
	 if (fi != NULL)
	 {
		fwrite(&bandata, sizeof(bandata),1,fi);
		fclose(fi);
	 }
    printf("<br><img src=\"%s\"><br>\n", bandata.location);
	 printf("<h3>name:         %s</h3>\n", bandata.name);
	 printf("<h3>redirecturl:  %s</h3>\n", bandata.redirecturl);
	 printf("<h3>javascript function:  %s</h3>\n", bandata.extrafunc);
	 printf("<h3>alt:  %s</h3>\n", bandata.alt);
	 printf("<h3>border:        %d</h3>\n", bandata.border);
	 printf("<h3>location:     %s</h3>\n", bandata.location);
	 printf("<h3>width:        %d</h3>\n", bandata.width);
	 printf("<h3>height:       %d</h3>\n", bandata.height);
	 printf("<h3>text:         %s</h3>\n", bandata.text);
    printf("<h3>textsize:     %d</h3>\n\n", bandata.textsize);
  }
  else
	 printf("<h2>ERROR: no bannername entered</h2>\n");

  printf("<form action=\"%s\" method=\"POST\">\n",admincgi);
  printf("<input type=\"hidden\" name=\"pass\" value=\"%s\">\n",passw);
  printf("<input type=\"submit\" value=\"CLICK TO CONTINUE\">\n");
  printf("</form>\n");
  strcpy(displayflag, "n");   /* set flag for not displaying stats */
}

