#!/usr/bin/perl 
##############################################################################
# EZ Count                         Version 2.0                               #
# Last Modified 10/02/2000                                                   #
# URL: http:/www.cgiadmin.com                                                #
# Copyright 1998-2001 Chad Casselman - Casselware, Inc.                      #
##############################################################################
##############################################################################
#                                                                            
# COPYRIGHT NOTICE:                                                          
#                                                                            
# Copyright 1998-2001 Chad Casselman - Casselware, Inc.                      
#  All Rights Reserved.                                                      
#                                                                            
# TERMS OF USE 
# 1. EZ Count is offered as shareware.  In exchange
# for its use, Casselware, Inc. requires the following:
#
# Customer/User may use/install EZ Count as many
# times as customer wishes, as long as customer owns the web
# site that EZ Count is installed on.  
# EZ Count may not under any circumstances be sold
# or redistributed without the written consent of Casselware, Inc. and 
# its owner Chad Casselman.
#
# 2. Casselware, Inc., at its own discresion, will decide if any terms 
# of the this agreement have been violated by customer. Upon written e- 
# mailed notification to Customer of Terms of Use violations, 
# Casselware, Inc. may revoke customer's license to use EZ Count
#
# In that event, Customer agrees to any and all of the following:
#
# a) Customers found in violation of this agreement, found reselling or
# redistributing EZ Count, will no longer be licensed to 
# use EZ Count and agrees to either immediately cease
# the use/distribution of EZ Count or pay 
# Casselware, Inc. the full price of our Professional Series
# EZ Count for each copy used and/or distributed.
# 
# b). Customer will no longer be licensed to run any version of 
# EZ Count. 
#
# Indemnification
# 1. Customer agrees that it shall defend, indemnify, save and hold
# Casselware, Inc., and any
# persons affiliated with the company, harmless from any and all
# demands, liabilities, losses, costs and claims, including reasonable
# attorney's fees asserted against Casselware, Inc., its agents, its
# customers, officers and employees, that may arise or result from any
# service provided or performed or agreed to be performed or any product 
# sold by customer, its agents, employees or assigns. Customer agrees to 
# defend, indemnify and hold harmless Casselware, Inc., its # agents,  
# its cusomters, officers, and employes,against
# liabilities arising out of; a) any injury to person or property caused 
# by an products sold or  otherwise distributed in connection with CGI
# Script Center products; (b) any material supplied by customer
# infringing or allegedly infringing on the proprietary rights of a
# third party; c) copyright infringement and (d) any defective products 
# sold to customer from Casselware, Inc. products.
#
# This program may not be distributed in whole or part, freely, for pay, 
# or any other form of compensation.  This program may not be offered
# by Internet Service and/or other providers to their customers, whether
# for free or compensation.  Contanct the Casselware, Inc. for
# commercial licensing information.
#
##############################################################################
# This version designed for UNIX servers.  If you require
# a Win32(NT/Win95) version, please visit: http://www.casselware.com
##############################################################################

##############################################################################
#############################> USER OPTIONS <#################################
##############################################################################
# NOTE:
# Please set the first line of this file "#!/usr/bin/perl" to the location
#  of PERL on your server.  If you do not know the path to PERL, please ask
#  your server adminstrator or see our support site 
#  @ http://www.cgiadmin.com/support


# AFTER INSTALLATION:
##############################################################################
# To call the counter from your web pages, you must have SSI for that page
# turned on please check with your system administrator.
# (On most servers it means naming your file .shtml instead of .html)
# You will need to insert the following code in your web page.  You must edit
# the code before inserting it to reflect the installation of EZ Count on your 
# server.
#
#  <!--#exec cgi="/location/to/cgi-bin/ezcount.cgi"-->
#

# INSTALLATION:
##############################################################################

$countfile = "/home/public_html/cgi-bin/ssi/ezcount.dat";
 # Absolute path from the root of your server to where you installed the 
 #  counter file.  It must end in "/ezcount.dat"

$invisible = "0";
  # "1": Counter will be invisible.
  # "0": Counter will be visible.

$block_repeats = "0";
  # "1": Blocks the reload button.
  # "0": Does not block the reload button.

$private = "0";
  # "1": Call must come from the site listed in @referers.
  # "0": Call can be from ANY site ANYWHERE!

@referrers = ("websitereporter.com","www.websitereporter.com","209.130.97.145");
  # If private is "1" then set the referrers else leave at "0".
  # Must have www.domain.com, domain.com, and IP Address.
  # For more information see http://www.websitereporter.com/support

$digit_dir = "http://www.websitereporter.com/digits";
  # URL of where the digits are located. Must be accessable via web browser.

$extension ="gif";
  # extension of digits, either "gif" or "jpg";

$same_digit_size = "0";
  # "1": If the digits are SAME sizes.      FASTER DISPLAY TIME
  # "0": If the digits are DIFFERENT sizes. SLOWER DISPLAY TIME
  
$width = "15";
  # Width of digits if the same size.

$height = "20";
  # Height of digits if the same size.


###############################################################################
# If you have trouble or need additional help please see
#  http://www.cgiadmin.com/support or please email
#  mailto:ezcount@cgiadmin.com
###############################################################################
############################> END USER OPTIONS <###############################
###############################################################################
#######        !!!! DO NOT CHANGE ANYTHING BELOW THIS LINE !!!!         #######
###############################################################################


$LOCK_EX = "2";
$LOCK_UN = "8";
$ip = $ENV{'REMOTE_ADDR'}; 
$showCounter = 0;

if($private == 1){
	&Check_Referrer;
}else{
	$showCounter = 1;
}

&IncrementCounter;
&CheckInvisibility;
if($showCounter == 1){
	&DisplayCounter;
}else{
	print "Content-type: text/html\n\n ";
}
exit;

###############################################################################
###############################################################################
sub DisplayCounter{
	print "Content-type: text/html\n\n";
	$num = $length = length($count);
	while($num > 0){
		$NUMS{$num} = chop($count);
		$num--;
	}
	
	$i = 1;
	while($i <= $length){
		if($same_digit_size == 1){
			print qq~<img src="$digit_dir/$NUMS{$i}.$extension" width="$width" height="$height">~;
		}else{
			print qq~<img src="$digit_dir/$NUMS{$i}\.$extension">~;
		}
		$i++;
	}
}

###############################################################################
###############################################################################
sub Check_Referrer{
	my $ref = $ENV{'HTTP_REFERER'};
	foreach $referer(@referers){
		if($ref =~ m/$referer/){
			$showCounter = 1;
            last;
        }
	}
	if($showCounter == 0){
		print qq~<img src="$digit_dir/bad_referrer\.$extension">~;
	}
	exit;
}

###############################################################################
###############################################################################
sub CheckInvisibility{
   if($invisible == 1){
      print "Content-type: text/html\n\n ";
	  exit;
   }
}

###############################################################################
###############################################################################
sub IncrementCounter{
	open(COUNT,"+<$countfile") || die("Can't open $countfile: $!\n");
	flock(COUNT,$LOCK_EX);
	$count = <COUNT>; 
	chop $count;
	$lastvisitor = <COUNT>;
	chop $lastvisitor;
	if(($block_repeats == "1") && ($ip == $lastvisitor)){
		$dont_log = "1";
	}else{
		$count++;
	}
	$number = $count;

  	seek(COUNT,0,0);
  	print (COUNT "$count\n$ip\n");
  	flock(COUNT,$LOCK_UN);  
  	close(COUNT);
}
