#!/usr/bin/perl
$|=1;
############################################################################
#                                                                          #
# Application  : arcount.cgi                                               #
# Description  : Argala Counter Script                                     #
# Version      : 1.00                                                      #
# Created      : 7th April 2000                                            #
# Last Updated : 17th May 2000                                             #
#                                                                          #
# Copyright (c) 2000 Argala.com All rights reserved.                       #
# WWW    : http://www.argala.com                                           #
# Email  : webmaster@argala.com                                            #
#                                                                          #
############################################################################

require "arcount.cfg";

# default variables
$flock  = '0';
$len    = '6';
$uselog = '0';

if (-e "custom.pl") {
  require "custom.pl";
}

print "Content-type: text/html\n\n";

# get data file
if ( ($df eq "") || ($df =~ /\D/) ) {
  $df = "1";
}

$df =~ s/ //gi;

$count_file   = "$counter_path/$df.dat";

# check if the file exists
if ( not (-e $count_file)) {
  &counter_error;
}

&create_counter;

# Log the Counter Access
if ($uselog == 1) {
   $date = &get_date;
   &log_access;
}

exit;

# functions

sub get_file_lock {
  local ($lock_file) = @_;
  local ($endtime);
  $endtime = 60;
  $endtime = time + $endtime;
  while (-e $lock_file && time < $endtime){
     sleep(1);
  }
  open(LOCK_FILE, ">$lock_file") || die ("Could not open the lock file");
  if($flock) {
     flock(LOCK_FILE, 2);
  }  
} 

sub release_file_lock{
  local ($lock_file) = @_;
  if($flock) {
     flock(LOCK_FILE, 8);
  }
  close(LOCK_FILE);
  unlink($lock_file);
} 

sub get_num {
   open(COUNT,"$count_file") || die "Can't Open Count Data File: $!\n"; 
   $count = <COUNT>;
   close(COUNT);   
   if ($count =~ /\n$/) {
      chop($count);
   }   
   $count++;   
   open(COUNT,">$count_file") || die "Can't Open Count Data File For Writing: $!\n";
   print COUNT "$count";
   close(COUNT);   
}

sub log_access {
   $remote_addr = $ENV{'REMOTE_ADDR'}; 
   $remote_host = $ENV{'REMOTE_HOST'};   
   if ($ENV{'REQUEST_METHOD'} eq "GET") {
        $query_string  = $ENV{'QUERY_STRING'};
   }
   elsif ($ENV{'REQUEST_METHOD'} eq "POST") {   
        read(STDIN,$query_string ,$ENV{'CONTENT_LENGTH'});
   }   
   $remote = "$remote_addr - $remote_host ";
   open(LOG,">>$df.access_log") || die "Can't Open User Access Log: $!\n";
   print LOG "[$date] $ENV{'HTTP_REFERER'} - $remote - $query_string - $ENV{'HTTP_USER_AGENT'}\n";
   close(LOG);   
}

sub get_date {
  local ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst,$date);
  local (@days, @months); 
  @days   = ('Sunday','Monday','Tuesday','Wednesday','Thursday',
             'Friday','Saturday');
  @months = ('January','February','March','April','May','June','July',
             'August','September','October','November','December');
  ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);
  if ($hour < 10) { 
    $hour = "0$hour"; 
  }
  if ($min < 10) { 
    $min = "0$min"; 
  }
  if ($sec < 10) {
    $sec = "0$sec";
  }    
  $year = 1900 + $year;  
  $date = "$days[$wday], $months[$mon] $mday, $year at $hour\:$min\:$sec";
  return $date;
}

sub counter_error {

  print "error";
  exit;
    
}

sub create_counter {

  # Get the count and update it to data file
  &get_file_lock("$df.lockfile");
  &get_num;
  &release_file_lock("$df.lockfile");

  # display the counter image

  $count = "0" x $len . $count ;

  $count = substr($count, length($count) - $len , $len);

  for ($i=0; $i<$len; $i++) {
        $gf = substr($count,$i,1);
        $counter = qq~<img src="$digit_dir/$gf.gif" width="$width" height="$height" alt="$gf">~;
        print $counter;
  }
}
