#!/usr/bin/perl
$|=1;
############################################################################
#                                                                          #
# Application  : admin.cgi                                                 #
# Description  : Configure Argala Counter Script                           #
# Version      : 1.00                                                      #
# Created      : 7th April 2000                                            #
# Last Updated : 16th May 2000                                             #
#                                                                          #
# Copyright (c) 2000 Argala. All rights reserved.                          #
# WWW    : http://www.argala.com                                           #
# Email  : webmaster@argala.com                                            #
#                                                                          #
############################################################################

require "../arcount.cfg";
#require "$counter_path/cgi-lib.pl";
#require "$counter_path/config.pl";

$custom_file = "$counter_path/custom.pl";

if (-e "$custom_file"){
   require "$custom_file"; 
}

$script_url = "admin.cgi";

$fontface         = "verdana, arial, helvetica";
$fontface_button  = "courier new,courier";

$menu_bgcolor          = "#3399FF";
$menu_header_bgcolor   = "#CCFFCC";
$menu_header_textcolor = "#0000FF";

$fontcolor  = "#FFFFFF";
$fontcolor1 = "#000000";
$fontsize   = "-1";
$fontsize_small = "-1";

if ($flock == 1){
  $flock_radio_yes = "CHECKED";
  $flock_radio_no  = "";
}
else{
  $flock_radio_yes = "";
  $flock_radio_no  = "CHECKED";
}

if ($uselog == 1){
  $uselog_radio_yes = "CHECKED";
  $uselog_radio_no  = "";
}
else{
  $uselog_radio_yes = "";
  $uselog_radio_no  = "CHECKED";
}


# configure selection

$config_button{'counter_cfg'} = 1;
                    
@mainmenu_variables = (
                       "Press the 'Configure' button to configure Argala Counter.|configure_counter|Configure"
                    );

@form_variables = (  	      
         "SECTION|Argala Counter",         
         "OPTION|If your system supports flock() function, please select 'Yes', otherwise select 'No'?|flock|1,0|$flock_radio_yes,$flock_radio_no|Yes,No",                  
         "OPTION|If you would like to log the counter access, please select 'Yes', otherwise select 'No'?|uselog|1,0|$uselog_radio_yes,$uselog_radio_no|Yes,No",                           
         "SELECT|Length of the counter|len|$len",                                    
         "SELECT|Width of the image|width|$width",                                    
         "SELECT|Height of the image|height|$height"         
         );                  
         
read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
@pairs = split(/&/, $buffer);
foreach $pair (@pairs) {
	($name, $value) = split(/=/, $pair);
	$value =~ tr/+/ /;
	$value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
	if ($FORM{$name}) { $FORM{$name} = $FORM{$name}.",".$value; }
	else { $FORM{$name} = $value; }
      $value =~ s/<!--(.|\n)*-->//g;
}

@path_variables = (            
      "$counter_path/1.dat|er"
);
                     
if ($FORM{'verify'}) {

  &html_header_config("Argala Counter Configuration");
  
  $is_path_ok = &validate;     
 
  if ( $is_path_ok ne "") {     
     &error_message;      
  }
  else {       
     &verify($config_button{'counter_cfg'});        
  }   
}
elsif ($FORM{'update'}) {
  &html_header_config("Argala Counter Configuration");  
  &update($config_button{'counter_cfg'});
}
elsif ($FORM{'configure_counter'}) {
  &html_header_config("Argala Counter Configuration");    
  &config_form($config_button{'counter_cfg'});
}
else {
  &html_header_config("Argala Counter Main Menu");
  &main_menu;
}

&html_footer_config;

exit;



# functions

sub config_form{

local($choice) = @_;

local($check);

local($section_count);

print qq~
<FORM METHOD=POST ACTION="$script_url">
<TABLE BORDER="0" WIDTH=100%>
~;

&menu_table_header(0);

foreach $line(@form_variables){

   @form_fields = split(/\|/,$line);
   
   if ($form_fields[0] eq "SECTION") {
     $section_count ++;
   }
   
   if ($section_count != $choice){
      next;
   }
      
   $form_fields[4] =~ s/>/&gt;/gi;
  
   if($form_fields[0] eq "SECTION"){           
       print qq~
       <TR BGCOLOR="$menu_header_bgcolor">
       <TD COLSPAN=2 ALIGN=CENTER>
       <FONT FACE="$fontface" COLOR="$menu_header_textcolor">
       <FONT SIZE=+1><B>Argala Counter</B></FONT><BR>
       <B>Please answer the following questions about <BR>$form_fields[1]</B>
       </FONT>
       </TD>
       </TR>
       ~;
   }
   elsif($form_fields[0] eq "OPTION"){           
              
       ($yes[0], $no[0]) = split(/\,/,$form_fields[3]);
       ($yes[1], $no[1]) = split(/\,/,$form_fields[4]);
       ($yes[2], $no[2]) = split(/\,/,$form_fields[5]);
       print qq~
       <TR>
       <TD COLSPAN=2 ALIGN=LEFT><FONT FACE="$fontface" COLOR="$fontcolor" SIZE=$fontsize><B>$form_fields[1]</B></FONT></TD>
       </TR>
       <TR>
       <TD WIDTH=30%>\&nbsp</TD>
       <TD>
       <INPUT TYPE=radio NAME="$form_fields[2]" VALUE="$yes[0]" $yes[1]><FONT FACE="$fontface" COLOR="$fontcolor" SIZE=$fontsize><B>$yes[2]</FONT>\&nbsp <INPUT TYPE=radio NAME="$form_fields[2]" VALUE="$no[0]" $no[1]><FONT FACE="$fontface" COLOR="$fontcolor" SIZE=$fontsize><B>$no[2]</FONT> \&nbsp 
       </TD>
       </TR>
       ~;
   }
   elsif($form_fields[0] eq "SELECT"){
       print qq~
       <TR>
       <TD colspan=2><FONT FACE="$fontface" COLOR="$fontcolor" SIZE=$fontsize><B>$form_fields[1]</B></FONT></TD>
       </TR>
       <TR>
       <TD colspan=2>
       <center>
       <SELECT NAME="$form_fields[2]">
       ~;
       
       if ($form_fields[2] eq "len") {        
          for($i = 1 ; $i <= 15 ; $i ++) {          
             if ($len == $i) {
               $select_mark = "SELECTED";
             }
             else {
               $select_mark = "";
             }  
                          
             print qq~
             <OPTION VALUE="$i" $select_mark>$i</OPTION>
             ~;       
          }
       }   

       if ($form_fields[2] eq "width") {        
          for($i = 1 ; $i <=100 ; $i ++) {          
             if ($width == $i) {
               $select_mark = "SELECTED";
             }
             else {
               $select_mark = "";
             }  
  
             print qq~             
             <OPTION VALUE="$i" $select_mark>$i</OPTION>
             ~;       
          }
       }   
       
       if ($form_fields[2] eq "height") {        
          for($i = 1 ; $i <=100 ; $i ++) {          
             if ($height == $i) {
               $select_mark = "SELECTED";
             }
             else {
               $select_mark = "";
             }  
             print qq~
             <OPTION VALUE="$i" $select_mark>$i</OPTION>
             ~;       
          }       
       
       }
       
       print qq~
       </SELECT>
       </center>
       </TD>
       </TR>
       ~
   }   
   elsif($form_fields[0] eq "TEXTBOX"){
       print qq~
       <TR>
       <TD COLSPAN=2><FONT FACE="$fontface" COLOR="$fontcolor" SIZE=$fontsize><B>$form_fields[1]</B></FONT></TD>
       </TR>
       <TR>
       <TD COLSPAN=2 ALIGN=CENTER>
       <TEXTAREA NAME="$form_fields[2]" ROWS="$form_fields[3]" COLS="$form_fields[4]">$form_fields[5]</TEXTAREA>
       </TD>
       </TR>
       ~
   }
   elsif($form_fields[0] eq "CHECKBOX"){
       
       @req_names = split(/\,/,$form_fields[3]);
       
       print qq~
       <TR>
       <TD VALIGN=TOP><FONT FACE="$fontface" COLOR="$fontcolor" SIZE=$fontsize><B>$form_fields[1]</B></FONT></TD>
       <TD>
       ~;
       
       $i = 0;
       foreach $req_name(@req_names) {
          
          $i ++;          
          ($cc1, $cc2) = split(/\=/,$req_name);  
          
          $check_ccname = "";
          foreach $tmp_ccname(@required_fields) {
              
              ($tmp_cc1, $tmp_cc2) = split(/\=/,$tmp_ccname);  
              if ($cc2 eq $tmp_cc1){
                $check_ccname = "CHECKED";
                last;
              }                            
          }
                  
          print qq~<INPUT TYPE=CHECKBOX NAME="$cc2" $check_ccname><FONT FACE="$fontface" COLOR="$fontcolor" SIZE=$fontsize><B>$cc1</B></FONT><BR>~;
         
       }
       
       print qq~
       </TD>
       </TR>
       ~;
       
   }
   else{              

       $tab_width = 100;
              
       if ($form_fields[0] eq ""){
          print qq~
          <TR>
          <TD WIDTH=$tab_width ALIGN=RIGHT><FONT FACE="$fontface" COLOR="$fontcolor" SIZE=$fontsize><B>$form_fields[5]</B></FONT> \&nbsp </TD>
          <TD><FONT FACE="$fontface" COLOR="$fontcolor" SIZE=-1><INPUT TYPE=TEXT NAME="$form_fields[1]" SIZE="$form_fields[2]" VALUE="$form_fields[4]"></FONT>
          </TD>
          </TR>
          ~;       
       }
       else {
          print qq~
          <TR>
          <TD COLSPAN=2><FONT FACE="$fontface" COLOR="$fontcolor" SIZE=$fontsize><B>$form_fields[0]</B></FONT></TD>
          </TR>
          <TR>
          <TD WIDTH=$tab_width ALIGN=RIGHT><FONT FACE="$fontface" COLOR="$fontcolor" SIZE=$fontsize><B>$form_fields[5]</B></FONT> \&nbsp </TD>
          <TD><FONT FACE="$fontface" COLOR="$fontcolor" SIZE=-1><INPUT TYPE=TEXT NAME="$form_fields[1]" SIZE="$form_fields[2]" VALUE="$form_fields[4]"></FONT>
          </TD>
          </TR>
          ~;
       }    
   }
}

print qq~
<TR>
<TD COLSPAN=2 ALIGN=CENTER>
<INPUT TYPE=HIDDEN VALUE="$FORM{'configure'}" NAME="config_choice">
<BR><FONT FACE="$fontface_button" SIZE="$fontsize_small">
<INPUT TYPE=SUBMIT VALUE="Verify" NAME="verify">\&nbsp <INPUT TYPE=RESET>
</FONT></TD> 
</TR>
~;

&menu_table_footer(2);

print qq~
</FORM>
~;

}

sub verify{

local($choice) = @_;
local($section_count);

&menu_table_header(0);

foreach $line(@form_variables){

   @form_fields = split(/\|/,$line);

   if ($form_fields[0] eq "SECTION") {
     $section_count ++;
   }
   
   if ($section_count != $choice){
      next;
   }

   if($form_fields[0] eq "SECTION"){           
          
       print qq~
       <TR BGCOLOR="$menu_header_bgcolor">
       <TD COLSPAN=2 ALIGN=CENTER>
       <FONT FACE="$fontface" COLOR="$menu_header_textcolor">
       <FONT SIZE=+1><B>Argala Counter</B></FONT><BR>       
       <B>$form_fields[1]</B></FONT>
       </TD>
       </TR>
       ~;       
       
   }
   elsif($form_fields[0] eq "OPTION"){           

       print qq~
       <TR>
       <TD COLSPAN=2 ALIGN=LEFT><FONT FACE="$fontface" COLOR="$fontcolor" SIZE=$fontsize><B>$form_fields[1]</B></FONT></TD>
       </TR>       
       ~;
       
       if ($FORM{$form_fields[2]} == 1){         
         print qq~
         <TR>
         <TD COLSPAN=2 ALIGN=CENTER>
         <TABLE BORDER COLS=1 WIDTH="20%" BGCOLOR="#FFFFFF" >
         <TR>
         <TD ALIGN=CENTER><FONT FACE="$fontface" SIZE=$fontsize COLOR="$fontcolor1"><B>Yes</B></FONT></TD>
         </TR>
         </TABLE>         
         </TD>
         </TR>
         ~;
       }
       else {
         print qq~
         <TR>
         <TD COLSPAN=2 ALIGN=CENTER>

         <TABLE BORDER COLS=1 WIDTH="20%" BGCOLOR="#FFFFFF" >
         <TR>
         <TD ALIGN=CENTER><FONT FACE="$fontface" SIZE=$fontsize COLOR="$fontcolor1"><B>No</B></FONT></TD>
         </TR>
         </TABLE>         

         </TD>
         </TR>
         ~;       
       }            
       
   }
   elsif($form_fields[0] eq "SELECT"){
 
       $FORM{$form_fields[2]} =~ s/</\&lt;/gi;
       $FORM{$form_fields[2]} =~ s/>/\&gt;/gi;       
       
       print qq~
       <TR>
       <TD COLSPAN=2 ALIGN=LEFT>
       <TABLE CELLSPACING=0 CELLPADDING=0>
       <TR>
       <TD COLSPAN=2>
       <FONT FACE="$fontface" COLOR="$fontcolor" SIZE=$fontsize><B>$form_fields[1]</B></FONT>
       </TD>
       </TR>
       <TR>
       <TD COLSPAN=2 ALIGN=CENTER>
       <TABLE BORDER COLS=1 WIDTH="50%" >
       <TR>
       <TD ALIGN=CENTER BGCOLOR="#FFFFFF" ><FONT FACE="$fontface" COLOR="$fontcolor1" SIZE=$fontsize><B>$FORM{"$form_fields[2]"}</B></FONT>\&nbsp 
       </TD>
       </TR>
       </TABLE>                           
       </TD>
       </TR>
       </TABLE>
       </TD>               
       </TR>
       ~;    
   }   
   elsif($form_fields[0] eq "TEXTBOX"){
 
       $FORM{$form_fields[2]} =~ s/</\&lt;/gi;
       $FORM{$form_fields[2]} =~ s/>/\&gt;/gi;             
       
       print qq~
       <TR>
       <TD COLSPAN=2><FONT FACE="$fontface" COLOR="$fontcolor" SIZE=$fontsize><B>$form_fields[1]</B></FONT></TD>
       </TR>
       <TR>       
       <TD COLSPAN=2 ALIGN=CENTER>
               
       <TABLE BORDER COLS=1 WIDTH="70%" BGCOLOR="#FFFFFF" >
       <TR>
       <TD ALIGN=LEFT><PRE><FONT FACE="$fontface" COLOR="$fontcolor1" SIZE=$fontsize><B>$FORM{$form_fields[2]}</B></FONT></PRE>\&nbsp</TD>
       </TR>
       </TABLE>                           
       
       </TD>
       </TR>
       ~;
   
   }
   else{       
 
       $FORM{$form_fields[1]} =~ s/</\&lt;/gi;
       $FORM{$form_fields[1]} =~ s/>/\&gt;/gi;       
 
       if ($form_fields[0] eq ""){
          print qq~
          <TR>
          <TD WIDTH=40% ALIGN=RIGHT><FONT FACE="$fontface" COLOR="$fontcolor" SIZE=$fontsize><B>$form_fields[5]</B></FONT> \&nbsp </TD>
          <TD>
          <TABLE BORDER COLS=1 WIDTH="70%" BGCOLOR="#FFFFFF" >
          <TR>
          <TD ALIGN=LEFT><FONT FACE="$fontface" COLOR="$fontcolor1" SIZE=$fontsize><B>$FORM{$form_fields[1]}</B> \&nbsp</FONT></TD>
          </TR>
          </TABLE>                                              
          </TD>
          </TR>
          ~;       
       }
       else {
          print qq~
          <TR>
          <TD COLSPAN=2><FONT FACE="$fontface" COLOR="$fontcolor" SIZE=$fontsize><B>$form_fields[0]</B></FONT></TD>
          </TR>
          <TR>
          <TD ALIGN=RIGHT><FONT FACE="$fontface" COLOR="$fontcolor" SIZE=$fontsize><B>$form_fields[5]</B></FONT> \&nbsp </TD>
          <TD>          
          <TABLE BORDER COLS=1 WIDTH="70%" BGCOLOR="#FFFFFF" >
          <TR>
          <TD ALIGN=LEFT><FONT FACE="$fontface" COLOR="$fontcolor1" SIZE=$fontsize><B>$FORM{$form_fields[1]}</B> \&nbsp </FONT></TD>
          </TR>
          </TABLE>                                               
          </TD>
          </TR>
          ~;
       }           
   }
}

print qq~<FORM METHOD=POST ACTION="$script_url">~;

@fields = sort(keys(%FORM));

foreach $field(@fields){       
    if($field eq "verify" || $field eq "config_choice"){ 
       next;
    }    

    $FORM{$field} =~ s/</\&lt;/gi;
    $FORM{$field} =~ s/>/\&gt;/gi;
    $FORM{$field} =~ s/"/\%22/gi;

    print qq~
    <INPUT TYPE=HIDDEN VALUE="$FORM{$field}" NAME="$field">
    ~;       
}

print qq~
<TR>
<TD COLSPAN=2 ALIGN=CENTER>
<INPUT TYPE=HIDDEN VALUE="$FORM{'config_choice'}" NAME="update_choice">
<CENTER><FONT FACE="$fontface_button" SIZE="$fontsize_small">
<INPUT TYPE=SUBMIT VALUE="Update" NAME="update">
</FONT><CENTER>
</FORM>
</TD> 
</TR>
~;

&menu_table_footer(2);

}

sub update{
  
  local($choice) = @_;
  
  @fields = sort(keys(%FORM));
  
  local($variables);
  
  $variables = "";
                
  foreach $field(sort @fields){     
    
    if ($field eq "update" || $field eq "update_choice") {        
        next;
    }    
            
    $FORM{$field} =~ s/'/\\'/gi; 
    $variables .= qq~\$$field = '$FORM{$field}';\n~;      
    
  }
       
  $variables =~ s/\&lt;/</gi;
  $variables =~ s/\&gt;/>/gi;  
  $variables =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
  
  if (-e "$custom_file") {
     open (CUSTOM_TEXT, "$custom_file")|| die("Can't read $custom_file");
     @lines = <CUSTOM_TEXT> ;
     close (CUSTOM_TEXT);     
  }   

  open (CUSTOM_TEXT, ">$custom_file")|| die("Can't write $custom_file");
  
  $is_new_section = 1;
      
  foreach $line(@lines) {
     
     if ($line =~ /1\;/i ) {
        next;
     }
          
     if ($line =~ /\#\#\#\#$FORM{'update_choice'}-start/i ) {
        $section_start = 1;               
        $is_new_section = 0;
        print CUSTOM_TEXT "####$FORM{'update_choice'}-start\n";        
     }                 

     if ($line =~ /\#\#\#\#$FORM{'update_choice'}-end/i ) {              
        print CUSTOM_TEXT $variables;       
        $section_start = 0;               
     }
     
     if ($section_start == 1) {
        next;
     }
     else{            
        print CUSTOM_TEXT $line;            
     }            
  }
  
  if(@lines == 0 || $is_new_section == 1) {
     print CUSTOM_TEXT "####$FORM{'update_choice'}-start\n";
     print CUSTOM_TEXT $variables;       
     print CUSTOM_TEXT "####$FORM{'update_choice'}-end\n";         
  }  
  print CUSTOM_TEXT "1;\n";     
  close (CUSTOM_TEXT);     
  &main_menu;      
}

sub html_header_config{
   
   local($title) = @_;
   local($warning) ;

   ($ENV{'REMOTE_USER'} or $ENV{'AUTH_USER'}) ? ($warning = '') :
   ($warning = '<h1><blink><FONT COLOR=#FF0000>WARNING: ADMIN Directory is not Password Protected!</FONT></blink></h1>');

   print "Content-type: text/html\n\n";
   print "<HTML>\n";
   print "<HEAD><TITLE>$title</TITLE></HEAD>\n";   
   print qq~
   <body text="#000000" BGCOLOR="#CCFFFF" link="#0000EE" vlink="#0000FF" alink="#FF0000">
   <center>$warning</center>    
   ~;
}

sub html_footer_config{    
   print "</BODY></HTML>\n";   
}

sub copyright_link{
   print qq~
   <FONT FACE="$fontface" COLOR="$menu_header_textcolor" SIZE="-1"><B>Copyright &copy; <A HREF="http://www.argala.com">Argala.com</a> 2000 All rights reserved</B></FONT>
   ~;
}
  
sub validate{
  
  local($path_error);
  
  foreach $path_variable(@path_variables){     
      ($path_name,$path_right) = split(/\|/,$path_variable);      
      $path_error .= &check_path($path_name, $path_right);   
  }
  
  if(not &isnumeric($FORM{"width"}) ){
     $path_error .= qq~
     <TR><TD><FONT FACE="$fontface" color="$fontcolor"><B>Width must be numeric.</B></FONT></TD></TR>
     ~;             
  }  

  if(not &isnumeric($FORM{"height"}) ){
     $path_error .= qq~
     <TR><TD><FONT FACE="$fontface" color="$fontcolor"><B>Height must be numeric.</B></FONT></TD></TR>
     ~;             
  }  
        
  return $path_error;
}

sub check_path {
    
  local($path, $rights) = @_;

  local($out);
  
  if ($rights =~ /e/i) { # exist
    if (!(-e $path)) {
      $out .= qq~
      <TR><TD>      
      <FONT FACE="$fontface" color="$fontcolor"><B>$path does not exist.</B></FONT></TD>
      </TR>
      ~;
    } 
  }

  if ($rights =~ /r/i) { # read
    if (!(-r $path)) {
      $out .= qq~
      <TR><TD>
      <FONT FACE="$fontface" color="$fontcolor"><B>Can't read from $path </B></FONT></TD>
      </TR>
      ~;
    } 
  }

  if ($rights =~ /w/i) { # write
    if (!(-w $path)) {
      $out .= qq~
      <TR><TD>
      <FONT FACE="$fontface" color="$fontcolor"><B>Can't write from $path </B></FONT></TD>
      </TR>
      ~;
    } 
  }

  if ($rights =~ /x/i) { # execute
    if (!(-x $path)) {
      $out .= qq~
      <TR><TD>
      <FONT FACE="$fontface" color="$fontcolor"><B>Can't execute from $path </B></FONT></TD>
      </TR>
      ~;      
    } 
  } 
  
  return $out;
} 

sub error_message {
      
      &menu_table_header(0);
      
      print qq~
      <TR BGCOLOR="$menu_header_bgcolor">
      <TD ALIGN=CENTER>
      <FONT FACE="$fontface" COLOR="$menu_header_textcolor">
      <FONT SIZE=+1><B>Argala Counter</B></FONT><BR>       
      <B>Error(s)</B></FONT>
      </TD>
      </TR>
      ~;            
      
      print "$is_path_ok";      
      &menu_table_footer(1);
      
      print qq~
      <CENTER>
      <FORM>
      <INPUT TYPE=BUTTON VALUE="  Go Back  " onClick="history.go(-1)">
      </FORM>
      </CENTER>
      ~;
}

sub menu_table_header {
  
  local($border) = @_;    
  print qq~
  <center>
  <TABLE WIDTH="550" BORDER="1" CELLSPACING="0" CELLPADDING="0" BORDERCOLOR="#666633" ALIGN="CENTER">
  <TR>
  <TD>
  <TABLE BORDER="$border" CELLSPACING="0" CELLPADDING="5" WIDTH="100%" BGCOLOR="$menu_bgcolor">
  ~;  
}

sub menu_table_footer {  
  local($colspan) = @_;  
  print qq~
  <TR BGCOLOR="$menu_header_bgcolor">
  <TD COLSPAN=$colspan ALIGN=CENTER>
  ~;
  &copyright_link;
  print qq~  
  </TD>
  </TR>  
  </TABLE>
  </TD>
  </TR>
  </TABLE>
  </CENTER>
  ~;
}

sub main_menu {
        
  &menu_table_header(1);
    
  print qq~
  <tr BGCOLOR="$menu_header_bgcolor">
  <TD colspan=2 align=center><FONT FACE="$fontface" COLOR="$menu_header_textcolor" SIZE=+1><B>Argala Counter Main Menu</B></FONT></td>
  </tr>
  ~;

  foreach $line(@mainmenu_variables){
     @form_fields = split(/\|/,$line);
     print qq~  
     <FORM METHOD=POST ACTION="$script_url">               
     <TR>
     <TD ALIGN=LEFT VALIGN=TOP><FONT FACE="$fontface" SIZE=$fontsize COLOR="$fontcolor">
     <B>$form_fields[0]</B>
     </FONT>
     </TD>
     <TD ALIGN=CENTER VALIGN=TOP>
     <FONT FACE="$fontface_button" SIZE="$fontsize_small">
     <INPUT TYPE=HIDDEN NAME="configure"        VALUE="counter_cfg">     
     <INPUT TYPE=SUBMIT NAME="$form_fields[1]"  VALUE="$form_fields[2]">
     </FONT>
     </TD>
     </TR>  
     </FORM>
     ~;     
  }  
  &menu_table_footer(2);
}

sub isnumeric {

   local($in) = @_;
   local($i);
   local($count);   
   local($out) = 0;
   
   for($i = 0; $i < length($a) ; $i++) {  
      if ( substr($in , $i , 1) eq ".") {
      $count ++;
      } 
   }
   if ($count > 1) {
      $out = 0;
   }
   else {
      $in =~ s/\.//gi;
      if (not $in =~ /\D/) {
         $out = 1;
      }   
      else {
        $out = 0;
      }
   }   
   return $out;   
}
