# Config Script for LedAds v2.0
################################################################
#		       	LedAds v2.0 
#
# This program is distributed as freeware. We are not
# responsible for any damages that the program causes	
# to your system. It may be used and modified free of 
# charge, as long as the copyright notice
# in the program that give me credit remain intact.
# If you find any bugs in this program. Please feel free 
# to report it to bugs@ledscripts.com.
# If you have any troubles installing this program. Please feel
# free to post a message on our Support Forum.
# Selling this script is absolutely forbidden and illegal.
#
# On another note: This is the 'best' script I've released
# to date, so ripping of the code will really make me made :)
# Just be kind and don't take code. I gave away this program
# to you for free, so please don't abuse my kindness.
################################################################
#
#	               COPYRIGHT NOTICE:
#	
#	         Copyright 2000 Jon Coulter
#	
#	      Author:  Jon Coulter
#	      Web Site: http://www.ledscripts.com
#	      E-Mail: ledjon@ledscripts.com
#	      Support: http://www.ledscripts.com/ (or support@ledscripts.com)
#
#       This program is protected by the U.S. Copyright Law
################################################################

# Edit the config value below
%config = (
			# This is the login username
			# do something like,
			# user	=> 'my_user_name',
			user	=> 'admin',
			
			# This is the password for the above user
			# example:
			# pass	=> 'my_password',
			pass	=> 'asdf',
			
			#==========================================
			# The rest of this is just standard stuff.
			# Only change it before 'running' it the 1st time
			# I suggest you just don't change it at all
			#==========================================
			tplfile	=> 'data/la_tpl',
			dbfile	=> 'data/la_data.db',
			statdb	=> 'data/la_stats.db',
			imgdb	=> 'data/la_images.db',
			delim	=> '|:|',
			font_face => 'Verdana, Arial, Helvetica, sans-serif',
			font_size => 2
		   );

# we prefer DB_File... by far. But it isn't installed on every system
# so we're going to use AnyDBM_File and let it pick based on a list
BEGIN { 
		$CGI::HEADERS_ONCE = 1;
		@AnyDBM_File::ISA = qw(DB_File GDBM_File NDBM_File SDBM_File);
	  }

use AnyDBM_File;
use FileHandle;
use CGI qw/:standard -no_debug/;
use CGI::Carp qw(fatalsToBrowser set_message);
use POSIX qw/strftime/;

# setup some tie() args
$dbmfile = 'AnyDBM_File';
$filemode = O_RDWR|O_CREAT;

srand((time() ^ (time() % $])) ^ exp(length($0))**$$);

%c = (
		image	=> 1,
		rich	=> 2
		);
		
$tbl_settings = {
					-width=>'95%',
					-border=>1,
					-cellspacing=>1,
					-cellpadding=>0,
					-bordercolor=>"#000000",
					-align	=> 'center'
				};

$me = $ENV{'SCRIPT_NAME'};
$me =~ s|\?.+$||ig;

# setup compile time stuff
BEGIN {
	sub handle_errors {
		my $err = shift;
		
		print "<h1>Error!</h1>";
		print "<b>Unexpected CGI Error!</b><br>", $err;
		
		return 1;
	}
	
	set_message(\&handle_errors);
}

# to parse the query string
sub parse_string($) {
	my $in = shift;
	my %return;
	
    my @pairs = split(/&/, $in);
	
    foreach my $item (@pairs) {
    	my ($name,$value) = split(/=/, $item, 2);
			$value =~ tr/+/ /;
			$value =~ s/%(..)/pack("c",hex($1))/ge;
			$name =~ tr/+/ /;
			$name =~ s/%(..)/pack("c",hex($1))/ge;
    	$return{$name} = $value;
    }
    
    return %return;
}

sub header {
	return if $printed{'header'}++;
	
	return CGI::header(@_) || "Content-type: text/html\n\n";
}

# Fixed up td() to allow for auto-fonts
sub td {
	my @in = @_;
	
	foreach(@in) {
		if(ref($_) eq 'ARRAY') {
			foreach $a (@{$_}) {
				$a = font({-face=>$main::config{'font_face'}, -size=>$main::config{'font_size'}}) . $a;
			}
		} else {
			unless(ref($_)) {
				$_ = font({-face=>$main::config{'font_face'}, -size=>$main::config{'font_size'}}) . $_;
			}
		}
	}
	
	return CGI::td(@in);
}

sub center {
	return '<center>' . shift() . '</center>';
}

sub count_hash {
	my %hash = @_;
	
	return scalar (keys %hash);
}

sub high_key {
	my %in = @_;

	foreach my $key (sort { $b <=> $a } keys %in) {
		return $key;
	}
	
	return 0;
}

sub init_db {
	unless(%main::db) {
		tie(%main::db, $dbmfile, $config{'dbfile'}, $filemode, 0640) or die $!;
	}
	
	# only returns so that we can return true if needed
	return %main::db;
}

sub end_db {
	if(%main::db) {
		untie %main::db or die $!;
		
		undef(%main::db);
	}
	
	return 1;
}

sub is_logged_in {
	my $test = cookie('la_auth_user');
	
	if($test eq $config{'user'}) {
		return 1;
	} else {
		return 0;
	}
}

# upload sub
sub fetch_upload {
	my $field = shift;
	
	return_text("No field found ($field)", 1) unless $field;
	
	my $filename = param($field);
	my $fh = upload($field) or die "Not a real uploaded file ($filename - $fh)!\n";
	
	return_text("Unable to get filehandle ($fh) or filename ($filename)", 1) unless $fh && $filename;
	
	my $data = join('', <$fh>);
		die "Unable to fetch data for upload!\n" unless $data;
	my $ct = $foo->uploadInfo($filename)->{'Content-Type'};
	
	return_text("Unable to get conten-type of $filename", 1) unless $ct;
	
	return (wantarray) ? ($data, $ct) : $data;
}

sub fetch_ad {
	my $key = shift || 1;
	my $return;
	
	init_db();
	
	unless(defined($db{$key})) {
		die "Undefined key element on ad fetch: $key\n";
	}
	
	my ($type, $rest) = split(/\Q$config{delim}\E/, $db{$key}, 2);
	
	if($type == $c{'image'}) { # image type
		my $self = $me;
		$self =~ s|/([^/]+)$|/la_click.cgi|;
		$self .= '?key='.$key;
		
		my ($image_url, $links_to, $alt_text, $target, $width, $height) = split(/\Q$config{delim}\E/, $rest);
		
		$return = a({-href=>$self, -target=>$target},
					img({-src => $image_url, -alt=>$alt_text, -width=>$width, -height=>$height, -border=>0})
				);
	} else { # must be rich text
		my $rnd = rand($$**2);
		
		$rest =~ s/^\Q$config{delim}\E//ig;
		$rest =~ s/\Q[random]\E/$rnd/ig;
		
		$return = $rest;
	}

	$return = '<!-- Powered by LedAds v2.0 - http://www.ledscripts.com -->' . $return;
	$return .= '<!-- End LedAds v2.0 Ad Code -->';
	
	return $return;
}

sub getnowdate() {
	# below was just for debugging
	#return strftime('%Y,%m,%d', localtime((time() + ((3600 * 24) * 365))));
	return strftime('%Y,%m,%d', localtime());
}

# count an impression for an ad
sub count_ad($) {
	my $key = shift;

	my %stats;
	tie(%stats, $dbmfile, $config{'statdb'}, $filemode, 0640) or die $!;
		if(defined $stats{$key}) {
			my @stats = split(/\Q$config{delim}\E/, $stats{$key});
			my @imps = @stats[0..3];
			my @clicks = @stats[4..7];
			my @date = split(/,/, $stats[-1]);
			
			my @now = split(/,/, getnowdate());
			
			@imps = map { ++$_ } @imps;
			
			for(0..2) {
				if($now[$_] != $date[$_]) {
					$imps[($_ + 1)] = 0;
				}
			}
			
			# join it all back together
			$stats{$key} = join($config{'delim'}, (@imps, @clicks, join(',', @now)));
		} else {
			$stats{$key} = join($config{'delim'}, (1, 1, 1, 1, 0, 0, 0, 0, getnowdate()));
		}
	untie %images;
	
	return 1;
}

sub count_click($) {
	my $key = shift;

	my %stats;
	tie(%stats, $dbmfile, $config{'statdb'}, $filemode, 0640) or die $!;
		if(defined $stats{$key}) {
			my @stats = split(/\Q$config{delim}\E/, $stats{$key});
			my @imps = @stats[0..3];
			my @clicks = @stats[4..7];
			my @date = split(/,/, $stats[-1]);
			
			my @now = split(/,/, getnowdate());
			
			@clicks = map { ++$_ } @clicks;
			
			for(0..2) {
				if($now[$_] != $date[$_]) {
					$imps[($_ + 1)] = 0;
				}
			}
			
			# join it all back together
			$stats{$key} = join($config{'delim'}, (@imps, @clicks, join(',', @now)));
		} else {
			$stats{$key} = join($config{'delim'}, (0, 0, 0, 0, 1, 1, 1, 1, getnowdate()));
		}
	untie %images;
	
	return 1;
}

sub redirect {
	my $key = shift or die "Unable to get key!";

	init_db();
	
	my ($type, $image_url, $links_to, $alt_text, $target, $width, $height) = split(/\Q$config{delim}\E/, $db{$key});
	
	die "Incorrect type for this ad!" if $type != $c{'image'};
	
	print "Location: $links_to\n\n";
	
	exit;
}

END { &main::end_db(); }

1;