#!/usr/bin/perl

################################################################
#		       	LedAds v2.0 
#
# This program is distributed as freeware. We are not
# responsible for any damages that the program causes	
# to your system. It may be used and modified free of 
# charge, as long as the copyright notice
# in the program that give me credit remain intact.
# If you find any bugs in this program. Please feel free 
# to report it to bugs@ledscripts.com.
# If you have any troubles installing this program. Please feel
# free to post a message on our Support Forum.
# Selling this script is absolutely forbidden and illegal.
#
# On another note: This is the 'best' script I've released
# to date, so ripping of the code will really make me made :)
# Just be kind and don't take code. I gave away this program
# to you for free, so please don't abuse my kindness.
################################################################
#
#	               COPYRIGHT NOTICE:
#	
#	         Copyright 2000 Jon Coulter
#	
#	      Author:  Jon Coulter
#	      Web Site: http://www.ledscripts.com
#	      E-Mail: ledjon@ledscripts.com
#	      Support: http://www.ledscripts.com/ (or support@ledscripts.com)
#
#       This program is protected by the U.S. Copyright Law
################################################################

# import all the important stuff
require('la_config.cgi');

# Real work starts here
$|++;

$foo = new CGI;
%in = parse_string($ENV{'QUERY_STRING'});
$action = $in{'action'} || 'main';
%printed = ();

try_login() unless is_logged_in() || $action eq 'do_login';

if(defined(&$action)) {
	my $returned;
	eval {
		$returned = &$action();
	};
	
	return_text(($@ ? $@ : ($returned || 'Nothing Returned!')));
} else {
	return_text( "Function ($action) does not exist!\n" );
}

# Text Return
sub return_text {
	my $msg = shift;
	my $tpl;
	
	if(-f $config{'tplfile'}) {
		my $fh = FileHandle->new($config{'tplfile'}, 'r') or die $!;
		$tpl = join('', <$fh>);
		$fh->close();
	} else {
		die "Unable to find template file: " . $config{'tplfile'};
	}
	
	$tpl =~ s|{menu}|&mainmenu()|ige;
	$tpl =~ s|{output}|$msg|ig;
	
	print header(), $tpl;
	
	exit(0) if shift;
}

sub main {
	my $return;
	
	init_db();

	$return = "Welcome to LedAds v2.0!" . br();
	
	$return .= "Total Ads in System: " . count_hash(%db) . br();

	return $return;
}

sub newad {
	my $return;
	
	my @radio_group = radio_group({
							-name=>'banner_type',
							-values=>['image', 'rich'],
							-deafult=>'image',
							-labels => {
										image	=> 'Image Ad',
										rich	=> 'Rich Text/HTML (Insert [random] for a radom ID)'
									   }
						});
						
	my @image_action = radio_group({
							-name=>'image_type',
							-values=>['url', 'upload'],
							-deafult=>'url',
							-labels => {
										url		=> 'Existing URL',
										upload	=> 'Upload New Image (See Readme)'
									   }
						});
	
	$return = center( b('Add New Ad Banner') ) . br();
	
	$return .= startform({-action=>$me.'?action=exec_newad', -method=>'POST', -enctype=>'multipart/form-data'});
	
	$return .= table($tbl_settings,
						Tr(
							[
								td({-colspan=>2},
									[
										shift(@radio_group)
									]
								),
								td({-valign=>'top'},
									[
										'Image:',
										shift(@image_action) . br() .
											textfield({-name=>'image_url', -size=>40}) . br() .
										shift(@image_action) . br() .
											filefield({-name=>'image_upload', -size=>40})
									]
								),
								td(
									[
										'Links To:',
										textfield({-name=>'links_to', -size=>40})
									]
								),
								td(
									[
										'Alt Text:',
										textfield({-name=>'alt_text', -size=>35, -value=>'[ Advertisement Info ]'})
									]
								),
								td(
									[
										'Target:',
										popup_menu({-name=>'target',
													-values => [ qw/_top _self _blank/ ],
													-labels => {
																_top	=> 'Current Browser (On Top)',
																_self	=> 'Current Window/Frame',
																_blank	=> 'New Window'
																}
												   })
									]
								),
								td( 
									[
										'Width:',
										textfield({-name=>'width', -size=>5, -value=>468})
									]
								),
								td( 
									[
										'Height:',
										textfield({-name=>'height', -size=>5, -value=>60})
									]
								),
								td({-colspan=>2},
									[
										shift(@radio_group)
									]
								),
								td({-colspan=>2},
									[
										textarea({-name=>'rich_text', rows=>10, cols=>50, wrap=>'VIRTUAL'})
									]
								),
							]
						)
					);
					
	$return .= center( submit({-value=>'Add New Ad'}) . CGI::reset('Reset Fields') );
	$return .= endform();
	
	return $return;
}

# big, complex sub here!
# well not too bad :p
sub exec_newad {
	my $return;
	my $image_url;
	
	init_db();
	
	# this is our new ad key
	my $key = (high_key(%db) + 1);
	
	if(param('banner_type') eq 'image') {
		# using image-type banners
		if(param('image_type') eq 'upload') {
			# upload fresh image
			# not recomended because of the load it takes to call back
			my ($data, $content_type) = fetch_upload('image_upload');
			
			die "Unable to get upload data!\n" unless $data;
			
			# Special hash/db file here
			my %images;
			tie(%images, $dbmfile, $config{'imgdb'}, $filemode, 0640) or die $!;
				die "Image ID already taken! Something's really messed up!\n" if defined $images{$key};

				$images{$key} = join(';', ($content_type, $data));			
			untie %images;
			
			my $self = $me;
			$self =~ s|/([^/]+)$|/la_image.cgi|;
			
			$image_url = $self . '?key=' . $key;
		} else {
			# existing image, recomented!
			$image_url = param('image_url');
		}
		
		return "You didn't specify an image (or an error)!" unless defined $image_url;
		
		$db{$key} = join($config{'delim'}, ($c{'image'}, $image_url, param('links_to'),
											param('alt_text'), param('target'), param('width'),
											param('height')));
											
		$return .= center( b('Added Image to DB Using Image Link Option!') );
	} else {
		# using rich text
		$db{$key} = join($config{'delim'}, ($c{'rich'}, param('rich_text')));
		
		$return .= center( b('Added Image to DB Using Rich Text Option!') );
	}
	
	$return .= 'Finished Adding new Ad!';
	
	return $return;
}

sub modify {
	my $return;
	
	# just print out all the ads
	init_db();
	
	my $table;
	foreach my $key (sort { $a <=> $b } keys %db) {
		$table .= Tr(
					td(
						center( fetch_ad($key) . br() .
						a({-href=>$me.'?action=modifyad&key='.$key}, 'Modify This Ad') )
					)
				   );
	}
	
	return table($tbl_settings, $table);
}

sub modifyad {
	init_db();
	
	my $key = $in{'key'};
	
	die "Unable to find $key\n" unless defined $db{$key};
	
	my ($type, $rest) = split(/\Q$config{delim}\E/, $db{$key}, 2);
	
	if($type == $c{'image'}) { # is image
		return modify_entry_image($key, $rest);
	} else {
		return modify_entry_rich($key, $rest);
	}
}

# modify image
sub modify_entry_image($$) {
	my $key = shift;
	my $rest = shift;
	my $return;
	
	my ($image_url, $links_to, $alt_text, $target, $width, $height) = split(/\Q$config{delim}\E/, $rest);
	
	$return = center(b('Modify Image Ad'));
	
	$return .= startform({-action=>$me.'?action=exec_modify_entry_image&key='.$key, -method=>'POST'});
	
	$return .= center( fetch_ad($key) );
	
	$return .= table($tbl_settings,
					Tr(
						[
							td(
								[
									'Image URL:',
									textfield({-name=>'image_url', -size=>45, -value=>$image_url})
								]
							),
							td(
								[
									'Links To:',
									textfield({-name=>'links_to', -size=>40, -value=>$links_to})
								]
							),
							td(
								[
									'Alt Text:',
									textfield({-name=>'alt_text', -size=>40, -value=>$alt_text})
								]
							),
							td(
								[
									'Target:',
									popup_menu({-name=>'target',
												-values => [ qw/_top _self _blank/ ],
												-labels => {
															_top	=> 'Current Browser (On Top)',
															_self	=> 'Current Window/Frame',
															_blank	=> 'New Window'
															},
												-default => $target
											   })
								]
							),
							td( 
								[
									'Width:',
									textfield({-name=>'width', -size=>5, -value=>$width})
								]
							),
							td( 
								[
									'Height:',
									textfield({-name=>'height', -size=>5, -value=>$height})
								]
							)
						]
					)
				);
				
	$return .= center( checkbox({-label=>' Delete Ad?', -name=>'delete', value=>1}) );
	$return .= center( submit({-value=>'Modify/Delete Ad'}) . CGI::reset({-value=>'Reset Fields'}) );
	$return .= endform();
	
	return $return;
}

sub exec_modify_entry_image {
	my $return;
	
	init_db();
	
	my $key = $in{'key'};
	
	die "Undefined key!" unless defined $db{$key};
	
	# Modify the line
	if(param('delete')) {
		delete $db{$key};
		
		my %images;
		tie(%images, $dbmfile, $config{'imgdb'}, $filemode, 0640) or die $!;
			delete $images{$key} if defined $images{$key};
		untie %images;
		
		my %stats;
		tie(%stats, $dbmfile, $config{'statdb'}, $filemode, 0640) or die $!;
			delete $stats{$key} if defined $stats{$key};
		untie %stats;
		
		$return = b('Ad Successfully Deleted!');
	} else {
		$db{$key} = join($config{'delim'}, ($c{'image'}, param('image_url'), param('links_to'),
							param('alt_text'), param('target'), param('width'),
							param('height')));
							
		$return = b('Ad Successfully Updated!');
	}
	
	return $return . hr() . modify()
}

# modify rich text entry
sub modify_entry_rich($$) {
	my $key = shift;
	my $rest = shift;
	my $return;
	
	my ($empty, $text) = split(/\Q$config{delim}\E/, $rest, 2);
	
	$return = center(b('Modify Image Ad'));
	
	$return .= startform({-action=>$me.'?action=exec_modify_entry_rich&key='.$key, -method=>'POST'});
	
	$return .= center( fetch_ad($key) );
	
	$return .= table($tbl_settings,
					Tr(
						[
							td(
								[
									textarea({-name=>'rich_text', rows=>10, cols=>50, wrap=>'VIRTUAL', -value=>$rest})
								]
							)
						]
					)
				);
				
	$return .= center( checkbox({-label=>' Delete Ad?', -name=>'delete', value=>1}) );
	$return .= center( submit({-value=>'Modify/Delete Ad'}) . CGI::reset({-value=>'Reset Fields'}) );
	$return .= endform();
	
	return $return;
}

sub exec_modify_entry_rich {
	my $return;
	
	init_db();
	
	my $key = $in{'key'};
	
	die "Undefined key!" unless defined $db{$key};
	
	if(param('delete')) {
		delete $db{$key};

		my %stats;
		tie(%stats, $dbmfile, $config{'statdb'}, $filemode, 0640) or die $!;
			delete $stats{$key} if defined $stats{$key};
		untie %stats;
		
		$return = "Deleted Ad Entry!";
	} else {
		$db{$key} = join($config{'delim'}, ($c{'rich'}, param('rich_text')));
		
		$return = "Modified Ad Entry!";
	}
	
	return $return . hr() . modify();
}

sub stats {
	my $return;
	my %stats;
	my $table;
	my @totals;
	
	init_db();
	
	tie(%stats, $dbmfile, $config{'statdb'}, $filemode, 0640) or die $!;
	
	$table = Tr(
				td(
					'ID/Link'
				) .
				td({-colspan=>4},
					[
						qw/Impressions Clicks/
					]
				)
			);
	
	$table .= Tr(
				td(
					[
						qw(&nbsp; Life Year Month Day
							Life Year Month Day)
					]
				)
			);
	
	foreach my $key (sort { $a <=> $b } keys %db) {
		my @row = (split(/\Q$config{delim}\E/, $stats{$key}))[0..7];
		my $link = (split(/\Q$config{delim}\E/, $db{$key}))[2];
		
		$table .= Tr(
					td(
						[
							a({-href=>$me.'?action=modifyad&key='.$key, -target=>'_blank'}, '#'.$key) . '/' .
								($link ? a({-href=>$link, -target=>'_blank'}, 'Link') : 'N/A'),
								@row[0..3],
								($link ? @row[4..7] : qw(N/A N/A N/A N/A))
						]
					)
				);
		
		my $i = 0;
		map { $total[$i++] += $_ } @row;
	}
	
	$table .= Tr(
				td({-bgcolor=>'black'},
					[
						('Total', @total)
					]
				)
			);
	
	$return = table($tbl_settings, $table);
	
	return $return;
}

sub try_login {
	my $msg = shift;
	
	my $return = start_form({-action=>$me.'?action=do_login'});
	
	$return .= center(b( $msg )) if $msg;
	
	$return .= table($tbl_settings,
					Tr(
						[
						td(
							[
								'Username:',
								textfield({-name=>'username', -size=>30})
							]
						),
						td(
							[
								'Password:',
								password_field({-name=>'password', -size=>30})
							]
						)
						]
					)
				);
				
	$return .= center( submit({-value=>'Log In'}) );
	$return .= endform();
	
	return_text($return, 1);
}

sub do_login() {
	my $return;
	
	if(param('username') eq $config{'user'} && param('password') eq $config{'pass'}) {
		my $cookie = cookie(-name=>'la_auth_user',
							-value=>param('username'),
							-expires=>'+1y');
							
		print header(-cookie=>$cookie);
		
		return main();
	} else {
		return try_login('Incorrect Information!');
	}
}

sub logout {
	my $cookie = cookie(
						-name => 'la_auth_user',
						-value => '',
						-expires => '-1h'
					);
						
	print header(-cookie=>$cookie);
	
	return try_login('Logged Out!');
}

#=========================================
# Upgrade from led-banners stuff
#=========================================
sub upgrade1_0 {
	use Cwd;
	
	my $return;
	
	my @options = radio_group({
							-name=>'import_option',
							-values=>['path', 'upload'],
							-deafult=>'path',
							-labels => {
										path	=> 'Import from fine on server (specify path below).',
										upload	=> 'Upload an ads.dat file to import.'
									   }
						});
	
	$return = b('Import Ads and Ad Stats from Led-Banners version 1.0');
	
	$return .= startform({-action=>$me.'?action=exec_upgrade1_0', -enctype=>'multipart/form-data'});
	
	$return .= table($tbl_settings,
					Tr(
						[
						td(
							[
								shift(@options) . br() .
								textfield({-name=>'path', -value=>Cwd::getcwd(), -size=>45})
							]
						),
						td(
							[
								shift(@options) . br() .
								filefield({-name=>'uploaded_file', -size=>40})
							]
						)
						]
					)
				);
				
	$return .= center( submit({-value=>'Import Ads!'}) . CGI::reset({-value=>'Reset Fields'}) );
	$return .= endform();
				
	return $return;
}

# do the work now
sub exec_upgrade1_0 {
	my $return;
	my @data = ();
	
	if(param('import_option') eq 'upload') {
		# uploaded a file (maybe)
		my $data = fetch_upload('uploaded_file');
		$data =~ s/\r//g;
		
		@data = split(/\n/, $data);
	} else {
		# file on server
		my $file = param('path');
		
		return "$file is not a file!" unless -f $file;
		
		# only get this if we have to use it
		use FileHandle;
		
		my $fh = FileHandle->new($file, 'r') or die $!;
			my $data = join('', <$fh>);
			$data =~ s/\r//g;
			
			@data = split(/\n/, $data);
		$fh->close();
	}
	
	# now we should have data to fuck with
	#use Data::Dumper;
	#return pre(Data::Dumper->Dump([\@data]));
	
	# startup all our db's
	init_db();
	my %stats;
	tie(%stats, $dbmfile, $config{'statdb'}, $filemode, 0640) or die $!;
	
	foreach my $line (@data) {
		my @lines = split(/\|/, $line);
		
		if(scalar(@lines) != 8) {
			$return .= "$line has ".scalar(@lines)." fields, expected 8. Skipping";
			
			next;
		}
		
		my ($key,$zone,$image_url,$url,$displays,$displays_today,$clicks,$clicks_today) = @lines;
		
		# don't care about the old key
		my $new_key = high_key(%db) + 1;
		
		# create new %db entry
		$db{$new_key} = join($config{delim}, (
								$c{'image'}, $image_url, $url, $zone, '_self', 468, 60
							));
							
		# now the stats (do the best we can
		$stats{$new_key} = join($config{'delim'}, ($displays, $displays_today, $displays_today, $displays_today,
									$clicks, $clicks_today, $clicks_today, $clicks_today, getnowdate()));
									
	}
	
	untie %stats or die $!;
	
	$return .= "Successfully imported ".scalar(@data)." ads!";
	
	return $return;
}

sub mainmenu {
	my $return;
	my $i = 0;
	
	my @links = (
					{
						header	=> 'Main',
						links	=> [
									[ 'Main Page', 'main' ],
									[ 'Add New Ad', 'newad' ],
									[ 'Modify Existing Ad', 'modify' ],
									[ 'View Ad Stats', 'stats' ],
								   ]
					},
					{
						header	=> 'Import',
						links	=> [
									[ 'Import 1.0 Ads', 'upgrade1_0' ]
								   ]
					},
					{
						header	=> 'Logout',
						links	=> [
									[ 'Log Out', 'logout' ]
								   ]
					}
				);
				
	foreach my $key (@links) {
		$return .= br() if $i++;
		$return .= b($key->{header}) . br();
		
		foreach my $link (@{$key->{links}}) {
			$return .= a({-href=>$me . '?action=' . $link->[1]}, $link->[0]) . br();
		}
	}
	
	return $return;
}