<?php
/******************************************************************************\
* Cookies Graph Counter                        Version 1.0                     *
* Copyright 2000 Frederic TYNDIUK (FTLS)       All Rights Reserved.            *
* E-Mail: tyndiuk@ftls.org                     Script License: GPL             *
* Created  02/28/2000                          Last Modified 02/28/2000        *
* Scripts Archive at:                          http://www.ftls.org/php/        *
*******************************************************************************/
// Necessary Variables:

$COUNT_FILE = "count_data.txt";
	// En: Absolute path and name to count data file.
	// Fr: Chemin absolu (complet) et Nom du fichier compteur.

$NB_DIGITS = 8;
	// En: Minimum number of digits to display (0, to not use 0 left).
	// Fr: Nombre minimum de chiffre  afficher (0 pour ne pas avoir de 0 devant).

$EXPIRE_DATE = 86400;
   // En: Cookies Expiration date (second).
   // Fr: Date d'expiration du cookies (en seconde);

// End  Necessary Variables section
/******************************************************************************/

header("content-Type: image/gif");
$img = ImageCreate(9 * $NB_DIGITS + 1, 17);

$bg_color   = ImageColorAllocate($img, 0 ,0, 0); // En: black / Fr: noir
$text_color = ImageColorAllocate($img, 255, 255, 255); // En: white / Fr: blanc
	// En: Set background and text color, ($img, int red, int green, int blue)
	// Fr: Aloue les couleur du fond et du texte, ($img, int red, int green, int blue)


if (! file_exists($COUNT_FILE)) {
	// En: Display a error message if file does not exist.
	// Fr: Affiche un message d'erreur si le fichier n'existe pas.
	$txt = "Can't find file, check '\$file' var...<BR>";
} else {
	// En: Open, read, increment, save and close file.
	// Fr: Ouvre, lit, incrmente, sauve et ferme le fichier.
	$fp = fopen("$COUNT_FILE", "r+");
	flock($fp, 1);
	$count = fgets($fp, 4096);
	if ($visited == "") {
		$count += 1; 
		setcookie("visited", $count, time()+$EXPIRE_DATE , "/", $SERVER_NAME);
		fseek($fp,0);
		fputs($fp, $count);
	}
	flock($fp, 3);
	fclose($fp);


	// En: Display count value
	// Fr: Affiche le nombre de visiteur.

	chop($count);
	$nb_digits = max(strlen($count), $NB_DIGITS);
	$txt = substr("0000000000".$count, -$nb_digits);
}

ImageString($img,5,1,0,$txt,$text_color);
ImageGif($img);
ImageDestroy($img);

// En: End PHP Code
// Fr: Fin code PHP
?>

