<?php
// ============================================
//  Copyright:   (r)(c) 2000.
//  File:        useredit.php
//  Subsystem:   Administration
//  Description: Process add/delete/edit users
//  Author:      h2o, kkg
// ============================================

	$inc_dir = "inc/";
	$lib_dir = "../lib/";
	$cfg_dir = "cfg/";
	$img_dir = "img/";
	$admin_inc_dir = "inc/";
	$admin_lib_dir = "lib/";

	$strTitle = "Admin - Users";

	require ($admin_lib_dir . "fleetuser.class.php");

	$referer_uri = explode ("?", $GLOBALS["HTTP_REFERER"]);

	$storage = new fleetUser ($session_login, false);
	$users = array ();
	if (isset($action)) {
		$sURLvars = ((isset($urlvars) && ($urlvars <> "")) ? "?" . urldecode($urlvars) : "");
		$users["USER_ID"] = intval (trim ($user_id));
		$users["USER_NAME"] = trim ($user_name);
		$users["USER_PASSWORD"] = trim ($user_password);
		$users["USER_DESCRIPTION"] = trim ($user_description);
		$users["USER_EMAIL"] = trim ($user_email);
		$users["USER_FETCH_COUNT"] = $user_fetch_count;
		$users["USER_ENABLED"] = $user_enabled;
		if ($action == "insert") {
			if ($users["USER_ID"] == 0) $error = ERROR_WRONGPARAMS;
			elseif ($users["USER_NAME"] == "") $error = ERROR_WRONGPARAMS;
			else $error = $storage->insertUser ($users);
		}
		if ($action == "update") {
			if ($users["USER_ID"] == 0) // update admin settings
			{
				$session_fetch_count = $users["USER_FETCH_COUNT"];
			}
			if ($users["USER_NAME"] == "") $error = ERROR_WRONGPARAMS;
			else $error = $storage->updateUser ($users, $uname);
		}
		if ($error == SUCCESS) {
			header ('Location: users.php' . $sURLvars);
		}
		else $mode = $action;
	}
	else {
		if ($mode == "update") {
			if (!isset ($uid)) $error = ERROR_WRONGPARAMS;
			else $users = $storage->getUserByID ($uid);
			$strTitle = "Admin - Edit User";
		}
		elseif ($mode == "delete") {
			if (!isset ($uid)) $error = ERROR_WRONGPARAMS;
			elseif ($uid == 0) {
				header ('Location: users.php?error='.ERROR_TRY_DELETE_ADMIN);
				exit ();
			}
			else {
				$sURLvars = (isset($referer_uri[1]) ? $sURLvars = "?" . $referer_uri[1] : "");
				$storage->deleteUser ($uid);
				header ('Location: users.php' . $sURLvars);
				exit;
			}
		}
		elseif ($mode == "insert") {
			$users["USER_FETCH_COUNT"] = $storage->getDefaultFetchCount ();
			$users["USER_ENABLED"] = 'yes';
			$strTitle = "Admin - Add User";
		}
		else $error = ERROR_UNKNOWNACTION;
	}

	require ($cfg_dir . "style.cfg.php");

	$validfile = $inc_dir . "validate.js";
	$leftmenu = $admin_inc_dir . "menu.inc.php";
	$content_page = $admin_inc_dir . "useredit.inc.php";

	require ($inc_dir . "skeleton.inc.php");
?>
