<?php if (!defined ("_SQLSEARCH_LIB_")):

//# ==================================================
//# Softerra PHP developer's library
//# Copyright (c) Softerra LLC 2000, 2001
//# 
//# This library is free software; you can redistribute it and/or
//# modify it under the terms of the GNU Lesser General Public
//# License as published by the Free Software Foundation; either
//# version 2.1 of the License, or (at your option) any later version.
//# 
//# Contacts:
//# http://www.softerra.com
//# mailto:contacts@softerra.com
//# ==================================================

// ============================================
//         SQL Keywords Search Library
//                 Version 1.3
// ============================================
// library for search in database by keywords
// 
// expression2conditions ($expression)
//
// where $searchexp like on altavista
// f.e.: word1 word2 +word3 -word4 "word5 word6"
// +  with this word
// -  without this word
// ?  any character
// *  any sequence of characters
//
// function returns sql query conditions wich could be placed in where clause
//
//
// searchPattern ($pattern)
// expression2internal ($expression)
// standealone ($conditions)
// targetfield ($target)
//
// =============================================

define (_SQLSEARCH_LIB_, "sqlsearch.lib.php");

require ($lib_dir . "array.lib.php");

define (SQL_PATTERN, 0);
define (REGEXP_PATTERN, 1);
define (KWFIELD, "KEYWORDS");
define (SEARCHEXP_SEPARATOR, " ");
define (SYMBOL_ANYCHAR, "?");
define (SYMBOL_ANYSEQUENCE, "*");
define (SQL_ANYCHAR, "_");
define (SQL_ANYSEQUENCE, "%");
if ($sqlExtendedSearch) {
	define (REGEXP_ANYCHAR, "[[:alnum:]]");
	define (REGEXP_SEPARATOR, "[^[:alnum:]]");
} else {
	define (REGEXP_ANYCHAR, "[[:alnum:] ]");
	define (REGEXP_SEPARATOR, ",");
}
define (REGEXP_ANYSEQUENCE, REGEXP_ANYCHAR . "*");

function searchPattern ($pattern, $type=SQL_PATTERN) {
	switch ($type) {
		case SQL_PATTERN:
			$anychar = SQL_ANYCHAR;
			$anysequence = SQL_ANYSEQUENCE;
		break;
		case REGEXP_PATTERN:
			$anychar = REGEXP_ANYCHAR;
			$anysequence = REGEXP_ANYSEQUENCE;
			$pattern = sql_regcase ($pattern);
		break;
	}
	$pattern = ereg_replace (quotemeta (SYMBOL_ANYCHAR), $anychar, $pattern);
	$pattern = ereg_replace (quotemeta (SYMBOL_ANYSEQUENCE), $anysequence, $pattern);
	return $pattern;
}

function targetfield ($target="") {
	global $targetField;
	if (strlen ($target)) $targetField = $target;
	else return $targetField;
}

function re_k2c (&$keyword, $number, $extension) {
	$keyword = $extension["prefix"] .
		   targetfield () . " REGEXP " .
		   "\"(^|" . REGEXP_SEPARATOR . ")" .
		   searchPattern ($keyword, REGEXP_PATTERN) .
		   "(" . REGEXP_SEPARATOR . "|$)\"" .
		   $extension["suffix"];
}

function sql_k2c (&$keyword, $number, $extension) {
	global $sqlExtendedSearch;
	$keyword = $extension["prefix"] .
		   targetfield () . " like " .
		   ($sqlExtendedSearch ? "'%" : "'") .
		   searchPattern ($keyword) .
		   ($sqlExtendedSearch ? "%'" : "'") .
		   $extension["suffix"];
}

function keywords2conditions ($keywords, $type=SQL_PATTERN, $extension=0) {
	if ($type==REGEXP_PATTERN) $userfunc = 're_k2c';
	else $userfunc = 'sql_k2c';
	array_walk ($keywords, $userfunc, $extension);
	return $keywords;
}

function expression2internal ($expression) {
	if (preg_match_all ('/([+-]?)"([^"]*)"/', $expression, $quoted))
		$expression = preg_replace ('/[+-]{0,1}"[^"]*"/', "", $expression);
	$all = split ("[ ]+", $expression);
	for ($i=0; $i<count ($quoted); $i++)
		$all[] = $quoted[1][$i] . $quoted[2][$i];
	$internal["with"] = preg_grep ("/^\+/", $all);
	$internal["without"] = preg_grep ("/^-/", $all);
	$internal["withany"] = preg_grep ("/^[\w\?\* ]/", $all);
	for ($i=0; $i<count ($internal["with"]); $i++)
		$internal["with"][$i] = substr ($internal["with"][$i], 1);
	for ($i=0; $i<count ($internal["without"]); $i++)
		$internal["without"][$i] = substr ($internal["without"][$i], 1);
	return $internal;
}

function expression2conditions ($expression, $type=SQL_PATTERN) {
	$internal = expression2internal ($expression);
	if ($internal["withany"]) $query .= composeSearchConditions ($internal["withany"], $type);
	if ($internal["with"]) $query .= composeSearchConditions ($internal["with"], $type, "and");
	if ($internal["without"]) $query .= composeSearchConditions ($internal["without"], $type, "and", true);
	return $query;
}
	
function composeSearchConditions ($keywords, $type, $operation="or", $negation=false) {
	$query = " and (";
	if ($negation) {
		$extension["prefix"] = "not (";
		$extension["suffix"] = ")";
	}
	$conditions = keywords2conditions ($keywords, $type, $extension);
	$query .= listArrayValues ($conditions, " $operation ");
	$query .= ")";
	return $query;
}

function standalone ($conditions) {
	if ($conditions) $conditions = "where " . substr ($conditions, 5);
	return $conditions;
}

// =============================== //
//  set default target field name  //
// =============================== //
targetfield (KWFIELD);

endif ?>