<?php if (!defined ("_SQLCOMPOSE_LIB_")):

//# ==================================================
//# Softerra PHP developer's library
//# Copyright (c) Softerra LLC 2000, 2001
//# 
//# This library is free software; you can redistribute it and/or
//# modify it under the terms of the GNU Lesser General Public
//# License as published by the Free Software Foundation; either
//# version 2.1 of the License, or (at your option) any later version.
//# 
//# Contacts:
//# http://www.softerra.com
//# mailto:contacts@softerra.com
//# ==================================================

// ========================================
//     Simple SQL Query Compose Library
// ========================================
//              Version 1.3.4
// ========================================
//  --------------------------------
//  ------ Declared functions ------
//  --------------------------------
//
//  prepareValueOrExpression (&$value)
//  prepareValuesOrExpressions (&$values)
//  withTablePrefix ($fields, $table)
//  
//  composeInsertQuery ($table, $values)
//  composeUpdateQuery ($table, $values, $conditions)
//  composeSelectQuery ($tables, $fields, $conditions)
//  composeDeleteQuery ($table, $conditions)
//
//  simpleConditions ($conditions)
//  equalityConditions ($conditions)
//  homogenicConditions ($conditions, $relation="=", $operation="and")
//  complexConditions ($conditions, $operations)
//  composeQueryConditions ($conditions, $type=CND_EQUALITY, $limit=0, $parameters=0)
//
//  --------------------------------
// ======================================

define (_SQLCOMPOSE_LIB_, "sqlcompose.lib.php");

require ($lib_dir . "array.lib.php");

define (EXP_FLAG, 'EXPRESSION=');
define (CND_EQUALITY, 1);
define (CND_HOMOGENIC, 2);
define (CND_COMPLEX, 3);
define (CND_SIMPLE, 4);
define (CND_DUMMY, 5);

function quotedValue ($value) {
	return "'" . addslashes ($value) . "'";
}

/**
 * Prepare value or expression for using in SQL statements.
 * Add slashes if seted $sqlAddSlashes
 *
 * @param	$value string
 * @see prepareValuesOrExpressions
 * @author	boba <boba_manson@yahoo.com>
 */
function prepareValueOrExpression (&$value) {
	global $sqlAddSlashes;
	if (is_string ($value) && (strtoupper ($value) != "NULL"))
		if ((is_integer (strpos ($value, EXP_FLAG))) && (strpos ($value, EXP_FLAG) == 0))
			$value = substr ($value, strlen (EXP_FLAG));
		else
			if ($sqlAddSlashes)
				$value = "'" . addslashes ($value) . "'";
			else
				$value = "'" . $value . "'";
}

/**
 * Prepare values  or expressions for using in SQL statements.
 *
 * @param	$value array
 * @see prepareValuesOrExpressions
 * @author	boba <boba_manson@yahoo.com>
 */
function prepareValuesOrExpressions (&$values)
{
	array_walk ($values, 'prepareValueOrExpression');
}

function withTablePrefix ($fields, $table)
{
	alterArray ($fields, $table . ".");
	return $fields;
}

function composeInsertQuery ($table, $values)
{
	$query = "insert into $table";
	if (key ($values) != "0")
	{
		$query .= "(" . listArrayKeys ($values) . ")";
	}
	prepareValuesOrExpressions ($values);
	$query .= " values (" . listArrayValues ($values) . ")"; 
	return $query;
}

function composeUpdateQuery ($table, $values, $conditions)
{
	prepareValuesOrExpressions ($values);
	$query = "update $table set " . listArrayKeysAndValues ($values);
	$query .= simpleConditions ($conditions);
	return $query;
}

function composeSelectQuery ($tables, $fields, $conditions)
{
	$query = "select ";
	if (is_array ($fields))
		$query .= listArrayValues ($fields);
	else
		$query .= $fields;
	$query .= " from ";
	if (is_array ($tables))
		$query .= listArrayValues ($tables);
	else
		$query .= $tables;
	$query .= simpleConditions ($conditions);
	return $query;
}

function composeDeleteQuery ($table, $conditions)
{
	$query = "delete from $table";
	$query .= simpleConditions ($conditions);
	return $query;
}

function simpleConditions ($conditions)
{
	if ($conditions)
	{
		if (is_array ($conditions))
			$result = composeQueryConditions ($conditions);
		else
			$result = " " . $conditions;
	}
	else $result = "";
	return $result;
}

/**
 * Make conditions
 * Produce "$conditions[key] $relation $conditions[value] [$operation $conditions[key] $relation $conditions[value]]"
 *
 * @see equalityConditions
 * @param	$conditions array Array of table fields and values
 * @author	boba <boba_manson@yahoo.com>
 */
function homogenicConditions ($conditions, $relation="=", $operation="and")
{
	prepareValuesOrExpressions ($conditions);
	$relation = " " . $relation . " ";
	$operation = " " . $operation . " ";
	return listArrayKeysAndValues ($conditions, $relation, $operation);
}

/**
 * Make equality conditions. If $sqlLikeStringEquality seted else call homogenicConditions.
 * If value string produce "$conditions[key] like $conditions[value]" else "$conditions[key] = $conditions[value]"
 *
 * @see homogenicConditions
 * @param	$conditions array Array of table fields and values
 * @author	boba <boba_manson@yahoo.com>
 */
function equalityConditions ($conditions)
{
	global $sqlLikeStringEquality;
	if ($sqlLikeStringEquality)
	{
		prepareValuesOrExpressions ($conditions);
		reset ($conditions);
		while (list ($field, $value) = each ($conditions))
		{
			$equalities .= $field;
			if (is_string ($value) && ($value[0] == "'"))
				$equalities .= " like " . $value;
			else
				$equalities .= " = " . $value;
			$equalities .= " and ";
		}
		$equalities = substr ($equalities, 0, -strlen (" and "));
	}
	else $equalities = homogenicConditions ($conditions);
	return $equalities;
}

/**
 * Make complex conditions
 *
 * @param	$conditions array This array contain string $field and array $condition
 *			$field is a $conditions key and $condition is a $conditions value
 *			$condition contain string $relation and $value
 *			Supported $relation list: "like", "=", "!=", "<>", "<", ">", "<=", ">=", "in", "not in", "between", "not between", "IS NULL", "IS NOT NULL"
 * @param	$operations array This array contain operations "and" and "or" which should be placed before condition. I.e. first element must be a "".
 * @todo	group by
 */
function complexConditions ($conditions, $operations)
{
	while (list ($field, $condition) = each ($conditions))
	{
		list ($relation, $value) = each ($condition);
		$result .= $field . " " . $relation . " ";
		switch ($relation) {
			case "like": case "=": case "<>": case "!=":
			case "<": case ">": case "<=": case ">=":
				prepareValueOrExpression ($value);
				$result .= $value;
			break;
			case "in": case "not in":
				prepareValuesOrExpressions ($value);
				$result .= "(" . listArrayValues ($value) . ")";
			break;
			case "between": case "not between":
				prepareValuesOrExpressions ($value);
				$result .= $value[0] . " and " . $value[1];
			break;
			case "IS NULL": case "IS NOT NULL":
				cd($result);
			break;
		}
		if ($operation = next ($operations))
			$result .= " " . $operation . " ";
	}
	return "(" . $result . ")";
}

/**
 * Make dummy condition "(1)" where user not need any conditions
 *
 */
function dummyCondition ()
{
	return "(1)";
}

/**
 *
 *
 * @param	$conditions array
 * @param	$type string.
 *			CND_EQUALITY - equalityConditions
 *			CND_HOMOGENIC - homogenicConditions
 *			CND_COMPLEX - complexConditions
 * @param	$orderby array $orderby[0] - atring or array, $orderby[1] - direction (ASC, DESC)
 * @param	$limit array of integer $limit[0] - oofset, $limit[1] - rows
 * @param	$parameters array If $type == CND_HOMOGENIC you ned specify $parameters["relation"]
 *			 and  $parameters["operation"]
 */
//composeQueryConditions ($conditions, $type=CND_EQUALITY, $limit=0, $parameters=0)
function composeQueryConditions ($conditions, $type=CND_EQUALITY, $limit=0, $parameters=array("relation" => "=", "operation" => "and"), $orderby=0, $groupby=0)
{
	$where = " where ";
	switch ($type)
	{
		case CND_EQUALITY:
			$where .= equalityConditions ($conditions);
		break;
		case CND_HOMOGENIC:
			$where .= homogenicConditions ($conditions, $parameters["relation"], $parameters["operation"]);
		break;
		case CND_COMPLEX:
			$where .= complexConditions ($conditions, $parameters);
		break;
		case CND_SIMPLE:
			$where .= $conditions;
		break;
		case CND_DUMMY:
			$where .= dummyCondition ();
		break;
	}

	if (($groupby) && is_array($groupby)) $where .= " group by " . listArrayValues($groupby);
	elseif (($groupby) && is_string($groupby)) $where .= " group by " . $groupby;

	if (($orderby) && (is_array($orderby[0]))) $where .= " order by " . listArrayValues($orderby[0]) . " " . $orderby[1];
	elseif (($orderby) && (is_array($orderby))) $where .= " order by " . $orderby[0] . " " . $orderby[1];

	if ($limit) $where .= " limit $limit[0], $limit[1]";
	return $where;
}

endif ?>