<?php if (!defined ("_REGISTRY_LIB_")):

//# ==================================================
//# Softerra PHP developer's library
//# Copyright (c) Softerra LLC 2000, 2001
//# 
//# This library is free software; you can redistribute it and/or
//# modify it under the terms of the GNU Lesser General Public
//# License as published by the Free Software Foundation; either
//# version 2.1 of the License, or (at your option) any later version.
//# 
//# Contacts:
//# http://www.softerra.com
//# mailto:contacts@softerra.com
//# ==================================================

// =================================== 
//      Registry Emulation Library
// ===================================
//             Version 1.3
// ===================================
//  --------------------------------
//  ------ Declared functions ------
//  --------------------------------
//
//  regLastError ()
//  regKeyExists ($key)
//  regCreateKey ($key)
//  regDeleteKey ($key)
//  regRenameKey ($key, $name)
//  regCopySubTree ($dest, $source)
//  regGetValue ($key)
//  regSetValue ($key, $value)
//  regSubKeys ($key)
//  regGetSubValues ($key)
//  regTagAttributes ($key)
// 
//  --------------------------------
// ==================================

define (_REGISTRY_LIB_, "registry.lib.php");

require ($lib_dir . "sqlstorage.class.php");

define (REGISTRY_HOST, DB_HOST);
define (REGISTRY_USER, DB_USER);
define (REGISTRY_PASSWORD, DB_PASSWORD);
define (REGISTRY_DATABASE, DB_NAME);
define (TBL_REGISTRY, "REGISTRY");
define (FLD_KEY, "REGKEY");
define (FLD_VAL, "VALUE");

define (REGKEY_SEPARATOR, "/");
define (MAX_NAME_LENGTH, 32);
define (MAX_KEY_LENGTH, 255);
define (RE_VALID_NAME, "[a-zA-Z0-9_]{1," . MAX_NAME_LENGTH . "}");

define (E_SUCCESS, 0);
define (E_BASE, -100);
define (E_BADKEY, E_BASE-1);
define (E_BADNAME, E_BASE-2);
define (E_KEYEXISTS, E_BASE-3);
define (E_KEYNOTEXISTS, E_BASE-4);
define (E_UNKNOWN, E_BASE-100);

define (TYPE_BOOLEAN, "boolean");
define (TYPE_INTEGER, "integer");
define (TYPE_DOUBLE, "double");
define (TYPE_STRING, "string");
define (TYPE_ARRAY, "array");

function REG_CONNECT ($host=REGISTRY_HOST, $user=REGISTRY_USER, $password=REGISTRY_PASSWORD, $database=REGISTRY_DATABASE) {
	global $regStorage;
	return $regStorage->connect ($host, $user, $password, $database);
}

function REG_EXIT ($result, $error) {
	global $regestry_error;
	$regestry_error = $error;
	return $result;
}

function regLastError () {
	global $regestry_error;
	return $regestry_error;
}

function regValidName ($name) {
	return ereg ("^" . RE_VALID_NAME . "$", $name);
}

function regValidKey ($key) {
	return (strlen ($key)<MAX_KEY_LENGTH) && ereg ("^(" . RE_VALID_NAME . REGKEY_SEPARATOR . ")*" . RE_VALID_NAME . "$", $key);
}

function regNameFromKey ($key) {
	$pos = strrpos ($key, REGKEY_SEPARATOR);
	return substr ($key, $pos ? $pos+1:0);
}

function regPathFromKey ($key) {
	$pos = strrpos ($key, REGKEY_SEPARATOR);
	return substr ($key, 0, $pos);
}

function regKeyFromPathAndName ($path, $name) {
	if (strlen ($path)) $path .= REGKEY_SEPARATOR;
	return $path . $name;
}

function regExplodeKey ($key) {
	return explode (REGKEY_SEPARATOR, $key);
}
function regKeyExists ($key) {
	global $regStorage;
	return $regStorage->select_exists (TBL_REGISTRY, array (FLD_KEY => $key));
}

function regCreateKey ($key) {
	global $regStorage;
	if (!regValidKey ($key)) return REG_EXIT (false, E_BADKEY);
	if (regKeyExists ($key)) return REG_EXIT (false, E_KEYEXISTS);
	do {
		$regStorage->insert (TBL_REGISTRY, array (FLD_KEY => $key));
		$key = regPathFromKey ($key);
	} while (strlen ($key)>0 && !regKeyExists ($key));
	return REG_EXIT (true, E_SUCCESS);
}

function regDeleteKey ($key) {
	global $regStorage;
	if (!regValidKey ($key)) return REG_EXIT (false, E_BADKEY);
	if (!regKeyExists ($key)) return REG_EXIT (false, E_KEYNOTEXISTS);
	$regStorage->delete (TBL_REGISTRY, array (FLD_KEY => regKeyFromPathAndName ($key, "%")));
	return REG_EXIT ($regStorage->delete (TBL_REGISTRY, array (FLD_KEY => $key)), E_SUCCESS);
}

function regRenameKey ($key, $name) {
	global $regStorage;
	if (!regValidKey ($key)) return REG_EXIT (false, E_BADKEY);
	if (!regValidName ($name)) return REG_EXIT (false, E_BADNAME);
	if (!regKeyExists ($key)) return REG_EXIT (false, E_KEYNOTEXISTS);
	$newkey = regKeyFromPathAndName (regPathFromKey ($key), $name);
	if (regKeyExists ($newkey)) return REG_EXIT (false, E_KEYEXISTS);
	$children = $regStorage->select_column (TBL_REGISTRY, FLD_KEY, array (FLD_KEY => regKeyFromPathAndName ($key, "%")));
	for ($i=0; $i<count ($children); $i++)
		$regStorage->update (TBL_REGISTRY, array (FLD_KEY => ereg_replace ($key, $newkey, $children[$i])), array (FLD_KEY => $children[$i]));
	return REG_EXIT ($regStorage->update (TBL_REGISTRY, array (FLD_KEY => $newkey), array (FLD_KEY => $key)), E_SUCCESS);
}

function regCopySubTree ($dest, $source) {
	global $regStorage;
	if (!regValidKey ($source)) return REG_EXIT (false, E_BADKEY);
	if (!regKeyExists ($source)) return REG_EXIT (false, E_KEYNOTEXISTS);
	if (!regKeyExists ($dest)) if (!regCreateKey ($dest)) return false;
	$children = $regStorage->select_result (TBL_REGISTRY, "*", array (FLD_KEY => regKeyFromPathAndName ($source, "%")));
	for ($i=0; $i<count ($children); $i++)
		$regStorage->insert (TBL_REGISTRY, array (FLD_KEY => ereg_replace ($source, $dest, $children[$i][FLD_KEY]), FLD_VAL => $children[$i][FLD_VAL]));
	return REG_EXIT (count ($children)>0, E_SUCCESS);
}

function regGetValue ($key) {
	global $regStorage;
	if (!regValidKey ($key)) return REG_EXIT (false, E_BADKEY);
	$value = $regStorage->select_record (TBL_REGISTRY, FLD_VAL, array (FLD_KEY => $key));
	if ($regStorage->queryresult_exists ())
		return REG_EXIT (unserialize ($value), E_SUCCESS);
	else
		return REG_EXIT (false, E_KEYNOTEXISTS);
}

function regSetValue ($key, $value) {
	global $regStorage;
	global $sqlAddSlashes;
	$value = serialize ($value);
	if (!$sqlAddSlashes) $value = AddSlashes ($value);
	if (!regValidKey ($key)) return REG_EXIT (false, E_BADKEY);
	$result = $regStorage->update (TBL_REGISTRY, array (FLD_VAL => $value), array (FLD_KEY => $key));
	return REG_EXIT ($result, $result ? E_SUCCESS:E_KEYNOTEXISTS);
}

function regSubKeys ($key) {
	global $regStorage;
	if (strlen ($key)) {
		if (!regValidKey ($key)) return REG_EXIT (false, E_BADKEY);
		if (!regKeyExists ($key)) return REG_EXIT (false, E_KEYNOTEXISTS);
	}
	$condition = 'where REGKEY REGEXP "^' . regKeyFromPathAndName ($key, RE_VALID_NAME) . '$"';
	return REG_EXIT ($regStorage->select_column (TBL_REGISTRY, FLD_KEY, $condition), E_SUCCESS);
}

function regSubKeysCount ($key) {
	global $regStorage;
	if (strlen ($key)) {
		if (!regValidKey ($key)) return REG_EXIT (false, E_BADKEY);
		if (!regKeyExists ($key)) return REG_EXIT (false, E_KEYNOTEXISTS);
	}
	$condition = 'where REGKEY REGEXP "^' . regKeyFromPathAndName ($key, RE_VALID_NAME) . '$"';
	return REG_EXIT ($regStorage->select_count (TBL_REGISTRY, $condition), E_SUCCESS);
}

function regGetSubValues ($key) {
	global $regStorage;
	$subkeys = regSubKeys ($key);
	if (regLastError () != E_SUCCESS) return false;
	$result = array ();
	for ($i=0; $i<count ($subkeys); $i++)
		$result[regNameFromKey ($subkeys[$i])] = regGetValue ($subkeys[$i]);
	return $result;
}

function regTagAttributes ($key) {
	$attr = regGetSubValues ($key);
	return listArrayKeysAndValues ($attr, "=", " ");
}

//=======================================//
//    initializing registry storage      //
//=======================================//
$regStorage = new sqlStorage ();
//$regStorage->debugOn();
if ($regDefaultConnection) REG_CONNECT ();

endif ?>
