<?php if (!defined ("_CORBAN_LIB_")):

//# ==================================================
//# Softerra PHP developer's library
//# Copyright (c) Softerra LLC 2000, 2001
//# 
//# This library is free software; you can redistribute it and/or
//# modify it under the terms of the GNU Lesser General Public
//# License as published by the Free Software Foundation; either
//# version 2.1 of the License, or (at your option) any later version.
//# 
//# Contacts:
//# http://www.softerra.com
//# mailto:contacts@softerra.com
//# ==================================================

// ================================== 
//           "Corban, dear"
//        Debug Output Library
// ==================================
//            Version 1.3.1
// ===================================
//
// cd ($val, $name=0, $comment=0, $die=false)	{ alias for corban_dear () }
// ci ($name=0) 				{ alias for corban_inittimer () }
// cs ($name=0, $comment=0)			{ alias for corban_showtimer () }
// corban_dear ($val, $name=0, $comment=0, $die=false)
// corban_inittimer ($name=0)
// corban_showtimer ($name=0, $comment=0)
//
// ==================================

define (_CORBAN_LIB_, "corban.lib.php");

define (BR, "<br>");
define (FONTTEXT, "<font face=Arial color=%s style=\"font-size:%dpt\">%s</font>");
define (BOLDTEXT, "<b>%s</b>");

$corban_counter = 0;
$corban_blabla = true;

$corban_color = array (
	"prefix"	=> "gray",
	"die"		=> "red",
	"comment"	=> "teal",
	"boolean"	=> "green",
	"integer"	=> "red",
	"double"	=> "magenta",
	"string"	=> "blue",
	"array"		=> "navy",
	"object"	=> "olive"
);

$corban_prefix = "&nbsp;Corban, dear! [%d]:&nbsp;";
$corban_die_scream = BR . "CORBAN MUST DIE!" . BR;

function cd ($val, $name=0, $comment=0, $die=false) {
	corban_dear ($val, $name, $comment, $die);
}

function ci ($name=0) {
	corban_inittimer ($name);
}

function cs ($name=0, $comment=0) {
	corban_showtimer ($name, $comment);
}

function corban_dear ($val, $name=0, $comment=0, $die=false, $internal=false) {
	global $corban_counter, $corban_blabla, $corban_prefix, $corban_color;
	
	$type = gettype ($val);
	if (!$internal) {
		$corban_counter++;
		if ($corban_blabla)
			$corban_message = corban_format (sprintf ($corban_prefix, $corban_counter), $corban_color["prefix"]);
		if ($comment)
			$corban_message .= corban_format ($comment, $corban_color["comment"]);
		if ($name)
			$corban_message .= corban_format (corban_bold ("\$$name"));
		elseif (!isset ($val))
			$corban_message .= corban_format (corban_bold ("VARIABLE"));
		else
			$corban_message .= corban_format (corban_bold (strtoupper ($type)));
	} else $corban_message = $internal;
	if (!isset ($val)) echo $corban_message . corban_format (" is not set".BR);
	else {  switch ($type) {
			case "boolean":
				$val = $val ? "true" : "false";
			case "integer":
			case "double":
			case "string":
				corban_scalar (htmlspecialchars($val), $type, $corban_message);
			break;
			case "array":
				corban_array ($val, $corban_message);
			break;
			case "object":
				corban_object ($val, $corban_message);
			break;
			default:
				corban_scalar (strval ($val), "string", $corban_message);
		}
	}	
	if ($die) corban_die ($die);
}

function corban_die ($die) {
	global $corban_die_scream, $corban_blabla, $corban_color;
	if (!is_string ($die)) {
		if ($corban_blabla)
			$die = $corban_die_scream;
		else
			$die = "";
	}
	$die = corban_format ($die, $corban_color["die"], 3);
	die ($die);
}

function corban_bold ($text) {
	return sprintf (BOLDTEXT, $text);
}

function corban_format ($text, $color="black", $size="8") {
	return sprintf (FONTTEXT, $color, $size, $text);
}

function corban_scalar ($val, $type, $prefix) {
	global $corban_color;
	echo $prefix . corban_format ("&nbsp;=&nbsp;") . corban_format ($val, $corban_color[$type]) . BR;
}

function corban_array ($arr, $prefix) {
	global $corban_color;
	if (!$arr) echo $prefix . corban_format (" is empty array") . BR;
	while (list ($key, $value) = each ($arr)) {
		$curprefix = $prefix . corban_format (" [") . corban_format ($key , $corban_color["array"]) . corban_format ("]");
		corban_dear ($value, false, false, false, $curprefix);
	}
}

function corban_unserialize (&$varlist) {
	if (strtolower ($varlist[0])=="o" || strtolower ($varlist[0])=="a") {
		$pos=strpos ($varlist, "{")+1;
		$intcnt = 0;
		while ($pos<strlen ($varlist)) {
			if ($varlist[$pos]=="{") $intcnt++;
			elseif ($varlist[$pos]=="}") {
				if ($intcnt) $intcnt--;
				else {
					$pos++;
					break;
				}
			}
			$pos++;
		}
	}
	else $pos = strpos ($varlist, ";")+1;
	$value = unserialize (substr ($varlist, 0, $pos));
	$varlist = substr ($varlist, $pos);
	return $value;
}

function corban_object ($obj, $prefix) {
	global $corban_color;
	$ver = phpversion ();
	$php4add = ($ver[0] == "4") ? 2 : 0;
	$objAsStr = serialize ($obj);
	$objAsArr = split (":", $objAsStr, 3 + $php4add);
	$objPropCount = $objAsArr[1];
	if ($php4add) $objClassName = $objAsArr[2];
	$objPropList = substr ($objAsArr[2+$php4add], 1, -1);
	if (strlen ($objPropList)==0) echo $prefix . corban_format (" is empty object") . BR;
	while (strlen ($objPropList)) {
		$curprefix = $prefix . corban_format ("->") . corban_format (corban_unserialize ($objPropList), $corban_color["object"]);
		corban_dear (corban_unserialize ($objPropList), false, false, false, $curprefix);
	}
}

// ======================================= //
//    Estimate execution time functions    //
// ======================================= //

function corban_microtime () {
	$time = explode (" ", microtime ());
	return doubleval ($time[0]) + doubleval ($time[1]);
}

function corban_timer ($name=0) {
	global $corban_timer;
	return corban_microtime () - $corban_timer[$name];
}

function corban_inittimer ($name=0) {
	global $corban_timer;
	$corban_timer[$name] = corban_microtime ();
}

function corban_showtimer ($name=0, $comment=0) {
	if (!$comment) $comment = "CORBAN TIMER {$name} ";
	cd (sprintf ("%.3f", corban_timer ($name)), "time", $comment);
}

endif ?>