<?php
// ============================================
//  Copyright:   (r)(c) 2000.
//  File:        profile.php
//  Subsystem:   User profile
//  Description: database class
//  Author:      h2o, kkg
// ============================================

// ===========================================================================
//                D E C L A R A T E D    F U N C T I O N S
// ===========================================================================
//
// Constructor
// 	* fleetUser ($user, $debug=false)
// Accessors
//	* setUser ($user)
//	* userID ($user)
//	* signIn ($user, $password)
//	* remindPassword ($user)
//	* getUser ($user_name)
//	* getUserByID ($userID)
//	* userIDExists ($data)
//	* userExists ($data)
//	* getDefaultFetchCount ()
//	* getDefaultLogFlags ()
// Mutators
//	* insertUser ($data)
//	* updateUser ($data, $username)
//	* deleteUser ($userID)
//	* updateUserProfile ($data)
//

// -------------------------------------------------------------
//  Include libraries
// -------------------------------------------------------------

include ($cfg_dir . "database.cfg.php");
include ($lib_dir . "sqlstorage.class.php");
include ($lib_dir . "registry.lib.php");
require ($cfg_dir . "error.codes.php");

// -------------------------------------------------------------
//  Define registry path
// -------------------------------------------------------------

define (REG_USER_FETCH_COUNT, "APPS/Settings/Defaults/UserFetchCount");

define (MAIL_ADDITIONAL_HEADER, "From: %s\nReply-To: %s\nX-Mailer: PHP/".phpversion());
define (REG_FEEDBACK_EMAIL, "APPS/Settings/ServerSide/Common/feedbackEmail");

define (DEFUALT_USER_FETCH_COUNT, 5);

// -------------------------------------------------------------
//  Define log message patterns
// -------------------------------------------------------------

define (LOG_MSG_SEND_PASSWORD, "The user (PIN:%d,Login:%s) password was sended to %s");

// -------------------------------------------------------------
//  Class
// -------------------------------------------------------------

class fleetUser extends sqlStorage {

	var $user_id;
	var $user_login;
	var $user_email;
	var $user_fetch_count;
	var $last_login;

	function fleetUser ($user, $debug=false) {
		$this->connect (DB_HOST, DB_USER, DB_PASSWORD, DB_NAME);
		if ($user) $this->setUser ($user);
		if ($debug) $this->debugOn ();
	}

	function setUser ($user) {
		$this->user_login = $user;
		$this->user_id = intval ($this->userID ($user));
	}

	function userID ($user) {
		$this->select (TBL_USERS, "USER_ID", array ("USER_NAME" => $user));
		$id = $this->fetch_row ();
		return $id[0];
	}

	function signIn ($user, $password) {
		global $HTTP_SERVER_VARS;
		$this->select (TBL_USERS, "*", array ("USER_NAME" => $user));
		if ($this->num_rows () == 0) {
			$this->user_id = 0; // send log to admin
			return ERROR_USERNOTEXISTS;
		}
		$entry = $this->fetch_array ();
		if ($entry["USER_PASSWORD"] != $password) {
			$this->user_id = $entry["USER_ID"];
			return ERROR_BADPASSWORD;
		}
		if ($entry["USER_ENABLED"] != "yes") return ERROR_USERDISABLED;
		else {
			$this->user_fetch_count = $entry["USER_FETCH_COUNT"];
			$this->last_login = $entry["USER_LAST_LOGIN"];
			$this->update (TBL_USERS, array ("USER_LAST_LOGIN" => date ("Y-m-d H:i:s")), array ("USER_NAME" => $user));
			$this->setUser ($user);
			return SUCCESS;
		}
	}

	function remindPassword ($user) {
		$fields = array ("USER_EMAIL", "USER_PASSWORD", "USER_ID", "USER_ENABLED");
		$condition = array ("USER_NAME" => $user);
		$this->select (TBL_USERS, $fields, $condition);
		if ($this->num_rows () == 0) return ERROR_USERNOTEXISTS;
		$entry = $this->fetch_array ();
		if ($entry["USER_ENABLED"] != "yes") return ERROR_USERDISABLED;
		$email = $entry["USER_EMAIL"];
		$password = $entry["USER_PASSWORD"];
		$userPIN = $entry["USER_ID"];
		$adminemail = regGetValue (REG_FEEDBACK_EMAIL);
		$extraHeader = sprintf (MAIL_ADDITIONAL_HEADER,$adminemail,$adminemail);
		if (mail ($email, "Fleet Manager Password", $password, $extraHeader)) {
			$message = sprintf (LOG_MSG_SEND_PASSWORD, $userPIN, $user, $email);
			return SUCCESS;
		}
		else return ERROR_SENDMAIL;
	}

	function getUser ($user_name) {
		return $this->select_row (TBL_USERS, "*", array ("USER_NAME" => $user_name));
	}

	function getUserByID ($userID) {
		return $this->select_row (TBL_USERS, "*", array ("USER_ID" => $userID));
	}

	function userIDExists ($data) {
		$this->select (TBL_USERS, "*", array ("USER_ID" => $data));
		if ($this->num_rows () != 0)
			return ERROR_IDEXISTS;
		return SUCCESS;
	}

	function userExists ($data) {
		$this->select (TBL_USERS, "*", array ("USER_NAME" => $data));
		if ($this->num_rows () != 0)
			return ERROR_USEREXISTS;
		return SUCCESS;
	}

	function insertUser ($data) {
		$errcode = $this->userIDExists ($data[USER_ID]);
		if ($errcode != SUCCESS)
			return $errcode;
		$errcode = $this->userExists ($data[USER_NAME]);
		if ($errcode != SUCCESS)
			return $errcode;
		if (!$this->insert (TBL_USERS, $data)) return ERROR_INSERT;
		return SUCCESS;
	}

	function updateUser ($data, $username) {
		if ($this->userID ($username) != $data[USER_ID]) {
			$errcode = $this->userIDExists ($data[USER_ID]);
			if ($errcode != SUCCESS)
				return $errcode;
		}
		if ($username != $data[USER_NAME]) {
			$errcode = $this->userExists ($data[USER_NAME]);
			if ($errcode != SUCCESS)
				return $errcode;
		}
		if (!$this->update (TBL_USERS, $data, array ("USER_ID" => $data["USER_ID"]))) return ERROR_UPDATE;
		return SUCCESS;
	}

	function deleteUser ($userID)
	{
		if (!isset($userID) || intval($userID) == 0)
			return false;
		$condition = array ("USER_ID" => intval($userID));

		$this->delete (TBL_DEPARTMENTS, $condition);
		$this->delete (TBL_EQUIPMENT, $condition);
		$this->delete (TBL_MAINTENANCE, $condition);
		$this->delete (TBL_USERS, $condition);
		return SUCCESS;
	}

	function getDefaultFetchCount () {
		$nFC = regGetValue (REG_USER_FETCH_COUNT);
		return ($nFC) ? $nFC : DEFUALT_USER_FETCH_COUNT;
	}

	function getBrowserType () {
		global $HTTP_USER_AGENT;
		if (eregi("msie",$HTTP_USER_AGENT))
			return "IE"; 
		if (eregi("gecko",$HTTP_USER_AGENT)) 
			return "NN6"; 
		if (eregi("mozilla",$HTTP_USER_AGENT)) 
			return "NN"; 
		else return "OTHER"; 
	}
	
	function updateUserProfile ($data)
	{
		if (!isset ($this->user_id) || $this->user_id == 0)
			return ERROR_USERNOTEXISTS;
		$this->update (TBL_USERS, $data, array ("USER_ID" => $this->user_id));
	}
}
?>