//<SCRIPT LANGUAGE="JavaScript">
<!--
// Genaral validation functions

var digits = "0123456789";
var phoneNumberDelimiters = "()- ";
var validPhoneChars = digits + phoneNumberDelimiters;
// whitespace characters
var whitespace = " \t\n\r";

// WORKAROUND FUNCTION FOR NAVIGATOR 2.0.2 COMPATIBILITY.
// The below function *should* be unnecessary.  In general,
// avoid using it.  Use the standard method indexOf instead.
// However, because of an apparent bug in indexOf on
// Navigator 2.0.2, the below loop does not work as the
// body of LTrim:
// while ((i < s.length) && (whitespace.indexOf(s.charAt(i)) != -1))
//   i++;
//
// ... so we provide this workaround function charInString
// instead.
//
// Returns true if single character c (actually a string)
// is contained within string s.
function charInString(c, s) {
	var i
	for (i = 0; i < s.length; i++) {
		if (s.charAt(i) == c) return true
	}
	return false
}

// Removes initial (leading) whitespace characters from s
function LTrim(s) {
	var i = 0
	while ((i < s.length) && charInString(s.charAt(i), whitespace)) { i++ }
	return s.substring(i, s.length);
}

// Removes ending (trailing) whitespace characters from s
function RTrim(s) {
	var i = s.length - 1
	while ((i >= 0) && charInString(s.charAt(i), whitespace)) { i-- }
	return s.substring(0, i+1);
}

 // Returns string with both leading and trailing whitespaces removed from s
function Trim(s) {
	return RTrim(LTrim(s))
}

// Returns true if string s is empty
function isEmpty(s) {
	return ((s == null) || (s.length == 0))
}

// Returns true if character c is a digit
function isDigit(c) {
	return ((c >= "0") && (c <= "9"))
}

// Returns true if character c is a digit
function isAlpha(c) {
	return ( ((c >= 'A') && (c <= 'Z')) || ((c >= 'a') && (c <= 'z')) );
}

// Returns true if all characters in string s are numbers (non-signed integers only)
function isInteger(s) {
	if (isEmpty(s)) return false;
	for (var i = 0; i < s.length; i++) {
		var c = s.charAt(i) // Check that current character is number
		if (!isDigit(c)) return false;
	}
	// All characters are numbers.
	return true
}

// Returns true if string s is a positive float value
function isPositiveFloat(s) {
	if (isEmpty(s)) return false;
	var bDotPassed = false;
	for (var i=0; i<s.length; i++)
		if (!isDigit(s.charAt(i)))
			if (s.charAt(i) == '.' && !bDotPassed)
				bDotPassed = true;
			else
				return false;
	return true;
}

// Returns true if all chars of string s belong to string bag
function CharsInBag(s, bag) {
	var i
    for (i = 0; i < s.length; i++) {
        var c = s.charAt(i)
        if (bag.indexOf(c) == -1) return false
    }
    return true
}

// Returns true if string s is empty or whitespace characters only
function isWhitespace(s) {
    if (isEmpty(s)) return true
	return CharsInBag(s,whitespace)
}

// Returns true if string s is a valid phone number
function isPhoneNumber(s) {
	return CharsInBag(s,validPhoneChars)
}

// Returns true if string s is a valid email address
function isEmail(s) {
	// there must be >= 1 character before @, so we
	// start looking at character position 1
	// (i.e. second character)
	var i = 1
	var sLength = s.length
	// look for @
	while ((i < sLength) && (s.charAt(i) != "@")) { i++ }
	if ((i >= sLength) || (s.charAt(i) != "@")) return false
	else i += 2
	// look for .
	while ((i < sLength) && (s.charAt(i) != ".")) { i++ }
	// there must be at least one character after the .
	if ((i >= sLength - 1) || (s.charAt(i) != ".")) return false
	else return true
}

// Returns whether the specified year is leap
function leapYear(yr) {
	if (((yr % 4 == 0) && yr % 100 != 0) || yr % 400 == 0)
		return true;
	else return false;
}

// Returns number of days in specified month & year
// month = [1,12]
function numDaysIn(mth, yr) {
	if (mth==4 || mth==6 || mth==9 || mth==11) return 30;
	else if ((mth==2) && leapYear(yr)) return 29;
	else if (mth==2) return 28;
	else return 31;
}

// Form specific validation functions

function emptyInput (input) {
	switch (input.type) {
		case "hidden":
		case "password":
		case "text": return isWhitespace (input.value); break;
		case "textarea": return isWhitespace (input.value); break;
		case "file": return isWhitespace (input.value); break;
		case "select": return (input.selectedIndex == -1);	break;
		default:
			if ((input[0].type == "radio") || (input[0].type == "checkbox")) {
				for (var i=0; i<input.length; i++)
					if (input[i].checked) return false;
			}
			return true;
	}
}

function alertInput (input, message) {
	alert (message);
	input.focus ();
	if ((input.type == "text") || (input.type == "file") || (input.type == "password"))
		input.select ();
	return false;
}

function checkRequiredFields (form, fields, messages) {
	for (var i=0; i<fields.length; i++) {
		if (emptyInput (form.elements [fields [i]])) {
			alertInput (form.elements [fields [i]], messages [i]);
			return false;
		}
	}
	return true;
}

// Check date
// fields - array of form field names
// fields/messages arrays should be {day, month, year}
// yearbounds - {min, max} year values
function checkDate (form, fields, messages, yearbounds) {
	if ((fields.length != 3) || (messages.length != 3) || (yearbounds.length != 2))
		return false;
	year = form.elements[fields [2]];
	month = form.elements[fields [1]];
	day = form.elements[fields [0]];
	if (!isInteger(year.value) || (year.value < yearbounds[0]) || (year.value > yearbounds[1]))
		return alertInput (year, messages[2]+': should be '+yearbounds[0]+'-'+yearbounds[1]);
	if (!isInteger(month.value) || (month.value < 1) || (month.value > 12))
		return alertInput (month, messages[1]+': should be 1-12');
	maxdays = numDaysIn(month.value, year.value);
	if (!isInteger(day.value) || (day.value < 1) || (day.value > maxdays))
		return alertInput (day, messages[0]+': should be 1-'+maxdays);
	return true;
}
// Check date - for pages with multiple controls
// fields - array of form field names
// fields/messages arrays should be {day, month, year}
// yearbounds - {min, max} year values
function checkDate1 (form, fields, messages, yearbounds, i) {
	if ((fields.length != 3) || (messages.length != 3) || (yearbounds.length != 2))
		return false;
	if (i != 'undefined') indx = "["+i+"]"; else indx = "";
	year = form.elements[fields [2]+indx];
	month = form.elements[fields [1]+indx];
	day = form.elements[fields [0]+indx];
	if (!isInteger(year.value) || (year.value < yearbounds[0]) || (year.value > yearbounds[1]))
		return alertInput (year, messages[2]+': should be '+yearbounds[0]+'-'+yearbounds[1]);
	if (!isInteger(month.value) || (month.value < 1) || (month.value > 12))
		return alertInput (month, messages[1]+': should be 1-12');
	maxdays = numDaysIn(month.value, year.value);
	if (!isInteger(day.value) || (day.value < 1) || (day.value > maxdays))
		return alertInput (day, messages[0]+': should be 1-'+maxdays);
	return true;
}
// Check date (ISO format)
// field - form field
// fields/messages arrays should be {day, month, year}
// yearbounds - {min, max} year values
function checkDate2 (form, field, messages, yearbounds) {
	CDate = Trim(field.value);
	if (CDate == '') return true;
	var DateParts = CDate.split('-');
	if (DateParts.length != 3) 
		return alertInput (field, 'Incorrect date');
	year = DateParts[0];
	month = DateParts[1];
	day = DateParts[2];
	if (!isInteger(year) || (year < yearbounds[0]) || (year > yearbounds[1]))
		return alertInput (field, messages[2]+': should be '+yearbounds[0]+'-'+yearbounds[1]);
	if (!isInteger(month) || (month < 1) || (month > 12))
		return alertInput (field, messages[1]+': should be 1-12');
	maxdays = numDaysIn(month, year);
	if (!isInteger(day) || (day < 1) || (day > maxdays))
		return alertInput (field, messages[0]+': should be 1-'+maxdays);
	return true;
}
// -->
//</SCRIPT>
