<?php
// ============================================
//  Copyright:   (r)(c) 2000.
//  File:        regedit.inc.php
//  Subsystem:   Administration
//  Description: Configuration editor
//  Author:      kkg, h2o
// ============================================

	$lib_dir = "../lib/";
	$cfg_dir = "cfg/";

	include ($cfg_dir . "database.cfg.php");
	include ($lib_dir . "registry.lib.php");

	if (!isset ($key)) $key = "";
	$self = $PHP_SELF;

	switch ($action) {
		case "create":
			$key = regKeyFromPathAndName ($key, $name);
			regCreateKey ($key);
			$view = "edit";
		break;
		case "delete":
			$tmp = regPathFromKey ($key);
			regDeleteKey ($key);
			$key = $tmp;
		break;
		case "update":
			switch ($type) {
				case TYPE_BOOLEAN:
					$value = $boolval == "true";
				break;
				case TYPE_INTEGER:
					$value = intval ($intval);
				break;
				case TYPE_DOUBLE:
					$value = doubleval ($doubleval);
				break;
				case TYPE_STRING:
					if (isset ($astext))
						$value = $textval;
					else
						$value = $strval;
					if (get_magic_quotes_gpc ())
						$value = stripslashes ($value);
				break;
			}
			regSetValue ($key, $value);
			$key = regPathFromKey ($key);
		break;
		case "rename":
			regRenameKey ($key, $name);
			$key = regPathFromKey ($key);
		break;
		case "copy":
			regCopySubTree ($name, $key);
			$key = $name;
		break;
	}

	$keys = regSubKeys($key);
	$expl = regExplodeKey($key);
?>

<script>
<!--
function isEmpty(s) {
	return ((s == null) || (s.length == 0))
}

function validKeyName(s) {
	var VALID_CHARS = "0123456789_abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ/";
	for (var i=0; i<s.length; i++)
		if (VALID_CHARS.indexOf (s.charAt (i)) == -1) return false;
	return true;
}

function chkCreateForm(form) {
	return validKeyName(form.elements["name"].value != '') && !isEmpty(form.elements["name"].value);
}

function copysubtree () {
	document.createform.action.value = "copy";
	if (chkCreateForm (document.createform)) document.createform.submit ();
}

function changeBox (element){
    var ChekArr = new Array();
    ChekArr["strval"] = "string";
    ChekArr["boolval"] = "boolean";
    ChekArr["intval"] = "integer";
    ChekArr["textval"] = "yes";
    ChekArr["doubleval"] = "double";

    form = element.form;

    for (var i=0; i<form.length; i++) {
        if (form.elements[i].type == "radio" || form.elements[i].type == "checkbox") {
            if (element.name == "textval" && form.elements[i].value == "string") {
                form.elements[i].checked = true;
            } else {
                form.elements[i].checked = (ChekArr[element.name] == form.elements[i].value);
            }
        }
    }
}

function doDelete(key)
{
    var selfLocation = "<? echo $self . "?action=delete&key="; ?>";
    if (confirm ("Do you really want to delete the key:\n'/" + key + "' ?"))
    {
        location.href = selfLocation + key;
    }
}

//-->
</script>

<table width="100%" cellspacing="0" cellpadding="2">
<tr>
	<td width="1%" align="left"><img src="<? echo $img_dir; ?>menua.gif"></td>
	<td class="big" colspan="2">Configuration Manager</td>
</tr>
</table>
<table <? echo regTagAttributes ("RegEdit/Interface/MAIN_TABLE") ?>>
<tr bgcolor=<? echo regGetValue ("RegEdit/Interface/COLOR/Path") ?> valign=center height=28><td>
	<table border=0 cellspacing=0 cellpadding=0 width=100%>
	<td class=bt align=left width=99%>
		&nbsp;<a href="<? echo $self ?>"><? echo regGetValue ("RegEdit/Strings/Root") ?></a><font color=blue>/</font><?php
			$str = "";
			if ($expl[0] == "") unset($expl);
			for($i = 0; $i < count($expl); $i++) {
				$str .= $expl[$i];
				echo "<a href=\"" . $self . "?key=" . rawurlencode ($str) ."\">" . $expl[$i] . "</a><font color=blue>/</font>";
				$str .= "/";
			}
		?>
	</td>
	<td align="right" width="1%" class="st">
		<a href="javascript:copysubtree ()">Copy Subtree</a>
	</td>
	<td align="right" width=1%>&nbsp;</td>
	<form action="<? echo $self ?>" name=createform method=post onsubmit="return chkCreateForm(this)">
	<td align="right" width="1%">
		<input type="input" name="name" size="16" maxlength="64" class="st">
	</td>
	<td align="right" width="1%">
		<input type="submit" value="Create" class="st">
		<input type="hidden" name="action" value="create">
		<input type="hidden" name="key" value=<? echo $key ?>>
	</td>
	<td align="right" width="1%">&nbsp;</td>
	</form>
	</table>
</td></tr>
<? if (empty ($view)): ?>
<tr><td>
<table <? echo regTagAttributes ("RegEdit/Interface/VIEW_TABLE") ?>>
<? for($i = 0; $i < count($keys); $i++): ?>
<?php
	$name = regNameFromKey($keys[$i]);
	$count = regSubKeysCount ($keys[$i]);
	$value = regGetValue($keys[$i]);
	$type = gettype ($value);
	if ($type == "boolean") {
	    if ($value == 1) {
            $value = "True";
        } else {
            $value = "False";
        }
	}
?>
<tr bgcolor="#cccccc">
	<td class=st align=left width=30%>
		&nbsp;
		<b>
		<? if ($count): ?>
			<a href="<? echo $self . '?key=' . rawurlencode ($keys[$i]) ?>"><? echo $name ?></a>
		<? else: ?>
			<font color=blue><? echo $name ?></font>
		<? endif ?>
		</b>
		<? if ($count): ?>&nbsp;<b>(<? echo $count ?>)</b><? endif ?>
	</td>
	<td class=st align=left width=70%>&nbsp;<font color=<? echo $corban_color[$type] ?>><? echo htmlspecialchars (substr (strval ($value), 0, 40)) ?></font></td>
	<td class=st align=right><? echo "&nbsp;<a href=\"" . $self . "?view=edit&key=" . rawurlencode($keys[$i]) . "\">edit</a>&nbsp;" ?></td>
	<td class=st align=right><? echo "&nbsp;<a href=\"" . $self . "?view=rename&key=" . rawurlencode($keys[$i]) . "\">rename</a>&nbsp;" ?></td>
	<!--<td class=st align=right><? echo "&nbsp;<a href=\"" . $self . "?action=delete&key=" . rawurlencode($keys[$i]) . "\">delete</a>&nbsp;" ?></td>--->
	<td class="st" align="right"><? echo "&nbsp;<a href=\"javascript:doDelete('" . rawurlencode($keys[$i]) . "')\">delete</a>&nbsp;" ?></td>
</tr>
<? endfor ?>
</table>
</td></tr>
<? elseif ($view == "edit"): ?>
<?php
	$value = regGetValue ($key);
	$type = gettype ($value);
	if ($session_browser == "IE") {
		$cols = 50;
		$slen = 32;
	}
	else {
		$cols = 30;
		$slen = 25;
	}
?>
<tr align=center><td bgcolor=<? echo regGetValue ("RegEdit/Interface/COLOR/Editor") ?>>
	<table cellspacing=2 cellpadding=0 border=0>
	<form action="<? echo $self ?>" method="post" name="EditForm">
	<tr height=1>
		<td class=st colspan=5>&nbsp;</td>
	</tr>
	<tr>
		<td class="st" width=60><input type="radio" name="type" value="string" class="radiobut" <? if ($type == TYPE_STRING) echo "checked" ?>>String</td>
		<td class="st" align=right><input type="text" name="strval" size="<? echo $slen;?>" maxlength="255" class="st" <? if ($type == TYPE_STRING) echo 'value="' . htmlspecialchars (substr ($value, 0, 255)) . '"' ?> onFocus="changeBox(this);"></td>
		<td class="st" width=40>&nbsp</td>
		<td class="st" width=70><input type="radio" name="type" value="boolean" class="radiobut" <? if ($type == TYPE_BOOLEAN) echo "checked" ?>>Boolean</td>
		<td class="st"><select name="boolval" class="st" onFocus="changeBox(this);"><option value="false" <? if ($type == TYPE_BOOLEAN && !$value) echo "selected"?>>False<option value="true" <? if ($type == TYPE_BOOLEAN && $value) echo "selected"?>>True</select></td>
	</tr>
	<tr>
		<td class="st" colspan=2><input type="checkbox" name="astext" value="yes" class="radiobut" <? if ($type == TYPE_STRING && strlen ($value) > 255) echo "checked" ?>>Save as text</td>
		<td class="st" width=40>&nbsp</td>
		<td class="st" width=70><input type="radio" name="type" value="integer" class="radiobut" <? if ($type == TYPE_INTEGER) echo "checked"; ?>>Integer</td>
		<td class="st"><input type="text" name="intval" size=20 maxlength=32 class="st" <? if ($type == TYPE_INTEGER) echo 'value="' . $value . '"' ?> onFocus="changeBox(this);"></td>
	</tr>
	<tr valign=top>
		<td class=st colspan=2 rowspan=3><textarea class=st cols=<? echo $cols;?> rows=10 name=textval onFocus="changeBox(this);"><? if ($type == TYPE_STRING) echo $value ?></textarea></td>
		<td class=st width=40>&nbsp</td>
		<td class=st width=70><input type=radio name=type value=double class="radiobut" <? if ($type == TYPE_DOUBLE) echo "checked"; ?>>Double</td>
		<td class=st><input type=text name=doubleval size=20 maxlength=32 class=st <? if ($type == TYPE_DOUBLE) echo 'value="' . $value . '"' ?> onFocus="changeBox(this);"></td>
	</tr>
	<tr>
		<td class=st colspan=3>&nbsp</td>
	</tr>
	<tr valign=bottom>
		<td class=st>&nbsp</td>
		<td class=st colspan=2 align=left>
			<input type=hidden name=action value=update>
			<input type=hidden name=key value=<? echo $key ?>>
			<input type=submit value="Save" class=st>
			<input type=reset value="Cancel" class=st>
		</td>
	</tr>
	<tr valign=top height=1>
		<td class=st colspan=5>&nbsp;</td>
	</tr>
	</form>
	</table>
</td></tr>
<? elseif ($view == "rename"): ?>
<tr><td>
	<table width="100%" cellspacing=0 cellpadding=0 border=0>
	<form action="<? echo $self ?>" onsubmit="return chkCreateForm (this)">
	<tr>
		<td align=center class=bt>Rename entry</tr>
	</tr>
	<tr>
		<td align=center><input type=input name=name value=<? echo regNameFromKey($key) ?> class=st></tr>
	</tr>
	<tr>
	<td align=center>
		<input type=hidden name=action value=rename>
		<input type=hidden name=key value=<? echo $key ?>>
		<input type=submit value="Save" class=st>
		<input type=reset value="Reset" class=st>
	</td>
	</tr>
	</form>
	</table>
</td></tr>
<? endif ?>

</table>
