<?php if (!defined ("_ARRAY_LIB_")):

//# ==================================================
//# Softerra PHP developer's library
//# Copyright (c) Softerra LLC 2000, 2001
//# 
//# This library is free software; you can redistribute it and/or
//# modify it under the terms of the GNU Lesser General Public
//# License as published by the Free Software Foundation; either
//# version 2.1 of the License, or (at your option) any later version.
//# 
//# Contacts:
//# http://www.softerra.com
//# mailto:contacts@softerra.com
//# ==================================================

// =================================== 
//      Array Functions Library
// ===================================
//           Version 1.1.3
// ===================================
//  --------------------------------
//  ------ Declared functions ------
//  --------------------------------
//
//  alterValue (&$value, $key, $prefix)
//  alterArray (&$array, $prefix)
//  listArrayValues ($array, $separator=",")
//  listArrayKeys ($array, $separator=",")
//  listArrayKeysAndValues ($array, $relation="=", $separator=",")
//  printArray ($array, $prefix=0)
// 
//  --------------------------------
// ==================================

define (_ARRAY_LIB_, "array.lib.php");

function alterValue (&$value, $key, $prefix) {
	$value = $prefix . $value;
}

function alterArray (&$array, $prefix) {
	array_walk ($array, 'alterValue', $prefix);
}

function listArrayValues ($array, $separator=",") {
	while (list ($key, $value) = each ($array))
		$list .= $value . $separator;
	$list = substr ($list, 0, -strlen ($separator));
	return $list;
}

function listArrayKeys ($array, $separator=",") {
	while (list ($key, $value) = each ($array))
		$list .= $key . $separator;
	$list = substr ($list, 0, -strlen ($separator));
	return $list;
}

function listArrayKeysAndValues ($array, $relation="=", $separator=",") {
	while (list ($key, $value) = each ($array))
		$list .= $key . $relation . $value . $separator;
	$list = substr ($list, 0, -strlen ($separator));
	return $list;
}

function printArray ($array, $prefix=0) {
	if (!$prefix) $prefix = "array";
	while (list ($key, $value) = each ($array)) {
		$curprefix = $prefix . " [" . $key . "]";
		if (is_array ($value))
			printArray ($value, $curprefix);
		else
			echo $curprefix . " = " . $value . "<br>";
	}
}

/** Return the maximal array element
* @param	array	$data
* @return	int
*/
function array_max ($data)
{
	$first = true;
	while (list ($key, $val) = each ($data))
	{
		if ($first)
		{
			$max = intval($val);
			$first = false;
		}
		elseif ($max < intval($val))
		{
			$max = intval($val);
		}
	}
	return $max;
}

function removeIntegerValuesFormArray (&$array)
{
	for($i=0; $i<count ($array); $i++)
		if ( is_integer ($array[$i]) )
			array_splice ($array, $i, 1);
}

function removeNotItegerValuesFormArray (&$array)
{
	for($i=0; $i<count ($array); $i++)
		if ( !is_integer ($array[$i]) )
			array_splice ($array, $i, 1);
}

function array_sprintf ($format, $array, $urlenc=true)
{
	$picies = explode ("%", $format);
	for($i=0; $i< count ($picies); $i++)
		if ($i)
			$result .= sprintf ("%" . $picies[$i], $this->bUseUrlEnc ? rawurlencode($array[$i-1]) : $array[$i-1]);
		else
			$result .= $picies[$i];
	return $result;
}



// ===============================================/
// functions implemented to portability with PHP3 /
// ===============================================/

if (!function_exists ("in_array")):
function in_array ($needle, $haystack) {
	for ($i=0; $i<count ($haystack); $i++)
		if ($haystack[$i] == $needle) return true;
	return false;
}
endif; // if function_exists ("in_array")

if (!function_exists ("array_slice")):
function array_slice ($input, $offset, $length) {
	$result = array ();
	for ($i=0; $i<$length; $i++) {
		$result[] = $input[$offset+$i];
	}
	return $result;
} 
endif; // if function_exists ("array_slice")

endif ?>