#! /bin/sh
# Script for DB creation/populating with data

DBCFG="../example/cfg/database.cfg.php"

# get value of parameter specified as
# define (DB_NAME, "fleetbase");
getParam() {
    echo `gawk '
              /define \('$1'/ {
                                    n = split ($0, string ,/"/);
              			    if (n == 3) {
              			 	print string[2];
              			    }
              			  }
' $DBCFG`     
}

DB_NAME=`getParam DB_NAME`
DB_HOST=`getParam DB_HOST`
DB_USER=`getParam DB_USER`
DB_PASSWORD=`getParam DB_PASSWORD`

if [ "$DB_PASSWORD" != "" ]; then
    pwdCmd="--password=$DB_PASSWORD"
 else 
    pwdCmd=""
fi    

mysqlCmdCreate="mysql --user=$DB_USER --host=$DB_HOST $pwdCmd"
mysqlCmdExec="mysql --user=$DB_USER --host=$DB_HOST --database=$DB_NAME $pwdCmd"

# test commands
#echo "mysqlCmdCreate = $mysqlCmdCreate"
#echo "mysqlCmdExec = $mysqlCmdExec"

case "$1" in
'create')
	echo "DROP DATABASE IF EXISTS $DB_NAME" | $mysqlCmdCreate
	echo "CREATE DATABASE $DB_NAME" | $mysqlCmdCreate
	cat crebas.sql | $mysqlCmdExec
    ;;

*)
        echo "Usage: createdb.sh create"
        ;;

esac
