<?php if (!defined ("_STDCTRL_LIB_")):

//# ==================================================
//# Softerra PHP developer's library
//# Copyright (c) Softerra LLC 2000, 2001
//# 
//# This library is free software; you can redistribute it and/or
//# modify it under the terms of the GNU Lesser General Public
//# License as published by the Free Software Foundation; either
//# version 2.1 of the License, or (at your option) any later version.
//# 
//# Contacts:
//# http://www.softerra.com
//# mailto:contacts@softerra.com
//# ==================================================

// =================================== 
//      Standart HTML controls
//         generator library
// ===================================
//           Version 1.1
// ===================================
//  --------------------------------
//  ------ Declared functions ------
//  --------------------------------
//
//  makeOptionsFromSimpleArray ($array, $selectedItems=false)
//  makeOptionsFromArray ($array, $valueField, $textField, $selectedItems=false)
//  makeOptionsFromHashArray ($array, $selectedItems=false, $reverse=false)
//  makeRadioFromArray ($ctrlName, $array, $checkedIndex=false)
//  makeCheckboxesFromArray ($ctrlName, $array, $checkedItems=false)
// 
//  --------------------------------
// ==================================

define (_STDCTRL_LIB_, "stdctrl.lib.php");

function in_values ($val, $vals) {
	if (is_array ($vals))
		return in_array ($val, $vals);
	else
		return $val == $vals;
}

function outOption ($value, $text, $selected) {
	printf ("<option value=\"%s\" %s>%s", $value, $selected ? "selected":"", $text);
}

function outRadio ($name, $value, $text, $checked) {
	printf ("<input type=radio name=\"%s\" value=\"%s\" %s>%s", $name, $value, $checked ? "checked":"", $text);
}

function outCheckbox ($name, $value, $text, $checked) {
	printf ("<input type=checkbox name=\"%s\" value=\"%s\" %s>%s", $name, $value, $checked ? "checked":"", $text);
}

function makeOptionsFromSimpleArray ($array, $selectedItems=false) {
	for ($i=0; $i < count ($array); $i++)
		outOption ($array[$i], $array[$i], in_values ($array[$i], $selectedItems));
}

function makeOptionsFromArray ($array, $valueField, $textField, $selectedItems=false) {
	for ($i=0; $i < count ($array); $i++) {
		$value = $array[$i][$valueField];
		$text = $array[$i][$textField];
		outOption ($value, $text, in_values ($value, $selectedItems));
	}
}

function makeOptionsFromHashArray ($array, $selectedItems=false, $reverse=false) {
	if ($reverse) {
		$key = "value";
		$val = "text";
	} else {
		$key = "text";
		$val = "value";
	}
	while (list (${$key}, ${$val}) = each ($array))
		outOption ($value, $text, in_values ($value, $selectedItems));
}

function makeRadioFromArray ($ctrlName, $array, $checkedIndex=false) {
	for ($i=0; $i<=count ($array); $i++)
		outRadio ($ctrlName, $i, $array[$i], $i==$checkedIndex);
}

function makeCheckboxesFromArray ($ctrlName, $array, $checkedItems=false) {
	for($i=0; $i<count ($array); $i++)
		outCheckbox ($ctrlName . $i, $i, $array[$i], in_values ($i, $checkedItems));
}

endif ?>