<?php if (!defined ("_SOFTERRA_GRID_INT_")):

//# ==================================================
//# Softerra PHP developer's library
//# Copyright (c) Softerra LLC 2000, 2001
//# 
//# This library is free software; you can redistribute it and/or
//# modify it under the terms of the GNU Lesser General Public
//# License as published by the Free Software Foundation; either
//# version 2.1 of the License, or (at your option) any later version.
//# 
//# Contacts:
//# http://www.softerra.com
//# mailto:contacts@softerra.com
//# ==================================================

///////////////////////////////////////////////////////////////////////////////
//  Copyright:   (r)(c) 2000, 2001
//  Project:     Grid library
//  File:        grid3.lib.php
//  Subsystem:   Universal grid library (version 2.5.1)
//  Description: Main file
//  Author:      kkg, h2o

///////////////////////////////////////////////////////////////////////////////
// Define include checking flag

define (_SOFTERRA_GRID_INT_, "grid3.lib.php");

///////////////////////////////////////////////////////////////////////////////
// Include libraries

require ($cfg_dir . "database.cfg.php");
require ($cfg_dir . "error.codes.php");
require ($lib_dir . "sqlstorage.class.php");
require ($lib_dir . "registry.lib.php");

///////////////////////////////////////////////////////////////////////////////
// Define constants

define (REGISTRY_GRID_TIMER, "registry_grid_timer");

define (DEFAULT_KEY, "Default");
define (COLUMN_TITLE_KEY, "Title");
define (TITLE_ATTRS_KEY, "TitleAttributes");
define (BODY_ATTRS_KEY, "BodyAttributes");
define (EXTRA_COLUMN_TYPE_KEY, "Type");
define (EXTRA_COLUMN_LEFT, "Left");
define (EXTRA_COLUMN_RIGHT, "Right");
define (EXTRA_TEXT_PATTERN_KEY, "TextPattern");
define (EXTRA_VARIABLES_KEY, "Variables");
define (LEFT_EXTRA_KEY, "LeftExtra");
define (RIGHT_EXTRA_KEY, "RightExtra");

define (EMPTY_STRING, "");

define (GET_VAR_SORT_FIELD, "sf");
define (GET_VAR_START_ROW, "sr");
define (GET_VAR_SORT_DIRECTION, "d");
define (GET_VAR_ROWS_TO_SHOW, "rows");

///////////////////////////////////////////////////////////////////////////////
// Define registry constants

define (REG_GRIDS_PATH, "FMWC/Interface/GridsV2/%s/");
define (REG_TABLE_SUBKEY, "Table");
define (REG_NAVIGATOR_SUBKEY, "Navigator");
define (REG_COLUMNS_SUBKEY, "Columns");
define (REG_EXTRACOLUMNS_SUBKEY, "ExtraColumns");
define (REG_ROWS_SUBKEY, "Rows");

define (REG_TABLE_ATTRIBUTES_SUBKEY, REG_TABLE_SUBKEY."/Attributes");
define (REG_NAVIGATOR_ATTRIBUTES_SUBKEY, REG_NAVIGATOR_SUBKEY."/Attributes");
define (REG_NAVIGATOR_LEFT_CELL_SUBKEY, REG_NAVIGATOR_SUBKEY."/LeftCell");
define (REG_NAVIGATOR_CENTER_CELL_SUBKEY, REG_NAVIGATOR_SUBKEY."/CenterCell");
define (REG_NAVIGATOR_RIGHT_CELL_SUBKEY, REG_NAVIGATOR_SUBKEY."/RightCell");
define (REG_DEFAULT_COLUMN_SUBKEY, REG_COLUMNS_SUBKEY."/".DEFAULT_KEY);
define (REG_DEFAULT_EXTRACOLUMN_SUBKEY, REG_EXTRACOLUMNS_SUBKEY."/".DEFAULT_KEY);
define (REG_EVEN_ROW_SUBKEY, REG_ROWS_SUBKEY."/0");
define (REG_ODD_ROW_SUBKEY, REG_ROWS_SUBKEY."/1");

///////////////////////////////////////////////////////////////////////////////
// Define navigator images.

define (NAV_FIRST_IMAGE_NORMAL, '<img name="first" border="0" src="' . $img_dir . 'first_n.gif" width="32" height="20" alt="first">');
define (NAV_FIRST_IMAGE_DISABLED, '<img name="first" border="0" src="' . $img_dir . 'first_d.gif" width="32" height="20" alt="first (no records)">');
define (NAV_PREV_IMAGE_NORMAL, '<img name="prev" border="0" src="' . $img_dir . 'prev_n.gif" width="32" height="20" alt="previous">');
define (NAV_PREV_IMAGE_DISABLED, '<img name="prev" border="0" src="' . $img_dir . 'prev_d.gif" width="32" height="20" alt="previous (no records)">');
define (NAV_NEXT_IMAGE_NORMAL, '<img name="next" border="0" src="' . $img_dir . 'next_n.gif" width="32" height="20" alt="next">');
define (NAV_NEXT_IMAGE_DISABLED, '<img name="next" border="0" src="' . $img_dir . 'next_d.gif" width="32" height="20" alt="next (no records)">');
define (NAV_LAST_IMAGE_NORMAL, '<img name="last" border="0" src="' . $img_dir . 'last_n.gif" width="32" height="20" alt="last">');
define (NAV_LAST_IMAGE_DISABLED, '<img name="last" border="0" src="' . $img_dir . 'last_d.gif" width="32" height="20" alt="last (no records)">');

///////////////////////////////////////////////////////////////////////////////
// Class

class softerraGrid extends sqlStorage
{
	// ---------------------------------------
	//  common
	// ---------------------------------------

	var $sGridRegPath;		/* path to grid setting in registry */
	var $aURLVariables;     /* URL variables                    */
	var $bUseUrlEnc;		/* Use URLEncode in extra columns   */

	// ---------------------------------------
	//  query specific variables
	// ---------------------------------------

	var $vQryTable;			/* name of table used for query     */
	var $aQryData;			/* query result                     */
	var $aQryFields;		/* query result fields              */
	var $vQryConditions;	/* array of conditions              */
	var $aQrySorting;		/* sorting properties               */
	var $aQryLimits;		/* limits properties                */
	var $nQryTotal;			/* total records in query           */

	// ---------------------------------------
	//  rendering specific variables
	// ---------------------------------------

	var $sTableAttributes;  /* main table attributes            */
	var $sNavigAttributes;  /* navigator table attributes       */

	var $nBodyColCount;     /* count of body columns            */
	var $nExtraColCount;	/* count of extra columns           */
	var $aBodyColumns;		/* data columns                     */
	var $aExtraColumns;		/* extra (non data) columns         */

	var $sEvenRow;			/* even rows attributes             */
	var $sOddRow;			/* odd rows attributes              */

	var $sNavigLeftCell;	/* left navigator cell              */
	var $sNavigCenterCell;	/* center navigator cell            */
	var $sNavigRightCell;	/* right navigator cell             */

	var $sNoDataMessage;	/* message which appear if no record were fetched form the database */

	var $sFormName;			/* form name where grid is situated */
	var $sJavaScriptFile;	/* path to javascript file          */

	// ---------------------------------------
	//  Hack vars.
	//  I have added this since 3.22 MySQL
	//  doesn't support "select (distinct FIELD)" syntax
	//  I sugest you use MySQL 3.23 and forgot about this
	// ---------------------------------------

	var $bUseUserDefinedCount = false;
	var $nUserDefinedCount = 0;

	// ---------------------------------------
	//  Constructor
	// ---------------------------------------

	function softerraGrid ($sGridName, $bUseRegistry=true)
	{
		$this->connect (DB_HOST, DB_USER, DB_PASSWORD, DB_NAME);
		$this->aQrySorting	= array ("FIELD" => 1, "DIRECTION" => "ASC", "BACKDIRECTION" => "DESC");
		$this->aQryLimits	= array ("OFFSET" => 0, "ROWS" => 10);
		$this->aBodyColumns	= array ();
		$this->aExtraColumns	= array ();
		$this->aURLVariables    = array ();
		$this->bUseUrlEnc	= true;
		$this->sFormName  = $sGridName;
		$this->sJavaScriptFile  = "inc/grid.js";
		if ($bUseRegistry)
		{
			$this->sGridRegPath	= sprintf (REG_GRIDS_PATH, $sGridName);
			$this->processRegistryInfo ();
		}
		$this->processHttpVariables ();
	}

	// ---------------------------------------
	//  Process HTTP and Session variables
	// ---------------------------------------

	function processHttpVariables ()
	{
		global $HTTP_GET_VARS;
		global $session_fetch_count;

		if (isset ($HTTP_GET_VARS[GET_VAR_SORT_FIELD]))
			$this->aQrySorting["FIELD"] = $HTTP_GET_VARS[GET_VAR_SORT_FIELD];

		if (isset ($HTTP_GET_VARS[GET_VAR_SORT_DIRECTION]))
			if ($HTTP_GET_VARS[GET_VAR_SORT_DIRECTION] == "ASC")
			{
				$this->aQrySorting["DIRECTION"] = "ASC";
				$this->aQrySorting["BACKDIRECTION"] = "DESC";
			}
			else
			{
				$this->aQrySorting["DIRECTION"] = "DESC";
				$this->aQrySorting["BACKDIRECTION"] = "ASC";
			}

		if (isset ($HTTP_GET_VARS[GET_VAR_START_ROW]))
			$this->aQryLimits["OFFSET"] = intval ($HTTP_GET_VARS[GET_VAR_START_ROW]);

		if (isset ($HTTP_GET_VARS[GET_VAR_ROWS_TO_SHOW]) && intval ($HTTP_GET_VARS[GET_VAR_ROWS_TO_SHOW]) > 0)
			$this->aQryLimits["ROWS"] = intval ($HTTP_GET_VARS[GET_VAR_ROWS_TO_SHOW]);
		elseif (isset ($session_fetch_count) && $session_fetch_count > 0)
			$this->aQryLimits["ROWS"] = $session_fetch_count;
	}

	// ---------------------------------------
	//  Load and process registry variables
	// ---------------------------------------

	function processRegistryInfo ()
	{
		if ($this->debug) corban_inittimer (REGISTRY_GRID_TIMER);

		$this->sTableAttributes = regGetValue ($this->sGridRegPath.REG_TABLE_ATTRIBUTES_SUBKEY);
		$this->sNavigAttributes = regGetValue ($this->sGridRegPath.REG_NAVIGATOR_ATTRIBUTES_SUBKEY);
		$this->nBodyColCount = regGetValue ($this->sGridRegPath.REG_COLUMNS_SUBKEY);
		$this->nExtraColCount = regGetValue ($this->sGridRegPath.REG_EXTRACOLUMNS_SUBKEY);
		$this->sEvenRow = regGetValue ($this->sGridRegPath.REG_EVEN_ROW_SUBKEY);
		$this->sOddRow = regGetValue ($this->sGridRegPath.REG_ODD_ROW_SUBKEY);

		// Get all columns

		$path = $this->sGridRegPath.REG_DEFAULT_COLUMN_SUBKEY."/";
		$this->aBodyColumns[DEFAULT_KEY] = array ();

		$val = regGetValue ($path.COLUMN_TITLE_KEY);
		$this->aBodyColumns[DEFAULT_KEY][COLUMN_TITLE_KEY] = ($val != false) ? $val : "Col #";

		$val = regGetValue ($path.TITLE_ATTRS_KEY);
		$this->aBodyColumns[DEFAULT_KEY][TITLE_ATTRS_KEY] = ($val != false) ? $val : EMPTY_STRING;

		$val = regGetValue ($path.BODY_ATTRS_KEY);
		$this->aBodyColumns[DEFAULT_KEY][BODY_ATTRS_KEY] = ($val != false) ? $val : EMPTY_STRING;

		$path = $this->sGridRegPath.REG_COLUMNS_SUBKEY."/";

		for ($i=0; $i<$this->nBodyColCount; $i++)
		{
			$val = regGetValue ($path.$i."/".COLUMN_TITLE_KEY);
			$this->aBodyColumns[$i][COLUMN_TITLE_KEY] = ($val != false) ? $val : $this->aBodyColumns[DEFAULT_KEY][COLUMN_TITLE_KEY];

			$val = regGetValue ($path.$i."/".TITLE_ATTRS_KEY);
			$this->aBodyColumns[$i][TITLE_ATTRS_KEY] = ($val != false) ? $val : $this->aBodyColumns[DEFAULT_KEY][TITLE_ATTRS_KEY];

			$val = regGetValue ($path.$i."/".BODY_ATTRS_KEY);
			$this->aBodyColumns[$i][BODY_ATTRS_KEY] = ($val != false) ? $val : $this->aBodyColumns[DEFAULT_KEY][BODY_ATTRS_KEY];
		}

		// Get all extra columns

		$path = $this->sGridRegPath.REG_DEFAULT_EXTRACOLUMN_SUBKEY."/";

		$this->aExtraColumns[DEFAULT_KEY] = array ();

		$val = regGetValue ($path.TITLE_ATTRS_KEY);
		$this->aExtraColumns[DEFAULT_KEY][TITLE_ATTRS_KEY] = ($val != false) ? $val : EMPTY_STRING;

		$val = regGetValue ($path.BODY_ATTRS_KEY);
		$this->aExtraColumns[DEFAULT_KEY][BODY_ATTRS_KEY] = ($val != false) ? $val : EMPTY_STRING;

		$val = regGetValue ($path.EXTRA_COLUMN_TYPE_KEY);
		$this->aExtraColumns[DEFAULT_KEY][EXTRA_COLUMN_TYPE_KEY] = ($val != false) ? $val : EXTRA_COLUMN_RIGHT;

		$path = $this->sGridRegPath.REG_EXTRACOLUMNS_SUBKEY."/";

		$this->aExtraColumns[LEFT_EXTRA_KEY] = regGetValue ($path.LEFT_EXTRA_KEY);
		$this->aExtraColumns[RIGHT_EXTRA_KEY] = regGetValue ($path.RIGHT_EXTRA_KEY);

		for ($i=0; $i<$this->nExtraColCount; $i++)
		{
			$key = regGetValue ($path.$i."/".EXTRA_COLUMN_TYPE_KEY);
			if ($key == false) $key = $this->aExtraColumns[DEFAULT_KEY][EXTRA_COLUMN_TYPE_KEY];

			$titleattrs = regGetValue ($path.$i."/".TITLE_ATTRS_KEY);
			if ($titleattrs == false) $titleattrs = $this->aExtraColumns[DEFAULT_KEY][TITLE_ATTRS_KEY];

			$bodyattrs = regGetValue ($path.$i."/".BODY_ATTRS_KEY);
			if ($bodyattrs == false) $bodyattrs = $this->aExtraColumns[DEFAULT_KEY][BODY_ATTRS_KEY];

			$pattern = regGetValue ($path.$i."/".EXTRA_TEXT_PATTERN_KEY);

			$varialbles = explode (",", regGetValue ($path.$i."/".EXTRA_VARIABLES_KEY));

			$this->aExtraColumns[$key][] = array (TITLE_ATTRS_KEY => $titleattrs,
								BODY_ATTRS_KEY => $bodyattrs,
								EXTRA_TEXT_PATTERN_KEY => $pattern,
								EXTRA_VARIABLES_KEY => $varialbles);
		}

		$this->sNavigLeftCell = regGetValue ($this->sGridRegPath.REG_NAVIGATOR_LEFT_CELL_SUBKEY);
		$this->sNavigCenterCell = regGetValue ($this->sGridRegPath.REG_NAVIGATOR_CENTER_CELL_SUBKEY);
		$this->sNavigRightCell  = regGetValue ($this->sGridRegPath.REG_NAVIGATOR_RIGHT_CELL_SUBKEY);

		if ($this->debug) corban_showtimer (REGISTRY_GRID_TIMER, "Regisy loading takes");
	}

	function renderTableBegin ($data="")
	{
		echo "<table ".$data.">\n";
	}

	function renderTableEnd ()
	{
		echo "</table>\n";
	}

	function renderTRBegin ($attibutes="")
	{
		echo "<tr ".$attibutes.">\n";
	}

	function renderTREnd ()
	{
		echo ("</tr>\n");
	}

	function renderTD($data, $attributes="")
	{
		echo "<td ".$attributes.">".$data."</td>\n";
	}

	function renderTDBegin($attributes="")
	{
		echo "<td ".$attributes.">";
	}

	function renderTDEnd()
	{
		echo "</td>\n";
	}

	function createAnchorTag($url, $data, $onMouseOver=false, $onMouseOut=false)
	{
		$result = "<a href=\"" . $url . "\" ";
		if (isset ($onMouseOver))
			$result .= "onMouseOver=\"" . $onMouseOver . "\" ";
		if (isset ($onMouseOut))
			$result .= "onMouseOut=\"" . $onMouseOut . "\"";
		$result .= ">" . $data . "</a>";
		return $result;
	}

	function renderJavaScript ($source)
	{
		echo "<script src=\"" . $source . "\"></script>\n";
	}

	function renderButton ($name, $value, $onclick)
	{
		echo '<input type="button" class="st" name="' . $name . '" value="' . $value . '" onclick="' . $onclick . "\">";
	}

	function renderHidden ($name, $value)
	{
		echo '<input type="hidden" name="' . $name . '" value="' . $value . "\">";
	}

	function renderTextInput ($name, $value=false, $size=false, $maxlength=false)
	{
		echo '<input type="text" name="' . $name . '" value="' . $value . '"';
		if (is_integer ($size))
			echo ' size="' . $size . '"';
		if (is_integer ($maxlength))
			echo ' maxlength="' . $maxlength . '"';
		echo ">";
	}

	function removeIntegerValuesFormArray (&$array)
	{
		for($i=0; $i<count ($array); $i++)
			if ( is_integer ($array[$i]) )
				array_splice ($array, $i, 1);
	}

	function removeNotItegerValuesFormArray (&$array)
	{
		for($i=0; $i<count ($array); $i++)
			if ( !is_integer ($array[$i]) )
				array_splice ($array, $i, 1);
	}

	function array_sprintf ($format, $array, $urlenc=true)
	{
		$picies = explode ("%", $format);
		for($i=0; $i< count ($picies); $i++)
			if ($i)
				$result .= sprintf ("%" . $picies[$i], $this->bUseUrlEnc ? rawurlencode($array[$i-1]) : $array[$i-1]);
			else
				$result .= $picies[$i];
		return $result;
	}

	function registerURLVariable ($name, $default=false)
	{
		global $HTTP_GET_VARS;
		$value = isset ($HTTP_GET_VARS[$name]) ? $HTTP_GET_VARS[$name] : $default;
		$this->aURLVariables[$name] = $value;
	}

	function getExtraURL ()
	{
		$url = "";
		$keys = array_keys ($this->aURLVariables);
		for ($k=0; $k<count ($keys); $k++)
		{
			$key = $keys[$k];
			$value = $this->aURLVariables[$key];
			if (is_array ($value))
				for ($i=0; $i<count ($value); $i++)
					$url .= $key . rawurlencode("[]") . "=" . $value[$i] . "&";
			else
				$url .= $key . "=" . $value . "&";

		}
		$url = substr ($url, 0, -1);
		return strlen ($url) ? "&".$url : "";
	}

	function renderTableHeader()
	{
		global $PHP_SELF;

		if (is_array ($this->aExtraColumns[EXTRA_COLUMN_LEFT]))
			$nLeftExtraCount = count ($this->aExtraColumns[EXTRA_COLUMN_LEFT]);
		else
			$nLeftExtraCount = 0;

		if (is_array ($this->aExtraColumns[EXTRA_COLUMN_RIGHT]))
			$nRightExtraCount = count ($this->aExtraColumns[EXTRA_COLUMN_RIGHT]);
		else
			$nRightExtraCount = 0;

		$this->renderTRBegin ();

		if ($nLeftExtraCount > 0)
		{
			$attributes = ($nLeftExtraCount == 1) ? "" : " colspan=\"". $nLeftExtraCount . "\"";
			$this->renderTD ("&nbsp;", $attributes . " " . $this->aExtraColumns[LEFT_EXTRA_KEY]);
		}

		if (!is_array ($this->aQryData[0]))
			$this->aQryData[0] = array ();

		$keys = array_keys($this->aQryData[0]);
		$this->removeIntegerValuesFormArray($keys);

		$attributes = array ();
		$attributes[GET_VAR_SORT_FIELD] = 1;
		$attributes[GET_VAR_START_ROW] = $this->aQryLimits["OFFSET"];
		$attributes[GET_VAR_SORT_DIRECTION] = $this->aQrySorting["BACKDIRECTION"];
		$attributes[GET_VAR_ROWS_TO_SHOW] = $this->aQryLimits["ROWS"];

		for ($col=0; $col < $this->nBodyColCount; $col++)
		{
			echo "<td " . $this->aBodyColumns[$col][TITLE_ATTRS_KEY] . ">";
			$attributes[GET_VAR_SORT_FIELD] = $keys[$col];
			echo $this->createAnchorTag ($this->makeSelfUrl ($attributes), $this->aBodyColumns[$col][COLUMN_TITLE_KEY]);
			echo "</td>\n";
		}

		if ($nRightExtraCount > 0)
		{
			$attributes = ($nRightExtraCount == 1) ? "" : " colspan=\"". $nRightExtraCount . "\"";
			$this->renderTD ("&nbsp;", $attributes . " " . $this->aExtraColumns[RIGHT_EXTRA_KEY]);
		}

		$this->renderTREnd ();
	}

	function renderTableBody(&$data)
	{
		if (!is_array ($data) || !($nRowCount = count ($data)))
				return;

		if (is_array ($this->aExtraColumns[EXTRA_COLUMN_LEFT]))
			$nLeftExtraCount = count ($this->aExtraColumns[EXTRA_COLUMN_LEFT]);
		else
			$nLeftExtraCount = 0;

		if (is_array ($this->aExtraColumns[EXTRA_COLUMN_RIGHT]))
			$nRightExtraCount = count ($this->aExtraColumns[EXTRA_COLUMN_RIGHT]);
		else
			$nRightExtraCount = 0;


		for($row=0; $row<$nRowCount; $row++)
		{
			$rowstyle = ($row % 2) ? $this->sOddRow : $this->sEvenRow;
			$this->renderTRBegin ($rowstyle);

			for($i=0; $i<$nLeftExtraCount; $i++)
			{
				echo "<td " . $this->aExtraColumns[EXTRA_COLUMN_LEFT][$i][BODY_ATTRS_KEY] . ">";
				$values = array ();
				$nExtraVarsCount = count ($this->aExtraColumns[EXTRA_COLUMN_LEFT][$i][EXTRA_VARIABLES_KEY]);
				for($e=0; $e < $nExtraVarsCount; $e++)
					$values[] = $data[$row][$this->aExtraColumns[EXTRA_COLUMN_LEFT][$i][EXTRA_VARIABLES_KEY][$e]];
				echo $this->array_sprintf ($this->aExtraColumns[EXTRA_COLUMN_LEFT][$i][EXTRA_TEXT_PATTERN_KEY], $values);
				echo "</td>";
			}

			for($i=0; $i<$this->nBodyColCount; $i++)
			{
				echo "<td " . $this->aBodyColumns[$i][BODY_ATTRS_KEY] . ">";
				echo ((!isset ($data[$row][$i]) || !strlen($data[$row][$i])) ? "&nbsp;" : htmlspecialchars ($data[$row][$i])) . "</td>";
			}

			for($i=0; $i<$nRightExtraCount; $i++)
			{
				echo "<td " . $this->aExtraColumns[EXTRA_COLUMN_RIGHT][$i][BODY_ATTRS_KEY] . ">";
				$values = array ();
				$nExtraVarsCount = count ($this->aExtraColumns[EXTRA_COLUMN_RIGHT][$i][EXTRA_VARIABLES_KEY]);
				for($e=0; $e < $nExtraVarsCount; $e++)
					$values[] = $data[$row][$this->aExtraColumns[EXTRA_COLUMN_RIGHT][$i][EXTRA_VARIABLES_KEY][$e]];
				echo $this->array_sprintf ($this->aExtraColumns[EXTRA_COLUMN_RIGHT][$i][EXTRA_TEXT_PATTERN_KEY], $values);
				echo "</td>";
			}

			$this->renderTREnd ();
		}
	}

	function makeConditions ()
	{
		if (is_array ($this->vQryConditions))
			$conditions = simpleConditions ($this->vQryConditions);
		elseif ($this->vQryConditions)
			$conditions = $this->vQryConditions;
		else
			$conditions = "";
		return $conditions . " order by " . $this->aQrySorting["FIELD"] . " " . $this->aQrySorting["DIRECTION"] .
			" limit " . $this->aQryLimits["OFFSET"] . "," . $this->aQryLimits["ROWS"];
	}

	function makeSelfUrl ($values=array())
	{
		global $PHP_SELF;
		$result = $PHP_SELF . "?";
		while (list ($key, $value) = each ($values))
			$result .= $key . "=" . $value . "&";
		if (count ($values) != 0) $result = substr ($result, 0, -1);
		$result .= $this->getExtraURL ();
		return $result;
	}

	function renderGrid ()
	{
		if ($this->bUseUserDefinedCount)
			$this->nQryTotal = $this->nUserDefinedCount;
		else
			//$this->nQryTotal = $this->select_count ($this->vQryTable, $this->vQryConditions);
			$this->nQryTotal = count($this->select_result ($this->vQryTable, "*", $this->vQryConditions));
		$this->free_result ();
		if ($this->nQryTotal <= $this->aQryLimits["OFFSET"])
			$this->aQryLimits["OFFSET"] = 0;
		$this->aQryData = $this->select_result ($this->vQryTable, $this->aQryFields, $this->makeConditions ());
		$this->free_result ();
		if (intval($this->nQryTotal) > 0)
		{
			if ($this->sJavaScriptFile)
				$this->renderJavaScript ($this->sJavaScriptFile);
			$this->renderTableBegin ($this->sTableAttributes);
			$this->renderTableHeader ();
			$this->renderTableBody ($this->aQryData);
			$this->renderTableEnd ();
			$this->renderNavigator ();
			return SUCCESS;
		}
		$this->renderNodataMessage ();
		return ERROR_NODATA;
	}

	function renderNodataMessage ()
	{
		if (!isset ($this->sNoDataMessage))
			return;
		$this->renderTableBegin ($this->sTableAttributes);
		$this->renderTRBegin ();
		$this->renderTD ($this->sNoDataMessage, $this->sNavigCenterCell);
		$this->renderTREnd ();
		$this->renderTableEnd ();
	}

	function renderNavigator ()
	{
		$attributes = array ();
		$attributes [GET_VAR_SORT_FIELD]		= $this->aQrySorting["FIELD"];
		$attributes [GET_VAR_SORT_DIRECTION]	= $this->aQrySorting["DIRECTION"];
		$attributes [GET_VAR_ROWS_TO_SHOW]      = $this->aQryLimits["ROWS"];

		if ( $this->aQryLimits["OFFSET"] != 0)
		{
			$attributes [GET_VAR_START_ROW] = 0;
			$url = $this->makeSelfUrl ($attributes);
			$first = $this->createAnchorTag($url, NAV_FIRST_IMAGE_NORMAL, "si(first, first_h)", "si(first, first_n)");
		}
		else $first = NAV_FIRST_IMAGE_DISABLED;

		if ( $this->aQryLimits["OFFSET"] != 0)
		{
			$attributes [GET_VAR_START_ROW] = $this->aQryLimits["OFFSET"] - $this->aQryLimits["ROWS"];
			if ($attributes [GET_VAR_START_ROW] < 0) $attributes [GET_VAR_START_ROW] = 0;
			$url = $this->makeSelfUrl ($attributes);
			$prev = $this->createAnchorTag($url, NAV_PREV_IMAGE_NORMAL, "si(prev, prev_h)", "si(prev, prev_n)");
		}
		else $prev = NAV_PREV_IMAGE_DISABLED;

		$cur_last_row = $this->aQryLimits["OFFSET"] +  $this->aQryLimits["ROWS"];

		if ( $this->aQryLimits["OFFSET"] != $this->nQryTotal && $this->nQryTotal > $cur_last_row )
		{
			$attributes [GET_VAR_START_ROW] = $this->aQryLimits["OFFSET"] + $this->aQryLimits["ROWS"];
			$url = $this->makeSelfUrl ($attributes);
			$next = $this->createAnchorTag($url, NAV_NEXT_IMAGE_NORMAL, "si(next, next_h)", "si(next, next_n)");
		}
		else $next = NAV_NEXT_IMAGE_DISABLED;

		if ( $this->aQryLimits["OFFSET"] != $this->nQryTotal && $this->nQryTotal > $cur_last_row )
		{
			$attributes[GET_VAR_START_ROW] = intval ($this->nQryTotal / $this->aQryLimits["ROWS"]) * $this->aQryLimits["ROWS"];
			if ($attributes[GET_VAR_START_ROW] == $this->nQryTotal)
				$attributes [GET_VAR_START_ROW] -= $this->aQryLimits["ROWS"];
			$url = $this->makeSelfUrl ($attributes);
			$last = $this->createAnchorTag($url, NAV_LAST_IMAGE_NORMAL, "si(last, last_h)", "si(last, last_n)");
		}
		else $last = NAV_LAST_IMAGE_DISABLED;

		$first_half = intval ($this->aQryLimits["OFFSET"] > 0 ? ($this->aQryLimits["OFFSET"] - 1) / $this->aQryLimits["ROWS"] + 1 : 0);
		$pBegin = $first_half;
		$tmp_var = $this->nQryTotal - $this->aQryLimits["OFFSET"];
		$sec_half = intval ($tmp_var > 0 ? ($tmp_var - 1) / $this->aQryLimits["ROWS"] + 1 : 0);
		$pEnd = $first_half + $sec_half;

		$statistics = sprintf("Page %d of %d (Total rows %d)", ++$pBegin, $pEnd, $this->nQryTotal);

		$this->renderTableBegin (&$this->sNavigAttributes);
		$this->renderTRBegin();

		$this->renderTD($first, $this->sNavigLeftCell);
		$this->renderTD($prev, $this->sNavigLeftCell);

		$this->renderTDBegin ($this->sNavigLeftCell);
		echo '<a href="javascript:onGridShowClick(\''.$this->sFormName.'\')"><img src="img/show.gif" border="0" alt=">Show"></a>';
		$this->renderTDEnd ();
		$this->renderTDBegin ($this->sNavigLeftCell);
		echo "&nbsp;";
		$this->renderTextInput ("gpRows", $this->aQryLimits["ROWS"], 4, 4);
		$this->renderTDEnd ();
		$this->renderTDBegin ($this->sNavigLeftCell." nowrap");
		echo "&nbsp;rows from&nbsp;";
		$this->renderTDEnd ();
		$this->renderTDBegin ($this->sNavigLeftCell);
		$this->renderTextInput ("gpFrom", $this->aQryLimits["OFFSET"], 4, 4);
		$this->renderHidden ("gpTotal", $this->nQryTotal);
		$vars = array ();
		$vars[GET_VAR_SORT_FIELD] = $this->aQrySorting["FIELD"];
		$vars[GET_VAR_SORT_DIRECTION] = $this->aQrySorting["DIRECTION"];
		$this->renderHidden ("gpUrl", $this->makeSelfUrl ($vars));
		$this->renderTDEnd ();

		$this->renderTD($statistics, $this->sNavigCenterCell);
		$this->renderTDBegin ($this->sNavigLeftCell." nowrap");
		echo '<a href="javascript:onGridShowAllClick(\''.$this->sFormName.'\')"><img src="img/showall.gif" border="0" alt="Show all"></a>';
		$this->renderTDEnd ();
		$this->renderTD($next, $this->sNavigRightCell);
		$this->renderTD($last, $this->sNavigRightCell);

		$this->renderTREnd();
		$this->renderTableEnd ();
	}

}

///////////////////////////////////////////////////////////////////////////////
// Grid registry structure

/* ----------------------------------------------------------------------------
GridsPath/TheGridName = "comment"
	/Table = "table name"
		/Attribures = "main table attributes"
	/Navigator
		/Attribures = "navigator table attributes"
		/LeftCell = "navigator left cell properties"
		/CenterCell = "navigator center cell properties"
		/RightCell = "navigator right cell properties"
	/Columns = count of columns
		/Default = "default titile"
			/TitleAttributes = "attributes of table title for this column"
			/BodyAttributes = "attributes of table body for this column"
		/0 = "title of this colums"
			/TitleAttributes = "attributes of table title for this column"
			/BodyAttributes = "attributes of table body for this column"
		...
		/n = "title of this colums"
			/TitleAttributes = "attributes of table title for this column"
			/BodyAttributes = "attributes of table body for this column"
	/ExtraColums = count of extra columns
		/Default = "default colums"
			/TitleAttributes = "attributes of table title for this column"
			/BodyAttributes = "attributes of table body for this column"
			/Type = "Left|Right"
		/LeftExtra = "attributes of left extra columns"
		/RightExtra = "attributes of right extra columns"
		/0
			/Type = "Left|Right"
			/TitleAttributes = "attributes of table title for this column"
			/BodyAttributes = "attributes of table body for this column"
			/TextPattern = "text patternt"
			/Variables = "VAR_1, VAR_2,...,VAR_N"
		...
		/m
			/Type = "Left|Right"
			/TitleAttributes = "attributes of table title for this column"
			/BodyAttributes = "attributes of table body for this column"
			/TextPattern = "text patternt"
			/Variables = "VAR_1, VAR_2,...,VAR_N"
	/Rows
		/0 = "Attrs of even rows"
		/1 = "Attrs of odd rows"
---------------------------------------------------------------------------- */

endif ?>