<%@page import="java.util.*,java.io.*,com.ths.csa.*,java.text.*"%><jsp:useBean id="csa" class="com.ths.csa.ClickStreamAnalyzer" scope="application"><%
    csa.initialize("C:\\xmllogs\\", System.out);
/*    csa.initialize("/home/techouse/www/xmllogs/", System.out); */
%></jsp:useBean>
<!-- Uncomment these if your ClickStream.jsp is not wrapped by another JSP
<html>
<head><title>Techouse Software CSA</title>
</head>
<body> -->
<%
/* heres the idea:
// if there are values coming in for directory names (folders[]), display the results
// if there are no values coming in for folder names, display the available folders
*/

String folders = "folders";  /* the request parameter name for the folders the user selected */
String refresh = "refresh";  /* the request parameter name for refreshing the folder list */
Vector fileVector = null;

if (request.getParameterValues(folders) == null ||
    request.getParameterValues(folders).length < 1) {
    /* show the list of available directories  */
    fileVector = csa.getFolderTree( ((request.getParameter(refresh) != null) ? true:false ));
%>
<p>Select the directories to include in the analysis.  Selecting a parent directory will automatically include all of its sub-directories.
<form action="<%= request.getRequestURI() %>" method=get>
<br>
<table border=0>
<%
    boolean flag = false;  /* when a <td> tag has been placed for a 3rd level block */
    int spacersUsedPreviously = -1;
    if (fileVector.size() < 1) { %><tr><td><i>No folders available.</i></td></tr><% }
    for (int i = 0; i < fileVector.size(); i++) {
        String displayName = ((File)fileVector.get(i)).getAbsolutePath().substring(csa.getFolderRoot().length()-1);
        int spacersUsed = 0;
        for (int j = 1; j < displayName.indexOf(System.getProperty("file.separator","\\"), j) &&
                        j > 0; j = displayName.indexOf(System.getProperty("file.separator","\\"), j) + 1) {
            spacersUsed++;
        }
        if (spacersUsed != spacersUsedPreviously ||
            spacersUsed < 2) {
            if (flag) { %></td><% flag = false; }
            %><tr><%
                for (int j = 0; j < spacersUsed; j++) {
                    %><td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td><%
                }
        }
        if (spacersUsed == 2) {
            if (!flag) {
                %><td align=left><%
                flag = true;
            }
            %><input type=checkbox name="<%= folders %>" value="<%= displayName %>"><%= displayName %>
            <%
        } else {
            %><td align=left colspan=<%= 3 - spacersUsed %>><input type=checkbox name="<%= folders %>" value="<%= displayName %>"><%= displayName %></td><%
        }
        spacersUsedPreviously = spacersUsed;
    } /* end of for each file to display */
    if (flag) { %></td><% }
%>
</table>
<p><input type=submit value="Submit">&nbsp;&nbsp;&nbsp;<input type=reset value="Reset">
</form>
<p><form action="<%= request.getRequestURI() %>" method=get>
<input type=submit name="<%= refresh %>" value="Refresh list">
</form>
<%
} else {
    /* else show the analysis page based on the selected directories */
    String[] folderNames = request.getParameterValues(folders);
    CSAResultSet results = csa.doAnalysis(folderNames);
%>
<p><table border=0>
<tr><td>Results for the following folder<%= (folderNames.length > 1) ? "s":"" %>:</td>
    <td><%
    for (int i = 0; i < folderNames.length; i++) {
        %><%= folderNames[i] %><%= (i < folderNames.length - 1) ? ", ":"" %><%
    }
    %></td></tr>
</table>
<p>
<table border=1 cellspacing=0 cellpadding=1>
<tr><td width=260>Sessions counted:</td>
    <td width=100><%= results.sessionsCounted %></td></tr>
<tr><td>Sessions dropped:</td>
    <td><%= results.sessionsDropped %></td></tr>
<tr><td>Single page view sessions:</td>
    <td><%= results.zeroLengthSessions %></td></tr>
<tr><td>Average session duration:</td>
    <td><%= CSAUtils.ConvertMinutesFractionToTimeString(results.durationAverage) %></td></tr>
<tr><td>Sessions ending by timeout:</td>
    <td><%= results.timeouts %></td></tr>
<tr><td>Sessions ending by logout:</td>
    <td><%= results.logouts %></td></tr>
<tr><td>Average concurrent sessions at login:</td>
    <td><%= new DecimalFormat("####.##").format(results.concurrentSessionsAverage) %></td></tr>
</table>
<p>
<table border=1 cellspacing=0 cellpadding=1>
<tr><td colspan=2>Logins by hour:
        <table border=0 cellspacing=7>
            <tr><th align=center>00</th>
                <th align=center>01</th>
                <th align=center>02</th>
                <th align=center>03</th>
                <th align=center>04</th>
                <th align=center>05</th>
                <th align=center>06</th>
                <th align=center>07</th>
                <th align=center>08</th>
                <th align=center>09</th>
                <th align=center>10</th>
                <th align=center>11</th>
                <th align=center>12</th>
                <th align=center>13</th>
                <th align=center>14</th>
                <th align=center>15</th>
                <th align=center>16</th>
                <th align=center>17</th>
                <th align=center>18</th>
                <th align=center>19</th>
                <th align=center>20</th>
                <th align=center>21</th>
                <th align=center>22</th>
                <th align=center>23</th></tr>
            <tr><% for (int i = 0; i < results.loginsByHour.length; i++) { %><td align=right><%= results.loginsByHour[i] %></td><% } %></tr>
        </table>
    </td>
<tr><td colspan=2>Logins by weekday:
        <table border=0 cellspacing=5>
            <tr><th align=center>Sunday (<%= results.daysOfTheWeekCounted[Calendar.SUNDAY-1] %>)</th>
                <th align=center>Monday (<%= results.daysOfTheWeekCounted[Calendar.MONDAY-1] %>)</th>
                <th align=center>Tuesday (<%= results.daysOfTheWeekCounted[Calendar.TUESDAY-1] %>)</th>
                <th align=center>Wednesday (<%= results.daysOfTheWeekCounted[Calendar.WEDNESDAY-1] %>)</th>
                <th align=center>Thursday (<%= results.daysOfTheWeekCounted[Calendar.THURSDAY-1] %>)</th>
                <th align=center>Friday (<%= results.daysOfTheWeekCounted[Calendar.FRIDAY-1] %>)</th>
                <th align=center>Saturday (<%= results.daysOfTheWeekCounted[Calendar.SATURDAY-1] %>)</th></tr>
            <tr><td align=center><%= results.loginsByDayOfTheWeek[Calendar.SUNDAY-1] %></td>
                <td align=center><%= results.loginsByDayOfTheWeek[Calendar.MONDAY-1] %></td>
                <td align=center><%= results.loginsByDayOfTheWeek[Calendar.TUESDAY-1] %></td>
                <td align=center><%= results.loginsByDayOfTheWeek[Calendar.WEDNESDAY-1] %></td>
                <td align=center><%= results.loginsByDayOfTheWeek[Calendar.THURSDAY-1] %></td>
                <td align=center><%= results.loginsByDayOfTheWeek[Calendar.FRIDAY-1] %></td>
                <td align=center><%= results.loginsByDayOfTheWeek[Calendar.SATURDAY-1] %></td></tr>
        </table>
    </td></tr>
<tr><td colspan=2>Session data summary:
        <table border=0 cellspacing=5>
            <tr><td>
            <%
                int i = 0;
                for ( ; i < results.sessionData.size(); i++) {
                    %>
                            <table border=0 cellspacing=3>
                                <tr><th align=center><%= ((CSAVector)results.sessionData.get(i)).getFieldName() %></th></tr>
                                <tr><td align=center><select size=5>
                                    <%
                                        CSAVector current = (CSAVector)results.sessionData.get(i);
                                        for (int j = 0; j < current.size(); j++) {
                                            %><option><%= current.getValueAt(j) %> (<%= current.getValueCount(j) %>)</option><%
                                        }
                                    %></select></td></tr>
                            </table>
                    <%
                }  /* end of for each CSAVector in results.sessionData */
            %>
            </td></tr>
        </table>
    </td></tr>
<tr><td colspan=2>
        Overall Page hits:
        <table border=0 cellspacing=5>
            <tr><td>
                <select size=10>
                    <%
                    for (int j = 0; j < results.pagesVisited.size(); j++) {
                        CSAPage csaPage = (CSAPage)results.pagesVisited.get(j);
                        %><option><%= csaPage.getPageName() %> (<%= csaPage.getHits() %>)</option><%
                    }
                    %>
                </select>
            </tr></td>
        </table>
    </td></tr>
<tr><td colspan=2>
        Clickstream traces:<br>
        Rows represent the page view sequence for all sessions and columns represent the 1st, 2nd, and 3rd most common page viewed 
        for each row.<br>
        <table border=0 cellspacing=5>
            <td>&nbsp;</td><th>1st Place</th><th>2nd Place</th><th>3rd Place</th></tr>
            <%
                DecimalFormat percent = new DecimalFormat("##");
                for (int j = 0; j < results.pageOrders.length; j++) {
                    CSAVector current = results.pageOrders[j];
                    %><tr><th><%= current.getFieldName() %></th><%
                    int k = 0;
                    for (; k < current.size() && k < 3; k++) {
                        CSAPage csaPage = (CSAPage) current.getValueAt(k);
                        %><td valign=top>
                            <table class="pixelborder" width="100%" height="100%">
                                <tr><td>Name:</td>
                                    <td><%= csaPage.getPageName() %></td></tr>
                                <tr><td>Hit Rate:</td>
                                    <td><%= percent.format((((double) current.getValueCount(k)) / current.getGrandTotal()) * 100) %>%</td></tr>
                                <tr><td>Avg. Duration:</td>
                                    <td><%= CSAUtils.ConvertMinutesFractionToTimeString(csaPage.getAverageDuration()) %></td></tr>
                                <%
                                    Vector pageData = csaPage.getPageData();
                                    if (pageData.size() > 0) {
                                        for (int m = 0; m < pageData.size(); m++) {
                                            CSAVector dataItem = (CSAVector) pageData.get(m);
                                            %><tr><td valign=top><%= dataItem.getFieldName() %>:</td><%
                                            %>    <td valign=top><select size=3><%
                                                for (int n = 0; n < dataItem.size(); n++) {
                                                    %><option><%= dataItem.getValueAt(n) %> (<%= dataItem.getValueCount(n) %>)</option><%
                                                }
                                            %></select></td></tr><%
                                        }
                                    }
                                %>
                            </table>
                        </td><%
                    }
                    for (; k < 3; k++) {
                        %><td>&nbsp;</td><%
                    }
                }
            %>
        </table>
    </td></tr>
<tr><td colspan=2><pre><% for (int k = 0; k < results.errorMessages.size(); k++) { %><%= results.errorMessages.get(k).toString() %><% }  %></pre></td></tr>
</table>
<%
}
%>
<!-- Uncomment these if your ClickStream.jsp isn't wrapped by another JSP
</body>
</html>
-->