<?php
// +--------------------------------------------------------------------------+
// | dbMysql version 0.0.5 - 2001/06/13                                       |
// +--------------------------------------------------------------------------+
// | Copyright (c) 2000-2001 The phpHeaven-team                               |
// +--------------------------------------------------------------------------+
// | License:  GNU/GPL - http://www.gnu.org/copyleft/gpl.html                 |
// +--------------------------------------------------------------------------+
// | Library that sets a class for accessing a mysql database with an object  |
// |                                                                          |
// | usage:    - set the parameters to be used by this libary with following  |
// |             definitions of constants:                                    |
// |                 _SHOW_ERROR_MESSAGES                                     |
// |                 _DBMYSQL_FETCH_MODE                                      |
// |           - use the class as in the following example                    |
// |                                                                          |
// | example:  require_once('dbMysql.lib.php');                               |
// |           $db = new DB('localhost', 'test', 'user', 'pass');             |
// |           $array = $db->queryAllRecords('SELECT field FROM table');      |
// |           ...                                                            |
// |                                                                          |
// | required: - PHP                                                          |
// |           - MySQL                                                        |
// |                                                                          |
// | to do:    - add loging support                                           |
// |                                                                          |
// | changes:                                                                 |
// |           version 0.0.5 - 2001/06/13                                     |
// |           - PEAR style comments                                          |
// |           - nextRecord : missing second parameter in mysql_fetch_array   |
// |           - customizable fetch mode                                      |
// |                                                                          |
// +--------------------------------------------------------------------------+
// | Last release available on phpHeaven:                                     |
// |    http://www.phpheaven.net/resources/libraries/phpSyndication/          |
// |                                                                          |
// | Author:   Nicolas Hoizey <nhoizey@phpheaven.net>                         |
// +--------------------------------------------------------------------------+

if(!defined('_LIB_DB_MYSQL_LOADED'))
{
	define('_LIB_DB_MYSQL_LOADED', true);

	/**
	 * CONFIGURATION: verbose mode for errors ?
	 *
	 * @const _SHOW_ERROR_MESSAGES
	 */
	if(!defined('_DBMYSQL_SHOW_ERROR_MESSAGES'))
		define('_DBMYSQL_SHOW_ERROR_MESSAGES', false);
	
	/**
	 * CONFIGURATION: default mode for mysql_fetch_array (see doc)
	 *
	 * @const _DBMYSQL_FETCH_MODE
	 */
	if(!defined('_DBMYSQL_FETCH_MODE'))
		define('_DBMYSQL_FETCH_MODE', MYSQL_ASSOC);
	
	class DB
	{
		var $dbHost = '';		// hostname of the MySQL server
		var $dbName = '';		// logical database name on that server
		var $dbUser = '';		// database authorized user
		var $dbPass = '';		// user's password
		var $linkId = 0;		// last result of mysql_connect()
		var $queryId = 0;		// last result of mysql_query()
		var $record	= array();	// last record fetched
		var $currentRow;		// current row number
		var $errorNumber = 0;	// last error number
		var $errorMessage = '';	// last error message
		var $errorLocation = '';// last error location

		/**
		 * Object constructor
		 *
		 * @param	string	database host name or ip
		 * @param	string	database name
		 * @param	string	user
		 * @param	string	password
		 *
		 * @access	public
		 */
		function DB($dbHost = '', $dbName = '', $dbUser = '', $dbPass = '')
		{
			$this->dbHost = $dbHost;
			$this->dbName = $dbName;
			$this->dbUser = $dbUser;
			$this->dbPass = $dbPass;
		}

		/**
		 * updateError
		 *
		 * @param	string	function where the error occured
		 *
		 * @access	private
		 */
		function updateError($location)
		{
			$this->errorNumber = mysql_errno();
			$this->errorMessage = mysql_error();
			$this->errorLocation = $location;
			if($this->errorNumber && _DBMYSQL_SHOW_ERROR_MESSAGES)
			{
				echo('<br /><b>'.$this->errorLocation.'</b><br />'.$this->errorMessage);
				flush();
			}
		}

		/**
		 * connect
		 *
		 * @return	boolean	connected ?
		 *
		 * @access	private
		 */
		function connect()
		{
			if($this->linkId == 0)
			{
				$this->linkId = mysql_connect($this->dbHost, $this->dbUser, $this->dbPass);
				if(!$this->linkId)
				{
					$this->updateError('DB::connect()<br />mysql_connect');
					return false;
				}
			}
			return true;
		}

		/**
		 * query
		 *
		 * @param	string	SQL query
		 *
		 * @return	boolean	status ?
		 *
		 * @access	public
		 */
		function query($queryString)
		{
			if(!$this->connect())
			{
				return false;
			}
			if(!mysql_select_db($this->dbName, $this->linkId))
			{
				$this->updateError('DB::connect()<br />mysql_select_db');
				return false;
			}
			$this->queryId = mysql_query($queryString, $this->linkId);
			$this->updateError('DB::query('.$queryString.')<br />mysql_query');
			if(!$this->queryId)
			{
				return false;
			}
			$this->currentRow = 0;
			return true;
		}

		// returns all records in an array
		function queryAllRecords($queryString, $fetchMode = _DBMYSQL_FETCH_MODE)
		{
			if(!$this->query($queryString))
			{
				return false;
			}
			$ret = array();
			while($line = $this->nextRecord($fetchMode))
			{
				$ret[] = $line;
			}
			return $ret;
		}

		// returns one record in an array
		function queryOneRecord($queryString, $fetchMode = _DBMYSQL_FETCH_MODE)
		{
			if(!$this->query($queryString) || $this->numRows() != 1)
			{
				return false;
			}
			return $this->nextRecord($fetchMode);
		}

		// returns the next record in an array
		function nextRecord($fetchMode = _DBMYSQL_FETCH_MODE)
		{
			$this->record = mysql_fetch_array($this->queryId, $fetchMode);
			$this->updateError('DB::nextRecord()<br />mysql_fetch_array');
			if(!$this->record || !is_array($this->record))
			{
				return false;
			}
			$this->currentRow++;
			return $this->record;
		}

		// returns number of rows returned by the last select query
		function numRows()
		{
			return mysql_num_rows($this->queryId);
		}
	}
}
?>
