<?php

/*
* Subject:  XSLT class using PHP4 Sablotron extension
* Author:   Urs Gehrig <urs@circle.ch>
* Date:     11-10-2000
* Version:  0.1
*
* URL:      http://www.circle.ch/projects/xml/
*/

class xsl_transform {

    var $xsl_file;
    var $xml_file;
    var $filename;

    // {{{ xsl_transform(), constructor of xsl_transform class

    function xsl_transform($xsl_file = '', $xml_file = ''){
        $this->xsl_string = $this->read_file($xsl_file);
        $this->xml_string = $this->read_file($xml_file);
    }

    // }}}
    // {{{ read_file()

    function read_file($filename) {
        // get contents of a file into a string
        $fd = fopen( $filename, "r" );
        $content = fread( $fd, filesize( $filename ) );
        fclose( $fd );
        return $content;
    }

    // }}}
    // {{{ apply()

    function apply() {
        $this->result = '';

        $this->msg = xslt_process($this->xsl_string, $this->xml_string, $this->result);
        if(!$this->msg) print ("Transformation failed.");
        return $this->result;
    }

    // }}}
}

$xslt = new xsl_transform("test.xsl", "test.xml");
print ($xslt->apply());

?>