<?php
/**
*  Author:      Bill Humphries <bill@whump.com>
*  Adaption:    Urs Gehrig <urs@circle.ch>
*  Example:     Justin Grant <justin@glendale.net>
*
*  PHP:         PHP4.0.3 with ext/sablot
*  Date:        4-Oct-2000
*
*  Description: This classes work now for PHP4 ext/sablot Version 4.0.3. That means
*               the official PHP sablotron version and their commands are supported.
*
*  Enjoy!
*/

class XSLTransformer {

    var $xsl;
    var $xml;
    var $output;
    var $error;

    /* Constructor */
    function XSLTransformer() {
        $this->processor = @xslt_create();
    }

    /* Destructor */
    function destroy() {
        @xslt_free($this->processor);
    }

    /* output methods */
    function setOutput($string) {
        $this->output = $string;
    }

    function getOutput() {
        return $this->output;
    }

    /* set methods */
    function setXml($uri) {
        if($doc = new docReader($uri)) {
            $this->xml    = $doc->getString();
            return true;
        } else {
            $this->setError("Could not open $uri");
            return false;
        }
    }

    function setXslString($xsl) {
        $this->xsl = $xsl;
        return true;
    }

    function setXmlString($xml) {
        $this->xml = $xml;
        return true;
    }

    function setParameterArray($paramarray) {
        while (list($param, $value) = each($paramarray))
            $this->parms[$param] = $value;
    }

    function setXsl($uri) {
        if($doc = new docReader($uri))
        {
            $this->xsl    = $doc->getString();
            return true;
        } else {
            $this->setError("Could not open $uri");
            return false;
        }
    }

    /* transform method */
    function transform() {
        xslt_process($this->xsl, $this->xml, $outcome,$this->parms);
        $this->setOutput($outcome);
    }

    /* Error Handling */
    function setError($string) {
        $this->error = $string;
    }

    function getError() {
        return $this->error;
    }

}


/* docReader -- read a file or URL as a string */
class docReader {

    var $string;       // public string representation of file
    var $type;         // private URI type: 'file','url'
    var $bignum        = 1000000;

    /* public constructor */
    function docReader($uri) {  // returns integer

        $this->setUri($uri);
        $this->setType();

        $fp = fopen($this->getUri(),"r");

        if($fp) {
             // get length
            if ($this->getType() == 'file') {
                $length = filesize($this->getUri());
            } else {
                $length = $this->bignum;
            }

            $this->setString(fread($fp,$length));
            return 1;
        } else {
            return 0;
        }
    }


    /* determine if a URI is a filename or URL */

    function isFile($uri) {     // returns boolean

        if (strstr($uri,'http://') == $uri) {
            return false;
        } else {
            return true;
        }
    }

    /* set and get methods */
    function setUri($string) {
        $this->uri = $string;
    }

    function getUri() {
        return $this->uri;
    }

    function setString($string) {
        $this->string = $string;
    }

    function getString() {
        return $this->string;
    }

    function setType() {
        if ($this->isFile($this->uri)) {
            $this->type = 'file';
        } else {
            $this->type = 'url';
        }
    }

    function getType() {
        return $this->type;
    }

}

?>