// vtswitcher
// Copyright April 11th 1999 Toby Jaffey.

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <stdio.h>

void handle_buttons(GtkWidget *w, gpointer d);
GtkWidget *addButton(GtkWidget *vbox,GtkWidget *window,char *label,int show,GtkSignalFunc func,gpointer data);
GtkWidget *createDrawWindow(int xsize,int ysize,int xoff,int yoff);
GtkWidget *createHBox(GtkWidget *window);
void quit(GtkWidget *w);


int main(int argc, char *argv[])
{
GtkWidget *window,*hbox;
int i;

gtk_init(&argc, &argv);

window = createDrawWindow(100,100,10,10);
hbox = createHBox(window);


for (i=1;i<argc;i++)
addButton(hbox,window,argv[i],1,GTK_SIGNAL_FUNC(handle_buttons),(gpointer)g_strdup(argv[i]));

gtk_widget_show(window);
gtk_main();

return 0;
} // end main

void handle_buttons(GtkWidget *w,gpointer d)
{
printf("%s\n",(char *)d);
fflush(stdout);
} // end handle button presses


GtkWidget *addButton(GtkWidget *vbox,GtkWidget *window,char *label,int show,GtkSignalFunc func,gpointer data)
{
GtkWidget *button;
button = gtk_button_new_with_label(label);
gtk_box_pack_start(GTK_BOX(vbox),button,TRUE,TRUE,0);
gtk_signal_connect(GTK_OBJECT(button),"clicked",GTK_SIGNAL_FUNC(func),data);
if (show) gtk_widget_show(button);
return button;
} // end add a button to the vbox


GtkWidget *createDrawWindow(int xsize,int ysize,int xoff,int yoff)
{
GtkWidget *window;  
window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
gtk_window_set_policy((GtkWindow *)window,0,0,1);
gtk_widget_set_uposition(window,xoff,yoff);
gtk_window_set_title((GtkWindow *)window,"quickbutton");
gtk_signal_connect(GTK_OBJECT(window),"destroy",GTK_SIGNAL_FUNC (quit), NULL);
return window;
} // end create window to draw in.


GtkWidget *createHBox(GtkWidget *window)
{
GtkWidget *hbox;
hbox = gtk_hbox_new(FALSE, 1);
gtk_container_add(GTK_CONTAINER(window),hbox);
gtk_widget_show(hbox);
return hbox;
} // end create hbox for packing


void quit(GtkWidget *w)
{
gtk_widget_hide(w);
gtk_exit(0);
} // end prog
