/////////////////// Plug-in file for CalendarXP 7.0 /////////////////
// This file is totally configurable. You may remove all the comments in this file to shrink the download size.
/////////////////////////////////////////////////////////////////////

///////////// Calendar Onchange Handler ////////////////////////////
// It's triggered whenever the calendar gets changed.
// d = 0 means the calendar is about to switch to the month of (y,m); 
// d > 0 means a specific date [y,m,d] is about to be selected.
// Return a true value will cancel the change action.
// NOTE: DO NOT define this handler unless you really need to use it.
////////////////////////////////////////////////////////////////////
function fOnChange(y,m,d) {
	fSync(y,m,d);
	return false;  // return true to cancel the change.
}



///////////// Calendar AfterSelected Handler ///////////////////////
// It's triggered whenever a date gets fully selected.
// The selected date is passed in as y(ear),m(onth),d(ay)
// NOTE: DO NOT define this handler unless you really need to use it.
////////////////////////////////////////////////////////////////////
// function fAfterSelected(y,m,d) {}


///////////// Calendar Cell OnDrag Handler ///////////////////////
// It triggered when you try to drag a calendar cell. (y,m,d) is the cell date. 
// aStat = 0 means a mousedown is detected (dragstart)
// aStat = 1 means a mouseover between dragstart and dragend is detected (dragover)
// aStat = 2 means a mouseup is detected (dragend)
// Return true to skip the set date action, if any.
// NOTE: DO NOT define this handler unless you really need to use it.
////////////////////////////////////////////////////////////////////
// function fOnDrag(y,m,d,aStat) {}


// ====== Following are self-defined and/or custom-built functions! =======
gbShareAgenda=true;		// enable agenda sharing.
gsCalTitle="gMonths[gCurMonth[1]-1]";	// reset title to use full month name
giShowOther=2+4+8;	// hide days in other months
giDCStyle=2;	// hide month navigators


// indicates how many calendars need to be synchronized, their engine-context-names must end with "_1", "_2" and so on
var _calendars4sync=12;	// MUST be specified to exact number of your calendars, or you will get errors.

function fSync(y,m,d) {
	if (d>0&&gdSelect[0]==y&&gdSelect[1]==m) return false;	// no need to update others

	var cn=gTheme[3].split("_");	// get current context id
	var no=parseInt(cn[1]),ctx;
	var r=fCalibrate(1,no+gdSelect[1]-m)[1]; // find the one needs refreshing
	for (var n=1; n<=_calendars4sync; n++)
		if (n!=no) {
			ctx=eval("gContainer."+cn[0]+"_"+n);
			if (d>0) ctx.fUpdSelect(y,m,d);
			if (y!=gCurMonth[0]||m!=gCurMonth[1]||n==r&&gdSelect[1]!=0) ctx.fSetCal(y,m+n-no,0,false);
		}
}

