/////////////////// Plug-in file for CalendarXP 7.0 /////////////////
// This file is totally configurable. You may remove all the comments in this file to shrink the download size.
/////////////////////////////////////////////////////////////////////

///////////// Calendar Onchange Handler ////////////////////////////
// It's triggered whenever the calendar gets changed.
// d = 0 means the calendar is about to switch to the month of (y,m); 
// d > 0 means a specific date [y,m,d] is about to be selected.
// Return a true value will cancel the change action.
// NOTE: DO NOT define this handler unless you really need to use it.
////////////////////////////////////////////////////////////////////
function fOnChange(y,m,d) {
	if (d==0) return false; // ignore month change

	var bRangeClick=fCheckKeyPressed(ALT);	// or use CTRL or SHIFT if you like
	if (fIsSelectedDate(y,m,d)) {
		fRemoveRange(y,m,d,bRangeClick||gEvent.button==2||gEvent.which==3);
	} else
		fAddRange(y,m,d,bRangeClick);
	
	if (m!=gCurMonth[1]&&[y,m,d]+''!=gToday+'') { // cancel the auto month switching
		fRepaint();
		return true;
	}
	
	return false;  // return true to cancel the change.
}


///////////// Calendar AfterSelected Handler ///////////////////////
// It's triggered whenever a date gets fully selected.
// The selected date is passed in as y(ear),m(onth),d(ay)
// NOTE: DO NOT define this handler unless you really need to use it.
////////////////////////////////////////////////////////////////////
// function fAfterSelected(y,m,d) {}


///////////// Calendar Cell OnDrag Handler ///////////////////////
// It triggered when you try to drag a calendar cell. (y,m,d) is the cell date. 
// aStat = 0 means a mousedown is detected (dragstart)
// aStat = 1 means a mouseover between dragstart and dragend is detected (dragover)
// aStat = 2 means a mouseup is detected (dragend)
// Return true to skip the set date action, if any.
// NOTE: DO NOT define this handler unless you really need to use it.
////////////////////////////////////////////////////////////////////
function fOnDrag(y,m,d,aStat) {
	if (aStat!=1) return;	// only handle dragover here

	var ag=fGetAgenda(y,m,d,true);
	if (ag==null||ag[1]==null) return;	// only allow dragging on selectable date
	if (ag[0]!=_gs)
		fAddRange(y,m,d,true);

	fRepaint();
}

// ====== Following are self-defined and/or custom-built functions! =======
// Override to disable the default MarkSelect effect
giMarkSelected=0;	// no default select effect
giShowOther=1+2;	// allow selected to show up in other months
// set giShowOther=4+8+16 will inhibit selection from spanning across to other months


// ======= the following plugin is coded for the multi-select plugin ========
// If you define a fAddListItem(strDate) and a fRemoveListItem(strDate) in the 
// container page, they will be called when dates are adding and removing from
// the range. In this way you may make use of them to populate the listbox on
// your page.
// The format of param strDate can be modified in fDateString() function
// ------------------------------------------------------------------------
var _gs="Selected";	// Selected message
var _gc="#fffacd";	// Selected color
// please also make sure you've prepended the following line to fHoliday() function in agenda.js
// --->	if (fIsSelectedDate&&fIsSelectedDate(y,m,d)) return [_gs,"",_gc];	

var _pds=[];	// current selected date periods. It's a 2-d array comprosing pairs of date objects.
var _lastSelect=null;
var ALT=1, CTRL=2, SHIFT=4;

function fDateString(y,m,d) {
	return y+"/"+fPad0(m)+"/"+fPad0(d);
}

function fPad0(n) {
	return n<10?"0"+n:n;
}

function fIsSelectedDate(y,m,d) {
	if (_pds.length==0) return false;
	var dt=Date.UTC(y,m-1,d,0,0,0);
	for (var i=0; i<_pds.length; i++)
		if (_pds[i][0]<=dt&&dt<=_pds[i][1]) return true;
	return false;
}

function fCheckKeyPressed(key) {
	var pr=false;
	if (key==ALT) pr=NN4?gEvent.modifiers&1:gEvent.altKey;
	else if (key==CTRL) pr=NN4?gEvent.modifiers&2:gEvent.ctrlKey;
	else if (key==SHIFT) pr=NN4?gEvent.modifiers&4:gEvent.shiftKey;
	return pr;
}

function fAddDate(y,m,d) {
	var hd=fHoliday(y,m,d);
	if (hd&&(hd[0]==_gs||hd[1]==null)) return;
	if (gContainer.fAddListItem) gContainer.fAddListItem(fDateString(y,m,d));
}

function fRemoveDate(y,m,d) {
	if (gContainer.fRemoveListItem) gContainer.fRemoveListItem(fDateString(y,m,d));
}

function fAddRange(y,m,d,bBatch) {
	var dt=Date.UTC(y,m-1,d,0,0,0);
	if (_lastSelect==null||!bBatch) {
		fAddDate(y,m,d);
		_lastSelect=[dt,dt];
		_pds.push([dt,dt]);
	} else {
		var pd=_lastSelect;
		_lastSelect=[dt,dt];

		if (dt<pd[0]) pd[0]=dt;
		else if (pd[1]<dt) pd[1]=dt;
		for (var i=pd[0];i<=pd[1];i+=MILLIDAY) {
			var di=new Date(i);
			fAddDate(di.getUTCFullYear(),di.getUTCMonth()+1,di.getUTCDate());
		}
		_pds.push(pd);
	}
	fMergePDS();
}

function fSort(a,b) {
	return a[0]<b[0]?-1:a[0]>b[0]?1:0;
}

function fMergePDS() {
	if (_pds.length<=1) return;
	_pds.sort(fSort);
	var tmpd=[_pds[0]];
	for (var i=0,j=1; j<_pds.length; j++)
		if (tmpd[i][1]<_pds[j][0]-MILLIDAY) {
			i=tmpd.length;
			tmpd[i]=_pds[j];
		} else
			tmpd[i][1]=Math.max(tmpd[i][1],_pds[j][1]);
	_pds=tmpd;
}

function fRemoveRange(y,m,d,bBatch) {
	var dt=Date.UTC(y,m-1,d,0,0,0);
	for (var i=0; i<_pds.length; i++)
		if (_pds[i][0]<=dt&&_pds[i][1]>=dt) break;
	if (bBatch||_pds[i][0]==_pds[i][1]) {
		for (var k=_pds[i][0];k<=_pds[i][1];k+=MILLIDAY) {
			var dk=new Date(k);
			fRemoveDate(dk.getUTCFullYear(),dk.getUTCMonth()+1,dk.getUTCDate());
		}
		fSplice(_pds,i);
	} else {
		fRemoveDate(y,m,d);
		if (dt<_pds[i][1]) _pds.push([dt+MILLIDAY,_pds[i][1]]);
		if (_pds[i][0]<dt) _pds[i][1]=dt-MILLIDAY;
		else fSplice(_pds,i);
	}
	_lastSelect=null;
}

function fClearAll() {
	for (var i=_pds.length-1; i>=0; i--) {
		var d=new Date(_pds[i][0]);
		fRemoveRange(d.getUTCFullYear(),d.getUTCMonth()+1,d.getUTCDate(),true);
	}
}

function fSplice(arr,n) { // made for IE5, push() had already been implemented in the engine
	for (var i=n; i<arr.length-1; i++) arr[i]=arr[i+1];
	arr[i]=null;
	arr.length--;
}

// ======= end of multi-select plugin ========
