// Common.js

// Written by Martin Krolik (martin@krolikconsulting.com)
// June 2001 
// Copyright  2001 Regents of the University of California. All rights reserved. 

// This is a common javascript library that is used throughtout the application.
// It includes generic functions that can be applied to almost any application.


// client side browser type detection
function GetBrowser() 
{
	if (document.layers)
		return "NS4";  
	else if (document.all)
		return "IE";  
	else if (document.getElementById)
		return "NS6";  //dom standardized?
	else
		return "UNKNOWN";
}

function AltToStatus()
{
	// this function works only in IE
	
	var el = document.all.tags("A");
	for ( var n = 0; n < el.length; n++ )
	{
		el.item(n).onmouseout = function anonymous() { return window.status = ''; };
		el.item(n).onmouseover = function anonymous() { return window.status = window.event.srcElement.title; };
	}
}

function ValidateInteger(checkStr, bAllowNeg)
{
	return ValidateNumber(checkStr, bAllowNeg, false, null, null)
}

function ValidateDecimal(checkStr, bAllowNeg)
{
	return ValidateNumber(checkStr, bAllowNeg, true, null, null)
}

function ValidateNumber(vTxt, bAllowNeg, bAllowDec, minVal, maxVal)
{
	var checkOK = "0123456789";
	var allValid = true;
	var decPoints = 0;
	var	bFound;
	var checkStr = vTxt;

	if ( checkStr.length == 0 ) return true;
	
	if ( bAllowNeg ) checkOK += "-";
	if ( bAllowDec ) checkOK += ".";
	
	for ( var i = 0;  i < checkStr.length;  i++ )
	{
		ch = checkStr.charAt(i);

		bFound = false;
		for ( var j = 0;  j < checkOK.length;  j++ )
			if ( ch == checkOK.charAt(j) )
			{
				bFound = true;
				break;
			}

		if ( !bFound )
		{
			allValid = false;
			break;
		}

		if ( ch == "." ) decPoints++;

		if ( ch == "-" )
			if ( i != 0 && j != checkStr.length - 1 )
				allValid = false;
	}

	if ( !allValid ) return false;
	if ( decPoints > 1 ) return false;
	if ( minVal != null && checkStr < minVal ) return false;
	if ( maxVal != null && checkStr > maxVal ) return false;
	
	return true;
}

function ValidateDate(checkStr)
{
	var checkOK = "0123456789/";
	var allValid = true;
	var decSlash = 0;
	var aStr;
	var nDay, nMonth, nYear;

	for ( i = 0;  i < checkStr.length;  i++ )
	{
		ch = checkStr.charAt(i);

		// Is character a number?
		for ( j = 0;  j < checkOK.length;  j++ )
			if ( ch == checkOK.charAt(j) )
				break;

		if ( j == checkOK.length )
		{
			// Bad character (non-numeric) found
			allValid = false;
			break;
		}

		if ( ch == "/" )
			decSlash++;
	}

	if ( !allValid ) return false;

	if ( decSlash != 2 ) return false;

	aStr = checkStr.split("/");
	
	nMonth = aStr[0];
	nDay = aStr[1];
	nYear = aStr[2];
	alert(nYear);
	if ( nMonth < 1 || nMonth > 12) return false;
	if ( nDay < 1 || nDay > 31) return false;
	if ( nYear < 0 || (nYear > 99 && nYear < 1900) || nYear > 5000) return false;  // I won't be around to fix this Y5K bug.

	if ( ( nMonth == 4 || nMonth == 6 || nMonth == 9 || nMonth == 11 ) && nDay == 31 ) return false;

	if ( nMonth == 2 )
	{
		if ( nDay > 29 ) return false;
		if ( nDay == 29 && (nYear / 4) != parseInt(nYear / 4) ) return false;
	}

	return false;
}

// validateDate is a modified version of:
// Original:  Mike Welagen (welagenm@hotmail.com)
// The JavaScript Source!! http://javascript.internet.com
function validateDate (objName, blnReformat) {
   var strDateArray;
   var strDay;
   var strMonth;
   var strYear;
   var intday;
   var intMonth;
   var intYear;
   var booFound = false;
   var datefield = objName;
   var strDate = datefield.value;
   var strSeparatorArray = new Array("-"," ","/",".");
   var intElementNr;
   var err = 0;
   var strMonthArray = new Array(12);
      strMonthArray[0] = "Jan";
      strMonthArray[1] = "Feb";
      strMonthArray[2] = "Mar";
      strMonthArray[3] = "Apr";
      strMonthArray[4] = "May";
      strMonthArray[5] = "Jun";
      strMonthArray[6] = "Jul";
      strMonthArray[7] = "Aug";
      strMonthArray[8] = "Sep";
      strMonthArray[9] = "Oct";
      strMonthArray[10] = "Nov";
      strMonthArray[11] = "Dec";
   // debug
   for (intElementNr = 0; intElementNr < strSeparatorArray.length; intElementNr++) {
      if (strDate.indexOf(strSeparatorArray[intElementNr]) != -1) {
         strDateArray = strDate.split(strSeparatorArray[intElementNr]);
         if (strDateArray.length != 3) {
            err = 0;
            return false;
         }
         else {
            strMonth = strDateArray[0];
            strDay = strDateArray[1];          
            strYear = strDateArray[2];
         }
         booFound = true;
      }
   }
   
   if (booFound == false) {
      if (strDate.length > 5) {
         strMonth = strDate.substr(0, 2);
         strDay = strDate.substr(2, 2);
         strYear = strDate.substr(4);
      }
      else if (strDate.length == 4) {
         strMonth = strDate.substr(0, 1);
         strDay = strDate.substr(1, 1);
         strYear = strDate.substr(2);
      }
      else {err = 1; return false;}
   }
   if (strYear.length == 2) {
      if (strYear >= 35) {
		strYear = '19' + strYear;
		}
		else
		{
		strYear = '20' + strYear;
		}
   }
   
   intday = parseInt(strDay, 10);
   if (isNaN(intday)) {
      err = 2;
      return false;
   }
   
   intMonth = parseInt(strMonth, 10);
   if (isNaN(intMonth)) {
      for (i = 0;i<12;i++) {
         if (strMonth.toUpperCase() == strMonthArray[i].toUpperCase()) {
            intMonth = i+1;
            strMonth = strMonthArray[i];
            i = 12;
         }
      }
      if (isNaN(intMonth)) {
         err = 3;
         return false;
      }
   }
   intYear = parseInt(strYear, 10);
   if (isNaN(intYear)) {
      err = 4;
      return false;
   }
   else if (intYear < 10) {
      err = 4.3;
      return false;
   }
   else if (intYear>=100 && intYear<1000) {
      err = 4.7;
      return false;
   }
   else if (intYear>3000) {
      err = 4.8;
      return false;
   }
   
   if (intMonth>12 || intMonth<1) {
      err = 5;
      return false;
   }
   if ((intMonth == 1 || intMonth == 3 || intMonth == 5 || intMonth == 7 || intMonth == 8 || intMonth == 10 || intMonth == 12) && (intday > 31 || intday < 1)) {
      err = 6;
      return false;
   }
   if ((intMonth == 4 || intMonth == 6 || intMonth == 9 || intMonth == 11) && (intday > 30 || intday < 1)) {
      err = 7;
      return false;
   }
   if (intMonth == 2) {
      if (intday < 1) {
         err = 8;
         return false;
      }
      if (LeapYear(intYear) == true) {
         if (intday > 29) {
         err = 9;
         return false;
         }
      }
      else {
         if (intday > 28) {
            err = 10;
            return false;
         }
      }
   }
	if (blnReformat == true)
	{
		datefield.value = intMonth + "/" + intday + "/" + strYear;
	}
   return true;
}


function LeapYear(intYear) 
{
// True if the given year is a leap year
   if (intYear % 100 == 0) {
      if (intYear % 400 == 0) { return true; }
   }
   else {
      if ((intYear % 4) == 0) { return true; }
   }
   return false;
}

function trim(val)
{
	// remove leading spaces
	val = val.replace(/^\s+/, "");
	// remove trailing spaces
	val = val.replace(/\s+$/, "");
	
	return val;
}
 
function RightClickInit ()
	{
	if (GetBrowser() == "NS4")
		{
		document.captureEvents(Event.MOUSEDOWN);
		}
	document.oncontextmenu = CancelContextMenu;		
	document.onmousedown = DisallowRightClick;
	}
	

function CancelContextMenu(evt)
	{
	if (GetBrowser() == "IE")
	{
		window.event.returnValue = false;
		window.event.cancelBubble = true;
	}
	return false;
	}
 
function DisallowRightClick(evt)
 {
	var disallow = false;
	if (navigator.appName == "Netscape") 
		{
		if (evt.which == 3) 
			{
			disallow = true;
			}
		}
	else
		{
		if (window.event.button == 2)
			{
				disallow = true;
			}
		}
	if (disallow == true)
		{
			alert( "Right Clicking has been disabled in this window."  );
			return false;
		}
 }
 
 
function CheckTop() 
{
	if (window != window.top ) 
		{
		window.top.location.href = location.href;
		}	
}

function SelectOptionValue(selectElement, vSelectValue)
{
	// this selects the first record only!!		
	for (var n = 0; n < selectElement.options.length; n ++)
	{
		if (selectElement.options[n].value == vSelectValue)
		{
			selectElement.options[n].selected = true;
			break;
		}
	}
}

function SelectOptionText(selectElement, vSelectText)
{
	// this selects the first record only!!	
	for (var n = 0; n < selectElement.options.length; n ++)
	{
		if (selectElement.options[n].text == vSelectText)
		{
			selectElement.options[n].selected = true;
			break;
		}
	}
}

function SelectOptionIndex(selectElement, vSelectIndex)
{
	
	if (isNaN(vSelectIndex) == false)
		{
		if (selectElement != null) 
			{
			if (selectElement.options != null) 
				{
				selectElement.selectedIndex=-1;
				if (selectElement.options.length != null) 
					{
					if (selectElement.options.length > vSelectIndex) 
						{
						selectElement.options[vSelectIndex].selected = true;
						}
					}
				} 
			}
		}
}


function UnSelectAnyOptions(selectElement)
{
	// this unselects any records
	for (var n = 0; n < selectElement.options.length; n ++)
	{
		selectElement.options[n].selected = false;
	}
	
	if (selectElement.options.length > 0)  // this is for NS4 on X-Windows
	{
		selectElement.options[0].selected = true;
		selectElement.options[0].selected = false;
	}
	selectElement.value = null;
}

function RemoveAllOptions(selectElement)
{
	// this removes all options from a dropdown
	for (var n = (selectElement.options.length - 1); n >= 0; n --)
	{
		if (navigator.appName == "Netscape") 
		{
			selectElement.options[n] = null;
		}
		else
		{
			selectElement.options.remove(n);
		}
	}
}

function PopulateOptions(selectElement, arrSource, intTextField, intValueField)
{
	// this adds options from an array to a dropdown
	RemoveAllOptions(selectElement);
	for (var n = 0; n < arrSource.length; n ++)
	{
		if (navigator.appName == "Netscape") 
		{
			selectElement.options[n] = new Option(arrSource[n][intTextField],arrSource[n][intValueField],false,false);
		}
		else
		{
			var newElem = document.createElement("OPTION")
			newElem.text = arrSource[n][intTextField];
			newElem.value = arrSource[n][intValueField];
			selectElement.options.add(newElem);
		}
	}
	UnSelectAnyOptions(selectElement);
}


function DisableTextBox(evt)
{
	if (navigator.appName == "Netscape") 
	{
		evt.target.blur();
	}
	return false;
}

function EraseDateMask(evt)
{
	if (navigator.appName == "Netscape") 
	{
		if (evt.target.value == "MM/DD/YYYY")
		{
			evt.target.value = "";
		}
	}
	else
	{
		if (event.srcElement.value == "MM/DD/YYYY")
		{
			event.srcElement.value = "";
		}
	}
	return false;
}

function ShowDiv(divName)
{
	var elem;
	if (navigator.appName == "Netscape") 
	{
		elem = eval("document." + divName);
		if (elem != null)
			elem.visibility = "show"
	}
	else
	{
		elem = eval(divName);
		if (elem != null)
			elem.style.visibility = "visible"
	}
	
}

function HideDiv(divName)
{
	var elem;
	if (navigator.appName == "Netscape") 
	{
		elem = eval("document." + divName);
		if (elem != null)
			elem.visibility = "hide"
	}
	else
	{
		elem = eval(divName);
		if (elem != null)
			elem.style.visibility = "hidden"
	}
	
}

function OpenWindow(vURL, vName, vWidth, vHeigth)
{
	var myWindow
	myWindow = window.open(vURL,vName,"height=" + vHeigth + ",width=" + vWidth + ",status=no,toolbar=no,menubar=no,location=no,titlebar=no,resizable=yes,scrollbars=yes,screenX=400,screenY=400");	
	return myWindow;
}

function OpenWindowNR(vURL, vName, vWidth, vHeigth)
{
	
	window.open(vURL,vName,"height=" + vHeigth + ",width=" + vWidth + ",status=no,toolbar=no,menubar=no,location=no,titlebar=no,resizable=yes,scrollbars=yes");	
	
}

var ModalWindow;

function OpenModalWindow(vURL, vWidth, vHeigth)
{
	if (navigator.appName == "Netscape")
	{
		ModalWindow = window.open(vURL,"NSModalWindow","height=" + vHeigth + ",width=" + vWidth + ",status=no,toolbar=no,menubar=no,location=no,titlebar=no");
		ModalWindow.focus();
		window.onfocus = CheckModalStillOpen;
	}
	else 
	{
		ModalWindow = window.showModalDialog(vURL,null,"dialogHeigth:" + vHeigth + "px; dialogWidth:" + vWidth + "px; center:yes");
	}
}

function CheckModalStillOpen(evnt)
{
	if ((ModalWindow == null) || (ModalWindow.closed == true))
	{
		window.onfocus = null;
	}
	else
	{
		if (ModalWindow != null)
		{
			ModalWindow.focus();
		}
	}
}

function SubmitTo(vForm, vNewAction)
{
	vForm.action = vNewAction;
	vForm.submit();
}


function layerWrite(id,nestref,text) {
	var vBrowser = GetBrowser();
	if (vBrowser == 'NS4') {
		var lyr = (nestref)? eval('document.' + nestref + '.document.' + id + '.document') : document.layers[id].document ;
		lyr.open();
		lyr.write(text);
		lyr.close();
	}
	else if (vBrowser == 'IE') { 
		document.all[id].innerHTML = text;
	} 
	else {
		document.getElementById(id).innerHTML = text;
	}
}

function GetWindowWidth()
{
	var vBrowser = GetBrowser();
	if (vBrowser == 'IE') {
		return document.body.offsetWidth;
	}
	else {
		return innerWidth;
	}
}

function GetWindowHeight()
{
	var vBrowser = GetBrowser();
	if (vBrowser == 'IE') {
		return document.body.offsetHeight;
	}
	else {
		return innerHeight;
	}
}

function ChangeCheckboxFamily(form, familyName, newValue)
{
	for (var i=0;i<form.elements.length;i++)
		{
		var e = form.elements[i];
		if (e.name.indexOf(familyName,0) == 0)
			e.checked = newValue;
		}
}

function validEmail(email) 
{
	//var isEmail = email.match(/^\w+@\w+\.(((com|net|org|edu|gov|mil|[a-z]{2})$)|(((com|net|org|edu|gov|mil)\.[a-z]{2})$))/);

var isEmail = email.match(/\b(^(\S+@).+((\.com)|(\.net)|(\.edu)|(\.mil)|(\.gov)|(\.org)|(\..{2,2}))$)\b/gi);
	if (isEmail == null) 
	{
		return false;
	}
	else
	{
		return true;
	}
}

function DelayClose()
{
	window.setTimeout("window.close()",2000)
}

function GetSelectedValue(selectElement)
{
	if (selectElement.selectedIndex < 0)
	{
		return null;
	}
	else
	{
		return selectElement.options[selectElement.selectedIndex].value;
	
	}
}

function GetSelectedText(selectElement)
{
	if (selectElement.selectedIndex < 0)
	{
		return null;
	}
	else
	{
		return selectElement.options[selectElement.selectedIndex].text;
	
	}
}

function GetSelectedOption(selectElement)
{
	if (selectElement.selectedIndex < 0)
	{
		return null;
	}
	else
	{
		return selectElement.options[selectElement.selectedIndex];
	
	}
}

function IEConfirm(vConfMessage)
{
	var vReply = window.showModalDialog("IEConfirm.asp?Question=" + escape(vConfMessage), '' , "dialogWidth:300px; dialogHeight=160px; center:yes edge:raised; status:no;");
	return vReply;
}

function FixedLengthNumber(vNumber, vLength)
{
	// Prepends an integer with zeros so that the resulting string is of a minumum length
	var vTemp;
	var strNumber;
	var n;
	strNumber = new String(vNumber);
	if (strNumber.length < vLength)
		{
		vTemp = "";
		for (n=1; n <= (vLength - strNumber.length); n++)
			{
			vTemp = vTemp + "0";
			}
		vTemp = vTemp + strNumber;
		} else {
		vTemp = strNumber;
		}
	return (vTemp);
}

function IIf(vCond, vPos, vNeg)
{
	if (vCond)
	{
		return (vPos);
	} else {
		return (vNeg);
	}
}

function getCookie(name)
{ 
	var arg = name + "="; 
	var alen = arg.length; 
	var clen = document.cookie.length; 
	var i = 0; 
	while (i < clen) { 
	var j = i + alen; 
	
	if (document.cookie.substring(i, j) == arg) 
	return getCookieVal (j); 
	i = document.cookie.indexOf(" ", i) + 1; 
	if (i == 0) 
	break; 
	} 
	return null; 
}

function getCookieVal (offset) 
{ 
	var endstr = document.cookie.indexOf (";", offset); 
	if (endstr == -1) 
	endstr = document.cookie.length; 
	return unescape(document.cookie.substring(offset, endstr)); 
} 

function setCookie(NameOfCookie, value, expiredays) 
{
	var ExpireDate = new Date ();

	ExpireDate.setTime(ExpireDate.getTime() + (expiredays * 24 * 3600 * 1000));
	document.cookie = NameOfCookie + "=" + escape(value) + ((expiredays == null) ? "" : "; expires=" + ExpireDate.toGMTString());
}
