#
# Schma des tables de WAnewsletter 2.1pre
# pour MySQL
#
# 30 octobre 2002 - Bobe
#

#
# Structure de la table "wa_abonnes"
#
CREATE TABLE wa_abonnes (
  id MEDIUMINT(8) UNSIGNED NOT NULL auto_increment, 
  email VARCHAR(255) NOT NULL, 
  code VARCHAR(16) NOT NULL, 
  date INT(11) NOT NULL, 
  format TINYINT(1) NOT NULL default '1', 
  liste_id TINYINT(3) NOT NULL, 
  actif TINYINT(1) NOT NULL, 
  send TINYINT(1) NOT NULL default '0', 
  PRIMARY KEY (id), 
  KEY id (id)
) TYPE=MyISAM;


#
# Structure de la table "wa_admin"
#
CREATE TABLE wa_admin (
  admin_id TINYINT(3) NOT NULL auto_increment, 
  user VARCHAR(50) NOT NULL, 
  passwd VARCHAR(32) NOT NULL, 
  email VARCHAR(255) NOT NULL, 
  level TINYINT(1) NOT NULL default '1', 
  PRIMARY KEY (admin_id)
) TYPE=MyISAM;


#
# Structure de la table "wa_auth_admin"
#
CREATE TABLE wa_auth_admin (
  admin_id tinyint(3) NOT NULL default '0',
  liste_id tinyint(3) NOT NULL default '0',
  auth_view tinyint(1) NOT NULL default '0',
  auth_edit tinyint(1) NOT NULL default '0',
  auth_del tinyint(1) NOT NULL default '0',
  auth_send tinyint(1) NOT NULL default '0',
  auth_import tinyint(1) NOT NULL default '0',
  auth_export tinyint(1) NOT NULL default '0'
) TYPE=MyISAM;


#
# Structure de la table "wa_ban_list"
#
CREATE TABLE wa_ban_list (
  ban_id smallint(5) unsigned NOT NULL auto_increment,
  liste_id tinyint(3) NOT NULL default '0',
  ban_email varchar(250) NOT NULL default '',
  PRIMARY KEY  (ban_id)
) TYPE=MyISAM;


#
# Structure de la table "wa_config"
#
CREATE TABLE wa_config (
  nom VARCHAR(255) NOT NULL default '', 
  valeur VARCHAR(255) NOT NULL default ''
) TYPE=MyISAM;


#
# Structure de la table "wa_liste"
#
CREATE TABLE wa_liste (
  liste_id TINYINT(3) NOT NULL auto_increment, 
  nom VARCHAR(100) NOT NULL, 
  choix_format TINYINT(1) NOT NULL default '1', 
  email_confirm TINYINT(1) NOT NULL default '0', 
  limitevalidate TINYINT(3) NOT NULL default '3', 
  form_url VARCHAR(255) NOT NULL, 
  email_new_inscrit TINYINT(1) NOT NULL default '0', 
  PRIMARY KEY (liste_id)
) TYPE=MyISAM;


#
# Structure de la table "wa_log"
#
CREATE TABLE wa_log (
  log_id SMALLINT(5) UNSIGNED NOT NULL auto_increment, 
  liste_id TINYINT(3) NOT NULL, 
  sujet VARCHAR(100) NOT NULL, 
  body_html MEDIUMTEXT NOT NULL, 
  body_text MEDIUMTEXT NOT NULL, 
  date INT(11) NOT NULL, 
  attach TEXT NOT NULL, 
  send TINYINT(1) NOT NULL, 
  PRIMARY KEY (log_id)
) TYPE=MyISAM;


#
# Structure de la table "wa_session"
#
CREATE TABLE wa_session (
  session_id CHAR(32) NOT NULL, 
  admin_id TINYINT(3) NOT NULL, 
  session_start INT(11) NOT NULL, 
  session_time INT(11) NOT NULL, 
  PRIMARY KEY (session_id)
) TYPE=HEAP;
