<?php
/*******************************************************************
 *			
 * 			Fichier			:	mssql.inc.php 
 * 			Cr le			:	12 septembre 2002 
 * 			Dernire modif	:	31 janvier 2003 
 * 			Email			:	wascripts@phpcodeur.net 
 * 
 * 				 Copyright 2002-2003 PHPcodeur
 * 
 *******************************************************************/

/*******************************************************************
 *  This program is free software; you can redistribute it and/or 
 * 	modify it under the terms of the GNU General Public License as 
 * 	published by the Free Software Foundation; either version 2 of 
 *  the License, or (at your option) any later version. 
 *******************************************************************/


/*
 * Cette classe fonctionne thoriquement sur mssql.
 * Toutefois, je n'ai pas pu la tester...
 * 
 * Je me suis bas sur le fonctionnement de la classe sql_db (mssql.php) 
 * de phpBB.
 */

class sql 
{
	var $connect_id;
	var $query_result;	
	var $last_id;
	
	function sql($dbhost, $dbuser, $dbpwd, $dbname)
	{
		$this->connect_id = mssql_connect($dbhost, $dbuser, $dbpwd); 
		
		if( $this->connect_id )
		{
			$select_db = mssql_select_db($dbname, $this->connect_id); 
		
			if( !$select_db )
			{
				mssql_close($this->connect_id);
			}
		
			return $select_db;
		}
		else
		{
			return false;
		}	
	}
	
	function query($query, $transaction = false)
	{
		unset($this->query_result);
		$transaction = ( $transaction ) ? strtolower($transaction) : false;
		
		if( $query != '' )
		{
			if( $transaction == START_TRC )
			{
				if ( !mssql_query("BEGIN TRANSACTION", $this->connect_id) )
				{
					return false;
				}
				
				$this->_in_trc = true;
			}
			
			$query_type = substr($query, 0, 6); 
			
			if( $query_type == "INSERT" )
			{
				if( mssql_query($query, $this->connect_id) )
				{
					$this->query_result = true; 
					
					$result = mssql_query("SELECT @@IDENTITY AS last_id", $this->connect_id);
					if( $result )
					{
						$this->last_id = mssql_result($result, 0, "last_id");
					}
				}
			}
			else if( $query_type == "SELECT" )
			{
				preg_match("#^SELECT (.*) (LIMIT ([0-9]+)([, ]*([0-9]+))*)?$#s", $query, $matches);
				
				$query2 = "SELECT ";
				
				if( $matches[2] != '' )
				{
					$query2 .= "TOP " . ( $matches[3] + $matches[5] ) . " ";
				}
				
				$query2 .= $matches[1]; 
				
				$this->query_result = mssql_query($query2, $this->connect_id); 
			}
			else
			{
				$this->query_result = mssql_query($query, $this->connect_id);
			}
			
			if( !$this->query_result && $this->_in_trc )
			{
				mssql_query("ROLLBACK", $this->connect_id);
				$this->_in_trc = false;
			}

			if( $transaction == END_TRC && $this->_in_trc )
			{
				$this->_in_trc = false;

				if( !mssql_query("COMMIT", $this->connect_id) )
				{
					mssql_query("ROLLBACK", $this->connect_id);
					return false;
				}
			}
		}
		
		return $this->query_result;
	}
	
	function num_rows($result = false)
	{
		if( !$result )
		{
			$result = $this->query_result;
		}
		
		return ( $result ) ? mssql_num_rows($result) : false;
	}
	
	function affected_rows()
	{
		return ( $this->connect_id ) ? mssql_rows_affected($this->connect_id) : false;
	}
	
	function fetch_array($result = false)
	{
		if( !$result )
		{
			$result = $this->query_result;
		}
		
		return ( $result ) ? mssql_fetch_array($result) : false;
	}
	
	function fetch_object($result = false)
	{
		if( !$result )
		{
			$result = $this->query_result;
		}
		
		return ( $result ) ? mssql_fetch_object($result) : false;
	}
	
	function result($result, $row, $field = '')
	{
		if( $field != '' )
		{
			return mssql_result($result, $row, $field);
		}
		else
		{
			return mssql_result($result, $row);
		}
	}
	
	function next_id()
	{
		return ( $this->connect_id ) ? $this->last_id : false;
	}
	
	function free_result($result = false)
	{
		if( !$result )
		{
			$result = $this->query_result;
		}
		
		mssql_free_result($result);
		
		return true;
	}
	
	function sql_error()
	{
		$sql_error['errno'] = 0;
		$sql_error['error'] = mssql_get_last_message();
		
		return $sql_error;
	}
	
	function close_connexion()
	{
		if( $this->connect_id )
		{
			if( $this->query_result )
			{
				$this->free_result();
			}
			
			if( $this->_in_trc )
			{
				mssql_query("COMMIT", $this->connect_id);
			}
			
			return mssql_close($this->connect_id);
		}
		else
		{
			return false;
		}
	}
}// fin de la classe
?>