<?php 
/*******************************************************************
 *			
 * 			Fichier			:	config.php 
 * 			Cr le			:	14 juillet 2002 
 * 			Dernire modif	:	31 janvier 2003 
 * 			Email			:	wascripts@phpcodeur.net 
 * 
 * 				 Copyright 2002-2003 PHPcodeur
 * 
 *******************************************************************/

/*******************************************************************
 *  This program is free software; you can redistribute it and/or 
 * 	modify it under the terms of the GNU General Public License as 
 * 	published by the Free Software Foundation; either version 2 of 
 *  the License, or (at your option) any later version. 
 *******************************************************************/


define('IN_NEWSLETTER', true); 
define('PAGE', basename(__FILE__)); 

$waroot = '../'; 
require('./pagestart.php');

if( $admindata['level'] != ADMIN )
{
	$meta = '<meta http-equiv="refresh" content="8;url=' . sessid("index.php") . '">'; 
	$message = $lang['info_msg']['not_auth']; 
	message(INFO, $message); 
}

$submit = ( isset($HTTP_POST_VARS['submit']) ) ? true : false;
$mode 	= ( !empty($HTTP_GET_VARS['mode']) ) ? $HTTP_GET_VARS['mode'] : '';

if( $mode == 'reglages' )
{
	if( !empty($HTTP_POST_VARS['liste']) )
	{
		$liste = intval($HTTP_POST_VARS['liste']); 
	}
	else if( !empty($HTTP_GET_VARS['liste']) )
	{
		$liste = intval($HTTP_GET_VARS['liste']); 
	}
	else
	{
		$liste = 0; 
	}
	
	define('MENU', true);
	include('page_header.php'); 
	
	if( $submit || $liste )
	{
		$sql = "SELECT form_url, choix_format 
				FROM " . LISTE_TABLE . " 
				WHERE liste_id = $liste";
		if( !($result = $db->query($sql)) )
		{
			message(ERROR, 'Impossible d\'obtenir des infos sur la liste', __FILE__, __LINE__, $sql);
		}
		
		include($waroot . 'language/' . $newsletter_config['language'] . '/lang.php'); 

		$liste_info = $db->fetch_array($result);

		$code_to_insert = "<form method=\"POST\" action=\"" . $liste_info['form_url'] . "\">\n";
		$code_to_insert .= $lang['address_mail'] . " : <input type=\"text\" name=\"email\" maxlength=\"100\" /> &amp;nbsp; \n";

		if( $liste_info['choix_format'] == FORMAT_MULTIPLE )
		{
			$code_to_insert .= $lang['Format'] . " : <select name=\"format\">\n";
			$code_to_insert .= "<option value=\"" . FORMAT_TEXTE . "\">TXT</option>\n";
			$code_to_insert .= "<option value=\"" . FORMAT_HTML . "\">HTML</option>\n";
			$code_to_insert .= "</select>\n";
		}
		else
		{
			$code_to_insert .= "<input type=\"hidden\" name=\"format\" value=\"" . $liste_info['choix_format'] . "\" />\n";
		}

		$code_to_insert .= "<input type=\"hidden\" name=\"liste\" value=\"" . $liste . "\" />\n";
		$code_to_insert .= "<br />\n";

		$code_to_insert .= "<input type=\"radio\" name=\"action\" value=\"inscription\" checked=\"checked\" /> " . $lang['suscribe'] . " <br />\n";
		$code_to_insert .= ( $liste_info['choix_format'] == FORMAT_MULTIPLE ) ? "<input type=\"radio\" name=\"action\" value=\"setformat\" /> " . $lang['setformat'] . " <br />\n" : "";
		$code_to_insert .= "<input type=\"radio\" name=\"action\" value=\"desinscription\" /> " . $lang['unsuscribe'] . " <br />\n";
		$code_to_insert .= "<input type=\"submit\" name=\"wanewsletter\" value=\"" . $lang['valider'] . "\" />\n";
		$code_to_insert .= "</form>";
		
		$code_to_insert2 = "<?php\ndefine('IN_WA_FORM', true); \n\$waroot = './';\ninclude(\$waroot . 'newsletter.php');\n?>";

		$template->set_filenames(array(
			'body' => 'reglages2.tpl'
		));

		$template->assign_vars( array(
			'TITLE' => $lang['menu']['form_gen'], 
			'L_TEXT_REGLAGES' => sprintf($lang['text_reglages1'], $liste_info['form_url']), 
			'L_TEXT_REGLAGES2' => $lang['text_reglages2'], 
			
			'CODE_TO_INSERT' => $code_to_insert, 
			'CODE_TO_INSERT2' => $code_to_insert2 
		));

		$template->pparse('body');	

		include('page_footer.php');
		exit;
	}
	
	$template->set_filenames( array(
		'body' => 'reglages.tpl'
	)); 

	$template->assign_vars( array(
		'TITLE' => $lang['menu']['form_gen'], 
		'HEAD' => nl2br($lang['head']['reglages']), 
		'L_CHOICE' => $lang['choice_liste'], 
		'L_BUTTON_VALID' => $lang['button']['valid'], 
		
		'LIST_BOX' => list_box(AUTH_VIEW), 
		'U_FORM' => sessid("config.php?mode=reglages") 
	));
}
else
{
	if( $submit )
	{
		if( $HTTP_POST_VARS['sitename'] == '' || $HTTP_POST_VARS['urlsite'] == '' || $HTTP_POST_VARS['path'] == '' || $HTTP_POST_VARS['sender_email'] == '' || $HTTP_POST_VARS['session_duree'] == '' || $HTTP_POST_VARS['signature'] == '' )
		{
			$meta = '<meta http-equiv="refresh" content="5;url=' . sessid("config.php") . '">'; 
			$message =  $lang['info_msg']['fields_empty'] . '<br /><br />' . sprintf( $lang['return_form'], '<a href="' . sessid("config.php") . '">', '</a>');
			
			message(ERROR,$message);
		}
	
		if( !EmailOK($HTTP_POST_VARS['sender_email']) || ( $HTTP_POST_VARS['return_path_email'] != '' && !EmailOK($HTTP_POST_VARS['return_path_email']) ) )
		{
			$meta = '<meta http-equiv="refresh" content="5;url=' . sessid("config.php") . '">'; 
			$message = $lang['info_msg']['invalid_email'] . '<br /><br />' . sprintf( $lang['return_form'], '<a href="' . sessid("config.php") . '">', '</a>');
			
			message(ERROR, $message);
		}
	
		$HTTP_POST_VARS['session_duree'] = intval($HTTP_POST_VARS['session_duree']);
		
		$sql = "SELECT * FROM " . CONFIG_TABLE;
		if( !($result = $db->query($sql)) )
		{
			message(ERROR, 'Impossible d\'obtenir la configuration de la newsletter', __FILE__, __LINE__, $sql);
		}
		
		while( $row = $db->fetch_array($result) )
		{
			$nom = $row['nom'];
			$valeur = ( isset($HTTP_POST_VARS[$nom]) ) ? $HTTP_POST_VARS[$nom] : $newsletter_config[$nom];
			
			$sql = "UPDATE " . CONFIG_TABLE . " 
					SET valeur = '" . $valeur . "' 
					WHERE nom = '" . $nom . "'";
			if( !($result2 = $db->query($sql)) )
			{
				message(ERROR, 'Impossible de mettre  jour la configuration de la newsletter', __FILE__, __LINE__, $sql);
			}
		}
	
		$meta = '<meta http-equiv="refresh" content="6;url=' . sessid("index.php") . '">';
		message(INFO, $lang['info_msg']['success_modif']);		
	}

	$lang_box = lang_box($newsletter_config['language']); 

	define('MENU', true);
	include('page_header.php');

	$template->set_filenames( array(
		'body' => 'config.tpl'
	));

	$template->assign_vars( array(
		'TITLE' => $lang['menu']['config'], 
		'TITLE_CONFIG_LANGUAGE' => $lang['title']['config_lang'], 
		'TITLE_CONFIG_DIVERS' => $lang['title']['config_divers'], 
		'TITLE_CONFIG_EMAIL' => $lang['title']['config_email'], 
		'L_SELECT_LANGUAGE' => $lang['select_langue'], 
		'L_SITENAME' => $lang['sitename'], 
		'L_URLSITE' => $lang['url_site'], 
		'L_URLSITE_NOTE' => $lang['url_site_note'], 
		'L_URLSCRIPT' => $lang['url_script'], 
		'L_URLSCRIPT_NOTE' => $lang['url_script_note'], 
		'L_SENDER_EMAIL' => $lang['sender_email'], 
		'L_RETURN_PATH_EMAIL' => $lang['return_path_email'], 
		'L_RETURN_PATH_EMAIL_NOTE' => $lang['return_path_email_note'], 
		'L_SIG_EMAIL' => $lang['sig_email'], 
		'L_SIG_EMAIL_NOTE' => $lang['sig_email_note'], 
		'L_LENGTH_SESSION' => $lang['length_session'], 
		'L_SECONDS' => $lang['seconds'], 	
		'L_YES' => $lang['yes'], 
		'L_NO' => $lang['no'], 
		'L_DATE_FORMAT' => $lang['date_format'], 
		'L_DATE_FORMAT_NOTE' => $lang['date_format_note'], 
		'L_POPUP' => $lang['popup_version'], 
		'L_ENGINE_SEND' => $lang['choice_engine_send'], 
		'L_ENGINE_BCC' => $lang['with_engine_bcc'], 
		'L_ENGINE_UNIQ' => $lang['with_engine_uniq'], 
		'L_EMAILS_SENDED' => $lang['emails_paquet'], 
		'L_EMAILS_SENDED_NOTE' => $lang['emails_paquet_note'], 
		'L_HEBERGEUR' => $lang['hebergeur'], 
		'L_OTHER' => $lang['other'], 
		'L_USE_SMTP' => $lang['use_smtp'], 
		'L_USE_SMTP_NOTE' => sprintf($lang['use_smtp_note'], '<a href="' . sessid("infos.php") . '#9">', '</a>'), 
		'L_ADDR_SMTP' => $lang['addr_smtp'], 
		'L_PORT_SMTP' => $lang['port_smtp'], 
		'L_PORT_SMTP_NOTE' => $lang['port_smtp_note'], 
		'L_USER_SMTP' => $lang['user_smtp'], 
		'L_PASS_SMTP' => $lang['pwd_smtp'], 
		'L_AUTH_SMTP_NOTE' => $lang['auth_smtp_note'], 	
		'L_BUTTON_VALID' => $lang['button']['valid'], 
		'L_BUTTON_RESET' => $lang['button']['reset'], 
							  
		'LANG_BOX' => $lang_box, 
		'SITENAME' => $newsletter_config['sitename'], 
		'URLSITE' => $newsletter_config['urlsite'], 
		'URLSCRIPT' => $newsletter_config['path'], 
		'SENDER_EMAIL' => $newsletter_config['sender_email'], 
		'RETURN_PATH_EMAIL' => $newsletter_config['return_path_email'], 
		'SIG_EMAIL' => $newsletter_config['signature'], 
		'LENGTH_SESSION' => $newsletter_config['session_duree'], 
		'DATE_FORMAT' => $newsletter_config['date_format'], 
		'CHECK1' => ( $newsletter_config['popup_version'] == 1 ) ? ' checked="checked"' : '', 
		'CHECK2' => ( $newsletter_config['popup_version'] == 0 ) ? ' checked="checked"' : '', 
		'CHECK3' => ( $newsletter_config['engine_send'] == ENGINE_BCC ) ? ' checked="checked"' : '', 
		'CHECK4' => ( $newsletter_config['engine_send'] == ENGINE_UNIQ ) ? ' checked="checked"' : '', 
		'EMAILS_SENDED' => $newsletter_config['emails_sended'], 
		'SELECTED1' => ( $newsletter_config['hebergeur'] == 1 ) ? ' selected="selected"' : '', 
		'SELECTED2' => ( $newsletter_config['hebergeur'] == 2 ) ? ' selected="selected"' : '', 
		'SELECTED3' => ( $newsletter_config['hebergeur'] == 3 ) ? ' selected="selected"' : '', 
		'CHECK5' => ( $newsletter_config['use_smtp'] == 1 ) ? ' checked="checked"' : '', 
		'CHECK6' => ( $newsletter_config['use_smtp'] == 0 ) ? ' checked="checked"' : '', 	
		'SMTP_HOST' => $newsletter_config['smtp_host'], 
		'SMTP_PORT' => $newsletter_config['smtp_port'], 
		'SMTP_USER' => $newsletter_config['smtp_user'], 
		'SMTP_PASS' => $newsletter_config['smtp_pass'], 
		'U_FORM' => sessid("config.php") 
	));
}

$template->pparse('body');

include('page_footer.php');
?>