<?php
/*******************************************************************
 *			
 * 			Fichier			:	admin_auth.php 
 * 			Cr le			:	21 octobre 2002 
 * 			Dernire modif	:	31 janvier 2003 
 * 			Email			:	wascripts@phpcodeur.net 
 * 
 * 				 Copyright 2002-2003 PHPcodeur
 * 
 *******************************************************************/

/*******************************************************************
 *  This program is free software; you can redistribute it and/or 
 * 	modify it under the terms of the GNU General Public License as 
 * 	published by the Free Software Foundation; either version 2 of 
 *  the License, or (at your option) any later version. 
 *******************************************************************/


define('IN_NEWSLETTER', true); 
define('PAGE', basename(__FILE__)); 

$waroot = '../'; 
require('./pagestart.php'); 

if( $admindata['level'] != ADMIN )
{
	$meta = '<meta http-equiv="refresh" content="8;url=' . sessid("index.php") . '">'; 	
	message(INFO, $lang['info_msg']['not_auth']); 
}

$submit   = ( isset($HTTP_POST_VARS['submit']) ) ? true : false; 
$admin_id = ( !empty($HTTP_POST_VARS['admin_id']) ) ? intval($HTTP_POST_VARS['admin_id']) : 0; 

if( $admin_id )
{
	if( $submit )
	{
		$rank 	   	 = $HTTP_POST_VARS['rank']; 
		$liste_id	 = $HTTP_POST_VARS['liste_id']; 
		$auth_view 	 = $HTTP_POST_VARS['auth_view']; 
		$auth_edit 	 = $HTTP_POST_VARS['auth_edit']; 
		$auth_del  	 = $HTTP_POST_VARS['auth_del']; 
		$auth_send 	 = $HTTP_POST_VARS['auth_send']; 
		$auth_import = $HTTP_POST_VARS['auth_import']; 
		$auth_export = $HTTP_POST_VARS['auth_export']; 
		
		$level = ( $rank == 'admin' ) ? ADMIN : USER; 
		
		if( $admindata['admin_id'] != $admin_id )
		{
			$sql = "UPDATE " . ADMIN_TABLE . " 
					SET level = '$level' 
					WHERE admin_id = '$admin_id'"; 
			if( !($result = $db->query($sql)) )
			{
				message(ERROR, 'Impossible de mettre  jour la table des administrateurs', __FILE__, __LINE__, $sql);
			}
		}
		
		$total_list = count($liste_id); 
		for( $i = 0; $i < $total_list; $i++ )
		{
			$sql = "UPDATE " . AUTH_ADMIN_TABLE . " 
					SET auth_view = '" . $auth_view[$i] . "', 
						auth_edit = '" . $auth_edit[$i] . "', 
						auth_del = '" . $auth_del[$i] . "', 
						auth_send = '" . $auth_send[$i] . "', 
						auth_import = '" . $auth_import[$i] . "', 
						auth_export = '" . $auth_export[$i] . "' 
					WHERE admin_id = $admin_id 
					  AND liste_id = '" . $liste_id[$i] . "'"; 
			if( !($result = $db->query($sql)) )
			{
				message(ERROR, 'Impossible de mettre  jour la table des permissions', __FILE__, __LINE__, $sql);
			}
		}
		
		$message = $lang['info_msg']['success_auth_maj']; 
		message(INFO, $message); 
	}
	
	$sql = "SELECT aa.auth_view, aa.auth_edit, aa.auth_del, aa.auth_send, aa.auth_import, aa.auth_export, a.user, a.level, li.nom, li.liste_id 
			FROM " . ADMIN_TABLE . " AS a, " . LISTE_TABLE . " AS li, " . AUTH_ADMIN_TABLE . " AS aa 
			WHERE a.admin_id = $admin_id 
			  AND aa.admin_id = a.admin_id 
			  AND aa.liste_id = li.liste_id 
			GROUP BY li.liste_id";
	if( !($result = $db->query($sql)) )
	{
		message(ERROR, 'Impossible d\'obtenir les permissions actuelles pour l\'utilisateur concern', __FILE__, __LINE__, $sql);
	}
	
	$authrow = array(); 
	while( $row = $db->fetch_array($result) )
	{
		$authrow[] = $row; 
	}
	
	define('MENU', true); 
	include('page_header.php'); 
	
	$template->set_filenames( array(
		'body' => 'auth_admin.tpl' 
	));

	$template->assign_vars( array(		
		'TITLE' => sprintf($lang['auth_user'], stripslashes($authrow[0]['user'])), 
		'HEAD' => $lang['head']['auth'], 
		'L_RANK' => $lang['rank'], 
		'L_ADMIN' => $lang['admin'], 
		'L_USER' => $lang['user'], 
		'L_LIST' => $lang['list'], 
		'L_VIEW' => $lang['view'], 
		'L_EDIT' => $lang['button']['edit'], 
		'L_DELETE' => $lang['button']['delete'], 
		'L_SEND' => $lang['button']['send'], 
		'L_IMPORT' => $lang['import'], 
		'L_EXPORT' => $lang['export'], 
		'L_BUTTON_VALID' => $lang['button']['valid'], 
		'L_BUTTON_RESET' => $lang['button']['reset'], 
		
		'SELECTED1' => ( $authrow[0]['level'] == ADMIN ) ? " selected=\"selected\"" : "", 
		'SELECTED2' => ( $authrow[0]['level'] == USER ) ? " selected=\"selected\"" : "", 
		'HIDDEN_FIELD' => '<input type="hidden" name="admin_id" value="' . $admin_id . '" />', 
		'U_FORM' => sessid("admin_auth.php") 
	)); 
	
	$total_list = count($authrow); 
	for( $i = 0; $i < $total_list; $i++ )
	{
		$template->assign_block_vars('auth', array(
			'LIST_NAME' => stripslashes($authrow[$i]['nom']), 
			'HIDDEN_FIELD_ID' => '<input type="hidden" name="liste_id[]" value="' . $authrow[$i]['liste_id'] . '" />', 
			'BOX_AUTH_VIEW' => box_auth(AUTH_VIEW, $authrow[$i]['auth_view']), 
			'BOX_AUTH_EDIT' => box_auth(AUTH_EDIT, $authrow[$i]['auth_edit']), 
			'BOX_AUTH_DEL' => box_auth(AUTH_DEL, $authrow[$i]['auth_del']), 
			'BOX_AUTH_SEND' => box_auth(AUTH_SEND, $authrow[$i]['auth_send']), 
			'BOX_AUTH_IMPORT' => box_auth(AUTH_IMPORT, $authrow[$i]['auth_import']), 
			'BOX_AUTH_EXPORT' => box_auth(AUTH_EXPORT, $authrow[$i]['auth_export']) 
		));
	}
}
else
{
	$sql = "SELECT admin_id, user 
			FROM " . ADMIN_TABLE; 
	if( !($result = $db->query($sql)) )
	{
		message(ERROR, 'Impossible d\'obtenir la liste des administrateurs', __FILE__, __LINE__, $sql);
	}
	
	$box_select = "<select name=\"admin_id\">\n"; 
	$box_select .= "<option value=\"0\">" . $lang['select_user'] . "</option>\n"; 
	
	while( $row = $db->fetch_array($result) )
	{
		$box_select .= "<option value=\"" . $row['admin_id'] . "\"> - " . stripslashes($row['user']) . " - </option>\n"; 
	}
	
	$box_select .= "</select>\n"; 
	
	define('MENU', true); 
	include('page_header.php'); 
	
	$template->set_filenames( array(
		'body' => 'select.tpl'
	));

	$template->assign_vars( array(
		'TITLE' => $lang['title']['select'], 
		'L_SELECT' => $lang['select_user'], 
		'L_BUTTON_VALID' => $lang['button']['valid'], 
		
		'BOX_SELECT' => $box_select, 
		'U_FORM' => sessid("admin_auth.php") 
	)); 
}

$template->pparse('body'); 

include('page_footer.php'); 
?>