<?php
/*******************************************************************
 *			
 * 			Fichier			:	functions.auth.php 
 * 			Cr le			:	21 octobre 2002 
 * 			Dernire modif	:	31 janvier 2003 
 * 			Email			:	wascripts@phpcodeur.net 
 * 
 * 				 Copyright 2002-2003 PHPcodeur
 * 
 *******************************************************************/

/*******************************************************************
 *  This program is free software; you can redistribute it and/or 
 * 	modify it under the terms of the GNU General Public License as 
 * 	published by the Free Software Foundation; either version 2 of 
 *  the License, or (at your option) any later version. 
 *******************************************************************/


if( !defined('FUNCTIONS_AUTH_INC') )
{

define('FUNCTIONS_AUTH_INC', 1); 

//////////////////////////////////////////////////////////////
//
// Fonctions utilises dans le cadre des autorisations 
// d'administration
//

//
// Fonction de construction de liste pour chaque type de permission 
// Section: Permissions des admins
//
function box_auth($type, $auth)
{
	global $lang; 
	
	switch($type)
	{
		case AUTH_VIEW:
			$select_name = "auth_view"; 
			break; 
		
		case AUTH_EDIT:
			$select_name = "auth_edit"; 
			break; 
		
		case AUTH_DEL:
			$select_name = "auth_del"; 
			break; 
		
		case AUTH_SEND:
			$select_name = "auth_send"; 
			break; 
		
		case AUTH_IMPORT:
			$select_name = "auth_import"; 
			break; 
		
		case AUTH_EXPORT:
			$select_name = "auth_export"; 
			break; 
	}
	
	$box_auth = "\n<select name=\"" . $select_name . "[]\">\n"; 
	if( $auth )
	{
		$box_auth .= "<option value=\"1\" selected=\"selected\"> " . $lang['yes'] . " </option>\n"; 
		$box_auth .= "<option value=\"0\"> " . $lang['no'] . " </option>\n"; 
	}
	else
	{
		$box_auth .= "<option value=\"1\"> " . $lang['yes'] . " </option>\n"; 
		$box_auth .= "<option value=\"0\" selected=\"selected\"> " . $lang['no'] . " </option>\n"; 
	}
	$box_auth .= "</select>\n"; 
	
	return $box_auth; 
}

function obtain_auth($auth_type, $liste)
{
	global $admindata, $db; 
	
	$list_field = ''; 
	$auth_array = array(); 
	switch($auth_type)
	{
		case AUTH_ALL:
			$list_field = 'aa.auth_view, aa.auth_edit, aa.auth_del, aa.auth_send, aa.auth_import, aa.auth_export'; 
			$auth_array = array('auth_view', 'auth_edit', 'auth_del', 'auth_send', 'auth_import', 'auth_export'); 
			break; 
		case AUTH_VIEW:
			$list_field = 'aa.auth_view'; 
			$auth_array = array('auth_view'); 
			break;
		case AUTH_EDIT:
			$list_field = 'aa.auth_edit'; 
			$auth_array = array('auth_edit'); 
			break;
		case AUTH_DEL:
			$list_field = 'aa.auth_del'; 
			$auth_array = array('auth_del'); 
			break;
		case AUTH_SEND:
			$list_field = 'aa.auth_send'; 
			$auth_array = array('auth_send'); 
			break;
		case AUTH_IMPORT:
			$list_field = 'aa.auth_import'; 
			$auth_array = array('auth_import'); 
			break;
		case AUTH_EXPORT:
			$list_field = 'aa.auth_export'; 
			$auth_array = array('auth_export'); 
			break;
	}
	
	$list_field .= ( ( $list_field != '' ) ? ', ' : '') . 'li.liste_id'; 
	
	$sql_where = '';
	if( $liste != ALL_LIST )
	{
		$sql_where = "AND li.liste_id = '$liste'"; 
	}
	
	$sql = "SELECT $list_field 
			FROM " . AUTH_ADMIN_TABLE . " AS aa, " . ADMIN_TABLE . " AS a, " . LISTE_TABLE . " AS li 
			WHERE a.admin_id = '" . $admindata['admin_id'] . "' 
			  AND aa.admin_id = a.admin_id 
			  AND aa.liste_id = li.liste_id 
			  $sql_where
			GROUP BY li.liste_id"; 
	if( !($result = $db->query($sql)) )
	{
		message(ERROR, 'Impossible d\'obtenir les permissions', __FILE__, __LINE__, $sql);
	}
	
	$authrow = array();
	while( $row = $db->fetch_array($result) )
	{
		$authrow[] = $row;
	}
	
	$auth_list = array('all_list' => array(
		'auth_view' => array(), 'auth_edit' => array(), 'auth_del' => array(), 
		'auth_send' => array(), 'auth_import' => array(), 'auth_export' => array()
	)); 
	
	for( $i = 0; $i < count($authrow); $i++ )
	{
		reset($auth_array); 
		while( list(, $auth_name) = each($auth_array) )
		{
			if( $authrow[$i][$auth_name] || $admindata['level'] == ADMIN )
			{
				$auth_list[$authrow[$i]['liste_id']][$auth_name] = true; 
				$auth_list['all_list'][$auth_name][] = $authrow[$i]['liste_id']; 
			}
			else
			{
				$auth_list[$authrow[$i]['liste_id']][$auth_name] = false; 
			}
		}
	}
	
	return $auth_list; 
}

//
// Fin des fonctions d'autorisations
//
//////////////////////////////////////////////////////////////
}
?>