/*
  Schma des tables de WAnewsletter 2.1pre
  pour Microsoft SQL Server
 
  30 octobre 2002 - Bobe
*/

BEGIN TRANSACTION
GO

/*
  Structure de la table "wa_abonnes"
*/
CREATE TABLE [wa_abonnes] (
  [id] [int] IDENTITY (1, 1) NOT NULL, 
  [email] [varchar] (255) NOT NULL, 
  [code] [varchar] (16) NOT NULL, 
  [date] [int] NOT NULL, 
  [format] [smallint] NOT NULL, 
  [liste_id] [smallint] NOT NULL, 
  [actif] [smallint] NOT NULL, 
  [send] [smallint] NOT NULL 
) ON [PRIMARY]
GO


/*
  Structure de la table "wa_admin"
*/
CREATE TABLE [wa_admin] (
  [admin_id] [smallint] IDENTITY (1, 1) NOT NULL, 
  [user] [varchar] (50) NOT NULL, 
  [passwd] [varchar] (32) NOT NULL, 
  [email] [varchar] (255) NOT NULL, 
  [level] [smallint] NOT NULL
) ON [PRIMARY]
GO


/*
  Structure de la table "wa_auth_admin"
*/
CREATE TABLE [wa_auth_admin] (
  [admin_id] [smallint] NOT NULL,
  [liste_id] [smallint] NOT NULL,
  [auth_view] [smallint] NOT NULL,
  [auth_edit] [smallint] NOT NULL,
  [auth_del] [smallint] NOT NULL,
  [auth_send] [smallint] NOT NULL,
  [auth_import] [smallint] NOT NULL,
  [auth_export] [smallint] NOT NULL
) ON [PRIMARY]
GO


/*
  Structure de la table "wa_ban_list"
*/
CREATE TABLE [wa_ban_list] (
  [ban_id] [smallint] IDENTITY (1, 1) NOT NULL,
  [liste_id] [smallint] NOT NULL,
  [ban_email] [varchar] (255) NOT NULL
) ON [PRIMARY]
GO


/*
  Structure de la table "wa_config"
*/
CREATE TABLE [wa_config] (
  [nom] [varchar] (255) NOT NULL, 
  [valeur] [varchar] (255) NOT NULL
) ON [PRIMARY]
GO


/*
  Structure de la table "wa_liste"
*/
CREATE TABLE [wa_liste] (
  [liste_id] [smallint] IDENTITY (1, 1) NOT NULL, 
  [nom] [varchar] (100) NOT NULL, 
  [choix_format] [smallint] NOT NULL, 
  [email_confirm] [smallint] NOT NULL, 
  [limitevalidate] [smallint] NOT NULL, 
  [form_url] [varchar] (255) NOT NULL, 
  [email_new_inscrit] [smallint] NOT NULL 
)  ON [PRIMARY]
GO


/*
  Structure de la table "wa_log"
*/
CREATE TABLE [wa_log] (
  [log_id] [int] IDENTITY (1, 1) NOT NULL, 
  [liste_id] [smallint] NOT NULL, 
  [sujet] [varchar] (100) NOT NULL, 
  [body_html] [text] NOT NULL, 
  [body_text] [text] NOT NULL, 
  [date] [int] NOT NULL, 
  [attach] [text] NOT NULL, 
  [send] [smallint] NOT NULL 
)  ON [PRIMARY]
GO


/*
  Structure de la table "wa_session"
*/
CREATE TABLE [wa_session] (
  [session_id] [char] (32) NOT NULL, 
  [admin_id] [smallint] NOT NULL, 
  [session_start] [int] NOT NULL, 
  [session_time] [int] NOT NULL 
)  ON [PRIMARY]
GO

ALTER TABLE [wa_abonnes] WITH NOCHECK ADD 
	CONSTRAINT [PK_wa_abonnes] PRIMARY KEY  CLUSTERED 
	(
		[id]
	)  ON [PRIMARY] 
GO

ALTER TABLE [wa_admin] WITH NOCHECK ADD 
	CONSTRAINT [PK_wa_admin] PRIMARY KEY  CLUSTERED 
	(
		[admin_id]
	)  ON [PRIMARY] 
GO

ALTER TABLE [wa_ban_list] WITH NOCHECK ADD 
	CONSTRAINT [PK_wa_ban_list] PRIMARY KEY  CLUSTERED 
	(
		[ban_id]
	)  ON [PRIMARY] 
GO

ALTER TABLE [wa_liste] WITH NOCHECK ADD 
	CONSTRAINT [PK_wa_liste] PRIMARY KEY  CLUSTERED 
	(
		[liste_id]
	)  ON [PRIMARY] 
GO

ALTER TABLE [wa_log] WITH NOCHECK ADD 
	CONSTRAINT [PK_wa_log] PRIMARY KEY  CLUSTERED 
	(
		[log_id]
	)  ON [PRIMARY] 
GO

ALTER TABLE [wa_abonnes] WITH NOCHECK ADD 
	CONSTRAINT [DF_wa_abonnes_date] DEFAULT (0) FOR [date],
	CONSTRAINT [DF_wa_abonnes_format] DEFAULT (1) FOR [format],
	CONSTRAINT [DF_wa_abonnes_liste_id] DEFAULT (0) FOR [liste_id],
	CONSTRAINT [DF_wa_abonnes_actif] DEFAULT (0) FOR [actif],
	CONSTRAINT [DF_wa_abonnes_send] DEFAULT (0) FOR [send]
GO

ALTER TABLE [wa_admin] WITH NOCHECK ADD 
	CONSTRAINT [DF_wa_admin_level] DEFAULT (1) FOR [level]
GO

ALTER TABLE [wa_auth_admin] WITH NOCHECK ADD 
	CONSTRAINT [DF_wa_auth_admin_admin_id] DEFAULT (0) FOR [admin_id],
	CONSTRAINT [DF_wa_auth_admin_liste_id] DEFAULT (0) FOR [liste_id],
	CONSTRAINT [DF_wa_auth_admin_auth_view] DEFAULT (0) FOR [auth_view],
	CONSTRAINT [DF_wa_auth_admin_auth_edit] DEFAULT (0) FOR [auth_edit],
	CONSTRAINT [DF_wa_auth_admin_auth_del] DEFAULT (0) FOR [auth_del],
	CONSTRAINT [DF_wa_auth_admin_auth_send] DEFAULT (0) FOR [auth_send],
	CONSTRAINT [DF_wa_auth_admin_auth_import] DEFAULT (0) FOR [auth_import],
	CONSTRAINT [DF_wa_auth_admin_auth_export] DEFAULT (0) FOR [auth_export]
GO

ALTER TABLE [wa_ban_list] WITH NOCHECK ADD 
	CONSTRAINT [DF_wa_ban_list_liste_id] DEFAULT (0) FOR [liste_id]
GO

ALTER TABLE [wa_liste] WITH NOCHECK ADD 
	CONSTRAINT [DF_wa_liste_choix_format] DEFAULT (1) FOR [choix_format],
	CONSTRAINT [DF_wa_liste_email_confirm] DEFAULT (0) FOR [email_confirm],
	CONSTRAINT [DF_wa_liste_limitevalidate] DEFAULT (3) FOR [limitevalidate],
	CONSTRAINT [DF_wa_liste_email_new_inscrit] DEFAULT (0) FOR [email_new_inscrit]
GO

ALTER TABLE [wa_log] WITH NOCHECK ADD 
	CONSTRAINT [DF_wa_log_liste_id] DEFAULT (0) FOR [liste_id],
	CONSTRAINT [DF_wa_log_date] DEFAULT (0) FOR [date],
	CONSTRAINT [DF_wa_log_send] DEFAULT (0) FOR [send]
GO

CREATE INDEX [IX_wa_session] ON [wa_session]([session_id]) ON [PRIMARY]
GO

COMMIT
GO
