<?php
/*******************************************************************
 *			
 * 			Fichier			:	newsletter.php 
 * 			Cr le			:	29 juin 2002 
 * 			Dernire modif	:	25 mai 2003 
 * 			Email			:	wascripts@phpcodeur.net 
 * 
 * 				 Copyright 2002-2003 PHPcodeur
 * 
 *******************************************************************/

/*******************************************************************
 *  This program is free software; you can redistribute it and/or 
 * 	modify it under the terms of the GNU General Public License as 
 * 	published by the Free Software Foundation; either version 2 of 
 *  the License, or (at your option) any later version. 
 *******************************************************************/


if( defined('IN_WA_FORM') || defined('IN_SUSCRIBE') )
{
	define('IN_NEWSLETTER', true); 	
}

require_once($waroot . 'start.php'); 

$action  = ( !empty($HTTP_POST_VARS['action']) ) ? $HTTP_POST_VARS['action'] : ( ( !empty($HTTP_GET_VARS['action']) ) ? $HTTP_GET_VARS['action'] : '' ); 
$message = ''; 

if( $action != '' )
{
	$email 	= ( !empty($HTTP_POST_VARS['email']) ) ? $HTTP_POST_VARS['email'] : ''; 
	$format = ( !empty($HTTP_POST_VARS['format']) ) ? intval($HTTP_POST_VARS['format']) : 0;
	$liste 	= ( !empty($HTTP_POST_VARS['liste']) ) ? intval($HTTP_POST_VARS['liste']) : ( ( !empty($HTTP_GET_VARS['liste']) ) ? intval($HTTP_GET_VARS['liste']) : 0 );
	$code 	= ( !empty($HTTP_GET_VARS['code']) ) ? $HTTP_GET_VARS['code'] : ''; 
	
	$sql = 'SELECT * 
			FROM ' . LISTE_TABLE . ' 
			WHERE liste_id = ' . $liste; 
	if( !($result = $db->query($sql)) )
	{
		$message = 'SQL error [ligne: ' . __LINE__ . ']'; 
	}
	else
	{
		if( $listrow = $db->fetch_array($result) )
		{
			$db->free_result($result); 
			
			//
			// Dbut des actions 
			//
			if( $action == 'inscription' )
			{
				$resultat = check_email($email, $liste, false); 
				if( $resultat['error'] )
				{
					$message = $resultat['message']; 
				}
				else
				{
					$code = get_code();
					$time = time();
					$actif = ( $listrow['email_confirm'] ) ? ABO_INACTIF : ABO_ACTIF; 
					
					if( $listrow['choix_format'] != FORMAT_MULTIPLE )
					{
						$format = $listrow['choix_format']; 
					}
					else if( $format != 1 && $format != 2 )
					{
						$format = FORMAT_TEXTE; 
					}
					
					$sql = "INSERT INTO " . ABONNES_TABLE . " (email, code, date, format, liste_id, actif) 
						VALUES ('$email', '$code', '$time', $format, $liste, $actif)"; 
					if( !($result = $db->query($sql)) )
					{
						$message = 'SQL error [ligne: ' . __LINE__ . ']'; 
					}
					
					if( $listrow['email_confirm'] || $listrow['email_new_inscrit'] )
					{
						include_once($waroot . 'includes/mailer.php'); 
						
						$mailer = new Mailer($waroot . 'language/' . $newsletter_config['language'] . '/email/');
						if( $newsletter_config['use_smtp'] )
						{
							$mailer->set_smtp(
								$newsletter_config['smtp_host'], 
								$newsletter_config['smtp_port'], 
								$newsletter_config['smtp_user'], 
								$newsletter_config['smtp_pass'] 
							);
						}
					
						$mailer->hebergeur = $newsletter_config['hebergeur']; 
						$mailer->charset   = $datalang['CHARSET']; 						
					}
					
					if( $listrow['email_confirm'] )
					{
						$mailer->set_from($newsletter_config['sender_email'], stripslashes($listrow['nom'])); 
						$mailer->set_to(array($email));
						$mailer->set_subject(sprintf($lang['mail_suscribe'], $newsletter_config['sitename']));
						$mailer->set_priority(1); 
					
						$link  = $listrow['form_url']; 
						$link .= ( strstr($listrow['form_url'], '?') ) ? '&' : '?';
						$link .= 'action=confirmation&code=' . $code . '&liste=' . $liste;
				
						$mailer->set_message('inscription.tpl', array(
							'LISTE' => stripslashes($listrow['nom']), 
							'SITENAME' => $newsletter_config['sitename'],
							'LINK' => $link, 
							'URLSITE' => $newsletter_config['urlsite'], 
							'SIG' => $newsletter_config['signature'] 
						)); 
							
						if( !($mailer->send()) )
						{
							$message = $lang['info_msg']['failed_send']; 
						}
						else
						{
							$message = nl2br(sprintf($lang['info_msg']['suscribe_1'], $listrow['limitevalidate'])); 
						}
					}
					else
					{
						$message = $lang['info_msg']['suscribe_2']; 
					}
					
					if( $listrow['email_new_inscrit'] )
					{					
						$sql = "SELECT a.user, a.email 
								FROM " . ADMIN_TABLE . " AS a, " . AUTH_ADMIN_TABLE . " AS aa 
								WHERE a.admin_id = aa.admin_id 
								  AND aa.liste_id = $liste 
								  AND aa.auth_view = 1";
						$result = $db->query($sql); 
						
						while( $row = $db->fetch_array($result) )
						{
							$mailer->init();
							
							$mailer->set_from($newsletter_config['sender_email'], stripslashes($listrow['nom']));
							$mailer->set_to(array($row['email']));
							$mailer->set_subject($lang['mail_new_inscrit']);
						
							$mailer->set_message('prev_new_inscrit.tpl', array(
								'USER' => stripslashes($row['user']), 
								'EMAIL' => $email, 
								'LISTE' => stripslashes($listrow['nom']),
								'URLSITE' => $newsletter_config['urlsite'], 
								'SIG' => $newsletter_config['signature'] 
							));
				
							$mailer->send(); // envoi
						}
						$db->free_result($result); 
					}
					
					if( !$listrow['email_confirm'] )
					{
						include_once($waroot . 'includes/functions.stats.php'); 
						update_stats($liste); 
					}
				}
			}
			else if( $action == 'confirmation' )
			{
				$limit = time() - ( $listrow['limitevalidate'] * 86400 ); 
				
				if( strlen($code) > 0 )
				{
					$sql = "SELECT COUNT(*) AS hash 
							FROM " . ABONNES_TABLE . " 
							WHERE code = '$code' 
							  AND date > '$limit' 
							  AND liste_id = " . $liste; 
					if( !($result = $db->query($sql)) )
					{
						$message = 'SQL error [ligne: ' . __LINE__ . ']'; 
					}
					else
					{
						$hash = $db->result($result, 0, 'hash'); 
						
						if( $hash )
						{
							$sql = "UPDATE " . ABONNES_TABLE . " 
									SET actif = " . ABO_ACTIF . " 
									WHERE code = '$code' 
									  AND liste_id = " . $liste; 
							if( !($result = $db->query($sql)) )
							{
								$message = 'SQL error [ligne: ' . __LINE__ . ']'; 
							}
							else if( !$db->affected_rows() )
							{
								$message = $lang['info_msg']['confirm_double']; 
							}
							else
							{
								$message = $lang['info_msg']['confirm_ok']; 
								
								include_once($waroot . 'includes/functions.stats.php'); 
								update_stats($liste); 
							}
						}
						else
						{
							$message = $lang['info_msg']['invalid_code_or_date']; 
						}
					}
				}
				else
				{
					$message = $lang['info_msg']['invalid_code']; 
				}
			}
			else if( $action == 'desinscription' )
			{
				if( strlen($code) > 0 )
				{
					$sql = "SELECT COUNT(*) AS hash 
							FROM " . ABONNES_TABLE . " 
							WHERE liste_id = $liste 
							  AND code = '$code'"; 
					if( !($result = $db->query($sql)) )
					{
						$message = 'SQL error [ligne: ' . __LINE__ . ']'; 
					}
					else
					{
						$hash = $db->result($result, 0, 'hash'); 
						
						if( $hash )
						{
							$low_priority = ( $dbtype == 'mysql' ) ? 'LOW_PRIORITY' : ''; 
							
							$sql = "DELETE $low_priority 
									FROM " . ABONNES_TABLE . " 
									WHERE liste_id = $liste 
									  AND code = '$code'";
							if( !($result = $db->query($sql)) )
							{
								$message = 'SQL error [ligne: ' . __LINE__ . ']'; 
							}
							else
							{
								$message = $lang['info_msg']['unsuscribe_2'];
							}
						}
						else
						{
							$message = $lang['info_msg']['invalid_code']; 
						}
					}					
				}
				else
				{
					$resultat = check_email($email, $liste, true); 
					if( $resultat['error'] )
					{
						$message = $resultat['message']; 
					}
					else
					{
						$sql = "SELECT code 
								FROM " . ABONNES_TABLE . " 
								WHERE liste_id = $liste 
								  AND email = '$email'";
						if( !($result = $db->query($sql)) )
						{
							$message = 'SQL error [ligne: ' . __LINE__ . ']'; 
						}
						else if( !$db->num_rows($result) )
						{
							$message = $lang['info_msg']['invalid_email']; 
						}
						else
						{
							$row = $db->fetch_array($result); 
							
							include_once($waroot . 'includes/mailer.php'); 
						
							$mailer = new Mailer($waroot . 'language/' . $newsletter_config['language'] . '/email/');
							if( $newsletter_config['use_smtp'] )
							{
								$mailer->set_smtp(
									$newsletter_config['smtp_host'], 
									$newsletter_config['smtp_port'], 
									$newsletter_config['smtp_user'], 
									$newsletter_config['smtp_pass'] 
								);
							}
							
							$mailer->hebergeur = $newsletter_config['hebergeur']; 
							$mailer->charset   = $datalang['CHARSET']; 
							
							$mailer->set_from($newsletter_config['sender_email'], stripslashes($listrow['nom']));
							$mailer->set_to(array($email));
							$mailer->set_subject($lang['mail_unsuscribe']);
							$mailer->set_priority(3);
						
							$link  = $listrow['form_url'];
							$link .= ( strstr($listrow['form_url'], '?') ) ? '&' : '?';
							$link .= 'action=desinscription&code=' . $row['code'] . '&liste=' . $liste; 
							
							$mailer->set_message('confirm_des.tpl', array(
								'LISTE' => stripslashes($listrow['nom']), 
								'SITENAME' => $newsletter_config['sitename'],
								'LINK' => $link, 
								'URLSITE' => $newsletter_config['urlsite'], 
								'SIG' => $newsletter_config['signature'] 
							));
					
							if( !($mailer->send()) )
							{
								$message = $lang['info_msg']['failed_send']; 
							}
							else
							{
								$message = $lang['info_msg']['unsuscribe_1'];
							}
						}
					}// email valide
				}
			}
			else if( $action == 'setformat' )
			{
				$resultat = check_email($email, $liste, true); 
				if( $resultat['error'] )
				{
					$message = $resultat['message']; 
				}
				else if( $listrow['choix_format'] != FORMAT_MULTIPLE )
				{
					$message = $lang['info_msg']['inactive_format'];
				}
				else
				{
					$low_priority = ( $dbtype == 'mysql' ) ? 'LOW_PRIORITY' : ''; 
					
					$sql = "UPDATE $low_priority " . ABONNES_TABLE . " 
							SET format = $format 
							WHERE email = '$email' 
					 		  AND liste_id = " . $liste; 
					if( !($result = $db->query($sql)) )
					{
						$message = 'SQL error [ligne: ' . __LINE__ . ']'; 
					}
					else
					{
						$message = $lang['info_msg']['success_setformat'];
					}
				}
			}// fin des diffrentes actions
		}
		else
		{
			$message = $lang['info_msg']['unknow_list']; 
		}
	}
}// fin de si action est existant 


$list_box = ''; 
if( defined('IN_SUSCRIBE') )
{
	$sql = "SELECT liste_id, nom, choix_format 
			FROM " . LISTE_TABLE; 
	$result = $db->query($sql); 
	
	$list_box = '<select name="liste">'; 
	while( $row = $db->fetch_array($result) )
	{
		if( $row['choix_format'] == FORMAT_TEXTE )
		{
			$f = 'txt'; 
		}
		else if( $row['choix_format'] == FORMAT_HTML )
		{
			$f = 'html'; 
		}
		else
		{
			$f = 'txt &amp; html'; 
		}
		
		$list_box .= '<option value="' . $row['liste_id'] . '"> ' . stripslashes($row['nom']) . ' (' . $f . ') </option>'; 
	}
	$list_box .= '</select>'; 
	
	include($waroot . 'form_header.html'); 
?>
<div align="center">
<form method="post" action="suscribe.php">
<table border="0" cellpadding="5" cellspacing="0">
<tr>
  <td> <?php echo $lang['address_mail']; ?> : </td>
  <td> <input type="text" name="email" maxlength="100" /> </td>
</tr>
<tr>
  <td> <?php echo $lang['Format']; ?> : </td>
  <td> <select name="format">
	    <option value="1">TXT</option>
	    <option value="2">HTML</option>
	   </select> </td>
</tr>
<tr>
  <td> <?php echo $lang['diff_list']; ?> : </td>
  <td> <?php echo $list_box; ?> </td>
</tr>
<tr>
  <td align="center" colspan="2">
    <input type="radio" name="action" value="inscription" checked="checked" /> <?php echo $lang['suscribe']; ?> <br />
	<input type="radio" name="action" value="setformat" /> <?php echo $lang['setformat']; ?> <br />
	<input type="radio" name="action" value="desinscription" /> <?php echo $lang['unsuscribe']; ?> <br />
	<br />
	<input type="submit" name="wanewsletter" value="<?php echo $lang['valider']; ?>" />
  </td>
</tr>
</table>
</form>

<?php 
}

if( $action != '' )
{
	echo $message; 
}

if( defined('IN_SUSCRIBE') )
{
?>
</div>
<?php 
	include($waroot . 'form_footer.html'); 
}
?>