<?php
/*******************************************************************
 *			
 * 			Fichier			:	install.php 
 * 			Cr le			:	30 juillet 2002 
 * 			Dernire modif	:	25 mai 2003 
 * 			Email			:	wascripts@phpcodeur.net 
 * 
 * 				 Copyright 2002-2003 PHPcodeur
 * 
 *******************************************************************/

/*******************************************************************
 *  This program is free software; you can redistribute it and/or 
 * 	modify it under the terms of the GNU General Public License as 
 * 	published by the Free Software Foundation; either version 2 of 
 *  the License, or (at your option) any later version. 
 *******************************************************************/


define('IN_NEWSLETTER', true); 

$default_lang = 'francais'; 
$new_version = '2.1.3'; 
$waroot = '../'; 

require($waroot . 'includes/functions.php');
require($waroot . 'includes/template.php'); 

//error_reporting(E_ALL);

// Dsactivation de magic_quotes_runtime
set_magic_quotes_runtime(0); 

//
// magic_quotes_gpc et ajout ventuel des backslashes
//
if( !get_magic_quotes_gpc() )
{
	emul_magic_quotes_gpc($HTTP_GET_VARS); 
	emul_magic_quotes_gpc($HTTP_POST_VARS); 
}

$template = new Template($waroot . 'templates/'); 

$language = ( isset($HTTP_POST_VARS['language']) ) ? $HTTP_POST_VARS['language'] : $default_lang; 
$prev_language = ( isset($HTTP_POST_VARS['prev_language']) ) ? $HTTP_POST_VARS['prev_language'] : ''; 

unset($lang, $datetime, $datalang); 
require($waroot . 'language/' . $language . '/lang_admin.php');

$prestart 	= ( isset($HTTP_POST_VARS['prestart']) ) ? true : false;
$start 		= ( isset($HTTP_POST_VARS['start']) ) ? true : false; 
$type		= ( !empty($HTTP_POST_VARS['type']) ) ? $HTTP_POST_VARS['type'] : ''; 
$install 	= ( $type == 'install' ) ? true : false;
$upgrade 	= ( $type == 'upgrade' ) ? true : false;
$update 	= ( $type == 'update' ) ? true : false; 
$send_file	= ( isset($HTTP_POST_VARS['send_file']) ) ? true : false; 
$submit		= ( isset($HTTP_POST_VARS['submit']) ) ? true : false; 
$error 		= false;

$dbtype 	= ( !empty($HTTP_POST_VARS['dbtype']) ) ? $HTTP_POST_VARS['dbtype'] : ( ( !empty($dbtype) ) ? $dbtype : 'mysql' ); 
$dbhost 	= ( !empty($HTTP_POST_VARS['dbhost']) ) ? $HTTP_POST_VARS['dbhost'] : ( ( !empty($dbhost) ) ? $dbhost : '' ); 
$dbname 	= ( !empty($HTTP_POST_VARS['dbname']) ) ? $HTTP_POST_VARS['dbname'] : ( ( !empty($dbname) ) ? $dbname : '' ); 
$dbuser 	= ( !empty($HTTP_POST_VARS['dbuser']) ) ? $HTTP_POST_VARS['dbuser'] : ( ( !empty($dbuser) ) ? $dbuser : '' ); 
$dbpassword = ( !empty($HTTP_POST_VARS['dbpwd']) ) ? $HTTP_POST_VARS['dbpwd'] : ( ( !empty($dbpassword) ) ? $dbpassword : '' ); 
$prefixe 	= ( !empty($HTTP_POST_VARS['prefixe']) ) ? $HTTP_POST_VARS['prefixe'] : ( ( !empty($prefixe) ) ? $prefixe : '' ); 


$template->set_filenames( array(
	'body' => 'install.tpl'
));	

$template->assign_vars( array(
	'GENERAL_TITLE' => $lang['general_title_install'], 
	'S_CHARSET' => $datalang['CHARSET'], 
	'NEW_VERSION' => $new_version 
));	

if( $prestart && !$start && $language != $prev_language && !$send_file )
{
	$prestart = false;
}

if( !$prestart )
{
	$lang_box = lang_box($language);
	
	$template->assign_block_vars('welcome', array(
		'L_WELCOME' => nl2br( sprintf($lang['welcome'], '<a href="../docs/readme_fr.html" target="_blank">', '</a>')), 
		'L_SELECT_LANGUAGE' => $lang['select_langue'], 
		'L_SELECT_TYPE' => $lang['select_type'], 
		'L_TYPE_INSTALL' => $lang['type_install'], 
		'L_TYPE_UPGRADE' => $lang['type_upgrade'], 
		'L_TYPE_UPDATE' => $lang['type_update'], 
		'L_BUTTON_VALID' => $lang['button']['valid'], 
		
		'BOX_LANGUAGE' => $lang_box, 
		'SELECTED1' => ( $install ) ? ' selected="selected"' : '', 
		'SELECTED2' => ( $upgrade ) ? ' selected="selected"' : '', 
		'SELECTED3' => ( $update ) ? ' selected="selected"' : '', 		
		'S_HIDDEN_FIELD' => '<input type="hidden" name="prev_language" value="' . $language .'" />' 
	));
}
else if( $send_file )
{
	header("Content-Type: text/x-delimtext; name=\"config.inc.php\""); 
	header("Content-disposition: attachment; filename=config.inc.php"); 
	header("Content-Description: File Transfert"); 
	header("Pragma: no-cache"); 
	header("Expires: 0"); 
	
	$config_file  = "<?php \n\n";
	$config_file .= "//\n";
	$config_file .= "// Paramtres d'accs  la base de donnes \n";
	$config_file .= "// Ne pas modifier ! \n";
	$config_file .= "//\n";
	$config_file .= "define('NL_INSTALLED', true);\n\n"; 
	$config_file .= "\$dbtype = \"$dbtype\"; \n\n";
	$config_file .= "\$dbhost = \"$dbhost\"; \n";
	$config_file .= "\$dbuser = \"$dbuser\"; \n";
	$config_file .= "\$dbpassword = \"$dbpassword\"; \n";
	$config_file .= "\$dbname = \"$dbname\"; \n\n";
	$config_file .= "\$prefixe = \"$prefixe\"; \n\n";
	$config_file .= "?>";
	
	echo $config_file; 
	
	exit; 
}
else 
{
	if( ( $upgrade || $update ) && @file_exists($waroot . "includes/config.inc.php") )
	{
		include($waroot . 'includes/config.inc.php'); 
		
		if( $update )
		{
			include($waroot . 'includes/constantes.php'); 
		}
	}
	else if( $update )
	{
		//
		// erreur, fichier config non prsent sur le serveur 
		//
		$template->assign_block_vars('result', array(
			'TITLE' => '<font color="FF3333">' . $lang['title']['error'] . '</font>', 
			'MSG_RESULT' => $lang['no_exits_config_file'] 
		));
					
		$template->pparse('body'); 
		exit; 
	}
	
	$admin_email 		= ( !empty($HTTP_POST_VARS['admin_email']) ) ? $HTTP_POST_VARS['admin_email'] : ''; 
	$admin_user 		= ( !empty($HTTP_POST_VARS['admin_user']) ) ? $HTTP_POST_VARS['admin_user'] : ''; 
	$admin_pwd 			= ( !empty($HTTP_POST_VARS['admin_pwd']) ) ? $HTTP_POST_VARS['admin_pwd'] : ''; 
	$admin_pwd_confirm 	= ( !empty($HTTP_POST_VARS['admin_pwd_confirm']) ) ? $HTTP_POST_VARS['admin_pwd_confirm'] : ''; 
	$pass_encrypt 		= ( $admin_pwd != '' ) ? md5($admin_pwd) : ''; 
		
	$sitename 		= ( !empty($HTTP_POST_VARS['sitename']) ) ? $HTTP_POST_VARS['sitename'] : ''; 
	$urlsite 		= ( !empty($HTTP_POST_VARS['urlsite']) ) ? $HTTP_POST_VARS['urlsite'] : ''; 
	$urlscript 		= ( !empty($HTTP_POST_VARS['urlscript']) ) ? $HTTP_POST_VARS['urlscript'] : ''; 
	$sender_email 	= ( !empty($HTTP_POST_VARS['sender_email']) ) ? $HTTP_POST_VARS['sender_email'] : ''; 
	
	if( $start )
	{
		$date = time(); 
		$create_config_file = TRUE; 
		
		if( ( $install || $upgrade ) && 
			( $dbhost == '' || $dbname == '' || $dbuser == '' || $prefixe == '' || $admin_email == '' || 
			  $admin_user == '' || $admin_pwd == '' || $admin_pwd_confirm == '' || $sitename == '' || 
			  $urlsite == '' || $urlscript == '' || $sender_email == '' ) )
		{
			$msg_error = $lang['info_msg']['fields_empty'];
			$error = true;
		}
		
		if( !$error && ( $admin_pwd != $admin_pwd_confirm ) )
		{
			$msg_error = $lang['error_pass_admin'];
			$error = true;
		}
		
		include($waroot . 'sql/db_type.php'); 
		
		//
		// On allonge le temps maximum d'execution du script. 
		//			
		@set_time_limit(1200); 
		
		if( $install && !$error )
		{
			switch($dbtype)
			{
				case 'mysql':
					$delimiter = ';';
					$delimiter2 = ';';
					break;
				
				case 'mssql':
					$delimiter = 'GO';
					$delimiter2 = ';';
					break;
			}
			
			$sql_tables = $waroot . "sql/" . $dbtype . "/" . $dbtype . "_tables.sql"; 
			$sql_data	= $waroot . "sql/" . $dbtype . "/" . $dbtype . "_data.sql"; 
			
			$content = fread(fopen($sql_tables, 'r'), filesize($sql_tables)); 
			
			$sql_create = array(); 
			$sql_create = _sql_array($content, $delimiter, $prefixe); 
			
			$total_sql = count($sql_create)-1; 			
			for( $i = 0; $i < $total_sql; $i++ )
			{
				$result = $db->query($sql_create[$i]); 
				
				if( !$result )
				{
					$sql_error = $db->sql_error();
					
					$template->assign_block_vars('result', array(
						'TITLE' => '<font color="FF3333">' . $lang['title']['error'] . '</font>', 
						'MSG_RESULT' => nl2br(sprintf($lang['error_install'], $sql_error['error'])) 
					));
						
					$template->pparse('body');
					exit;
				}
			}
			
			$content = fread(fopen($sql_data, 'r'), filesize($sql_data)); 
			
			$sql_install = array(); 
			$sql_install = _sql_array($content, $delimiter2, $prefixe); 
			
			$total_sql = count($sql_install)-1; 			
			for( $i = 0; $i < $total_sql; $i++ )
			{
				$result = $db->query($sql_install[$i]); 
				
				if( !$result )
				{
					$sql_error = $db->sql_error();
					
					$template->assign_block_vars('result', array(
						'TITLE' => '<font color="FF3333">' . $lang['title']['error'] . '</font>', 
						'MSG_RESULT' => nl2br(sprintf($lang['error_install'], $sql_error['error'])) 
					));
						
					$template->pparse('body');
					exit;
				}
			}
			
			$sql[] = "UPDATE " . $prefixe . "config SET valeur = '$language' WHERE nom = 'language'"; 
			$sql[] = "UPDATE " . $prefixe . "config SET valeur = '$sitename' WHERE nom = 'sitename'";
			$sql[] = "UPDATE " . $prefixe . "config SET valeur = '$urlsite' WHERE nom = 'urlsite'";
			$sql[] = "UPDATE " . $prefixe . "config SET valeur = '$urlscript' WHERE nom = 'path'";
			$sql[] = "UPDATE " . $prefixe . "config SET valeur = '$sender_email' WHERE nom = 'sender_email'";
			$sql[] = "UPDATE " . $prefixe . "config SET valeur = '$new_version' WHERE nom = 'version'";
			$sql[] = "UPDATE " . $prefixe . "admin SET user = '$admin_user', passwd = '$pass_encrypt', email = '$admin_email' WHERE admin_id = 1"; 
			
			for( $i = 0; $i < count($sql); $i++ )
			{
				$result = $db->query($sql[$i]); 
				
				if( !$result )
				{
					$sql_error = $db->sql_error();
					
					$template->assign_block_vars('result', array(
						'TITLE' => '<font color="FF3333">' . $lang['title']['error'] . '</font>', 
						'MSG_RESULT' => nl2br(sprintf($lang['error_install'], $sql_error['error'])) 
					));
						
					$template->pparse('body');
					exit;
				}
			}			
		}
		else if( $upgrade && !$error )
		{
			include('upgrade.php'); 
		}
		else if( $update && !$error )
		{
			$sql = "SELECT * FROM " . CONFIG_TABLE;
			if( !($result = $db->query($sql)) )
			{
				$template->assign_block_vars('result', array(
					'TITLE' => $lang['title']['result_upgrade'], 
					'MSG_RESULT' => $lang['error_no_config'] 
				));
				
				$template->pparse('body');
				exit;
			}
		
			while( $row = $db->fetch_array($result) )
			{
				$newsletter_config[$row['nom']] = $row['valeur'];
			}
			
			$db->free_result($result);
			
			$sql = "SELECT COUNT(*) AS adm 
					FROM " . ADMIN_TABLE . " 
					WHERE LOWER(user) = '" . strtolower($admin_user) . "' 
					  AND passwd = '$pass_encrypt'";
			if( !($result = $db->query($sql)) )
			{
				$template->assign_block_vars('result', array(
					'TITLE' => $lang['title']['result_upgrade'], 
					'MSG_RESULT' => $lang['error_no_config'] 
				));
							
				$template->pparse('body');
				exit;
			}
			
			if( !$db->result($result, 0, 'adm') )
			{
				$msg_error = $lang['info_msg']['bad_pass'];
				$error = true; 
			}
			
			if( !$error )
			{
				$sql_error = false;
		
				$old_version = $newsletter_config['version']; 	
				$sql_update  = array(); 		
		
				switch( $old_version )
				{
					case '2.0Beta':
					case '2.0.0':
						// pas de changement dans la base de donnes
					
						// Nouveauts dans le fichier de configuration.
						// Voir plus loin dans le code
				
					case '2.0.1':
						$sql_update[] = "ALTER TABLE " . SESSION_TABLE . " CHANGE `session_id` `session_id` CHAR(32) NOT NULL";
						$sql_update[] = "ALTER TABLE " . SESSION_TABLE . " TYPE=HEAP";
						
					case '2.0.2':
						$sql_update[] = "UPDATE " . CONFIG_TABLE . " SET nom = 'sender_email' WHERE nom = 'emailadmin'"; 
						$sql_update[] = "INSERT INTO " . CONFIG_TABLE . " (nom, valeur) VALUES('use_autopurge', 0)"; 
						$sql_update[] = "INSERT INTO " . CONFIG_TABLE . " (nom, valeur) VALUES('purge_next', 0)"; 
						$sql_update[] = "INSERT INTO " . CONFIG_TABLE . " (nom, valeur) VALUES('purge_freq', 5)"; 
						$sql_update[] = "INSERT INTO " . CONFIG_TABLE . " (nom, valeur) VALUES('engine_send', 1)"; 
						$sql_update[] = "INSERT INTO " . CONFIG_TABLE . " (nom, valeur) VALUES('emails_sended', 0)"; 
						$sql_update[] = "INSERT INTO " . CONFIG_TABLE . " (nom, valeur) VALUES('return_path_email', '')"; 
						$sql_update[] = "UPDATE " . LOG_TABLE . " SET send = 2 WHERE send = 1"; 
						$sql_update[] = "DELETE FROM " . CONFIG_TABLE . " WHERE nom = 'email_new_inscrit'"; 
						
						switch($dbtype)
						{
							case 'mysql':
								$sql_update[] = "ALTER TABLE " . ABONNES_TABLE . " ADD `send` TINYINT(1) DEFAULT '0' NOT NULL"; 
								$sql_update[] = "ALTER TABLE " . LISTE_TABLE . " ADD `email_new_inscrit` TINYINT(1) DEFAULT '0' NOT NULL"; 
								$sql_update[] = "CREATE TABLE " . BANLIST_TABLE . "(
									`ban_id` SMALLINT(5) UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY , 
									`liste_id` TINYINT(3) DEFAULT '0' NOT NULL , 
									`ban_email` VARCHAR(250) NOT NULL) TYPE=MyISAM;"; 
								$sql_update[] = "CREATE TABLE " . AUTH_ADMIN_TABLE . " (
									`admin_id` tinyint(3) NOT NULL default '0', 
									`liste_id` tinyint(3) NOT NULL default '0', 
									`auth_view` tinyint(1) NOT NULL default '0', 
									`auth_edit` tinyint(1) NOT NULL default '0', 
									`auth_del` tinyint(1) NOT NULL default '0', 
									`auth_send` tinyint(1) NOT NULL default '0', 
									`auth_import` tinyint(1) NOT NULL default '0', 
									`auth_export` tinyint(1) NOT NULL default '0'
									) TYPE=MyISAM;"; 
								$sql_update[] = "ALTER TABLE " . ADMIN_TABLE . " CHANGE `droits` `level` TINYINT(1) NOT NULL default '1'"; 
								break; 
							
							case 'mssql':
								$sql_update[] = "ALTER TABLE " . ABONNES_TABLE . " ADD send smallint NOT NULL, CONSTRAINT [DF_" . ABONNES_TABLE . "_send] DEFAULT (0) FOR [send]"; 
								$sql_update[] = "ALTER TABLE " . LISTE_TABLE . " ADD email_new_inscrit smallint NOT NULL, CONSTRAINT [DF_" . LISTE_TABLE . "_email_new_inscrit] DEFAULT (0) FOR [email_new_inscrit]"; 
								$sql_update[] = "CREATE TABLE " . BANLIST_TABLE . "(
									[ban_id] [smallint] IDENTITY (1, 1) NOT NULL, 
									[liste_id] [smallint] NOT NULL, 
									[ban_email] [varchar] (255) NOT NULL
									) ON [PRIMARY]"; 
								$sql_update[] = "ALTER TABLE [" . BANLIST_TABLE . "] WITH NOCHECK ADD CONSTRAINT [PK_" . BANLIST_TABLE . "] PRIMARY KEY  CLUSTERED ([ban_id]) ON [PRIMARY]"; 
								$sql_update[] = "ALTER TABLE [" . BANLIST_TABLE . "] WITH NOCHECK ADD CONSTRAINT [DF_" . BANLIST_TABLE . "_liste_id] DEFAULT (0) FOR [liste_id]"; 
								$sql_update[] = "CREATE TABLE [" . AUTH_ADMIN_TABLE . "] (
									[admin_id] [smallint] NOT NULL, 
									[liste_id] [smallint] NOT NULL, 
									[auth_view] [smallint] NOT NULL, 
									[auth_edit] [smallint] NOT NULL, 
									[auth_del] [smallint] NOT NULL, 
									[auth_send] [smallint] NOT NULL, 
									[auth_import] [smallint] NOT NULL, 
									[auth_export] [smallint] NOT NULL
									) ON [PRIMARY]"; 
								$sql_update[] = "ALTER TABLE [" . AUTH_ADMIN_TABLE . "] WITH NOCHECK ADD 
									CONSTRAINT [DF_" . AUTH_ADMIN_TABLE . "_admin_id] DEFAULT (0) FOR [admin_id], 
									CONSTRAINT [DF_" . AUTH_ADMIN_TABLE . "_liste_id] DEFAULT (0) FOR [liste_id], 
									CONSTRAINT [DF_" . AUTH_ADMIN_TABLE . "_auth_view] DEFAULT (0) FOR [auth_view], 
									CONSTRAINT [DF_" . AUTH_ADMIN_TABLE . "_auth_edit] DEFAULT (0) FOR [auth_edit], 
									CONSTRAINT [DF_" . AUTH_ADMIN_TABLE . "_auth_del] DEFAULT (0) FOR [auth_del], 
									CONSTRAINT [DF_" . AUTH_ADMIN_TABLE . "_auth_send] DEFAULT (0) FOR [auth_send], 
									CONSTRAINT [DF_" . AUTH_ADMIN_TABLE . "_auth_import] DEFAULT (0) FOR [auth_import], 
									CONSTRAINT [DF_" . AUTH_ADMIN_TABLE . "_auth_export] DEFAULT (0) FOR [auth_export]"; 
								$sql_update[] = "ALTER TABLE " . ADMIN_TABLE . " ADD level smallint NOT NULL, CONSTRAINT [DF_" . ADMIN_TABLE . "_level] DEFAULT (1) FOR [level]";
								break;
						}
						
						$sql = "SELECT liste_id FROM " . LISTE_TABLE;
						if( !($result = $db->query($sql)) )
						{
							$template->assign_block_vars('result', array(
								'TITLE' => '<font color="FF3333">' . $lang['title']['error'] . '</font>', 
								'MSG_RESULT' => 'Impossible d\'obtenir la liste des listes de diffusion' 
							));
						
							$template->pparse('body');
							exit;
						}
						
						while( $rowlist = $db->fetch_array($result) )
						{
							$list[] = $rowlist; 
						}
						$db->free_result($result); 
						
						$sql = "SELECT admin_id, droits FROM " . ADMIN_TABLE;
						if( !($result = $db->query($sql)) )
						{
							$template->assign_block_vars('result', array(
								'TITLE' => '<font color="FF3333">' . $lang['title']['error'] . '</font>', 
								'MSG_RESULT' => 'Impossible d\'obtenir la liste des administrateurs' 
							));
						
							$template->pparse('body');
							exit;
						}
												
						while( $row = $db->fetch_array($result) )
						{
							if( $row['droits'] == 3 )
							{
								$sql_update[] = "UPDATE " . ADMIN_TABLE . " SET level = 2 WHERE admin_id = " . $row['admin_id']; 
								
								for( $i = 0; $i < count($list); $i++ )
								{
									$sql_update[] = "INSERT INTO " . AUTH_ADMIN_TABLE . " (admin_id, liste_id, auth_view, auth_edit, auth_del, auth_send, auth_import, auth_export) 
													 VALUES(" . $row['admin_id'] . ", " . $list[$i]['liste_id'] . ", 1, 1, 1, 1, 1, 1)"; 
								}
							}
							else if( $row['droits'] = 2 ) 
							{
								$sql_update[] = "UPDATE " . ADMIN_TABLE . " SET level = 1 WHERE admin_id = " . $row['admin_id']; 
								for( $i = 0; $i < count($list); $i++ )
								{
									$sql_update[] = "INSERT INTO " . AUTH_ADMIN_TABLE . " (admin_id, liste_id, auth_view, auth_edit, auth_del, auth_send, auth_import, auth_export) 
													 VALUES(" . $row['admin_id'] . ", " . $list[$i]['liste_id'] . ", 1, 0, 1, 1, 0, 0)"; 
								}
							}
							else
							{
								$sql_update[] = "UPDATE " . ADMIN_TABLE . " SET level = 1 WHERE admin_id = " . $row['admin_id']; 
								for( $i = 0; $i < count($list); $i++ )
								{
									$sql_update[] = "INSERT INTO " . AUTH_ADMIN_TABLE . " (admin_id, liste_id, auth_view, auth_edit, auth_del, auth_send, auth_import, auth_export) 
													 VALUES(" . $row['admin_id'] . ", " . $list[$i]['liste_id'] . ", 1, 0, 0, 1, 0, 0)"; 
								}
							}
						}
						
						if( $dbtype == 'mssql' )
						{
							$sql_update[] = "ALTER TABLE " . ADMIN_TABLE . " DROP COLUMN droits"; 
						}
						
						include('../includes/functions.stats.php'); 
						$sql = "SELECT liste_id FROM " . LISTE_TABLE; 
						if( !($result = $db->query($sql)) )
						{
							$template->assign_block_vars('result', array(
								'TITLE' => '<font color="FF3333">' . $lang['title']['error'] . '</font>', 
								'MSG_RESULT' => 'Impossible d\'obtenir la liste des listes de diffusion' 
							));
						
							$template->pparse('body');
							exit;
						}
						
						while( $row = $db->fetch_array($result) )
						{
							create_stats($row['liste_id']); 
						}
					
					case '2.1Beta':
					case '2.1Beta2':
						$sql_update[] = "INSERT INTO " . CONFIG_TABLE . " (nom, valeur) VALUES('date_format', 'j F Y H:i')"; 
					
					case '2.1.0':
					case '2.1.1':
					case '2.1.2':
						break; 
					
					default:
						$template->assign_block_vars('result', array(
							'TITLE' => $lang['title']['result_upgrade'], 
							'MSG_RESULT' => $lang['update_not_required'] 
						));
							
						$template->pparse('body');
						exit;
						break;
				}
				
				$sql_update[] = "UPDATE " . CONFIG_TABLE . " SET valeur = '$language' WHERE nom = 'language'";
				$sql_update[] = "UPDATE " . CONFIG_TABLE . " SET valeur = '$new_version' WHERE nom = 'version'";
				
				for( $i = 0; $i < count($sql_update); $i++ )
				{
					$result = $db->query($sql_update[$i]); 
					
					if( !$result )
					{
						$sql_error = $db->sql_error();
					
						$template->assign_block_vars('result', array(
							'TITLE' => '<font color="FF3333">' . $lang['title']['error'] . '</font>', 
							'MSG_RESULT' => nl2br(sprintf($lang['error_update'], $sql_error['error'])) 
						));
						
						$template->pparse('body');
						exit;
					}
				}
			}
		}// fin de if update
		
		$db->close_connexion();	
		
		if( !$error )
		{
			$title_result = ( $install ) ? $lang['title']['result_install'] : $lang['title']['result_upgrade']; 
			
			if( $install || ( $update && $create_config_file ) )
			{
				$config_file  = "<?php \n\n";
				$config_file .= "//\n";
				$config_file .= "// Paramtres d'accs  la base de donnes \n";
				$config_file .= "// Ne pas modifier ! \n";
				$config_file .= "//\n";
				$config_file .= "define('NL_INSTALLED', true);\n\n"; 
				$config_file .= "\$dbtype = \"$dbtype\"; \n\n";
				$config_file .= "\$dbhost = \"$dbhost\"; \n";
				$config_file .= "\$dbuser = \"$dbuser\"; \n";
				$config_file .= "\$dbpassword = \"$dbpassword\"; \n";
				$config_file .= "\$dbname = \"$dbname\"; \n\n";
				$config_file .= "\$prefixe = \"$prefixe\"; \n\n";
				$config_file .= "?>";
				
				@chmod($waroot . "includes/config.inc.php", 0666);
				//
				// Cration du fichier config.inc.php 
				//
				if( !($fp = @fopen($waroot . "includes/config.inc.php", "w")) )
				{
					$msg_result = ( $install ) ? $lang['success_install_whithout_config'] : $lang['success_update_whithout_config']; 
					
					$s_hidden_fields  = '<input type="hidden" name="prestart" value="1" />'; 
					$s_hidden_fields .= '<input type="hidden" name="dbtype" value="' . $dbtype . '" />'; 
					$s_hidden_fields .= '<input type="hidden" name="dbhost" value="' . $dbhost . '" />'; 
					$s_hidden_fields .= '<input type="hidden" name="dbuser" value="' . $dbuser . '" />'; 
					$s_hidden_fields .= '<input type="hidden" name="dbpwd" value="' . $dbpassword . '" />'; 
					$s_hidden_fields .= '<input type="hidden" name="dbname" value="' . $dbname . '" />'; 
					$s_hidden_fields .= '<input type="hidden" name="prefixe" value="' . $prefixe . '" />'; 
					
					$template->assign_block_vars('result_bis', array(
						'TITLE' => $title_result, 
						'MSG_RESULT' => nl2br($msg_result), 
						'L_BUTTON_DL' => $lang['button']['dl'], 
						
						'S_HIDDEN_FIELDS' => $s_hidden_fields 
					));
						
					$template->pparse('body');
					exit;
				}

				fwrite($fp, $config_file);
				fclose($fp);
				
				@chmod("../includes/config.inc.php", 0644);
			}
			
			$msg_result = ( $install ) ? $lang['success_install'] : $lang['success_upgrade']; 
			
			$template->assign_block_vars('result', array(
				'TITLE' => $title_result, 
				'MSG_RESULT' => nl2br(sprintf($msg_result, '<a href="../admin/login.php">', '</a>')) 
			));
						
			$template->pparse('body');
			exit;
		}		
	}
	
	$domaine 		= ( !empty($HTTP_SERVER_VARS['SERVER_NAME']) ) ? $HTTP_SERVER_VARS['SERVER_NAME'] : ''; 
	$script_path 	= ( !empty($HTTP_SERVER_VARS['PHP_SELF']) ) ? $HTTP_SERVER_VARS['PHP_SELF'] : ''; 
	$script_path 	= ( $script_path != '' ) ? substr($script_path, 0, strlen($script_path) - 17) : ''; 
	
	$s_hidden_field = '<input type="hidden" name="language" value="' . $language .'" />';
	$s_hidden_field .= '<input type="hidden" name="type" value="' . $type . '" />';
	$s_hidden_field .= '<input type="hidden" name="prestart" value="1" />';
	
	$template->assign_block_vars('form', array(
		'TITLE_INSTALL_ADMIN' => $lang['title']['install_admin'], 
		'L_ADMIN_USER' => $lang['login'], 
		'L_ADMIN_PWD' => $lang['password'], 
		'L_ADMIN_PWD_CONFIRM' => $lang['admin_pwd_confirm'], 
		'L_BUTTON_INSTALL' => $lang['button']['install'], 
		
		'ADMIN_USER' => stripslashes($admin_user), 
		'S_HIDDEN_FIELD' => $s_hidden_field  
	));
	
	if( $install || $upgrade )
	{
		$template->assign_block_vars('form.install_or_upgrade', array(
			'TITLE_INSTALL_DB' => $lang['title']['install_db'], 
			'TITLE_INSTALL_CONFIG' => $lang['title']['install_config'], 
			'L_DBTYPE' => $lang['dbtype'], 
			'L_DBHOST' => $lang['dbhost'], 
			'L_DBNAME' => $lang['dbname'], 
			'L_DBUSER' => $lang['dbuser'], 
			'L_DBPWD' => $lang['dbpwd'], 
			'L_PREFIXE' => $lang['prefixe'], 
			'L_SITENAME' => $lang['sitename'], 
			'L_URLSITE' => $lang['url_site'], 
			'L_URLSITE_NOTE' => $lang['url_site_note'], 
			'L_URLSCRIPT' => $lang['url_script'], 
			'L_URLSCRIPT_NOTE' => $lang['url_script_note'], 
			'L_SENDER_EMAIL' => $lang['sender_email'], 
			'L_ADMIN_EMAIL' => $lang['admin_email'], 
			
			'DBHOST' => htmlspecialchars(stripslashes($dbhost)), 
			'DBNAME' => htmlspecialchars(stripslashes($dbname)), 
			'DBUSER' => htmlspecialchars(stripslashes($dbuser)), 
			'PREFIXE' => ( !empty($prefixe) ) ? htmlspecialchars(stripslashes($prefixe)) : 'wa_', 
			'SITENAME' => htmlspecialchars(stripslashes($sitename)), 
			'URLSITE' => ( !empty($urlsite) ) ? htmlspecialchars(stripslashes($urlsite)) : 'http://' . $domaine, 
			'URLSCRIPT' => ( !empty($urlscript) ) ? htmlspecialchars(stripslashes($urlscript)) : $script_path, 
			'SENDER_EMAIL' => htmlspecialchars(stripslashes($sender_email)), 
			'ADMIN_EMAIL' => htmlspecialchars(stripslashes($admin_email)) 
		));
	}
	
	if( $error )
	{
		$template->assign_block_vars('form.error', array(
			'MSG_ERROR' => $msg_error 
		));
	}
}

$template->pparse('body'); 
?>