<?php
/*******************************************************************
 *			
 * 			Fichier			:	functions.session.php 
 * 			Cr le			:	21 octobre 2002 
 * 			Dernire modif	:	31 janvier 2003 
 * 			Email			:	wascripts@phpcodeur.net 
 * 
 * 				 Copyright 2002-2003 PHPcodeur
 * 
 *******************************************************************/

/*******************************************************************
 *  This program is free software; you can redistribute it and/or 
 * 	modify it under the terms of the GNU General Public License as 
 * 	published by the Free Software Foundation; either version 2 of 
 *  the License, or (at your option) any later version. 
 *******************************************************************/


if( !defined('FUNCTIONS_SESSION_INC') )
{

define('FUNCTIONS_SESSION_INC', 1); 

//////////////////////////////////////////////////////////////
//
// Fonctions utilises pour les sessions sur l'administration.
//

//
// Ouverture d'une session.
//
// session_open prend l'identifiant de l'utilisateur comme argument.
//
function session_open($admin_id)
{
	global $newsletter_config, $HTTP_COOKIE_VARS, $HTTP_GET_VARS, $SESSID, $db;
	
	$sql = "SELECT * FROM " . ADMIN_TABLE . " 
		WHERE admin_id = '$admin_id'";
	if( !($result = $db->query($sql)) )
	{
		message(GENERAL_ERROR, 'Impossible d\'obtenir des informations sur l\'utilisateur', __FILE__, __LINE__, $sql);
	}
	
	if( $admindata = $db->fetch_array($result) )
	{
		$starttime  = time();
		$session_id = md5(uniqid($admindata['user']));
		
		$sql = "UPDATE " . SESSION_TABLE . " 
				SET session_id = '$session_id', 
			    	session_start = $starttime, 
					session_time = $starttime 
				WHERE admin_id = " . $admin_id;	
		if( !$db->query($sql) )
		{
			message(CRITICAL_ERROR, 'Impossible de mettre  jour la session', __FILE__, __LINE__, $sql);
		}
	
		if( !$db->affected_rows() )
		{	
			$sql = "INSERT INTO " . SESSION_TABLE . " (session_id, admin_id, session_start, session_time) 
					VALUES('$session_id', $admin_id, $starttime, $starttime)"; 
			if( !$db->query($sql) )
			{
				message(CRITICAL_ERROR, 'Impossible de dmarrer la session', __FILE__, __LINE__, $sql);
			}
		}
		
		setcookie('wanewsletter_sessid', $session_id, 0, '/'); 
		
		$SESSID = 'sessid=' . $session_id; 
		
		return true; 
	}
	
	return false; 
}

//
// Vrification de l'existence d'une session grce  l'identifiant de session
// obtenu par dfaut via le cookie, ou, si les cookies ne sont pas accepts par le navigateur, 
// via l'url.
//
function session_verif()
{
	global $newsletter_config, $lang, $HTTP_COOKIE_VARS, $HTTP_GET_VARS, $SESSID, $db;
	
	if( isset($HTTP_COOKIE_VARS['wanewsletter_sessid']) )
	{
		$session_id = isset($HTTP_COOKIE_VARS['wanewsletter_sessid']) ? $HTTP_COOKIE_VARS['wanewsletter_sessid'] : '';
		$method = 'COOKIE';
	}
	else
	{
		$session_id = isset($HTTP_GET_VARS['sessid']) ? $HTTP_GET_VARS['sessid'] : '';
		$method = 'GET';
	}
	
	$current_time = time(); 
	
	if( !empty($session_id) )
	{
		//
		// On rcupre les infos sur la session et l'utilisateur 
		//
		$sql = "SELECT a.*, s.* 
			FROM " . ADMIN_TABLE . " AS a, " . SESSION_TABLE . " AS s 
			WHERE a.admin_id = s.admin_id 
			  AND s.session_id = '$session_id'";	
		if( !($result = $db->query($sql)) )
		{
			$message = 'Impossible d\'obtenir des informations sur la session et sur l\'utilisateur';
			message(CRITICAL_ERROR, $message, __FILE__, __LINE__, $sql); 
		}
		
		if( $admindata = $db->fetch_array($result) )
		{
			$SESSID = ( $method == 'GET' ) ? 'sessid=' . $session_id : ''; 
			
			if( $current_time - $admindata['session_time'] > 60 )
			{
				$sql = "UPDATE " . SESSION_TABLE . " 
					SET session_time = $current_time 
					WHERE session_id = '$session_id'";
				if( !$db->query($sql) )
				{
					message(CRITICAL_ERROR, 'Impossible de mettre  jour la session', __FILE__, __LINE__, $sql);
				}
				
				setcookie('wanewsletter_sessid', $session_id, 0, '/'); 
			}
			
			//
			// Suppression des sessions primes 
			//
			$limit_time = $current_time - $newsletter_config['session_duree']; 
			
			$sql = "DELETE FROM " . SESSION_TABLE . " 
				WHERE session_time < $limit_time 
				  AND session_id <> '$session_id'"; 
			if( !$db->query($sql) )
			{
				message(CRITICAL_ERROR, 'Impossible de nettoyer la table des sessions', __FILE__, __LINE__, $sql);
			}
			
			return $admindata; 
		}
	}
	
	return false; 
}

//
// Fermeture de la session en cours.
//
function session_close()
{
	global $newsletter_config, $HTTP_COOKIE_VARS, $HTTP_GET_VARS, $SESSID, $db;
	
	if( isset($HTTP_COOKIE_VARS['wanewsletter_sessid']) )
	{
		$session_id = isset($HTTP_COOKIE_VARS['wanewsletter_sessid']) ? $HTTP_COOKIE_VARS['wanewsletter_sessid'] : '';
	}
	else
	{
		$session_id = isset($HTTP_GET_VARS['sessid']) ? $HTTP_GET_VARS['sessid'] : '';
	}
	
	if( !empty($session_id) )
	{
		$sql = "DELETE FROM " . SESSION_TABLE . " 
			WHERE session_id = '$session_id'";
		if( !$db->query($sql) )
		{
			message(GENERAL_ERROR, 'Impossible de clotrer la session', __FILE__, __LINE__, $sql);
		}
	}
	
	setcookie('wanewsletter_sessid', '', time() - 84600, '/'); 
}

//
// Ajout de l'identifiant de session s'il est transmis par l'url.
//
function sessid($url)
{
	global $SESSID;
	
	if ( $SESSID != '' && !strstr('sessid=', $url) )
	{
		$url .= ( ( strpos($url, '?') ) ?  '&' : '?' ) . $SESSID;
	}

	return($url);
}

//
// Fin des fonctions de session.
//
//////////////////////////////////////////////////////////////
}
?>