<?php 
/*******************************************************************
 *			
 * 			Fichier			:	functions.php 
 * 			Cr le			:	27 mars 2002 
 * 			Dernire modif	:	04 mars 2003 
 * 			Email			:	wascripts@phpcodeur.net 
 * 
 * 				 Copyright 2002-2003 PHPcodeur
 * 
 *******************************************************************/

/*******************************************************************
 *  This program is free software; you can redistribute it and/or 
 * 	modify it under the terms of the GNU General Public License as 
 * 	published by the Free Software Foundation; either version 2 of 
 *  the License, or (at your option) any later version. 
 *******************************************************************/


//
// Fonction de redirection du script 
// - Ajout ventuel de l'identifiant de session 
// - URL absolue, d'aprs les specifications HTTP/1.1 
//
function Location($url)
{
	global $HTTP_SERVER_VARS; 
	
	$use_refresh = @preg_match("#Microsoft|WebSTAR|Xitami#", $HTTP_SERVER_VARS['SERVER_SOFTWARE']); 
	$header_location = ( $use_refresh ) ? 'Refresh: 0; URL=' : 'Location: '; 
	
	$dirname  = dirname($HTTP_SERVER_VARS['PHP_SELF']); 
	$dirname .= ( substr($dirname, -1) == '/' ) ? '' : '/'; 
	
	$absolute_url  = 'http://' . $HTTP_SERVER_VARS['HTTP_HOST']; 
	$absolute_url .= ( $HTTP_SERVER_VARS['SERVER_PORT'] != 80 ) ? ':' . $HTTP_SERVER_VARS['SERVER_PORT'] : ''; 
	$absolute_url .= $dirname . str_replace('&amp;', '&', $url); 
	
	header($header_location . $absolute_url); 
	exit;
}


//
// vrification 
//
// note : Obtenu sur phpinfo.net, section trucs et astuces. (pour regex email)
//
function EmailOK($email)
{
	return ereg('^[-!#$%&\'*+\\./0-9=?A-Z^_`a-z{|}~]+'.
			    '@'.'[-!#$%&\'*+\\/0-9=?A-Z^_`a-z{|}~]+\.'.
			    '[-!#$%&\'*+\\./0-9=?A-Z^_`a-z{|}~]+$', $email); 
}

function check_email($email, $liste, $hash)
{
	global $db, $lang; 
	
	if( !ereg('^[-!#$%&\'*+\\./0-9=?A-Z^_`a-z{|}~]+'.
			  '@'.'[-!#$%&\'*+\\/0-9=?A-Z^_`a-z{|}~]+\.'.
			  '[-!#$%&\'*+\\./0-9=?A-Z^_`a-z{|}~]+$', $email) )
	{
		return array('error' => true, 'message' => $lang['info_msg']['invalid_email']);
	}
	
	//$statut = ( $hash ) ? ABO_ACTIF : ABO_INACTIF; 
	
	$sql = "SELECT email 
			FROM " . ABONNES_TABLE . " 
			WHERE LOWER(email) = '" . strtolower($email) . "' 
			  AND liste_id = '$liste'"; 
	if( $result = $db->query($sql) )
	{
		if( $db->num_rows($result) && !$hash )
		{
			return array('error' => true, 'message' => $lang['info_msg']['allready_suscribe']); 
		}
		
		if( !($db->num_rows($result)) && $hash )
		{
			return array('error' => true, 'message' => $lang['info_msg']['unknow_email']); 
		}
	}
	
	$sql = "SELECT ban_email 
			FROM " . BANLIST_TABLE . " 
			WHERE liste_id = '$liste'"; 
	if( $result = $db->query($sql) )
	{
		while( $row = $db->fetch_array($result) )
		{
			if( preg_match("/\b(" . str_replace("*", ".*?", $row['ban_email']) . ")\b/i", $email) )
			{
				return array('error' => true, 'message' => $lang['info_msg']['Email_banned']);
			}
		}
	}
	
	return array('error' => false, 'message' => ''); 
}


//
// Retourne un identifiant unique.
//
function get_code()
{    
    return substr( md5( uniqid( rand() ) ), 0, 16); 
} 

//
// Fonction de retour de messages d'informations ou d'erreur sur l'admin.
//
function message($type, $text, $file = '', $line = '', $query = '')
{
	global $lang, $newsletter_config, $meta, $waroot, $template, $db, $datalang; 
	
	$debug_text = ''; 
	
	if( $type == CRITICAL_ERROR || $type == GENERAL_ERROR || $type == ERROR )
	{
		if( $query != '' )
		{
			$sql_error = $db->sql_error();
			
			$debug_text .= '<u>SQL errno</u> : ' . $sql_error['errno'] . '<br /><u>SQL error</u> : ' . $sql_error['error'] . '<br /><br />';
			$debug_text .= '<u>SQL query</u> : <br /><br /> ' . nl2br($query) . ' <br /><br />';
		}
		
		if( $file != '' && $line != '' )
		{
			$debug_text .= '<u>Fichier</u> : ' . basename($file) . ' <br /><u>Ligne</u> : ' . $line . ' <br />';
		}
	}
	
	$msg_text = $text . ( ( $debug_text != '' ) ? '<br /><br />' . $debug_text : '' ); 
	
	switch($type)
	{
		case CRITICAL_ERROR:
			$msg_title = 'Erreur critique'; 
			break;
		
		case GENERAL_ERROR:
			$display_menu = false; 
			$msg_title    = 'Erreur gnrale !'; 
			$file_error   = 'general_error.tpl'; 
			break;
		
		case ERROR: 
			$display_menu = true; 
			$msg_title    = '<span style="color: #FF3333">' . $lang['title']['error'] . '</span>'; 
			$file_error   = 'error.tpl'; 
			break;
		
		case INFO: 
			$display_menu = true; 
			$msg_title    = '<span style="color: #33BB33">' . $lang['title']['info'] . '</span>'; 
			$file_error   = 'error.tpl'; 
			break;
	}
	
	if( $type != CRITICAL_ERROR )
	{
		if( !defined('HEADER_INC') )
		{
			define('MENU', $display_menu);
			include('page_header.php');
		}
				
		$template->set_filenames(array(
			'body' => $file_error 
		));
			
		$template->assign_vars( array(
			'TITLE' => $msg_title, 
			'TEXTE' => $msg_text 
		));
		
		$template->pparse('body');
		
		include('page_footer.php');	
	}
	else
	{
		echo '<html><body><b>' . $msg_title . '</b><br /><br />'; 
		echo $msg_text . '</body></html>'; 
	}
	
	exit;
}

//
// Fonction d'affichage par page.
//
// $url -> adresse vers laquelle doivent pointer les liens de navigation
// $total_num -> nombre total d'lments  afficher
// $num_per_page -> nombre d'lments par page
// $page_id -> identifiant de la page en cours
//
function navigation($url, $total_num, $num_per_page, $page_id)
{
	global $lang;
	
	$total_pages = ceil($total_num / $num_per_page);
	
	// premier caractre de l'url au moins en position 1 
	// on place un espace  la position 0 de la chane
	$url = ' ' . $url; 
	
	$url = ( strpos($url, '?') ) ? $url . '&amp;' : $url . '?'; 
	
	// suppression de l'espace prcdemment ajout 
	$url = substr($url, 1); 
	
	if( $total_pages == 1 )
	{
		return '';
	}
	
	$nav_string = '';
		
	if( $total_pages > 10 )
	{
		if( $page_id > 10 )
		{
			$prev = $page_id - 1; 
			while( substr($prev, -1, 1) != 0 )
			{
				$prev -= 1; 
			}
			
			$nav_string .= '<a href="' . $url . 'page=' . $prev . '">' . $lang['prev'] . '</a> &nbsp;&nbsp;';
		}
		
		$current = $page_id;
		while( substr($current, -1, 1) != 1 )
		{
			$current -= 1; 
		}
		
		for( $i = $current; $i < $current + 10; $i++ )
		{
			if( $i < $total_pages + 1 )
			{
				$nav_string .= ( $i == $page_id ) ? '<b>' . $i . '</b>' : '<a href="' . $url . 'page=' . $i . '">' . $i . '</a>';
				if ( $i <  $current + 9 && $i < $total_pages )
				{
					$nav_string .= ', ';
				}
			}
		}
		
		$page_max = $page_id; 
		while( substr($page_max, -1, 1) != 0 )
		{
			$page_max += 1; 
		}			
		$next = $page_max + 1; 
		
		if( $total_pages >= $next )
		{
			$nav_string .= '&nbsp;&nbsp; <a href="' . $url . 'page=' . $next . '">' . $lang['next'] . '</a>';
		}
	}
	else
	{
		for( $i = 1; $i < $total_pages + 1; $i++ )
		{
			$nav_string .= ( $i == $page_id ) ? '<b>' . $i . '</b>' : '<a href="' . $url . 'page=' . $i . '">' . $i . '</a>';

			if ( $i <  $total_pages )
			{
				$nav_string .= ', ';
			}
		}
	}
	
	return $nav_string;
}

//
// Fonction de renvoi de date selon la langue
//
// variables d'entre : 
// $timestamp = contient le timestamp  convertir
// 
// En sortie, une date formate 
//
function convert_time($timestamp)
{
	global $newsletter_config, $datetime; 	
	static $orig_array, $replace_array; 
	
	if( !isset($orig_array) || !isset($replace_array) )
	{
		$orig_array = array(); 
		$replace_array = array(); 
		while( list($orig_word, $replace_word) = each($datetime) )
		{
			$orig_array[] = '/\b' . $orig_word . '\b/i'; 
			$replace_array[] = $replace_word; 
		}
	}
	
	return preg_replace($orig_array, $replace_array, date($newsletter_config['date_format'], $timestamp)); 
}

//
// Liste droulante des diffrentes langues disponibles 
//
function lang_box($value = '')
{
	global $waroot; 
	
	$lang_box = "<select name=\"language\">\n"; 
	
	$res = @opendir($waroot . 'language/'); 
	
	while( $folder = @readdir($res) ) 
	{
		if( $folder != '.' && $folder != '..' && !strpos($folder, '.') )
		{
			$selected = ( $value == $folder ) ? ' selected="selected"' : ''; 
			$lang_box .= '<option value="' . $folder . '"' . $selected . '> - ' . $folder . " - </option>\n";
		}
	}
	
	$lang_box .= "</select>\n"; 
	@closedir($res); 
	
	return $lang_box; 
}

//
// Construction de la liste droulante pour les listes de diffusion selon les permissions 
// Option $jump  true changement de page sur changement
// Option $restrict_where si seulement listes qui demandent confirmation 
// Option $default_value si doit apparaitre en premire option "toutes les listes"
//
function list_box($auth_type, $jump = false, $restrict_where = false, $default_value = false)
{
	global $admindata, $db, $lang, $liste; 
	
	switch($auth_type)
	{
		case AUTH_VIEW: 
			$auth_name = 'auth_view'; 
			break; 
		case AUTH_EDIT: 
			$auth_name = 'auth_edit'; 
			break;
		case AUTH_DEL: 
			$auth_name = 'auth_del'; 
			break;
		case AUTH_SEND: 
			$auth_name = 'auth_send'; 
			break;
		case AUTH_IMPORT: 
			$auth_name = 'auth_import'; 
			break;
		case AUTH_EXPORT: 
			$auth_name = 'auth_export'; 
			break;
	}
	
	$is_auth = obtain_auth($auth_type, ALL_LIST); 
	
	if( !count($is_auth['all_list'][$auth_name]) )
	{
		return false; 
	}
	
	$liste_in = implode(', ', $is_auth['all_list'][$auth_name]); 
	
	$sql_where = ''; 
	if( $restrict_where )
	{
		$sql_where = 'AND email_confirm = 1'; 
	}
	
	$sql = "SELECT liste_id, nom 
			FROM " . LISTE_TABLE . " 
			WHERE liste_id IN($liste_in) $sql_where 
			ORDER BY nom";
	if( !($result = $db->query($sql)) )
	{
		message(ERROR, 'Impossible d\'obtenir des infos sur les listes de diffusion', __FILE__, __LINE__, $sql);
	}
	
	$total_list = $db->num_rows($result);
		
	if( $total_list > 1 )
	{
		if( $jump )
		{
			$list_box = '<select name="listediff" onchange="jumpliste(this.value);">'; 
			$list_box .= '<option value="0"> - ' . $lang['all_list'] . ' - </option>'; 
		}
		else
		{
			$list_box = '<select name="liste">'; 
			if( $default_value )
			{
				$list_box .= '<option value="-1"> - ' . $lang['all_list'] . ' - </option>'; 
			}
		}
		
		while( $row = $db->fetch_array($result) )
		{
			$nom = stripslashes($row['nom']);
			if( strlen($nom) > 40 )
			{ 
				$nom   = substr($nom, 0, 40); 
				$space = strrpos($nom, ' '); 
				$nom   = substr($nom, 0, $space); 
				$nom  .= '...'; 
			}
			
			$selected = ( $liste == $row['liste_id'] ) ? ' selected="selected"' : ''; 		
			$list_box .= '<option value="' . $row['liste_id'] . '"' . $selected . '> - ' . htmlspecialchars($nom) . ' - </option>'; 
		}
		
		$list_box .= '</select>'; 
	}
	else if( $total_list == 1 )
	{
		$row = $db->fetch_array($result); 	
		$list_box = htmlspecialchars(stripslashes($row['nom'])); 
		$list_box .= '<input type="hidden" name="liste" value="' . $row['liste_id'] . '" />'; 
		$liste = $row['liste_id']; 
	}
	else
	{
		return false; 
	}

	$db->free_result($result); 
	
	return $list_box;
}

//
// Purge de la table des abonns 
//
function auto_purge()
{
	global $newsletter_config, $db; 
	
	$sql = "SELECT liste_id, limitevalidate 
			FROM " . LISTE_TABLE . " 
			WHERE email_confirm = 1"; 
	$result = $db->query($sql); 
	
	while( $row = $db->fetch_array($result) )
	{
		$limit_time = time() - ( $row['limitevalidate'] * 86400 ); 
		
		$sql2 = "DELETE FROM " . ABONNES_TABLE . " 
				WHERE liste_id = " . $row['liste_id'] . " 
				  AND actif = " . ABO_INACTIF . " 
				  AND date < $limit_time"; 
		$result2 = $db->query($sql2); 
	}
	
	$db->query("OPTIMIZE TABLE `" . ABONNES_TABLE . "`");
	
	$purge_next = time() + ( $newsletter_config['purge_freq'] * 86400 ); 
	
	$sql = "UPDATE " . CONFIG_TABLE . " 
			SET valeur = $purge_next 
			WHERE nom = 'purge_next'"; 
	$db->query($sql); 
}

//
// Parsing d'un fichier sql 
//
function _sql_array($input, $glue, $prefixe)
{
	$comments = false;
	$output = array();
	$lines = explode("\n", $input);
	
	$total_lines = count($lines);
	
	for( $i = 0; $i < $total_lines; $i++ )
	{
		if( preg_match("#^/\*#", $lines[$i]) )
		{
			$comments = true;
		}
		
		if( !$comments )
		{
			if( strlen($lines[$i]) > 0 && $lines[$i][0] != '#' )
			{
				$output[] .= $lines[$i] . "\n";
			}
		}
		
		if( preg_match("#\*/$#", $lines[$i]) )
		{
			$comments = false;
		}
	}
	
	$output = preg_replace('/wa_/', $prefixe, $output);
	
	$content = implode('', $output);
	
	$output = explode($glue, $content);
	
	return $output;
}

// 
// Simulation de la configuration magic_quotes_gpc  on 
//
function emul_magic_quotes_gpc(&$data)
{
	if( is_array($data) )
	{
		reset($data); 
		while( list($key, $value) = each($data) )
		{
			if( is_array($value) )
			{
				emul_magic_quotes_gpc($value); 
			}
			else
			{
				$data[$key] = addslashes($value); 
			}
		}
	}
}
?>