<?php
/*******************************************************************
 *			
 * 			Fichier			:	view.php 
 * 			Cr le			:	17 juillet 2002 
 * 			Dernire modif	:	31 janvier 2003 
 * 			Email			:	wascripts@phpcodeur.net 
 * 
 * 				 Copyright 2002-2003 PHPcodeur
 * 
 *******************************************************************/

/*******************************************************************
 *  This program is free software; you can redistribute it and/or 
 * 	modify it under the terms of the GNU General Public License as 
 * 	published by the Free Software Foundation; either version 2 of 
 *  the License, or (at your option) any later version. 
 *******************************************************************/


define('IN_NEWSLETTER', true); 
define('PAGE', basename(__FILE__) . '?mode=' . $HTTP_GET_VARS['mode']); 

$waroot = '../'; 
require('./pagestart.php');

$mode = ( !empty($HTTP_GET_VARS['mode']) ) ? $HTTP_GET_VARS['mode'] : ''; 
//
// si aucun mode
//
if( $mode == '' )
{
	Location(sessid("index.php")); 
}

$ajout 		= ( isset($HTTP_POST_VARS['ajout']) ) ? true : false;
$modif	 	= ( isset($HTTP_POST_VARS['modif']) ) ? true : false;
$delete 	= ( isset($HTTP_POST_VARS['delete']) ) ? true : false; 
$search 	= ( isset($HTTP_POST_VARS['search']) ) ? true : false;
$confirm 	= ( isset($HTTP_POST_VARS['confirm']) ) ? true : false;
$liste 		= ( !empty($HTTP_GET_VARS['liste']) ) ? intval($HTTP_GET_VARS['liste']) : 0; 

if( isset($HTTP_POST_VARS['cancel']) )
{
	Location(sessid("view.php?mode=" . $mode)); 
}

$ask_list = ( !$liste ) ? ALL_LIST : $liste; 
$is_auth = obtain_auth(AUTH_ALL, $ask_list); 

if( ( !$liste && !count($is_auth['all_list']['auth_view']) && $mode != 'liste' ) || $liste && !$is_auth[$liste]['auth_view'] )
{
	$meta = '<meta http-equiv="refresh" content="6;url=' . sessid("index.php") . '">'; 
	$message = $lang['info_msg']['not_auth']; 
	message(INFO, $message); 
}

$list_box = list_box(AUTH_VIEW, true); 

if( !$list_box )
{
	$meta = '<meta http-equiv="refresh" content="6;url=' . sessid("index.php") . '">'; 
	$message = $lang['info_msg']['not_confirm']; 
	message(INFO, $message); 
}

$sql_where = '';
$sql_search = '';
$varget = '';

//
// mode download : tlchargement des fichiers joints  un log
//
if( $mode == 'download' && !empty($HTTP_GET_VARS['file']) )
{
	header("Content-type: application/force-download"); 
	header("Content-Disposition: attachment; filename=" . $HTTP_GET_VARS['file']); 
	readfile('upload/' . $HTTP_GET_VARS['file']); 
}

//
// mode iframe pour visualiser les logs.
//
else if( $mode == 'iframe' && isset($HTTP_GET_VARS['id']) )
{
	include('../includes/iframe.php');
	exit;
}

//
// Mode abonns.
//
else if( $mode == 'abonnes' )
{
	if( $liste )
	{
		$varget .= '&liste=' . $liste;
		$sql_where = "AND liste_id = '$liste'";
	}
	else
	{
		$liste_in = implode(", ", $is_auth['all_list']['auth_view']); 
		$sql_where = "AND liste_id IN($liste_in)"; 
	}
	
	if( $delete )
	{
		$abonnes = ( !empty($HTTP_POST_VARS['abonne']) ) ? $HTTP_POST_VARS['abonne'] : array(); 
		
		if( $confirm )
		{
			if( count($abonnes) )
			{
				$list_abo_id = implode(", ", $abonnes); 
			
				$sql = "DELETE FROM " . ABONNES_TABLE . " 
						WHERE id IN ($list_abo_id)";
				if( !($result = $db->query($sql)) )
				{
					message(ERROR, 'La suppression des abonns a chou', __FILE__, __LINE__, $sql);
				}
			}
		
			Location(sessid("view.php?mode=abonnes" . $varget)); 
		}
		else
		{
			$hidden_fields = '<input type="hidden" name="delete" value="1" />'; 
			for( $i = 0; $i < count($abonnes); $i++ )
			{
				$hidden_fields .= '<input type="hidden" name="abonne[]" value="' . $abonnes[$i] . '" />'; 
			}
	
			define('MENU', true);
			include('page_header.php');	
		
			$template->set_filenames(array(
				'body' => 'confirm.tpl'
			)); 
	
			$template->assign_vars( array(
				'TITLE' => $lang['title']['confirm'], 
				'L_TEXT_CONFIRM' => $lang['info_msg']['confirm_del_abo'], 
				'L_YES' => $lang['yes'], 
				'L_NO' => $lang['no'], 
			
				'HIDDEN_FIELDS' => $hidden_fields, 
				'U_FORM' => sessid("view.php?mode=abonnes" . $varget) 
			)); 
	
			$template->pparse('body'); 
		
			include('page_footer.php'); 
			exit; 
		}
	}
	
	$abo_per_page = 40; 
			
	//
	// Si la fonction de recherche est sollicite
	//	
	$search_keyword = ''; 
	$search_date = 0; 
	if( $search || !empty($HTTP_GET_VARS['keyword']) || !empty($HTTP_GET_VARS['days']) )
	{
		if( $search )
		{
			$search_keyword = ( !empty($HTTP_POST_VARS['keyword']) ) ? $HTTP_POST_VARS['keyword'] : ''; 
			$search_date	= ( !empty($HTTP_POST_VARS['days']) ) ? intval($HTTP_POST_VARS['days']) : ''; 
			
			if( strlen($search_keyword) > 0 )
			{
				$varget .= '&keyword=' . urlencode($search_keyword); 				
				$sql_search .= " AND email LIKE '" . str_replace("*", "%", urldecode($search_keyword) ) . "' ";
			}
			
			if( $search_date != 'all' )
			{
				$varget .= '&days=' . $search_date;
				$sql_search .= " AND date > '" . ( time() - ( $search_date * 84600 ) ) . "' ";	
			}
		}
		else
		{
			$search_keyword = ( !empty($HTTP_GET_VARS['keyword']) ) ? $HTTP_GET_VARS['keyword'] : ''; 
			$search_date	= ( !empty($HTTP_GET_VARS['days']) ) ? intval($HTTP_GET_VARS['days']) : ''; 
			
			if( strlen($search_keyword) > 0 )
			{
				$varget .= '&keyword=' . urlencode($search_keyword);
				$sql_search .= " AND email LIKE '" . str_replace("*", "%", urldecode($search_keyword) ) . "' ";				
			}
			
			if( ereg("^[0-9]+$", $search_date) )
			{
				$varget .= '&days=' . $search_date;
				$sql_search .= " AND date > '" . ( time() - ( $search_date * 84600 ) ) . "' ";				
			}
		}
	}
	
	$sql = "SELECT COUNT(id) AS total_abo 
			FROM " . ABONNES_TABLE . " 
			WHERE actif = " . ABO_ACTIF . " 
			  $sql_where $sql_search"; 
	if( !($result = $db->query($sql)) )
	{
		message(ERROR, 'Impossible d\'obtenir le nombre d\'abonns', __FILE__, __LINE__, $sql);
	}
	
	$total_abo = $db->result($result, 0, "total_abo"); 
	$db->free_result($result);
	
	$page = ( isset($HTTP_GET_VARS['page']) ) ? intval($HTTP_GET_VARS['page']) : 1;		
	$start = ( ( $page - 1 ) * $abo_per_page );
	
	//
	// classement
	//
	$type = ( !empty($HTTP_POST_VARS['type']) ) ? $HTTP_POST_VARS['type'] : ( ( !empty($HTTP_GET_VARS['type']) ) ? $HTTP_GET_VARS['type'] : '' ); 
	
	if( $type == 'email' || $type == 'date' || $type == 'format' )
	{
		$varget .= '&type=' . $type; 
	}
	else
	{
		$type = 'date'; 
	}
	
	$order = ( !empty($HTTP_POST_VARS['order']) ) ? $HTTP_POST_VARS['order'] : ( ( !empty($HTTP_GET_VARS['order']) ) ? $HTTP_GET_VARS['order'] : '' ); 
	
	if( $order == 'ASC' || $order == 'DESC' )
	{
		$varget .= '&order=' . $order; 
	}
	else
	{
		$order = 'DESC'; 
	}
	
	$sql = "SELECT * 
			FROM " . ABONNES_TABLE . " 
			WHERE actif = " . ABO_ACTIF . " 
			  $sql_where $sql_search 
			ORDER BY $type $order 
			LIMIT $start, $abo_per_page"; 
	if( !($result = $db->query($sql)) )
	{
		message(ERROR, 'Impossible d\'obtenir la liste des abonns', __FILE__, __LINE__, $sql);
	}
	
	while( $row = $db->fetch_array($result) )
	{
		$rowabo[] = $row;
	}	
	$db->free_result($result);
	
	define('MENU', true);
	include('page_header.php');	
	
	$navigation = navigation( sessid("view.php?mode=abonnes" . $varget), $total_abo, $abo_per_page, $page);
	
	$template->set_filenames( array(
		'body' => 'view_abo.tpl'
	)); 
	
	$template->assign_vars( array(
		'TITLE' => $lang['menu']['suscribers'], 
		'HEAD' => $lang['head']['abo'], 
		'LIST_BOX' => $list_box, 
		'L_CLASSEMENT' => $lang['classement'], 
		'L_BY_DATE' => $lang['by_date'], 
		'L_BY_EMAIL' => $lang['by_email'], 
		'L_BY_FORMAT' => $lang['by_format'], 
		'L_ASC' => $lang['asc'], 
		'L_DESC' => $lang['desc'], 
		'L_CLASSER' => $lang['classer'], 
		'L_SEARCH' => $lang['search'], 
		'L_SEARCH_NOTE' => $lang['search_note'], 
		'L_SEARCH_BUTTON' => $lang['search_button'], 
		'L_INTERVAL10' => sprintf( $lang['interval'], 10), 
		'L_INTERVAL30' => sprintf( $lang['interval'], 30), 
		'L_INTERVAL90' => sprintf( $lang['interval'], 90), 
		'L_INTERVAL180' => sprintf( $lang['interval'], 180), 
		'L_INTERVAL_MAX' => $lang['all'], 
		'L_EMAIL_ABO' => $lang['email'], 
		'L_FORMAT' => $lang['format'], 
		'L_DATE' => $lang['suscribe_date'],	
		
		'SELECTED1' => ( $type == 'date' ) ? ' selected="selected"' : '', 
		'SELECTED2' => ( $type == 'email' ) ? ' selected="selected"' : '', 
		'SELECTED3' => ( $type == 'format' ) ? ' selected="selected"' : '', 
		'SELECTED4' => ( $order == 'ASC' ) ? ' selected="selected"' : '', 
		'SELECTED5' => ( $order == 'DESC' ) ? ' selected="selected"' : '', 
		
		'KEYWORD' => ( strlen($search_keyword) > 0 ) ? htmlspecialchars(stripslashes(urldecode($search_keyword))) : '', 
		'SELECTED6' => ( $search_date == 10 ) ? ' selected="selected"' : '', 
		'SELECTED7' => ( $search_date == 30 ) ? ' selected="selected"' : '', 
		'SELECTED8' => ( $search_date == 90 ) ? ' selected="selected"' : '', 
		'SELECTED9' => ( $search_date == 180 ) ? ' selected="selected"' : '', 
		
		'JUMP' => sessid("view.php?mode=abonnes"), 
		'NAVIGATION' => $navigation, 
		'PAGING' => ( !$total_abo ) ? '0/0' : $page . '/' . ceil( $total_abo / $abo_per_page ), 
		'U_FORM' => sessid("view.php?mode=abonnes" . $varget) 
	)); 
	
	if( $total_abo )
	{
		$display_checkbox = false; 
		if( ( !$liste && count($is_auth['all_list']['auth_del']) ) || ( $liste && $is_auth[$liste]['auth_del'] ) )
		{
			$template->assign_block_vars('del', array(
				'L_DELETE' => $lang['delete_abo']
			)); 
		
			$display_checkbox = true; 
		}
		
		for( $i = 0; $i < count($rowabo); $i++ )
		{
			$class = ( ( $i % 2 ) == 0 ) ? 'row1' : 'row2';
			$date = convert_time($rowabo[$i]['date']);
			$email = '<a href="mailto:' . $rowabo[$i]['email'] . '">' . $rowabo[$i]['email'] . '</a>';
			
			$template->assign_block_vars('row', array(
				'EMAIL_ABO' => $email, 
				'FORMAT' => ( $rowabo[$i]['format'] == FORMAT_TEXTE ) ? 'txt' : 'html', 
				'DATE' => $date, 
				'CLASS' => $class 
			)); 
			
			if( $display_checkbox )
			{
				if( $is_auth[$rowabo[$i]['liste_id']]['auth_del'] )
				{
					$checkbox = '<input type="checkbox" name="abonne[]" value="' . $rowabo[$i]['id'] . '" />';
				}
				else
				{
					$checkbox = '&nbsp;'; 
				}
			
				$template->assign_block_vars('row.checkbox', array(
					'CHECKBOX' => $checkbox 
				)); 
			}
		}
	}
	else
	{
		if( $search_keyword != '' || $search_date != 0 || $search )
		{
			$empty_reasons = $lang['empty_search_abo'];
		}
		else if( $liste )
		{
			$empty_reasons = $lang['empty_liste_abo'];
		}
		else
		{
			$empty_reasons = $lang['empty_abo'];
		}
		
		$template->assign_block_vars('empty', array(
			'L_EMPTY' => $empty_reasons 
		));
	}
}

//
// Mode listes.
//
else if( $mode == 'liste' )
{
	if( $ajout && $admindata['level'] == ADMIN )
	{
		$listname = $HTTP_POST_VARS['listname'];
		$limitevalidate = ( ereg("^[0-9]+$", $HTTP_POST_VARS['limitevalidate']) ) ? $HTTP_POST_VARS['limitevalidate'] : 3;
		$choix_format = $HTTP_POST_VARS['format'];
		$email_confirm = $HTTP_POST_VARS['email_confirm'];
		$form_url = $HTTP_POST_VARS['form_url']; 
		
		$sql = "SELECT admin_id FROM " . ADMIN_TABLE; 
		if( !($result = $db->query($sql)) )
		{
			message(ERROR, 'Impossible d\'obtenir la liste des utilisateurs', __FILE__, __LINE__, $sql);
		}
		
		while( $row = $db->fetch_array($result) )
		{
			$adminrow[] = $row; 
		}
		
		$sql = "INSERT INTO " . LISTE_TABLE . " (nom, choix_format, email_confirm, limitevalidate, form_url) 
				VALUES('$listname', $choix_format, $email_confirm, $limitevalidate,'$form_url')";
		if( !($result = $db->query($sql, START_TRC)) )
		{
			message(ERROR, 'Impossible d\'ajouter la nouvelle liste dans la base de donnes', __FILE__, __LINE__, $sql);
		}
		
		$last_id = $db->next_id();
		
		for( $i = 0; $i < count($adminrow); $i++ )
		{
			$sql = "INSERT INTO " . AUTH_ADMIN_TABLE . " (admin_id, liste_id) 
					VALUES(" . $adminrow[$i]['admin_id'] . ", $last_id)"; 
			if( ($i+1) < count($adminrow) )
			{
				$result = $db->query($sql); 
			}
			else
			{
				$result = $db->query($sql, END_TRC); 
			}
			
			if( !$result )
			{
				message(ERROR, 'Impossible d\'attribuer les droits pour la nouvelle liste', __FILE__, __LINE__, $sql);
			}
		}
		
		$meta = '<meta http-equiv="refresh" content="8;url=' . sessid("config.php?mode=reglages&liste=" . $last_id) . '">'; 
		message(INFO, nl2br( sprintf($lang['info_msg']['success_add_liste'], '<a href="' . sessid("config.php?mode=reglages&liste=" . $last_id) . '">', '</a>') ) );
	}
	
	if( $modif )
	{
		if( !$is_auth[$liste]['auth_edit'] )
		{
			$meta = '<meta http-equiv="refresh" content="6;url=' . sessid("view.php?mode=liste&liste=" . $liste) . '">'; 
			$message = $lang['info_msg']['not_auth']; 
			message(INFO, $message); 
		}
		
		if( $confirm )
		{
			$listname = $HTTP_POST_VARS['listname'];
			$limitevalidate = ( ereg("^[0-9]+$", $HTTP_POST_VARS['limitevalidate']) ) ? $HTTP_POST_VARS['limitevalidate'] : 3;
			$choix_format = $HTTP_POST_VARS['format'];
			$email_confirm = $HTTP_POST_VARS['email_confirm'];
			$form_url = $HTTP_POST_VARS['form_url']; 
			$email_new_inscrit = $HTTP_POST_VARS['email_new_inscrit']; 
			
			if( $listname == '' || $form_url == '' )
			{
				$meta = '<meta http-equiv="refresh" content="6;url=' . sessid("view.php?mode=liste&liste=" . $liste) . '">';
				message(ERROR, $lang['info_msg']['fields_empty']);
			}
			
			$sql = "UPDATE " . LISTE_TABLE . " 
					SET nom = '$listname', 
						choix_format = $choix_format, 
						email_confirm = $email_confirm, 
						limitevalidate = $limitevalidate, 
						form_url = '$form_url', 
						email_new_inscrit = '$email_new_inscrit' 
					WHERE liste_id = $liste";
			if( !($result = $db->query($sql)) )
			{
				message(ERROR, 'Impossible de mettre  jour les donnes de la liste de diffusion', __FILE__, __LINE__, $sql);
			}
			
			$meta = '<meta http-equiv="refresh" content="5;url=' . sessid("view.php?mode=liste&liste=" . $liste) . '">';
			message(INFO, $lang['info_msg']['success_modif']);
		}
		
		$sql = "SELECT * 
				FROM " . LISTE_TABLE . " 
				WHERE liste_id = $liste";
		if( !($result = $db->query($sql)) )
		{
			message(ERROR, 'Impossible d\'obtenir des informations sur la liste slectionne', __FILE__, __LINE__, $sql);
		}
		
		$row = $db->fetch_array($result);	
		$db->free_result($result);
		
		$box_format = '<select name="format">';		
		$box_format .= ( $row['choix_format'] == FORMAT_TEXTE ) ? '<option value="1" selected="selected"> - texte - </option>' : '<option value="1"> - texte - </option>';
		$box_format .= ( $row['choix_format'] == FORMAT_HTML ) ? '<option value="2" selected="selected"> - html - </option>' : '<option value="2"> - html - </option>';
		$box_format .= ( $row['choix_format'] == FORMAT_MULTIPLE ) ? '<option value="3" selected="selected"> - texte & html - </option>' : '<option value="3"> - texte & html - </option>';
		$box_format .= '</select>';
		
		define('MENU', true);
		include('page_header.php');	
	
		$template->set_filenames( array(
			'body' => 'view_liste.tpl'
		)); 
		
		$template->assign_vars( array(
			'TITLE' => $lang['menu']['diff_list'], 
			'HEAD' => $lang['head']['list'], 
			'LIST_BOX' => $list_box, 
			
			'JUMP' => sessid("view.php?mode=liste"), 
			'U_FORM' => sessid("view.php?mode=liste&liste=" . $liste) 
		));
		
		$template->assign_block_vars('modif_liste', array(
			'L_TITLE_MODIF' => $lang['title']['modif_liste'], 
			'L_LISTNAME' => $lang['listname'], 
			'L_AUTH_FORMAT' => $lang['auth_format'], 
			'L_AUTH_FORMAT_NOTE' => $lang['auth_format_note'], 
			'L_EMAIL_CONFIRM' => $lang['confirm_suscribe'], 
			'L_EMAIL_NEW_INSCRIT' => $lang['prev_new_inscrit'], 
			'L_BUTTON_CANCEL' => $lang['button']['cancel'], 
			'L_BUTTON_EDIT' => $lang['button']['edit'], 
			'L_YES' => $lang['yes'], 
			'L_NO' => $lang['no'], 
			'L_DAYS' => $lang['days'], 
			'L_LIMITEVALIDATE' => $lang['limite_validate'], 
			'L_NOTE_VALIDATE' => $lang['note_validate'], 
			'L_FORM_URL' => $lang['form_url'], 
														  
			'LISTNAME' => stripslashes($row['nom']), 
			'BOX_FORMAT' => $box_format, 
			'CHECK1' => ( $row['email_confirm'] ) ? 'checked="checked"' : '', 
			'CHECK2' => ( !$row['email_confirm'] ) ? 'checked="checked"' : '', 
			'CHECK3' => ( $row['email_new_inscrit'] ) ? 'checked="checked"' : '', 
			'CHECK4' => ( !$row['email_new_inscrit'] ) ? 'checked="checked"' : '', 
			'LIMITEVALIDATE' => $row['limitevalidate'], 
			'FORM_URL' => $row['form_url'], 
			'HIDDEN_FIELD' => '<input type="hidden" name="modif" value="1" />' 
		));
		
		$template->pparse('body');
		
		include('page_footer.php');
		exit;
	}
	
	if( $delete )
	{
		if( $admindata['level'] != ADMIN )
		{
			$meta = '<meta http-equiv="refresh" content="6;url=' . sessid("view.php?mode=liste") . '">'; 
			$message = $lang['info_msg']['not_auth']; 
			message(INFO, $message); 
		}
		
		if( $confirm )
		{
			$option = $HTTP_POST_VARS['option'];
			
			if( $option == 'alldel' )
			{
				$sql = "DELETE FROM " . LISTE_TABLE . " WHERE liste_id = $liste";
				if( !($result = $db->query($sql, START_TRC)) )
				{
					message(ERROR, 'Suppression de la table des listes impossible', __FILE__, __LINE__, $sql);
				}
				
				$sql = "DELETE FROM " . LOG_TABLE . " WHERE liste_id = $liste";
				if( !($result = $db->query($sql)) )
				{
					message(ERROR, 'Suppression de la table des logs impossible', __FILE__, __LINE__, $sql);
				}
				
				$sql = "DELETE FROM " . ABONNES_TABLE . " WHERE liste_id = $liste";
				if( !($result = $db->query($sql)) )
				{
					message(ERROR, 'Suppression de la table des abonns impossible', __FILE__, __LINE__, $sql);
				}
				
				$sql = "DELETE FROM " . AUTH_ADMIN_TABLE . " WHERE liste_id = $liste";
				if( !($result = $db->query($sql, END_TRC)) )
				{
					message(ERROR, 'Suppression de la table des permissions impossible', __FILE__, __LINE__, $sql);
				}
				
				include('../includes/functions.stats.php'); 
				remove_stats($liste); 
			}
			else
			{
				$sql = "DELETE FROM " . LISTE_TABLE . " WHERE liste_id = '$liste'";
				if( !($result = $db->query($sql, START_TRC)) )
				{
					message(ERROR, 'Suppression de la table des listes impossible', __FILE__, __LINE__, $sql);
				}
				
				$sql = "UPDATE " . LOG_TABLE . " SET liste_id = '$option' WHERE liste_id = '$liste'";
				if( !($result = $db->query($sql)) )
				{
					message(ERROR, 'La mise  jour de la table des logs a chou', __FILE__, __LINE__, $sql);
				}
				
				$sql = "UPDATE " . ABONNES_TABLE . " SET liste_id = '$option' WHERE liste_id = '$liste'";
				if( !($result = $db->query($sql)) )
				{
					message(ERROR, 'La mise  jour de la table des abonns a chou', __FILE__, __LINE__, $sql);
				}
				
				$sql = "DELETE FROM " . AUTH_ADMIN_TABLE . " WHERE liste_id = '$liste'";
				if( !($result = $db->query($sql, END_TRC)) )
				{
					message(ERROR, 'Supression de la table des permissions impossible', __FILE__, __LINE__, $sql);
				}
				
				include('../includes/functions.stats.php'); 
				remove_stats($liste, $option); 
			}
				
			$meta = '<meta http-equiv="refresh" content="6;url=' . sessid("view.php?mode=liste") . '">';
			message(INFO, $lang['info_msg']['success_del_list']); 
		}
		
		$is_auth = obtain_auth(AUTH_VIEW, ALL_LIST); 
		
		if( count($is_auth['all_list']['auth_view']) == 1 )
		{
			$meta = '<meta http-equiv="refresh" content="6;url=' . sessid("view.php?mode=liste") . '">';
			
			$message = "Vous n'avez plus qu'une liste de diffusion, vous ne pouvez supprimer votre dernire liste"; 
			message(INFO, $message); 
		}
		
		$liste_in = implode(", ", $is_auth['all_list']['auth_view']); 
		$sql = "SELECT liste_id, nom 
				FROM " . LISTE_TABLE . " 
				WHERE liste_id IN($liste_in)";
		if( !($result = $db->query($sql)) )
		{
			message(ERROR, 'Impossible d\'obtenir la liste des listes de diffusion', __FILE__, __LINE__, $sql);
		}
		
		$option_list = '<select name="option">'; 
		$option_list .= '<option value="alldel"> - ' . $lang['alldelete'] . ' - </option>';
		while( $row = $db->fetch_array($result) )
		{
			if( $row['liste_id'] != $liste )
			{
				$nom = stripslashes($row['nom']);
				if( strlen($nom) > 35 )
				{ 
					$nom   = substr($nom, 0, 40); 
					$space = strrpos($nom, " "); 
					$nom   = substr($nom, 0, $space); 
					$nom   = $nom . "..."; 
				}
				
				$option_list .= '<option value="' . $row['liste_id'] . '"> - ' . $lang['move_to'] . ' ' . $nom . ' - </option>'; 
			}
		}
		
		$option_list .= '</select>'; 		
		$db->free_result($result);
				
		define('MENU', true);
		include('page_header.php');	
	
		$template->set_filenames( array(
			'body' => 'view_liste.tpl'
		)); 
		
		$template->assign_vars( array(
			'TITLE' => $lang['menu']['diff_list'], 
			'HEAD' => $lang['head']['list'], 
			'LIST_BOX' => $list_box, 
			
			'JUMP' => sessid("view.php?mode=liste"), 
			'U_FORM' => sessid("view.php?mode=liste&liste=" . $liste)  
		));
		
		$template->assign_block_vars('delete_liste', array(
			'L_TITLE_DELETE' => $lang['title']['delete_liste'], 
			'L_DELETE_LISTE' => $lang['delete_liste'], 
			'L_DELETE_LISTE2' => $lang['delete_liste2'], 
			'L_YES' => $lang['yes'], 
			'L_NO' => $lang['no'], 
															
			'OPTION_LIST' => $option_list, 
			'HIDDEN_FIELD' => '<input type="hidden" name="delete" value="1" />' 
		));
		
		$template->pparse('body'); 
		
		include('page_footer.php');
		exit;
	}
	
	if( $liste )
	{
		$varget .= '&liste=' . $liste; 
	}
	
	define('MENU', true);
	include('page_header.php');	
	
	$template->set_filenames( array(
		'body' => 'view_liste.tpl'
	)); 
	
	$template->assign_vars( array(
		'TITLE' => $lang['menu']['diff_list'], 
		'HEAD' => $lang['head']['list'], 
		'LIST_BOX' => $list_box, 
		
		'JUMP' => sessid("view.php?mode=liste"), 
		'U_FORM' => sessid("view.php?mode=liste" . $varget)  
	));
	
	if( $liste ) 
	{
		if( !$is_auth[$liste]['auth_view'] )
		{
			$meta = '<meta http-equiv="refresh" content="6;url=' . sessid("index.php") . '">'; 
			$message = $lang['info_msg']['not_auth']; 
			message(INFO, $message); 
		}
		
		//
		// On affiche les infos sur la liste slectionn
		//
		$sql = "SELECT * 
				FROM " . LISTE_TABLE . " 
				WHERE liste_id = '$liste'";
		if( !($result = $db->query($sql)) )
		{
			message(ERROR, 'Impossible d\'obtenir des informations sur la liste slectionne', __FILE__, __LINE__, $sql);
		}
		
		$row = $db->fetch_array($result); 
		
		$sql = "SELECT COUNT(*) AS num, actif 
			FROM " . ABONNES_TABLE . " 
			WHERE liste_id = '$liste' 
			GROUP BY actif"; 
		if( !($result = $db->query($sql)) )
		{
			$message = 'Impossible d\'obtenir le nombre d\'inscrits/inscrits en attente';
			message(ERROR, $message, __FILE__, __LINE__, $sql);
		}
		
		$num_temp = 0; 
		$num_inscrits = 0; 
		while( $row2 = $db->fetch_array($result) )
		{
			if( $row2['actif'] == ABO_ACTIF )
			{
				$num_inscrits = $row2['num']; 
			}
			else
			{
				$num_temp = $row2['num']; 
			}
		}
		$db->free_result($result);
		
		$sql = "SELECT COUNT(*) AS nblog 
				FROM " . LOG_TABLE . " 
				WHERE liste_id = '$liste' 
				  AND send = " . SENDED; 
		if( !($result = $db->query($sql)) )
		{
			message(ERROR, 'Impossible d\'obtenir le nombre d\'archives pour la liste', __FILE__, __LINE__, $sql);
		}
		$num_logs = $db->result($result, 0, "nblog");
		
		switch($row['choix_format'])
		{
			case FORMAT_TEXTE:
				$format = "txt";
				break;			
			case FORMAT_HTML:
				$format = "html";
				break;			
			case FORMAT_MULTIPLE:
				$format = "txt & html";
				break;
			default:
				$format = $lang['unknow'];
				break;
		}

		$template->assign_block_vars('info_liste', array(
			'TITLE_INFO' => $lang['title']['info_liste'], 
			'L_IDLISTE' => $lang['list_ID'], 
			'L_LISTNAME' => $lang['listname'], 
			'L_AUTH_FORMAT' => $lang['auth_format'], 
			'L_NBINSCRITS' => $lang['total_inscrits'], 
			'L_NBNEWSLETTER' => $lang['total_newsletter'], 
			'L_EMAIL_CONFIRM' => $lang['confirm_suscribe'], 
			'L_EMAIL_NEW_INSCRIT' => $lang['prev_new_inscrit'], 
			'L_LIMITEVALIDATE' => $lang['limite_validate'], 
			'L_NBTEMP' => $lang['temp_inscrits'], 
			'L_FORM_URL' => $lang['form_url'], 

			'IDLISTE' => $row['liste_id'], 
			'LISTNAME' => stripslashes($row['nom']), 
			'AUTH_FORMAT' => $format, 
			'NBINSCRITS' => $num_inscrits, 
			'NBNEWSLETTER' => $num_logs, 
			'EMAIL_CONFIRM' => ( $row['email_confirm'] ) ? $lang['yes'] : $lang['no'], 
			'EMAIL_NEW_INSCRIT' => ( $row['email_new_inscrit'] ) ? $lang['yes'] : $lang['no'], 
			'LIMITEVALIDATE' => $row['limitevalidate'], 
			'NBTEMP' => $num_temp, 
			'FORM_URL' => $row['form_url'] 
		));
		
		if( $is_auth[$liste]['auth_edit'] )
		{
			$template->assign_block_vars('info_liste.admin', array(				
				'L_BUTTON_EDIT' => $lang['button']['edit'], 
				'L_BUTTON_DELETE' => $lang['button']['delete'], 
				
				'HIDDEN_FIELD' => '' 
			));
		}
	}
	
	if( $admindata['level'] == ADMIN )
	{
		$template->assign_block_vars('form_liste', array(
			'L_TITLE_FORM' => $lang['title']['add_liste'], 
			'L_LISTNAME' => $lang['listname'], 
			'L_AUTH_FORMAT' => $lang['auth_format'], 
			'L_EMAIL_CONFIRM' => $lang['confirm_suscribe'], 
			'L_YES' => $lang['yes'], 
			'L_NO' => $lang['no'], 
			'L_DAYS' => $lang['days'], 
			'L_LIMITEVALIDATE' => $lang['limite_validate'], 
			'L_NOTE_VALIDATE' => $lang['note_validate'], 
			'L_BUTTON_VALID' => $lang['button']['add'], 
			'L_FORM_URL' => $lang['form_url'] 
		));
	}
}

//
// Mode log
//
else if( $mode == 'log' )
{
	if( $liste )
	{
		$varget .= '&liste=' . $liste;
		$sql_where = "AND liste_id = '$liste'";
	}
	else
	{
		$liste_in = implode(", ", $is_auth['all_list']['auth_view']); 
		$sql_where = "AND liste_id IN($liste_in)"; 
	}
	
	if( $delete )
	{
		$logs = ( !empty($HTTP_POST_VARS['log']) ) ? $HTTP_POST_VARS['log'] : array(); 
		
		if( $confirm )
		{
			if( count($logs) )
			{
				$list_log_id = implode(", ", $logs); 
			
				$sql = "DELETE FROM " . LOG_TABLE . " WHERE log_id IN ($list_log_id)";
				if( !($result = $db->query($sql)) )
				{
					message(ERROR, 'La suppression des logs a chou', __FILE__, __LINE__, $sql);
				}
			}
		
			Location(sessid("view.php?mode=log")); 
		}
		else
		{
			$hidden_fields = '<input type="hidden" name="delete" value="1" />'; 
			for( $i = 0; $i < count($logs); $i++ )
			{
				$hidden_fields .= '<input type="hidden" name="log[]" value="' . $logs[$i] . '" />'; 
			}
	
			define('MENU', true);
			include('page_header.php');	
		
			$template->set_filenames(array(
				'body' => 'confirm.tpl'
			)); 
	
			$template->assign_vars( array(
				'TITLE' => $lang['title']['confirm'], 
				'L_TEXT_CONFIRM' => $lang['info_msg']['confirm_del_log'], 
				'L_YES' => $lang['yes'], 
				'L_NO' => $lang['no'], 
			
				'HIDDEN_FIELDS' => $hidden_fields, 
				'U_FORM' => sessid("view.php?mode=log") 
			)); 
	
			$template->pparse('body'); 
		
			include('page_footer.php'); 
			exit; 
		}
	}
	
	$log_per_page = 20; 
		
	$sql = "SELECT COUNT(*) AS total_log 
			FROM " . LOG_TABLE . " 
			WHERE send = " . SENDED . " $sql_where";
	if( !($result = $db->query($sql)) )
	{
		message(ERROR, 'Impossible d\'obtenir le nombre de logs envoys', __FILE__, __LINE__, $sql);
	}
	
	$total_log = $db->result($result, 0, "total_log");
	
	$page = ( isset($HTTP_GET_VARS['page']) ) ? intval($HTTP_GET_VARS['page']) : 1;	
	$start = ( ( $page - 1 ) * $log_per_page );
	
	//
	// classement
	//
	$type = ( !empty($HTTP_POST_VARS['type']) ) ? $HTTP_POST_VARS['type'] : ( ( !empty($HTTP_GET_VARS['type']) ) ? $HTTP_GET_VARS['type'] : '' ); 
	
	if( $type == 'sujet' || $type == 'date' )
	{
		$varget .= '&type=' . $type; 
	}
	else
	{
		$type = 'date'; 
	}
	
	$order = ( !empty($HTTP_POST_VARS['order']) ) ? $HTTP_POST_VARS['order'] : ( ( !empty($HTTP_GET_VARS['order']) ) ? $HTTP_GET_VARS['order'] : '' ); 
	
	if( $order == 'ASC' || $order == 'DESC' )
	{
		$varget .= '&order=' . $order; 
	}
	else
	{
		$order = 'DESC'; 
	}
	
	$sql = "SELECT * 
			FROM " . LOG_TABLE . " 
			WHERE send = " . SENDED . " $sql_where 
			ORDER BY $type $order LIMIT $start, $log_per_page";
	if( !($result = $db->query($sql)) )
	{
		message(ERROR, 'Impossible d\'obtenir la liste des logs', __FILE__, __LINE__, $sql);
	}
	
	while( $row = $db->fetch_array($result) )
	{
		$rowlog[] = $row;
	}
	
	$db->free_result($result);
	
	define('MENU', true);
	include('page_header.php');	
	
	$navigation = navigation( sessid("view.php?mode=log" . $varget), $total_log, $log_per_page, $page);
	$varget .= ( $page == '1' ) ? '' : '&page=' . $page;
	
	$template->set_filenames( array(
		'body' => 'view_log.tpl'
	)); 
	
	$template->assign_vars( array(
		'TITLE' => $lang['menu']['logs'], 
		'HEAD' => $lang['head']['logs'], 
		'LIST_BOX' => $list_box, 
		'L_CLASSEMENT' => $lang['classement'], 
		'L_BY_SUBJECT' => $lang['by_subject'], 
		'L_BY_DATE' => $lang['by_date'], 
		'L_ASC' => $lang['asc'], 
		'L_DESC' => $lang['desc'], 
		'L_CLASSER' => $lang['classer'], 
		'L_SUBJECT' => $lang['log_subject'], 
		'L_DATE' => $lang['log_date'], 
		
		'SELECTED1' => ( $type == 'sujet' ) ? ' selected="selected"' : '', 
		'SELECTED2' => ( $type == 'date' ) ? ' selected="selected"' : '', 
		'SELECTED3' => ( $order == 'ASC' ) ? ' selected="selected"' : '', 
		'SELECTED4' => ( $order == 'DESC' ) ? ' selected="selected"' : '', 
		'NAVIGATION' => $navigation, 
		'JUMP' => sessid("view.php?mode=log"), 
		'U_FORM' => ( $liste ) ? sessid("view.php?mode=log&liste=" . $liste) : sessid("view.php?mode=log"), 
		'PAGING' => ( !$total_log ) ? '0/0' : $page . '/' . ceil( $total_log / $log_per_page ) 
	));
	
	if( $total_log )
	{
		$display_checkbox = false; 
		if( ( !$liste && count($is_auth['all_list']['auth_del']) ) || ( $liste && $is_auth[$liste]['auth_del'] ) )
		{
			$template->assign_block_vars('del', array(
				'L_DELETE' => $lang['delete_log'] 
			)); 
		
			$display_checkbox = true; 
		}
		
		for( $i = 0; $i < count($rowlog); $i++ )
		{
			$class = ( ( $i % 2 ) == 0 ) ? 'row1' : 'row2';
			$date = convert_time($rowlog[$i]['date']);
			$subject = '<a href="' . sessid("view.php?mode=log&action=view&id=" . $rowlog[$i]['log_id'] . $varget) . '#view">' . stripslashes($rowlog[$i]['sujet']) . '</a>';
			
			$template->assign_block_vars('row', array(
				'SUBJECT' => $subject, 
				'DATE' => $date, 
				'CLASS' => $class 
			)); 
			
			if( $display_checkbox )
			{
				if( $is_auth[$rowlog[$i]['liste_id']]['auth_del'] )
				{
					$checkbox = '<input type="checkbox" name="log[]" value="' . $rowlog[$i]['log_id'] . '" />';
				}
				else
				{
					$checkbox = '&nbsp;'; 
				}
			
				$template->assign_block_vars('row.checkbox', array(
					'CHECKBOX' => $checkbox 
				)); 
			}
		}
	}
	else
	{
		$empty_reasons = ( $liste ) ? $lang['empty_liste_log'] : $lang['empty_log']; 
		
		$template->assign_block_vars('empty', array(
			'L_EMPTY' => $empty_reasons 
		));
	}
	
	$action = ( !empty($HTTP_GET_VARS['action']) ) ? $HTTP_GET_VARS['action'] : ''; 
	$log_id = ( !empty($HTTP_GET_VARS['id']) ) ? intval($HTTP_GET_VARS['id']) : 0; 
	$format = ( !empty($HTTP_GET_VARS['format']) ) ? intval($HTTP_GET_VARS['format']) : 0; 
	
	if( $action == 'view' && $log_id )
	{
		//
		// rcupration des infos sur le log slectionn
		//		
		$sql = "SELECT sujet, body_html, body_text, attach 
				FROM " . LOG_TABLE . " 
				WHERE log_id = '$log_id'";
		if( !($result = $db->query($sql)) )
		{
			message(ERROR, 'Impossible d\'obtenir des infos sur le log slectionn', __FILE__, __LINE__, $sql);
		}
		
		$rowinfo = $db->fetch_array($result);
		$db->free_result($result);
		
		if( strlen($rowinfo['body_text']) > 0 && strlen($rowinfo['body_html']) > 0 )
		{
			$box_format = $lang['format'] . ' : &nbsp; <select name="chg_format" onchange="window.location.href=\'' . sessid("view.php?mode=log&action=view&id=" . $log_id . $varget) . '&format=\'+this.value+\'#view\';">';
			$box_format .= '<option value="1"> texte </option>';
			$box_format .= ( $format == FORMAT_HTML ) ? '<option value="2" selected="selected"> html </option>' : '<option value="2"> html </option>';
			$box_format .= '</select>';
			
			$target = ( $format == FORMAT_TEXTE || $format == FORMAT_HTML ) ? sessid("view.php?mode=iframe&id=" . $log_id . "&format=" . $format) : sessid("view.php?mode=iframe&id=" . $log_id);
		}
		else
		{
			$box_format = '&nbsp;'; 
			$target = sessid("view.php?mode=iframe&id=" . $log_id); 
		}
		
		$template->assign_block_vars('iframe', array(
			'L_SUBJECT' => $lang['log_subject'], 
			'SUBJECT' => stripslashes($rowinfo['sujet']), 
			'U_FRAME' => $target, 
			'BOX_FORMAT' => $box_format 
		)); 
		
		if( !empty($rowinfo['attach']) )
		{
			if( strpos($rowinfo['attach'], ",") )
			{
				$filearray = explode(",", $rowinfo['attach']);
			}
			else
			{
				$filearray[] = $rowinfo['attach']; 
			}
			
			$template->assign_block_vars('iframe.attach', array(
				'L_ATTACH_LISTE' => $lang['attach_liste'], 
				'L_ATTACH_SIZE' => $lang['attach_size'] 
			));
			
			for( $i = 0; $i < count($filearray); $i++ )
			{
				$class = ( ( $i % 2 ) == 0 ) ? 'row1' : 'row2';
				$filename = $filearray[$i];
				
				if( !@file_exists('upload/' . $filename) )
				{
					$filesize = $lang['unknow'];
					$filename .= ' &nbsp; <span class="smalltexte">' . $lang['no_attach'] . '</span>';
				}
				else
				{
					$filesize = @filesize('upload/' . $filename);
					$filesize = sprintf("%.2f", $filesize / 1024) . ' Ko';
					$filename = '<a href="' . sessid("view.php?mode=download&file=" . $filename) . '">' . $filename . '</a>';
				}
				
				$template->assign_block_vars('iframe.attach.liste', array(
					'FILENAME' => $filename, 
					'FILESIZE' => $filesize, 
					'CLASS' => $class 
				));
			}
		} // fin du cas o fichier joints
	} // fin de action=view
}

$template->pparse('body');

include('page_footer.php');
?>