<?php
/*******************************************************************
 *			
 * 			Fichier			:	stats.php 
 * 			Cr le			:	21 octobre 2002 
 * 			Dernire modif	:	31 janvier 2003 
 * 			Email			:	wascripts@phpcodeur.net 
 * 
 * 				 Copyright 2002-2003 PHPcodeur
 * 
 *******************************************************************/

/*******************************************************************
 *  This program is free software; you can redistribute it and/or 
 * 	modify it under the terms of the GNU General Public License as 
 * 	published by the Free Software Foundation; either version 2 of 
 *  the License, or (at your option) any later version. 
 *******************************************************************/


define('IN_NEWSLETTER', true); 
define('PAGE', basename(__FILE__)); 

$waroot = '../'; 
require('./pagestart.php'); 

//
//// Configuration du module 
//
$img_type = 'png'; // les images sont au format gif ou png selon la version de la librairie GD 
//
////
//

if( !@extension_loaded('gd') )
{
	$message = $lang['info_msg']['no_gd_lib']; 
	message(INFO, $message); 
}

$is_auth = obtain_auth(AUTH_VIEW, ALL_LIST); 

if( !count($is_auth['all_list']['auth_view']) )
{
	$meta = '<meta http-equiv="refresh" content="6;url=' . sessid("index.php") . '">'; 
	$message = $lang['info_msg']['not_auth']; 
	message(INFO, $message); 
}

$liste_in = implode(', ', $is_auth['all_list']['auth_view']); 

include($waroot . 'includes/functions.stats.php'); 

$img = ( !empty($HTTP_GET_VARS['img']) ) ? $HTTP_GET_VARS['img'] : ''; 
if( !empty($HTTP_GET_VARS['date']) )
{
	$elt = explode("_", $HTTP_GET_VARS['date']); 
	
	$mois = $elt[0]; 
	$annee = $elt[1]; 
}
else
{
	$mois = date("m"); 
	$annee = date("Y"); 
}

if( $img == 'graph' )
{
	$im = imagecreate(510, 250); 
	
	$black   = rvb_color($im, "000000");
	$border  = rvb_color($im, "FFFFFF");
	$back_1  = rvb_color($im, "003366");
	$back_2  = rvb_color($im, "EAEAEA"); 
	$color[] = rvb_color($im, "FF8800"); 
	$color[] = rvb_color($im, "0022FF");
	
	imagefill($im, 0, 0, $black);
	
	//
	// contours 
	//
	imagefilledrectangle($im, 1, 1, 508, 248, $back_1);
	imagefilledrectangle($im, 17, 20, 483, 231, $border);
	imagefilledrectangle($im, 18, 21, 482, 230, $back_2); 
	
	//
	// titre du graphe 
	//
	$month = date("F", mktime(0, 0, 0, $mois, 1, $annee)); 
	
	$title = stripslashes($newsletter_config['sitename']) . " : Inscriptions/Jours - " . $datetime[$month] . " " . $annee;
	$start = ( 510 - ( imagefontwidth(3) *strlen($title) ) ) / 2;	
	imagestring($im, 3, $start, 4, $title, $color[0]); 
	
	//
	// Echelle horizontale (numro des jours) 
	//
	$int = 0;
	for( $day = 1; $day < 32; $day++ )
	{
		if( checkdate($mois, $day, $annee) )
		{
			$day2 = sprintf("%02d", $day); 
			imagestring($im, 1, 20+$int, 234, $day2, $border); 
			
			$int += 15; 
		}
	}
	
	//
	// Lecture des fichiers de statistiques 
	//
	$stats = read_stats($liste_in, $mois, $annee); 
	$max_value = $stats['max']; 
	$num_per_day = $stats['num']; 
	
	if( !$max_value ) $max_value = 10;
	$max_value2 = $max_value; 
	while( substr($max_value2, strlen($max_value2)-1, 1) != "0" )
	{
		$max_value2++; 
	}
	
	$interval = 198/$max_value2; 
	
	//
	// Echelle vertical (nombre d'inscriptions) 
	//
	$int = 0; 
	$num = $max_value2/5;
	for( $i = 0; $i < 5; $i++ )
	{
		imagestring($im, 1, 5, 29+$int, $max_value2, $border); 
		imageline($im, 18, 32+$int, 482, 32+$int, $black); 
		
		$int += 40; 
		$max_value2 -= $num;
	}
	
	$fct_imagecreatefrom = 'imagecreatefrom' . $img_type;
	$src = @$fct_imagecreatefrom("../images/barre." . $img_type); 
	if( !$src )
	{
		return; 
	}
	
	//
	// Affichage des rsultats 
	//
	$int = 0;
	for( $day = 1; $day < 32; $day++ )
	{
		if( checkdate($mois, $day, $annee) )
		{
			if( $num_per_day[$day] )
			{
				$height = 230 - ($interval*$num_per_day[$day]); 
				imagefilledrectangle( $im, 19+$int, $height, 31+$int, 230, $black); 
				imagecopyresized($im, $src, 20+$int, $height+1, 0, 0, 11, ($interval*$num_per_day[$day]), 10, 1); 
				
				$start = ( 26+$int - ( imagefontwidth(1) *strlen($num_per_day[$day]) )/2 );
				$color_value = ( $num_per_day[$day] == $max_value ) ? $color[1] : $black; 
				imagestring($im, 1, $start, $height-10, $num_per_day[$day], $color_value); 
			}
		
			$int += 15; 
		}
	}
	
	header("content-type: image/" . $img_type); 	
	$fct_image = 'image' . $img_type; 
	$fct_image($im); 
	
	imagedestroy($im); 
	exit;
}

if( $img == 'camenbert' )
{
	$sql = "SELECT COUNT(a.id) AS num_inscrits, li.nom 
			FROM " . ABONNES_TABLE . " AS a, " . LISTE_TABLE . " as li 
			WHERE a.actif = " . ABO_ACTIF . " 
			  AND li.liste_id IN($liste_in) 
			  AND a.liste_id = li.liste_id 
			GROUP BY a.liste_id"; 
	if( !($result = $db->query($sql)) )
	{
		return;
	}
	
	$total_inscrits = 0; 
	$list = array(); 
	while( $row = $db->fetch_array($result) )
	{
		$nom = stripslashes($row['nom']);
		if( strlen($nom) > 40 )
		{ 
			$nom   = substr($nom, 0, 40); 
			$space = strrpos($nom, " "); 
			$nom   = substr($nom, 0, $space); 
			$nom   = $nom . "..."; 
		}
		
		$list[] = array("name" => stripslashes($nom), "num" => $row['num_inscrits']); 
		$total_inscrits += $row['num_inscrits']; 
	}
	
	$start_x = 70; 
	$start_y = 100;
	
	$im = imagecreate(510, 250);

	$black	 = rvb_color($im, "000000");
	$back_1  = rvb_color($im, "003366");
	$back_2  = rvb_color($im, "EAEAEA");
	$color[] = rvb_color($im, "FF8800");
	$color[] = rvb_color($im, "66BB00");
	$color[] = rvb_color($im, "00BBCC");
	$color[] = rvb_color($im, "FF2200");
	$color[] = rvb_color($im, "660088");

	imagefill($im, 0, 0, $black); 
	imagefilledrectangle( $im, 1, 1, 508, 248, $back_1);
	
	// titre du graphe
	$title = stripslashes($newsletter_config['sitename']) . " : Repartition des abonns par liste de diffusion";
	$start = ( 510 - ( imagefontwidth(3) *strlen($title) ) ) / 2;	
	imagestring($im, 3, $start, 4, $title, $color[0]); 
	
	$hauteur = $start_y - ( 100/2 );
	imagefilledrectangle( $im, 145, $hauteur, 470, $hauteur+150, $black);
	imagefilledrectangle( $im, 146, $hauteur+1, 469, $hauteur+149, $back_2); 
	
	// camenbert
	
	$degre = 0;
	$int = 20;
	for( $i = 0; $i < count($list); $i++ )
	{
		$deb_arc = round($degre);
        $degre += ($list[$i]['num']/$total_inscrits)*360;
        $end_arc = round($degre); 
		
		imagearc($im, $start_x, $start_y, 100, 100, $deb_arc, $end_arc, $color[$i]); 
		
		list($x_arc, $y_arc) = xy_arc($deb_arc, 100);
        imageline($im, $start_x, $start_y, floor($start_x + $x_arc), floor($start_y + $y_arc), $color[$i]);

		list($x_arc, $y_arc) = xy_arc($end_arc, 100);
        imageline($im, $start_x, $start_y, ceil($start_x + $x_arc), ceil($start_y + $y_arc), $color[$i]);

        $mid_arc = round( ( ($end_arc - $deb_arc)/2 ) +  $deb_arc);
        list($x_arc, $y_arc) = xy_arc($mid_arc, 50);
        imagefilltoborder($im, floor($start_x + $x_arc), floor($start_y + $y_arc), $color[$i], $color[$i]); 
		
		imagefilledrectangle( $im, 165, $hauteur+$int, 175, $hauteur+$int+10, $black);
		imagefilledrectangle( $im, 166, $hauteur+1+$int, 176, $hauteur+$int+11, $color[$i]); 
		
		imagestring($im, 2, 185, $hauteur+$int, $list[$i]['name'] . "  (" . $list[$i]['num'] . ")", $black); 
		
		$int += 20;
	}
	
	imagearc($im, $start_x, $start_y, 100, 100, 0, 360, $black); 
	imagearc($im, $start_x, $start_y, 101, 101, 0, 360, $black); 	
	
	header("content-type: image/" . $img_type);
	$fct_image = 'image' . $img_type; 
	$fct_image($im); 
	
	imagedestroy($im); 
	exit; 
}

$sql = "SELECT MIN(date) AS first_abo 
		FROM " . ABONNES_TABLE . " 
		WHERE liste_id IN($liste_in) AND actif = " . ABO_ACTIF; 
if( !($result = $db->query($sql)) )
{
	message(ERROR, 'Impossible d\'obtenir les dates des premiers et derniers abonn', __FILE__, __LINE__, $sql);
}

$first_abo = @mysql_result($result, 0, 'first_abo'); 

$date_box = '<select name="date" onchange="window.location.href = \'stats.php?date=\'+this.value;">'; 
$m = date("m"); 
$y = date("Y"); 
$month = date("F"); 
$date_box .= '<option value="' . $m . '_' . $y . '">' . $datetime[$month] . ' ' . $y . '</option>'; 

if( $first_abo )
{
	$first_m = date("m", $first_abo); 
	$first_y = date("Y", $first_abo); 
	
	$toc = ( $m == $first_m && $y == $first_y ) ? false : true; 
	while( $toc )
	{
		$m--; 
		if( $m == 0 )
		{
			$m = 12; 
			$y--; 
		}
		
		$month = date("F", mktime(0, 0, 0, $m, 1, $y)); 
		$selected = ( $mois == $m && $annee == $y ) ? ' selected="selected"' : ''; 	
		$date_box .= '<option value="' . $m . '_' . $y . '"' . $selected . '>' . $datetime[$month] . ' ' . $y . '</option>'; 
		
		if( $m == $first_m && $y == $first_y ) $toc = false;
	}
}

$date_box .= '</select>'; 

define('MENU', true);
include('page_header.php');	

$template->set_filenames( array(
	'body' => 'stats.tpl'
)); 

$template->assign_vars(array(
	'TITLE' => $lang['menu']['stats'], 
	'HEAD' => $lang['head']['stats'], 
	
	'DATE_BOX' => $date_box, 
	'U_IMG_GRAPH' => sessid("stats.php?img=graph&date=" . $mois . "_" . $annee), 
	'U_IMG_CAMENBERT' => sessid("stats.php?img=camenbert") 
)); 

$template->pparse('body'); 

include('page_footer.php'); 
?>