<?php
/*******************************************************************
 *			
 * 			Fichier			:	purge.php 
 * 			Cr le			:	23 octobre 2002 
 * 			Dernire modif	:	31 janvier 2003 
 * 			Email			:	wascripts@phpcodeur.net 
 * 
 * 				 Copyright 2002-2003 PHPcodeur
 * 
 *******************************************************************/

/*******************************************************************
 *  This program is free software; you can redistribute it and/or 
 * 	modify it under the terms of the GNU General Public License as 
 * 	published by the Free Software Foundation; either version 2 of 
 *  the License, or (at your option) any later version. 
 *******************************************************************/


define('IN_NEWSLETTER', true); 
define('PAGE', basename(__FILE__)); 

$waroot = '../'; 
require('./pagestart.php'); 

$submit  = ( isset($HTTP_POST_VARS['submit']) ) ? true : false; 
$delete  = ( isset($HTTP_POST_VARS['delete']) ) ? true : false; 
$confirm = ( isset($HTTP_POST_VARS['confirm']) ) ? true : false; 
$liste 	 = ( !empty($HTTP_GET_VARS['liste']) ) ? intval($HTTP_GET_VARS['liste']) : 0; 

$ask_list = ( !$liste ) ? ALL_LIST : $liste; 
$is_auth = obtain_auth(AUTH_ALL, $ask_list); 

if( isset($HTTP_POST_VARS['cancel']) )
{
	Location(sessid("purge.php?liste=" . $liste)); 
}

if( $submit )
{
	if( $admindata['level'] != ADMIN )
	{
		$meta = '<meta http-equiv="refresh" content="6;url=' . sessid("purge.php") . '">'; 
		$message = $lang['info_msg']['not_auth']; 
		message(INFO, $message); 
	}
	
	$use_autopurge = intval($HTTP_POST_VARS['use_autopurge']); 
	$purge_freq    = intval($HTTP_POST_VARS['purge_freq']); 
	
	if( !$purge_freq )
	{
		$purge_freq = 5; 
	}
	
	$sql = "UPDATE " . CONFIG_TABLE . " 
			SET valeur = $purge_freq 
			WHERE nom = 'purge_freq'"; 
	if( !($result = $db->query($sql)) )
	{
		message(ERROR, 'Impossible de mettre  jour la configuration', __FILE__, __LINE__, $sql);
	}
	
	$purge_next = time() + ( $purge_freq * 84600 ); 
	
	$sql = "UPDATE " . CONFIG_TABLE . " 
			SET valeur = $purge_next 
			WHERE nom = 'purge_next'"; 
	if( !($result = $db->query($sql)) )
	{
		message(ERROR, 'Impossible de mettre  jour la configuration', __FILE__, __LINE__, $sql);
	}
	
	$sql = "UPDATE " . CONFIG_TABLE . " 
			SET valeur = $use_autopurge 
			WHERE nom = 'use_autopurge'"; 
	if( !($result = $db->query($sql)) )
	{
		message(ERROR, 'Impossible de mettre  jour la configuration', __FILE__, __LINE__, $sql);
	}
	
	$meta = '<meta http-equiv="refresh" content="6;url=' . sessid("purge.php") . '">'; 
	message(INFO, $lang['info_msg']['success_modif']); 
}
else if( $delete )
{
	$abonnes = ( !empty($HTTP_POST_VARS['abonne']) ) ? $HTTP_POST_VARS['abonne'] : array(); 
	
	if( $confirm )
	{
		if( count($abonnes) )
		{
			$list_abo_id = implode(", ", $abonnes); 
			
			$sql = "DELETE FROM " . ABONNES_TABLE . " 
					WHERE id IN ($list_abo_id)";
			if( !($result = $db->query($sql)) )
			{
				message(ERROR, 'La suppression des abonns a chou', __FILE__, __LINE__, $sql);
			}
		}
		
		Location(sessid("purge.php?liste=" . $liste)); 
	}
	else
	{
		$hidden_fields = '<input type="hidden" name="delete" value="1" />'; 
		for( $i = 0; $i < count($abonnes); $i++ )
		{
			$hidden_fields .= '<input type="hidden" name="abonne[]" value="' . $abonnes[$i] . '" />'; 
		}
	
		define('MENU', true);
		include('page_header.php');	
		
		$template->set_filenames(array(
			'body' => 'confirm.tpl'
		)); 
	
		$template->assign_vars( array(
			'TITLE' => $lang['title']['confirm'], 
			'L_TEXT_CONFIRM' => $lang['info_msg']['confirm_del_abo'], 
			'L_YES' => $lang['yes'], 
			'L_NO' => $lang['no'], 
			
			'HIDDEN_FIELDS' => $hidden_fields, 
			'U_FORM' => sessid("purge.php?liste=" . $liste) 
		)); 
	
		$template->pparse('body'); 
		
		include('page_footer.php'); 
		exit; 
	}
}

if( ( !$liste && !count($is_auth['all_list']['auth_view']) ) || $liste && !$is_auth[$liste]['auth_view'] )
{
	$meta = '<meta http-equiv="refresh" content="6;url=' . sessid("index.php") . '">'; 
	$message = $lang['info_msg']['not_auth']; 
	message(INFO, $message); 
}

$list_box = list_box(AUTH_VIEW, true, true); 

if( !$list_box )
{
	$meta = '<meta http-equiv="refresh" content="6;url=' . sessid("index.php") . '">'; 
	$message = $lang['info_msg']['not_confirm']; 
	message(INFO, $message); 
}

$abo_per_page = 40; 

$varget = ''; 
$sql_where = ''; 
if( $liste )
{
	$varget = '?liste=' . $liste;
	$sql_where = "AND liste_id = '$liste'";
}
else
{
	$liste_in = implode(", ", $is_auth['all_list']['auth_view']); 
	$sql_where = "AND liste_id IN($liste_in)"; 
}

$sql = "SELECT COUNT(id) AS total_abo 
		FROM " . ABONNES_TABLE . " 
		WHERE actif = " . ABO_INACTIF . "
		  $sql_where";
if( !($result = $db->query($sql)) )
{
	message(ERROR, 'Impossible d\'obtenir la liste des inscriptions non confirmes', __FILE__, __LINE__, $sql);
}

$total_abo = $db->result($result, 0, "total_abo"); 

$page = ( isset($HTTP_GET_VARS['page']) ) ? intval($HTTP_GET_VARS['page']) : 1;	
$start = ( ( $page - 1 ) * $abo_per_page );

$sql = "SELECT * 
		FROM " . ABONNES_TABLE . " 
		WHERE actif = " . ABO_INACTIF . "
		  $sql_where 
		ORDER BY date DESC 
		LIMIT $start, $abo_per_page";
if( !($result = $db->query($sql)) )
{
	message(ERROR, 'Impossible d\'obtenir la liste des inscriptions non confirmes [2]', __FILE__, __LINE__, $sql);
}

$rowabo = array(); 
while( $row = $db->fetch_array($result) )
{
	$rowabo[] = $row;
}
$db->free_result($result); 

define('MENU', true);
include('page_header.php');	

$navigation = navigation( sessid("purge.php" . $varget), $total_abo, $abo_per_page, $page);

$template->set_filenames( array(
	'body' => 'purge.tpl'
)); 

$template->assign_vars(array(
	'TITLE' => $lang['menu']['purge'], 
	'HEAD' => $lang['head']['purge'], 
	'L_EMAIL_ABO' => $lang['email'], 
	'L_FORMAT' => $lang['format'], 
	'L_DATE' => $lang['suscribe_date'], 
	
	'LIST_BOX' => $list_box, 
	'NAVIGATION' => $navigation, 
	'PAGING' => ( !$total_abo ) ? '0/0' : $page . '/' . ceil( $total_abo / $abo_per_page ), 
	'JUMP' => sessid("purge.php"), 
	'U_FORM' => sessid("purge.php" . $varget) 
)); 

if( $total_abo )
{
	$display_checkbox = false; 
	if( ( !$liste && count($is_auth['all_list']['auth_del']) ) || ( $liste && $is_auth[$liste]['auth_del'] ) )
	{
		$template->assign_block_vars('del', array(
			'L_DELETE' => $lang['delete_abo']
		)); 
		
		$display_checkbox = true; 
	}
		
	for( $i = 0; $i < count($rowabo); $i++ )
	{
		$class = ( ( $i % 2 ) == 0 ) ? 'row1' : 'row2';
		$date = convert_time($rowabo[$i]['date']);
		$email = '<a href="mailto:' . $rowabo[$i]['email'] . '">' . $rowabo[$i]['email'] . '</a>';
			
		$template->assign_block_vars('row', array(
			'EMAIL_ABO' => $email, 
			'FORMAT' => ( $rowabo[$i]['format'] == FORMAT_TEXTE ) ? 'txt' : 'html', 
			'DATE' => $date, 
			'CLASS' => $class 
		)); 
		
		
		if( $display_checkbox )
		{
			if( $is_auth[$rowabo[$i]['liste_id']]['auth_del'] )
			{
				$checkbox = '<input type="checkbox" name="abonne[]" value="' . $rowabo[$i]['id'] . '" />';
			}
			else
			{
				$checkbox = '&nbsp;'; 
			}
			
			$template->assign_block_vars('row.checkbox', array(
				'CHECKBOX' => $checkbox 
			)); 
		}
	}
}
else
{
	$empty_reasons = ( $liste ) ? $lang['empty_liste_abo'] : $lang['empty_abo']; 
	
	$template->assign_block_vars('empty', array(
		'L_EMPTY' => $empty_reasons 
	));
}

if( $admindata['level'] == ADMIN )
{
	$template->assign_block_vars('admin', array(
		'TITLE_AUTO_PURGE' => $lang['title']['autopurge'], 
		'L_USE_PURGE' => $lang['use_purge'], 
		'L_YES' => $lang['yes'], 
		'L_NO' => $lang['no'], 
		'L_PURGE_FREQ' => $lang['purge_freq'], 
		'L_DAYS' => $lang['days'], 
		'L_BUTTON_VALID' => $lang['button']['valid'], 
		
		'PURGE_FREQ' => $newsletter_config['purge_freq'], 
		'CHECKED1' => ( $newsletter_config['use_autopurge'] ) ? ' checked="checked"' : '', 
		'CHECKED2' => ( !$newsletter_config['use_autopurge'] ) ? ' checked="checked"' : '' 
	));
}

$template->pparse('body'); 

include('page_footer.php'); 
?>