<?php
/*******************************************************************
 *			
 * 			Fichier			:	page_header.php 
 * 			Cr le			:	04 juillet 2002 
 * 			Dernire modif	:	31 janvier 2003 
 * 			Email			:	wascripts@phpcodeur.net 
 * 
 * 				 Copyright 2002-2003 PHPcodeur
 * 
 *******************************************************************/

/*******************************************************************
 *  This program is free software; you can redistribute it and/or 
 * 	modify it under the terms of the GNU General Public License as 
 * 	published by the Free Software Foundation; either version 2 of 
 *  the License, or (at your option) any later version. 
 *******************************************************************/


if( !defined('IN_ADMIN') )
{
	exit('<b>no hacking</b>'); 
}

define('HEADER_INC', true); 

@header("Cache-Control: no-cache, must-revalidate, private, pre-check=0, post-check=0, max-age=0");
@header("Expires: " . gmdate('D, d M Y H:i:s', time()) . " GMT");
@header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT"); 	
@header("Pragma: no-cache"); 

$new_version = 0;

// vrification de la sortie ventuelle d'une nouvelle version.
if( $newsletter_config['popup_version'] && $admindata['level'] == ADMIN )
{
	$version_actu = $newsletter_config['version']; 	
	$path = "http://www.phpcodeur.net/wascripts/wanewsletter.txt";
	
	// on limite la tentative  2 secondes pour viter un time out du script.
	$socket = @fsockopen("http://www.phpcodeur.net", 80, $errno, $errstr, 2);
	if( $socket )
	{
		$fp = @fopen($path, "r");
		if( $fp )
		{
			$version_actu = fread($fp, 512);
			fclose($fp);
		}		
	}
	
	$new_version = ( $version_actu != $newsletter_config['version'] ) ? 1 : 0;
}

$template->set_filenames( array(
	'header' => 'header.tpl'
));

$template->assign_vars( array(
	'GENERAL_TITLE' => sprintf($lang['general_title'], $newsletter_config['sitename']), 
	'NEW_VERSION' => $new_version, 
	'S_CHARSET' => $datalang['CHARSET'], 
	'META' => $meta 
)); 

$template->pparse('header');

if( defined('MENU') && MENU )
{
	while( list($title, ) = each($lang['menu']) )
	{
		$first_letter = substr($lang['menu'][$title], 0, 1);
		$word = substr($lang['menu'][$title], 1);
		$lang['menu'][$title] = '<b>' . strtoupper($first_letter) . '</b>' . $word; 
	}
	
	$template->set_filenames( array(
		'menu' => 'menu.tpl'
	));
	
	$template->assign_vars( array(
		'TITLE_MENU' => 'menu', 
		'L_ACCUEIL' => $lang['menu']['accueil'], 
		'L_CONFIG' => $lang['menu']['config'], 
		'L_GENERATOR' => $lang['menu']['form_gen'], 
		'L_INFOS' => $lang['menu']['infos'], 
		'L_SEND' => $lang['menu']['send'], 
		'L_GEST_ADMIN' => $lang['menu']['gest_admin'], 
		'L_AUTH_ADMIN' => $lang['menu']['auth_admin'], 
		'L_SUSCRIBERS' => $lang['menu']['suscribers'], 
		'L_DIFF_LIST' => $lang['menu']['diff_list'], 
		'L_LOGS' => $lang['menu']['logs'], 
		'L_BAN_LIST' => $lang['menu']['ban_list'], 
		'L_SYS_PURGE' => $lang['menu']['purge'], 
		'L_IMPORT' => $lang['menu']['import'], 
		'L_EXPORT' => $lang['menu']['export'], 
		'L_STATS' => $lang['menu']['stats'], 
		'L_LOGOUT' => $lang['menu']['logout'], 
		
		'U_ACCUEIL' => sessid("index.php"), 
		'U_CONFIG' => sessid("config.php"), 
		'U_GENERATOR' => sessid("config.php?mode=reglages"), 
		'U_INFOS' => sessid("infos.php"), 
		'U_SEND' => sessid("envoi.php"), 
		'U_GEST_ADMIN' => sessid("admin.php"), 
		'U_AUTH_ADMIN' => sessid("admin_auth.php"), 
		'U_SUSCRIBERS' => sessid("view.php?mode=abonnes"), 
		'U_DIFF_LIST' => sessid("view.php?mode=liste"), 
		'U_LOGS' => sessid("view.php?mode=log"), 
		'U_BAN_LIST' => sessid("ban_list.php"), 
		'U_SYS_PURGE' => sessid("purge.php"), 
		'U_IMPORT' => sessid("tools.php?mode=import"), 
		'U_EXPORT' => sessid("tools.php?mode=export"), 
		'U_STATS' => sessid("stats.php"), 
		'U_LOGOUT' => sessid("login.php?mode=logout") 
	));
	
	$template->pparse('menu');
}
?>