<?php
/*******************************************************************
 *			
 * 			Fichier			:	envoi.php 
 * 			Cr le			:	12 aut 2002 
 * 			Dernire modif	:	07 fvrier 2003 
 * 			Email			:	wascripts@phpcodeur.net 
 * 
 * 				 Copyright 2002-2003 PHPcodeur
 * 
 *******************************************************************/

/*******************************************************************
 *  This program is free software; you can redistribute it and/or 
 * 	modify it under the terms of the GNU General Public License as 
 * 	published by the Free Software Foundation; either version 2 of 
 *  the License, or (at your option) any later version. 
 *******************************************************************/
 

define('IN_NEWSLETTER', true);  
define('PAGE', basename(__FILE__)); 

$waroot = '../'; 
require('./pagestart.php'); 

$vararray = array('new', 'save', 'load', 'send', 'attach', 'delete', 'submit'); 
foreach( $vararray AS $varname )
{
	$$varname = ( isset($HTTP_POST_VARS[$varname]) ) ? true : false; 
}

$resend 	= ( isset($HTTP_POST_VARS['resend']) ) ? true : ( ( isset($HTTP_GET_VARS['resend']) ) ? true : false );
$unattach 	= ( isset($HTTP_POST_VARS['unattach']) ) ? $HTTP_POST_VARS['unattach'] : false; 

$liste 		= ( !empty($HTTP_POST_VARS['liste']) ) ? intval($HTTP_POST_VARS['liste']) : ( ( !empty($HTTP_GET_VARS['liste']) ) ? intval($HTTP_GET_VARS['liste']) : 0 );
$log 		= ( !empty($HTTP_POST_VARS['log']) ) ? intval($HTTP_POST_VARS['log']) : ( ( !empty($HTTP_GET_VARS['log']) ) ? intval($HTTP_GET_VARS['log']) : 0 );
$subject 	= ( !empty($HTTP_POST_VARS['subject']) ) ? $HTTP_POST_VARS['subject'] : '';
$body_html 	= ( !empty($HTTP_POST_VARS['body_html']) ) ? $HTTP_POST_VARS['body_html'] : '';
$body_text 	= ( !empty($HTTP_POST_VARS['body_text']) ) ? $HTTP_POST_VARS['body_text'] : '';
$filename 	= ( !empty($HTTP_POST_VARS['filename']) ) ? $HTTP_POST_VARS['filename'] : array();
$filesize 	= ( !empty($HTTP_POST_VARS['filesize']) ) ? $HTTP_POST_VARS['filesize'] : array();

$num_log 	= '';
$joinlist 	= array();
for( $i = 0; $i < count($filename); $i++ )
{
	$joinlist[] = array(
		'name' => $filename[$i], 
		'size' => $filesize[$i] 
	);
}

$ask_list = ( !$liste || $new || $resend || $load || $delete ) ? ALL_LIST : $liste; 
$is_auth = obtain_auth(AUTH_ALL, $ask_list); 

if( ( !$liste && !count($is_auth['all_list']['auth_view']) ) || ( $liste && !$is_auth[$liste]['auth_view'] ) )
{
	$meta = '<meta http-equiv="refresh" content="6;url=' . sessid("index.php") . '">'; 
	$message = $lang['info_msg']['not_auth']; 
	message(INFO, $message); 
}

$mode = ( !empty($HTTP_GET_VARS['mode']) ) ? $HTTP_GET_VARS['mode'] : ''; 
$file = ( !empty($HTTP_GET_VARS['file']) ) ? $HTTP_GET_VARS['file'] : ''; 
if( $mode == 'download' && !empty($file) )
{
	header("Content-type: application/force-download"); 
	header("Content-Disposition: attachment; filename=" . $file); 
	header("Content-Description: File Transfert"); 
	header("Pragma: no-cache"); 
	header("Expires: 0"); 
	
	readfile('upload/' . $file); 
	
	exit;
}

if( $save || $send )
{
	$time = time();
	$array = array();
	
	for( $i = 0; $i < count($joinlist); $i++ )
	{
		$array[] = $joinlist[$i]['name'];
	}
	
	$attach = implode(",", $array); 
	
	$send_statut = ( $send && $subject != '' ) ? SEND_STANDBY : NO_SEND; 
	
	if( $subject == '' )
	{
		$subject = 'No subject'; 
	}
	
	if( !empty($log) )
	{
		$sql = "UPDATE " . LOG_TABLE . " 
				SET sujet = '$subject', 
					body_html = '$body_html', 
					body_text = '$body_text', 
					date = '$time', 
					attach = '$attach', 
					send = '$send_statut' 
				WHERE log_id = '$log'"; 
		if( !($result = $db->query($sql)) )
		{
			message(ERROR, 'Impossible de mettre  jour la table des logs', __FILE__, __LINE__, $sql);
		}
	}
	else
	{
		$sql = "INSERT INTO " . LOG_TABLE . " (liste_id, sujet, body_html, body_text, date, attach, send) 
				VALUES($liste, '$subject', '$body_html', '$body_text', '$time', '$attach', $send_statut)"; 
		if( !($result = $db->query($sql)) )
		{
			message(ERROR, 'Impossible d\'ajouter une entre dans la table log', __FILE__, __LINE__, $sql);
		}
		
		$log = $db->next_id();
	}
	
	if( $save )
	{
		message(INFO, $lang['info_msg']['success_save_log']);
	}
}

if( ( $send || $resend ) && !$load && !$delete )
{
	if( ( !$liste && !count($is_auth['all_list']['auth_send']) ) || ( $liste && !$is_auth[$liste]['auth_send'] ) )
	{
		$meta = '<meta http-equiv="refresh" content="6;url=' . sessid("envoi.php") . '">'; 
		$message = $lang['info_msg']['not_auth']; 
		message(INFO, $message); 
	}
	
	if( $resend )
	{
		if( $log )
		{
			$sql = "SELECT * 
					FROM " . LOG_TABLE . " 
					WHERE log_id = $log 
					  AND send = " . SEND_STANDBY;
			if( !($result = $db->query($sql)) )
			{
				message(ERROR, 'Impossible d\'obtenir les donnes sur le log slectionn', __FILE__, __LINE__, $sql);
			}
			
			if( !($db->num_rows($result)) )
			{
				message(ERROR, 'log inexistant'); 
			}
		
			$logrow = $db->fetch_array($result);
			$db->free_result($result);
		
			$liste = $logrow['liste_id'];
			$subject = $logrow['sujet'];
			$body_text = $logrow['body_text'];
			$body_html = $logrow['body_html'];
		
			if( !empty($logrow['attach']) )
			{
				if( strpos($logrow['attach'], ",") )
				{
					$array = explode(",", $logrow['attach']);
			
					for( $i = 0; $i < count($array); $i++ )
					{
						$size = @filesize("upload/" . $array[$i]);
						$joinlist[] = array(
							'name' => $array[$i], 
							'size' => ( $size != '' ) ? $size : '' 
						);
					}
				}
				else
				{
					$size = @filesize("upload/" . $logrow['attach']);
					$joinlist[] = array(
						'name' => $logrow['attach'], 
						'size' => ( $size != '' ) ? $size : '' 
					);
				}
			}
		}
		else
		{
			$liste_in = implode(", ", $is_auth['all_list']['auth_send']); 
			
			$sql = "SELECT * 
					FROM " . LOG_TABLE . " 
					WHERE send = " . SEND_STANDBY . " 
					  AND liste_id IN($liste_in)";
			if( !($result = $db->query($sql)) )
			{
				message(ERROR, 'Impossible d\'obtenir la liste des logs non envoys', __FILE__, __LINE__, $sql);
			}
		
			$num_log = $db->num_rows($result);
		
			if( $num_log )
			{
				$box_log = '<select name="log">';
			}
			else
			{
				$box_log = '<select name="log" disabled>';
				$box_log .= '<option value="0"> ------------- </option>'; 
			}
		
			while( $logrow = $db->fetch_array($result) )
			{
				$box_log .= '<option value="' . $logrow['log_id'] . '"> - ' . htmlspecialchars(stripslashes($logrow['sujet'])) . ' - </option>'; 
			}
				
			$box_log .= '</select>';
				
			$db->free_result($result); 
		}
	}
	
	if( $send || ( $resend && $log ) )
	{
		$sql = "SELECT * 
				FROM " . LISTE_TABLE . " 
				WHERE liste_id = $liste";
		if( !($result = $db->query($sql)) )
		{
			message(ERROR, 'Impossible d\'obtenir des infos sur la liste', __FILE__, __LINE__, $sql);
		}
	
		$liste_infos = $db->fetch_array($result);
		$db->free_result($result); 
	
		if( $subject == '' || ( $body_text == '' && $liste_infos['choix_format'] != FORMAT_HTML ) || ( $body_html == '' && $liste_infos['choix_format'] != FORMAT_TEXTE ) )
		{
			$message = $lang['info_msg']['fields_empty']; 
			$message .= '<br /><br />' . sprintf($lang['return_form'], '<a href="' . sessid("envoi.php?liste=" . $liste) . '">', '</a>' ); 
			message(ERROR, $message); 
		}
		else if( ( $body_text != '' && !strstr($body_text, '{LINKS}') ) || ( $body_html != '' && !strstr($body_html, '{LINKS}') ) )
		{
			$message = $lang['info_msg']['no_links']; 
			$message .= '<br /><br />' . sprintf($lang['return_form'], '<a href="' . sessid("envoi.php?liste=" . $liste) . '">', '</a>' ); 
			message(ERROR, $message); 
		}
	
		//
		// Tout est ok, on traite les donnes et on envoie 
		// 
		$subject = stripslashes($subject); 
		
		if( $newsletter_config['engine_send'] == ENGINE_BCC )
		{
			$link_txt = $liste_infos['form_url']; 
			$link_html = '<a href="' . $liste_infos['form_url'] . '">' . $liste_infos['form_url'] . '</a>';
		}
		else if( $newsletter_config['engine_send'] == ENGINE_UNIQ )
		{
			$link = $liste_infos['form_url']; 
			$link .= ( strpos($liste_infos['form_url'], "?") ) ? '&' : '?'; 
			$link .= 'action=desinscription&code={CODE}&liste=' . $liste; 
			
			$link_txt = $link; 
			$link_html = '<a href="' . $link . '">' . $link . '</a>';
		}
		
		if( $send )
		{
			$sql = "UPDATE " . ABONNES_TABLE . " SET send = 0 WHERE liste_id = '$liste'"; 
			if( !($result = $db->query($sql)) )
			{
				message(ERROR, 'Impossible de mettre  jour la table des abonns', __FILE__, __LINE__, $sql);
			}
		}
		
		@set_time_limit(1200);
	
		include_once('../includes/mailer.php');
	
		$mailer = new Mailer();
	
		if( $newsletter_config['use_smtp'] )
		{
			$mailer->set_smtp(
				$newsletter_config['smtp_host'], 
				$newsletter_config['smtp_port'], 
				$newsletter_config['smtp_user'], 
				$newsletter_config['smtp_pass'] 
			);
		}
		
		$mailer->hebergeur = $newsletter_config['hebergeur']; 
		$mailer->charset   = $datalang['CHARSET']; 
		
		if( $newsletter_config['engine_send'] == ENGINE_BCC )
		{
			if( $liste_infos['choix_format'] != FORMAT_HTML )
			{
				$body_text = stripslashes($body_text);		
				$body_text = str_replace('{LINKS}', $link_txt, $body_text);
			}
	
			if( $liste_infos['choix_format'] != FORMAT_TEXTE )
			{
				$body_html = stripslashes($body_html);		
				$body_html = str_replace('{LINKS}', $link_html, $body_html);
			}
		}
		
		switch($liste_infos['choix_format'])
		{
			case FORMAT_TEXTE:
			case FORMAT_HTML:
				$emails_sended = intval($newsletter_config['emails_sended']); 
				$sql_where = ''; 
				if( $emails_sended != 0 )
				{
					$sql_where = 'LIMIT 0, ' . $emails_sended; 
				}
				
				$sql = "SELECT id, email, code 
						FROM " . ABONNES_TABLE . " 
						WHERE liste_id = '$liste' 
						  AND actif = " . ABO_ACTIF . " 
						  AND send = 0 
						$sql_where";
				if( !($result = $db->query($sql)) )
				{
					message(ERROR, 'Impossible d\'obtenir la liste des destinataires', __FILE__, __LINE__, $sql);
				}
				
				$abonnes = array(); 
				$codes = array(); 
				$list_id_abo = array(); 
				while( $row = $db->fetch_array($result) )
				{
					$abonnes[] = $row['email']; 
					$codes[] = $row['code']; 
					$list_id_abo[] = $row['id']; 
				}
		
				$db->free_result($result);
		
				$num_inscrits = count($abonnes); 
		
				if( $num_inscrits > 0 )
				{
					if( $newsletter_config['engine_send'] == ENGINE_BCC )
					{
						$mailer->set_subject($subject);
						$mailer->set_from($newsletter_config['sender_email'], stripslashes($liste_infos['nom']));	
						$mailer->set_to($abonnes, 'bcc');
		
						if( count($joinlist) > 0 )
						{
							for( $j = 0; $j < count($joinlist); $j++ )
							{
								$mailer->attachment("upload/" . $joinlist[$j]['name']);					
							}				
						}
		
						if( $liste_infos['choix_format'] == FORMAT_TEXTE )
						{
							$mailer->set_format(FORMAT_TEXTE);
							$mailer->set_message($body_text);
						}
						else if( $liste_infos['choix_format'] == FORMAT_HTML )
						{
							$mailer->set_format(FORMAT_HTML);
							$mailer->set_message($body_html);
						}
		
						if( !($result = $mailer->send()) )
						{
							message(ERROR, sprintf($lang['info_msg']['failed_send'], $mailer->mail_reponse), __FILE__, __LINE__);
						}
					}
					else if( $newsletter_config['engine_send'] == ENGINE_UNIQ )
					{
						for( $i = 0; $i < $num_inscrits; $i++ )
						{
							if( $liste_infos['choix_format'] == FORMAT_TEXTE )
							{
								$link_tmp = $link_txt; 
								$body_tmp = $body_text;		
							}
							else if( $liste_infos['choix_format'] == FORMAT_HTML )
							{
								$link_tmp = $link_html; 
								$body_tmp = $body_html;		
							}
							
							$mailer->init(); 
							
							$mailer->set_subject($subject);
							$mailer->set_from($newsletter_config['sender_email'], stripslashes($liste_infos['nom']));	
							$mailer->set_to(array($abonnes[$i])); 
							
							if( $newsletter_config['return_path_email'] != '' && EmailOK($newsletter_config['return_path_email']) )
							{
								$mailer->set_header("Return-path", $newsletter_config['return_path_email']); 
							}
		
							if( count($joinlist) > 0 )
							{
								for( $j = 0; $j < count($joinlist); $j++ )
								{
									$mailer->attachment("upload/" . $joinlist[$j]['name']);					
								}				
							}
		
							if( $liste_infos['choix_format'] == FORMAT_TEXTE )
							{
								$link_tmp = str_replace('{CODE}', $codes[$i], $link_tmp); 
								$body_tmp = stripslashes($body_tmp);		
								$body_tmp = str_replace('{LINKS}', $link_tmp, $body_tmp);
								
								$mailer->set_format(FORMAT_TEXTE);
								$mailer->set_message($body_tmp);
							}
							else if( $liste_infos['choix_format'] == FORMAT_HTML )
							{
								$link_tmp = str_replace('{CODE}', $codes[$i], $link_tmp); 
								$body_tmp = stripslashes($body_tmp); 
								$body_tmp = str_replace('{LINKS}', $link_tmp, $body_tmp);
								
								$mailer->set_format(FORMAT_HTML);
								$mailer->set_message($body_tmp);
							}
		
							if( !($result = $mailer->send()) )
							{
								message(ERROR, sprintf($lang['info_msg']['failed_send'], $mailer->mail_reponse), __FILE__, __LINE__);
							}
						}
					}
				}
				break;
		
			case FORMAT_MULTIPLE:
				$emails_sended = intval($newsletter_config['emails_sended']); 
				$sql_where = ''; 
				if( $emails_sended != 0 )
				{
					$sql_where = 'LIMIT 0, ' . ceil($emails_sended/2); 
				}
				
				$sql = "SELECT id, email, code 
						FROM " . ABONNES_TABLE . " 
						WHERE liste_id = '$liste' 
						  AND format = " . FORMAT_TEXTE . " 
						  AND actif = " . ABO_ACTIF . " 
						  AND send = 0 
						$sql_where";
				if( !($result = $db->query($sql)) )
				{
					message(ERROR, 'Impossible d\'obtenir la liste des destinataires de la newsletter texte', __FILE__, __LINE__, $sql);
				}
				
				$abonnes_txt = array(); 
				$codes_txt = array(); 
				$list_id_abo = array(); 
				while( $row = $db->fetch_array($result) )
				{
					$abonnes_txt[] = $row['email']; 
					$codes_txt[] = $row['code']; 
					$list_id_abo[] = $row['id']; 
				}
				$db->free_result($result);
		
				$num_inscrits_txt = count($abonnes_txt);
		
				$sql = "SELECT id, email, code 
						FROM " . ABONNES_TABLE . " 
						WHERE liste_id = '$liste' 
						  AND format = " . FORMAT_HTML . " 
						  AND actif = " . ABO_ACTIF . " 
						  AND send = 0 
						$sql_where";
				if( !($result = $db->query($sql)) )
				{
					message(ERROR, 'Impossible d\'obtenir la liste des destinataires de la newsletter html', __FILE__, __LINE__, $sql);
				}
				
				$abonnes_html = array(); 
				$codes_html = array(); 
				while( $row = $db->fetch_array($result) )
				{
					$abonnes_html[] = $row['email']; 
					$codes_html[] = $row['code']; 
					$list_id_abo[] = $row['id']; 
				}
				$db->free_result($result);
		
				$num_inscrits_html = count($abonnes_html);
				
				if( $num_inscrits_txt > 0 )
				{
					if( $newsletter_config['engine_send'] == ENGINE_BCC )
					{
						$mailer->init(); 
						
						$mailer->set_subject($subject);
						$mailer->set_from($newsletter_config['sender_email'], stripslashes($liste_infos['nom']));	
						$mailer->set_to($abonnes_txt, 'bcc');
		
						if( count($joinlist) > 0 )
						{
							for( $j = 0; $j < count($joinlist); $j++ )
							{
								$mailer->attachment("upload/" . $joinlist[$j]['name']);					
							}				
						}
		
						$mailer->set_format(FORMAT_TEXTE);
						$mailer->set_message($body_text);
								
						if( !($result = $mailer->send()) )
						{
							message(ERROR, sprintf($lang['info_msg']['failed_send'], $mailer->mail_reponse), __FILE__, __LINE__);
						}
					}
					else if( $newsletter_config['engine_send'] == ENGINE_UNIQ )
					{
						for( $i = 0; $i < $num_inscrits_txt; $i++ )
						{
							$link_tmp = $link_txt; 
							$body_tmp = $body_text;		
							
							$mailer->init(); 
							
							$mailer->set_subject($subject);
							$mailer->set_from($newsletter_config['sender_email'], stripslashes($liste_infos['nom']));	
							$mailer->set_to(array($abonnes_txt[$i]));
							
							if( $newsletter_config['return_path_email'] != '' && EmailOK($newsletter_config['return_path_email']) )
							{
								$mailer->set_header("Return-path", $newsletter_config['return_path_email']); 
							}
							
							if( count($joinlist) > 0 )
							{
								for( $j = 0; $j < count($joinlist); $j++ )
								{
									$mailer->attachment("upload/" . $joinlist[$j]['name']);					
								}
							}
		
							$link_tmp = str_replace('{CODE}', $codes_txt[$i], $link_tmp); 
							$body_tmp = stripslashes($body_tmp);		
							$body_tmp = str_replace('{LINKS}', $link_tmp, $body_tmp);
							
							$mailer->set_format(FORMAT_TEXTE);
							$mailer->set_message($body_tmp);
									
							if( !($result = $mailer->send()) )
							{
								message(ERROR, sprintf($lang['info_msg']['failed_send'], $mailer->mail_reponse), __FILE__, __LINE__);
							}
						}
					}
				}
				
				if( $num_inscrits_html > 0 )
				{
					if( $newsletter_config['engine_send'] == ENGINE_BCC )
					{
						$mailer->init(); 
						
						$mailer->set_subject($subject);
						$mailer->set_from($newsletter_config['sender_email'], stripslashes($liste_infos['nom']));	
						$mailer->set_to($abonnes_html, 'bcc');
		
						if( count($joinlist) > 0 )
						{
							for( $j = 0; $j < count($joinlist); $j++ )
							{
								$mailer->attachment("upload/" . $joinlist[$j]['name']);					
							}				
						}
		
						$mailer->set_format(FORMAT_HTML);
						$mailer->set_message($body_html);
						
						if( !($result = $mailer->send()) )
						{
							message(ERROR, sprintf($lang['info_msg']['failed_send'], $mailer->mail_reponse), __FILE__, __LINE__);
						}
					}
					else if( $newsletter_config['engine_send'] == ENGINE_UNIQ )
					{
						for( $i = 0; $i < $num_inscrits_html; $i++ )
						{
							$link_tmp = $link_html; 
							$body_tmp = $body_html;		
							
							$mailer->init(); 
							
							$mailer->set_subject($subject);
							$mailer->set_from($newsletter_config['sender_email'], stripslashes($liste_infos['nom']));	
							$mailer->set_to(array($abonnes_html[$i]));
							
							if( $newsletter_config['return_path_email'] != '' && EmailOK($newsletter_config['return_path_email']) )
							{
								$mailer->set_header("Return-path", $newsletter_config['return_path_email']); 
							}
							
							if( count($joinlist) > 0 )
							{
								for( $j = 0; $j < count($joinlist); $j++ )
								{
									$mailer->attachment("upload/" . $joinlist[$j]['name']);					
								}
							}
		
							$link_tmp = str_replace('{CODE}', $codes_html[$i], $link_tmp); 
							$body_tmp = stripslashes($body_tmp); 
							$body_tmp = str_replace('{LINKS}', $link_tmp, $body_tmp);
								
							$mailer->set_format(FORMAT_HTML);
							$mailer->set_message($body_tmp);
							
							if( !($result = $mailer->send()) )
							{
								message(ERROR, sprintf($lang['info_msg']['failed_send'], $mailer->mail_reponse), __FILE__, __LINE__);
							}
						}
					}
				}
			break;
		}// fin du switch 
		
		if( count($list_id_abo) == 0 )
		{
			message(INFO, $lang['info_msg']['no_suscribers']); 
		}
		
		$list_id = implode(", ", $list_id_abo); 
		$sql = "UPDATE " . ABONNES_TABLE . " SET send = 1 WHERE id IN($list_id)"; 
		if( !$db->query($sql) )
		{
			unset($db); 
			$db = new sql($dbhost, $dbuser, $dbpassword, $dbname);
			
			$sql = "UPDATE " . ABONNES_TABLE . " SET send = 1 WHERE id IN($list_id)"; 
			if( !$db->connect_id || !$db->query($sql) )
			{
				message(ERROR, 'Impossible de mettre  jour la table des abonns', __FILE__, __LINE__, $sql); 
			}
		}
		
		$no_send = 0; 
		$num_dest = 0; 
		$sql = "SELECT COUNT(*) AS num, send 
				FROM " . ABONNES_TABLE . " 
				WHERE liste_id = '$liste' 
				  AND actif = " . ABO_ACTIF . " 
				GROUP BY send"; 
		if( !($result = $db->query($sql)) )
		{
			message(ERROR, 'Impossible d\'obtenir le nombre d\'envois restant  effectuer', __FILE__, __LINE__, $sql);
		}
		
		while( $row = $db->fetch_array($result) )
		{
			if( $row['send'] == 1 )
			{
				$num_dest = $row['num']; 
			}
			else
			{
				$no_send = $row['num']; 
			}
		}
		$db->free_result($result);
		
		if( $no_send > 0 )
		{
			$step = ( !empty($HTTP_GET_VARS['step']) ) ? $HTTP_GET_VARS['step'] : ''; 
			
			if( $step == 'auto' )
			{
				sleep(10); 
				Location(sessid("envoi.php?resend=1&log=" . $log . "&step=auto")); 
			}
			
			$message  = sprintf($lang['info_msg']['success_send_newsletter'], $num_dest); 
			$message .= '<br /><br />' .  sprintf($lang['info_msg']['resend_auto'], '<a href="' . sessid("envoi.php?resend=1&log=" . $log . "&step=auto") . '">', '</a>'); 
			$message .= '<br /><br />' .  sprintf($lang['info_msg']['resend_manuel'], '<a href="' . sessid("envoi.php?resend=1&log=" . $log) . '">', '</a>'); 
		
			message(INFO, $message); 
		}
		else
		{
			$sql = "UPDATE " . ABONNES_TABLE . " SET send = 0 WHERE liste_id = '$liste'"; 
			if( !($result = $db->query($sql)) )
			{
				message(ERROR, 'Impossible de mettre  jour la table des abonns', __FILE__, __LINE__, $sql);
			}
			
			$sql = "UPDATE " . LOG_TABLE . " SET send = " . SENDED . " WHERE log_id = '$log'"; 
			if( !($result = $db->query($sql)) )
			{
				message(ERROR, 'Impossible de mettre  jour la table des logs', __FILE__, __LINE__, $sql);
			}
			
			message(INFO, sprintf($lang['info_msg']['success_send_newsletter'], $num_dest)); 
		}		
	}// fin de envoi 
}
else if( $load && !$delete )
{
	if( $submit )
	{
		$log = intval($HTTP_POST_VARS['loadlog']);
		
		$sql = "SELECT * 
				FROM " . LOG_TABLE . " 
				WHERE log_id = $log 
				  AND send = " . NO_SEND;
		if( !($result = $db->query($sql)) )
		{
			message(ERROR, 'Impossible d\'obtenir les donnes sur le log slectionn', __FILE__, __LINE__, $sql);
		}
		
		if( !($db->num_rows($result)) )
		{
			message(ERROR, 'log inexistant'); 
		}
		
		$logrow = $db->fetch_array($result);
		$db->free_result($result);
		
		$liste = $logrow['liste_id'];
		$subject = $logrow['sujet'];
		$body_text = $logrow['body_text'];
		$body_html = $logrow['body_html'];
		
		if( !empty($logrow['attach']) )
		{
			if( strpos($logrow['attach'], ",") )
			{
				$array = explode(",", $logrow['attach']);
			
				for( $i = 0; $i < count($array); $i++ )
				{
					$size = @filesize("upload/" . $array[$i]);
					$joinlist[] = array(
						'name' => $array[$i], 
						'size' => ( $size != '' ) ? $size : '' 
					);
				}
			}
			else
			{
				$size = @filesize("upload/" . $logrow['attach']);
				$joinlist[] = array(
					'name' => $logrow['attach'], 
					'size' => ( $size != '' ) ? $size : '' 
				);
			}
		}
	}
	else
	{
		$liste_in = implode(", ", $is_auth['all_list']['auth_view']); 
		
		$sql = "SELECT * 
				FROM " . LOG_TABLE . " 
				WHERE send = " . NO_SEND . " 
				  AND liste_id IN($liste_in)";
		if( !($result = $db->query($sql)) )
		{
			message(ERROR, 'Impossible d\'obtenir la liste des logs non envoys', __FILE__, __LINE__, $sql);
		}
		
		$num_log = $db->num_rows($result);
		
		if( $num_log )
		{
			$box_log = '<select name="loadlog">';
		}
		else
		{
			$box_log = '<select name="loadlog" disabled>';
			$box_log .= '<option value="0"> ------------- </option>'; 
		}
		
		while( $logrow = $db->fetch_array($result) )
		{
			$box_log .= '<option value="' . $logrow['log_id'] . '"> - ' . htmlspecialchars(stripslashes($logrow['sujet'])) . ' - </option>'; 
		}
				
		$box_log .= '</select>';
				
		$db->free_result($result);
	}
}
else if( $delete )
{
	if( !count($is_auth['all_list']['auth_del']) )
	{
		$meta = '<meta http-equiv="refresh" content="6;url=' . sessid("envoi.php") . '">'; 
		$message = $lang['info_msg']['not_auth']; 
		message(INFO, $message); 
	}
	
	if( $submit )
	{
		$log_id = intval($HTTP_POST_VARS['deletelog']);
		
		$sql = "SELECT attach 
				FROM " . LOG_TABLE . " 
				WHERE log_id = $log_id";
		if( !($result = $db->query($sql)) )
		{
			message(ERROR, 'Impossible d\'obtenir les donnes sur le log slectionn', __FILE__, __LINE__, $sql);
		}
		
		$string_attach = $db->result($result, 0, "attach");
		
		$sql = "DELETE 
				FROM " . LOG_TABLE . " 
				WHERE log_id = $log_id";
		if( !($result = $db->query($sql)) )
		{
			message(ERROR, 'Impossible de supprimer le log slectionn', __FILE__, __LINE__, $sql);
		}
		
		if( strpos($string_attach, ",") )
		{
			$array_attach = explode(",", $string_attach);
		
			for( $i = 0; $i < count($array_attach); $i++ )
			{
				@unlink("upload/" . $array_attach[$i]);
			}
		}
		else if( $string_attach != '' )
		{
			@unlink("upload/" . $string_attach); 
		}
		
		message(INFO, $lang['info_msg']['success_delete_log']);
	}
	else
	{
		$liste_in = implode(", ", $is_auth['all_list']['auth_del']); 
		
		$sql = "SELECT * 
				FROM " . LOG_TABLE . " 
				WHERE send = " . NO_SEND . " 
				  AND liste_id IN($liste_in)";
		if( !($result = $db->query($sql)) )
		{
			message(ERROR, 'Impossible d\'obtenir la liste des logs non envoys', __FILE__, __LINE__, $sql);
		}
		
		$num_log = $db->num_rows($result);
		
		if( $num_log )
		{
			$box_log = '<select name="deletelog">';
		}
		else
		{
			$box_log = '<select name="deletelog" disabled>';
			$box_log .= '<option value="0"> ------------- </option>'; 
		}
		
		while( $logrow = $db->fetch_array($result) )
		{
			$box_log .= '<option value="' . $logrow['log_id'] . '"> - ' . htmlspecialchars(stripslashes($logrow['sujet'])) . ' - </option>'; 
		}
				
		$box_log .= '</select>';
				
		$db->free_result($result);
	}
}
else if( $attach )
{
	$upload_possibility = @ini_get('file_uploads');
	
	if( $upload_possibility && strtolower($upload_possibility) != 'off' )
	{
		if( !empty($HTTP_POST_FILES['join']['name']) )
		{
			if( is_uploaded_file($HTTP_POST_FILES['join']['tmp_name']) )
			{
				if( @file_exists("upload/" . $HTTP_POST_FILES['join']['name']) )
				{
					@unlink("upload/" . $HTTP_POST_FILES['join']['name']);
				}
				
				$res = @move_uploaded_file($HTTP_POST_FILES['join']['tmp_name'], "upload/" . $HTTP_POST_FILES['join']['name']);
				
				if( $res )
				{
					$joinlist[] = array(
						'name' => $HTTP_POST_FILES['join']['name'], 
						'size' => $HTTP_POST_FILES['join']['size']
					);
				}				
			}
		}
	}
	else if( !empty($HTTP_POST_VARS['join']) )
	{
		if( @file_exists("upload/" . $HTTP_POST_VARS['join']) )
		{
			$joinlist[] = array(
				'name' => $HTTP_POST_VARS['join'], 
				'size' => filesize("upload/" . $HTTP_POST_VARS['join']) 
			);
		}
	}
}
else if( $unattach )
{
	list( $offset,) = each($unattach);
	
	$filename_del = $joinlist[$offset]['name'];
	
	array_splice($joinlist, $offset, 1);
	@unlink("upload/" . $filename_del);
}

if( !$liste || $new )
{
	$destinataire = list_box(AUTH_VIEW); 
}

if( $liste && !$new )
{
	$sql = "SELECT liste_id, nom, choix_format 
			FROM " . LISTE_TABLE . " 
			WHERE liste_id = $liste"; 
	if( !($result = $db->query($sql)) )
	{
		message(ERROR, 'Impossible d\'obtenir des informations sur la liste slectionne', __FILE__, __LINE__, $sql);
	}
	
	$liste_info = $db->fetch_array($result);	
	$destinataire = htmlspecialchars(stripslashes($liste_info['nom'])) . '<input type="hidden" name="liste" value="' . $liste_info['liste_id'] . '" />';
}

define('MENU', true);
include('page_header.php');	

$template->set_filenames( array(
	'body' => 'default_send.tpl'
));
	
$template->assign_vars( array(
	'TITLE' => $lang['menu']['send'], 
	'HEAD' => $lang['head']['send'], 
	'L_BUTTON_NEW' => $lang['button']['new'], 
	'L_BUTTON_LOAD' => $lang['button']['load'], 
	'L_BUTTON_DELETE' => $lang['button']['delete'], 
	'L_BUTTON_RESEND' => $lang['button']['resend'], 
	'L_BODY_TEXT' => $lang['body_text'], 
	'L_BODY_HTML' => $lang['body_html'], 
	
	'U_FORM' => sessid("envoi.php"), 
	'LINKS' => '{LINKS}' 
));

if( $load && !$submit && !$new )
{
	$template->assign_block_vars('action', array(
		'L_CHOICE' => $lang['choice_load_log'], 
		'L_BUTTON_VALID' => $lang['button']['valid'], 
		
		'BOX_ITEM' => $box_log, 
		'HIDDEN_FIELDS' => ( $num_log ) ? '<input type="hidden" name="load" value="1" />' : '' 
	));
}
else if( $delete && !$submit && !$new )
{
	$template->assign_block_vars('action', array(
		'L_CHOICE' => $lang['choice_delete_log'], 
		'L_BUTTON_VALID' => $lang['button']['valid'], 
		
		'BOX_ITEM' => $box_log, 
		'HIDDEN_FIELDS' => ( $num_log ) ? '<input type="hidden" name="delete" value="1" />' : '' 
	));
}
else if( $resend && !$submit && !$new )
{
	$template->assign_block_vars('action', array(
		'L_CHOICE' => $lang['choice_load_log'], 
		'L_BUTTON_VALID' => $lang['button']['valid'], 
		
		'BOX_ITEM' => $box_log, 
		'HIDDEN_FIELDS' => '<input type="hidden" name="resend" value="1" />' 
	));
}
else if( !$liste || $new )
{
	$template->assign_block_vars('action', array(
		'L_CHOICE' => $lang['choice_liste_dest'], 
		'L_BUTTON_VALID' => $lang['button']['valid'], 
		
		'BOX_ITEM' => $destinataire, 
		'HIDDEN_FIELDS' => '' 
	));
}
else
{
	//
	// Affichage du formulaire selon les critres de la liste donne
	//
	$hidden_fields = '<input type="hidden" name="liste" value="' . $liste . '" />';
	$hidden_fields .= ( !empty($log) ) ? '<input type="hidden" name="log" value="' . $log . '" />' : '';
	$upload_possibility = @ini_get('file_uploads');
	
	$template->assign_block_vars('formulaire', array(
		'L_DEST' => $lang['destinataire'], 
		'L_SUBJECT' => $lang['log_subject'], 
		'L_BUTTON_APERCU' => $lang['button']['apercu'], 
		'L_BUTTON_SEND' => $lang['button']['send'], 
		'L_BUTTON_SAVE' => $lang['button']['save'], 
		'L_TITLE_ATTACH' => $lang['title']['attach'], 
		'L_ATTACH_NOTE' => $lang['attach_note'], 
		'INPUT_TYPE' => ( $upload_possibility && strtolower($upload_possibility) != 'off' ) ? 'file' : 'text', 
		'L_BUTTON_ATTACH' => $lang['button']['add_file'], 
		
		'S_SUBJECT' => ( !empty($subject) ) ? htmlspecialchars(stripslashes($subject)) : '', 
		'S_DEST' => htmlspecialchars(stripslashes($liste_info['nom'])), 
		'HIDDEN_FIELDS' => $hidden_fields 
	));
	
	if( $liste_info['choix_format'] != FORMAT_HTML )
	{
		$template->assign_block_vars('formulaire.text', array(
			'L_BODY_TEXT' => $lang['body_text'], 
			'S_BODY_TEXT' => ( !empty($body_text) ) ? htmlspecialchars(stripslashes($body_text)) : '', 			
			'L_LINK' => ( $liste_info['choix_format'] == FORMAT_MULTIPLE ) ? $lang['link_set_des'] : $lang['link_des'] 
		));
	}
	
	if( $liste_info['choix_format'] != FORMAT_TEXTE )
	{
		$template->assign_block_vars('formulaire.html', array(
			'L_BODY_HTML' => $lang['body_html'], 
			'S_BODY_HTML' => ( !empty($body_html) ) ? htmlspecialchars(stripslashes($body_html)) : '', 
			'L_LINK' => ( $liste_info['choix_format'] == FORMAT_MULTIPLE ) ? $lang['link_set_des'] : $lang['link_des'] 
		));
	}
	
	for( $i = 0; $i < count($joinlist); $i++ )
	{
		if( !( $i % 2 ) )
		{
			$class1 = 'row1';
			$class2 = 'row2';
		}
		else
		{
			$class1 = 'row2';
			$class2 = 'row1';
		}
		
		$template->assign_block_vars('formulaire.attach', array(
			'FILENAME' => ( $joinlist[$i]['size'] != '' ) ? '<a href="' . sessid("envoi.php?mode=download&file=" . $joinlist[$i]['name']) . '">' . $joinlist[$i]['name'] . '</a>' : $joinlist[$i]['name'], 
			'FILENAME2' => $joinlist[$i]['name'], 
			'FILESIZE' => ( $joinlist[$i]['size'] != '' ) ? sprintf("%.2f", $joinlist[$i]['size']/1024) . ' Ko' : '<br /><span class="smalltexte">' . $lang['no_attach_in_dir'] . '</span>', 
			'FILESIZE2' => $joinlist[$i]['size'], 
			'CLASS1' => $class1, 
			'CLASS2' => $class2, 
			'OFFSET' => $i, 
			'L_BUTTON_DELETE' => $lang['button']['del_file'] 
		));
	}
}

$template->pparse('body');
include('page_footer.php');
?>