<?php
/*******************************************************************
 *			
 * 			Fichier			:	ban_list.php 
 * 			Cr le			:	25 octobre 2002 
 * 			Dernire modif	:	31 janvier 2003 
 * 			Email			:	wascripts@phpcodeur.net 
 * 
 * 				 Copyright 2002-2003 PHPcodeur
 * 
 *******************************************************************/

/*******************************************************************
 *  This program is free software; you can redistribute it and/or 
 * 	modify it under the terms of the GNU General Public License as 
 * 	published by the Free Software Foundation; either version 2 of 
 *  the License, or (at your option) any later version. 
 *******************************************************************/


define('IN_NEWSLETTER', true); 
define('PAGE', basename(__FILE__)); 

$waroot = '../';  
require('./pagestart.php'); 

$submit  = ( isset($HTTP_POST_VARS['submit']) ) ? true : false; 
$delete  = ( isset($HTTP_POST_VARS['delete']) ) ? true : false; 
$confirm = ( isset($HTTP_POST_VARS['confirm']) ) ? true : false; 
$liste   = ( !empty($HTTP_POST_VARS['liste']) ) ? intval($HTTP_POST_VARS['liste']) : ( ( !empty($HTTP_GET_VARS['liste']) ) ? intval($HTTP_GET_VARS['liste']) : 0 ); 

if( !$submit )
{
	$ask_list = ( !$liste ) ? ALL_LIST : $liste; 
	$is_auth = obtain_auth(AUTH_ALL, $ask_list); 
}

if( isset($HTTP_POST_VARS['cancel']) )
{
	Location(sessid("ban_list.php?liste=" . $liste)); 
}

if( $submit )
{
	$liste = $HTTP_POST_VARS['liste']; 
	$pattern = ( !empty($HTTP_POST_VARS['pattern']) ) ? $HTTP_POST_VARS['pattern'] : ''; 
	
	if( $pattern == '' )
	{
		Location(sessid("ban_list.php")); 
	}
	
	$list = array(); 
	if( $liste == -1 )
	{
		$sql = "SELECT liste_id FROM " . LISTE_TABLE; 
		if( !($result = $db->query($sql)) )
		{
			message(ERROR, 'Impossible d\'obtenir la liste des listes de diffusion', __FILE__, __LINE__, $sql);
		}
		
		while( $row = $db->fetch_array($result) )
		{
			$list[] = $row['liste_id']; 
		}
	}
	else
	{
		$list[] = $liste; 
	}
	
	for( $i = 0; $i < count($list); $i++ )
	{
		$sql = "INSERT INTO " . BANLIST_TABLE . " (liste_id, ban_email) 
				VALUES(" . $list[$i] . ", '$pattern')"; 
		if( !($result = $db->query($sql)) )
		{
			message(ERROR, 'Impossible de mettre  jour la table des bannis', __FILE__, __LINE__, $sql);
		}
	}
	
	$meta = '<meta http-equiv="refresh" content="6;url=' . sessid("ban_list.php") . '">'; 
	$message = $lang['info_msg']['success_modif']; 
	message(INFO, $message); 
}
else if( $delete )
{
	$ban_email = ( !empty($HTTP_POST_VARS['ban_email']) ) ? $HTTP_POST_VARS['ban_email'] : array(); 
	
	if( $confirm )
	{
		if( count($ban_email) )
		{
			$list_ban_id = implode(", ", $ban_email); 
			
			$sql = "DELETE FROM " . BANLIST_TABLE . " WHERE ban_id IN ($list_ban_id)";
			if( !($result = $db->query($sql)) )
			{
				message(ERROR, 'La suppression des emails bannis a chou', __FILE__, __LINE__, $sql);
			}
		}
		
		Location(sessid("ban_list.php")); 
	}
	else
	{
		$hidden_fields = '<input type="hidden" name="delete" value="1" />'; 
		for( $i = 0; $i < count($ban_email); $i++ )
		{
			$hidden_fields .= '<input type="hidden" name="ban_email[]" value="' . $ban_email[$i] . '" />'; 
		}
	
		define('MENU', true);
		include('page_header.php');	
		
		$template->set_filenames(array(
			'body' => 'confirm.tpl'
		)); 
	
		$template->assign_vars( array(
			'TITLE' => $lang['title']['confirm'], 
			'L_TEXT_CONFIRM' => $lang['info_msg']['confirm_del_ban'], 
			'L_YES' => $lang['yes'], 
			'L_NO' => $lang['no'], 
			
			'HIDDEN_FIELDS' => $hidden_fields, 
			'U_FORM' => sessid("ban_list.php") 
		)); 
	
		$template->pparse('body'); 
		
		include('page_footer.php'); 
		exit; 
	}
}

if( ( !$liste && !count($is_auth['all_list']['auth_view']) ) || $liste && !$is_auth[$liste]['auth_view'] )
{
	$meta = '<meta http-equiv="refresh" content="6;url=' . sessid("index.php") . '">'; 
	$message = $lang['info_msg']['not_auth']; 
	message(INFO, $message); 
}

$list_box = list_box(AUTH_VIEW, true); 
$list_box2 = list_box(AUTH_VIEW, false, false, true); 

$varget = ''; 
$sql_where = ''; 
if( $liste )
{
	$varget = '?liste=' . $liste;
	$sql_where = "WHERE liste_id = $liste"; 
}
else
{
	$liste_in = implode(", ", $is_auth['all_list']['auth_view']); 
	$sql_where = "WHERE liste_id IN($liste_in)"; 
}

$sql = "SELECT ban_id, liste_id, ban_email 
		FROM " . BANLIST_TABLE . " $sql_where"; 
if( !($result = $db->query($sql)) )
{
	message(ERROR, 'Impossible d\'obtenir la liste des emails bannis', __FILE__, __LINE__, $sql);
}

$rowban = array(); 
while( $row = $db->fetch_array($result) )
{
	$rowban[] = $row; 
}
$db->free_result($result); 

define('MENU', true);
include('page_header.php');	

$template->set_filenames( array(
	'body' => 'ban_list.tpl'
)); 

$template->assign_vars(array(
	'TITLE' => $lang['menu']['ban_list'], 
	'HEAD' => $lang['head']['ban_list'], 
	'L_BAN_EMAIL' => $lang['email_ban'], 
	'L_ADD_BAN_EMAIL' => $lang['title']['addban'], 
	'L_EXPLAIN' => nl2br($lang['ban_note']), 
	'L_APPLI_LIST' => $lang['appli_restriction'], 
	'L_EMAIL_OR_FRAG' => $lang['ban_pattern'], 
	'L_BUTTON_VALID' => $lang['button']['valid'], 
	
	'LIST_BOX' => $list_box, 
	'LIST_BOX2' => $list_box2, 
	'JUMP' => sessid("ban_list.php"), 
	'U_FORM' => sessid("ban_list.php" . $varget) 
)); 

if( count($rowban) )
{
	$display_checkbox = false; 
	if( ( !$liste && count($is_auth['all_list']['auth_del']) ) || ( $liste && $is_auth[$liste]['auth_del'] ) )
	{
		$template->assign_block_vars('del', array(
			'L_DELETE' => $lang['delete_ban']
		)); 
		
		$display_checkbox = true; 
	}
		
	for( $i = 0; $i < count($rowban); $i++ )
	{
		$class = ( ( $i % 2 ) == 0 ) ? 'row1' : 'row2';
		
		$template->assign_block_vars('row', array(
			'EMAIL_BAN' => $rowban[$i]['ban_email'], 
			'CLASS' => $class 
		)); 
		
		
		if( $display_checkbox )
		{
			if( $is_auth[$rowban[$i]['liste_id']]['auth_del'] )
			{
				$checkbox = '<input type="checkbox" name="ban_email[]" value="' . $rowban[$i]['ban_id'] . '" />';
			}
			else
			{
				$checkbox = '&nbsp;'; 
			}
			
			$template->assign_block_vars('row.checkbox', array(
				'CHECKBOX' => $checkbox 
			)); 
		}
	}
}
else
{
	$empty_reasons = ( $liste ) ? $lang['empty_liste_ban'] : $lang['empty_ban']; 
	
	$template->assign_block_vars('empty', array(
		'L_EMPTY' => $empty_reasons 
	));
}

$template->pparse('body'); 

include('page_footer.php'); 
?>