<?php
/*******************************************************************
 *			
 * 			Fichier			:	tools.php 
 * 			Cr le			:	24 octobre 2002 
 * 			Dernire modif	:	31 janvier 2003 
 * 			Email			:	wascripts@phpcodeur.net 
 * 
 * 				 Copyright 2002-2003 PHPcodeur
 * 
 *******************************************************************/

/*******************************************************************
 *  This program is free software; you can redistribute it and/or 
 * 	modify it under the terms of the GNU General Public License as 
 * 	published by the Free Software Foundation; either version 2 of 
 *  the License, or (at your option) any later version. 
 *******************************************************************/


define('IN_NEWSLETTER', true); 
define('PAGE', basename(__FILE__)); 

$waroot = '../'; 
require('./pagestart.php'); 

$submit = ( isset($HTTP_POST_VARS['submit']) ) ? true : false; 
$mode 	= ( !empty($HTTP_GET_VARS['mode']) ) ? $HTTP_GET_VARS['mode'] : ''; 

if( $mode != 'import' && $mode != 'export' )
{
	Location(sessid('index.php')); 
}

$liste 	= ( !empty($HTTP_POST_VARS['liste']) ) ? intval($HTTP_POST_VARS['liste']) : 0; 
$format	= ( !empty($HTTP_POST_VARS['format']) ) ? intval($HTTP_POST_VARS['format']) : 0; 
$glue  	= ( !empty($HTTP_POST_VARS['glue']) ) ? $HTTP_POST_VARS['glue'] : ''; 

if( $mode == 'export' )
{
	$is_auth = obtain_auth(AUTH_EXPORT, ALL_LIST); 
	
	if( !count($is_auth['all_list']['auth_export']) )
	{
		$meta = '<meta http-equiv="refresh" content="6;url=' . sessid("index.php") . '">'; 
		$message = $lang['info_msg']['not_auth']; 
		message(INFO, $message); 
	}
	
	if( $submit )
	{
		$gzip_compress = ( !empty($HTTP_POST_VARS['gzip_compress']) ) ? $HTTP_POST_VARS['gzip_compress'] : 0; 
		$glue = ( $glue != '' ) ? $glue : "\r\n"; 
		
		$sql = 'SELECT choix_format 
				FROM ' . LISTE_TABLE . ' 
				WHERE liste_id = ' . $liste; 
		if( !($result = $db->query($sql)) )
		{
			message(ERROR, 'Impossible d\'obtenir des informations sur la liste donne', __FILE__, __LINE__, $sql);
		}
		
		if( $db->num_rows($result) )
		{
			$list_format = $db->result($result, 0, 'choix_format'); 
			
			//
			// On augmente le temps d'execution du script pour avoir plus de temps pour les insertions
			// 
			@set_time_limit(1200); 
			
			$sql = "SELECT email 
					FROM " . ABONNES_TABLE . " 
					WHERE liste_id = $liste 
					  AND actif = " . ABO_ACTIF; 
			$sql .= ( $list_format != FORMAT_MULTIPLE ) ? "" : " AND format = '$format'"; 
			if( !($result = $db->query($sql)) )
			{
				message(ERROR, 'Impossible d\'obtenir la liste des abonns pour la liste de diffusion concerne', __FILE__, __LINE__, $sql);
			}
			
			$emails = array(); 
			while( $row = $db->fetch_array($result) )
			{
				$emails[] = $row['email']; 
			}
			
			$gzip_file = false; 
			if( $gzip_compress && @extension_loaded('zlib') )
			{
				$gzip_file = true; 
			}
			
			if( $gzip_file ) 
			{
				@ob_start();
				@ob_implicit_flush(0);
				header("Content-Type: application/x-gzip; name=\"wa_listdiff_$liste.txt.gz\"");
				header("Content-disposition: attachment; filename=wa_listdiff_$liste.txt.gz");
			}
			else
			{
				header("Content-Type: text/x-delimtext; name=\"wa_listdiff_$liste.txt\""); 
				header("Content-disposition: attachment; filename=wa_listdiff_$liste.txt"); 				
			}
			
			header('Content-Description: File Transfert'); 
			header('Pragma: no-cache'); 
			header('Expires: 0'); 
			
			for( $i = 0; $i < count($emails); $i++ )
			{
				echo $emails[$i]; 
				
				if( ( $i+1 ) < count($emails) )
				{
					echo $glue; 
				}
			}
			
			if( $gzip_file )
			{
				$backup = ob_get_contents(); 
				$backup = gzencode($backup);
				ob_end_clean(); 
				
				echo $backup; 
			}			
			exit;
		}
		else
		{
			$meta = '<meta http-equiv="refresh" content="6;url=' . sessid("tools.php?mode=export") . '">';
			message(ERROR, $lang['info_msg']['unknow_list']);
		}		
	}
	
	$list_box = list_box(AUTH_EXPORT); 
	
	define('MENU', true);
	include('page_header.php');	
	
	$template->set_filenames( array(
		'body' => 'export.tpl' 
	)); 
	
	$template->assign_vars(array(
		'TITLE' => $lang['menu']['export'], 
		'HEAD' => nl2br($lang['head']['export']), 
		'L_CHOICE_LIST' => $lang['choice_liste'], 
		'L_CHOICE_FORMAT' => $lang['format_is'], 
		'L_GLUE' => $lang['char_glue'], 
		'L_BUTTON_VALID' => $lang['button']['valid'], 
		
		'LIST_BOX' => $list_box, 
		'U_FORM' => sessid('tools.php?mode=export') 
	)); 
	
	if( @extension_loaded('zlib') )
	{
		$template->assign_block_vars('gzip_option', array(
			'L_GZIP_COMPRESS' => $lang['gzip_compress'], 
			'L_YES' => $lang['yes'], 
			'L_NO' => $lang['no'] 
		));
	}
}
else if( $mode == 'import' )
{
	$is_auth = obtain_auth(AUTH_IMPORT, ALL_LIST); 
	
	if( !count($is_auth['all_list']['auth_import']) )
	{
		$meta = '<meta http-equiv="refresh" content="6;url=' . sessid("index.php") . '">'; 
		$message = $lang['info_msg']['not_auth']; 
		message(INFO, $message); 
	}
	
	if( $submit )
	{
		$list_email = ( !empty($HTTP_POST_VARS['list_email']) ) ? $HTTP_POST_VARS['list_email'] : ''; 
		
		$file_import_name 	 = ( !empty($HTTP_POST_FILES['file_import']['name']) ) ? $HTTP_POST_FILES['file_import']['name'] : ''; 
		$file_import_tmpname = ( !empty($HTTP_POST_FILES['file_import']['tmp_name']) ) ? $HTTP_POST_FILES['file_import']['tmp_name'] : ''; 
		$file_import_type	 = ( !empty($HTTP_POST_FILES['file_import']['type']) ) ? $HTTP_POST_FILES['file_import']['type'] : ''; 
		
		$list_tmp = ''; 
		//
		// Import via upload ? 
		//
		if( $file_import_tmpname != '' && $file_import_name != '' )
		{
			if( is_uploaded_file($file_import_tmpname) )
			{
				if( stristr($file_import_type, "text") || ( stristr($file_import_type, "gzip") && @extension_loaded('zlib') ) )
				{
					if( preg_match("#\.gz$#i", $file_import_name) )
					{
						$gz = @gzopen($file_import_tmpname, "rb"); 
						if( !$gz )
						{
							$meta = '<meta http-equiv="refresh" content="6;url=' . sessid("tools.php?mode=import") . '">';
							message(ERROR, $lang['failed_open_file']);
						}
						
						while( !gzeof($gz) )
						{
							$list_tmp .= gzgets($gz, 1024);
						}
						gzclose($gz); 
					}
					else
					{
						$fp = @fopen($file_import_tmpname, 'r'); 
						if( !$fp )
						{
							$meta = '<meta http-equiv="refresh" content="6;url=' . sessid("tools.php?mode=import") . '">';
							message(ERROR, $lang['failed_open_file']);
						}
						
						$list_tmp = fread($fp, filesize($file_import_tmpname)); 
						fclose($fp); 
						
						$list_tmp = addslashes($list_tmp); 
					}
				}
				else
				{
					$meta = '<meta http-equiv="refresh" content="6;url=' . sessid('tools.php?mode=import') . '">';
					message(ERROR, $lang['error_filetype']);
				}
			}
			else
			{
				$meta = '<meta http-equiv="refresh" content="6;url=' . sessid('tools.php?mode=import') . '">';
				message(ERROR, $lang['error_uploading']); 
			}
			
		}// fin de si upload 
		
		//
		// Mode importation via le textarea 
		//
		else if( strlen($list_email) > 0 )
		{
			$list_tmp = $list_email; 
		}
		
		// 
		// Aucun fichier d'import reu et textarea vide 
		//
		else
		{
			$meta = '<meta http-equiv="refresh" content="6;url=' . sessid("tools.php?mode=import") . '">';
			message(ERROR, $lang['no_receive_data']); 
		}
		
		$list_tmp = trim($list_tmp); 		
		$glue = ( $glue != '' ) ? $glue : "\n"; 
		$emails = array(); 
		$time = time(); 
		
		if( ereg($glue, $list_tmp) )
		{
			$elt = explode($glue, $list_tmp); 
			$total_emails = count($elt); 
			
			$num_emails = ( count($elt) > MAX_IMPORT ) ? MAX_IMPORT : $total_emails; 
			
			for( $i = 0; $i < $num_emails; $i++ )
			{
				$email = trim($elt[$i]); 
				if( !EmailOK($email) )
				{
					$meta = '<meta http-equiv="refresh" content="6;url=' . sessid('tools.php?mode=import') . '">';
					message(ERROR, $lang['info_msg']['invalid_email'] . " [1-$i]");
				}
				
				$emails[] = $email; 
			}
		}
		else
		{
			$total_emails = $num_emails = 1; 
			
			$email = trim($list_tmp); 
			if( !EmailOK($email) )
			{
				$meta = '<meta http-equiv="refresh" content="6;url=' . sessid('tools.php?mode=import') . '">';
				message(ERROR, $lang['info_msg']['invalid_email'] . " [2]");
			}
			
			$emails[] = $email; 
		}
		
		//
		// On augmente le temps d'execution du script pour avoir plus de temps pour les insertions
		// 
		@set_time_limit(1200); 
		
		for( $i = 0; $i < $num_emails; $i++ )
		{
			$code = get_code(); 
			
			$sql = "INSERT INTO " . ABONNES_TABLE . " (email, code, date, format, liste_id, actif) 
				VALUES('" . $emails[$i] . "', '$code', '$time', $format, $liste, " . ABO_ACTIF . ")"; 
			if( !$db->query($sql) )
			{
				message(ERROR, 'L\'insertion dans la base de donnes a chou', __FILE__, __LINE__, $sql); 
			}
		}
		
		$meta = '<meta http-equiv="refresh" content="10;url=' . sessid('tools.php?mode=import') . '">'; 		
		$message = ( $total_emails > $num_emails ) ? sprintf( $lang['info_msg']['success_import_2'], $num_emails, $total_emails, MAX_IMPORT) : sprintf($lang['info_msg']['success_import_1'], $num_emails); 
		message(INFO, $message); 
	}
	
	$list_box = list_box(AUTH_IMPORT); 
	
	define('MENU', true); 
	include('page_header.php');	
	
	$template->set_filenames( array(
		'body' => 'import.tpl' 
	)); 
	
	$template->assign_vars(array(
		'TITLE' => $lang['menu']['import'], 
		'HEAD' => nl2br(sprintf($lang['head']['import'], MAX_IMPORT, '<a href="' . sessid('infos.php') . '#4">', '</a>')), 
		'L_CHOICE_LIST' => $lang['choice_liste'], 
		'L_CHOICE_FORMAT' => $lang['choice_format'], 
		'L_GLUE' => $lang['char_glue'], 
		'L_BUTTON_VALID' => $lang['button']['valid'], 
		
		'LIST_BOX' => $list_box, 
		'U_FORM' => sessid("tools.php?mode=import") 
	)); 
	
	$upload_possibility = @ini_get('file_uploads'); 
	if( $upload_possibility && strtolower($upload_possibility) != 'off' )
	{
		//
		// L'upload est disponible sur le serveur
		// Affichage du champ file pour importation
		//
		$template->assign_block_vars('upload_file', array(
			'L_UPLOAD_FILE' => $lang['upload_file'] 
		));
	}
}

$template->pparse('body'); 

include('page_footer.php'); 
?>