<?php
/*******************************************************************
 *			
 * 			Fichier			:	index.php 
 * 			Cr le			:	04 juillet 2002 
 * 			Dernire modif	:	31 janvier 2003 
 * 			Email			:	wascripts@phpcodeur.net 
 * 
 * 				 Copyright 2002-2003 PHPcodeur
 * 
 *******************************************************************/

/*******************************************************************
 *  This program is free software; you can redistribute it and/or 
 * 	modify it under the terms of the GNU General Public License as 
 * 	published by the Free Software Foundation; either version 2 of 
 *  the License, or (at your option) any later version. 
 *******************************************************************/


define('IN_NEWSLETTER', true); 

$waroot = '../'; 
require('./pagestart.php'); 

$is_auth = obtain_auth(AUTH_VIEW, ALL_LIST); 

$num_inscrits = 0; 
$num_temp = 0; 
$num_logs = 0; 
$date_last_log = 0; 

if( count($is_auth['all_list']['auth_view']) )
{
	$liste_in = implode(', ', $is_auth['all_list']['auth_view']); 
	
	$sql = "SELECT COUNT(*) AS num, actif 
			FROM " . ABONNES_TABLE . " 
			WHERE liste_id IN($liste_in) 
			GROUP BY actif"; 
	if( !($result = $db->query($sql)) )
	{
		$message = 'Impossible d\'obtenir le nombre d\'inscrits/inscrits en attente';
		message(ERROR, $message, __FILE__, __LINE__, $sql);
	}
	
	while( $row = $db->fetch_array($result) )
	{
		if( $row['actif'] == ABO_ACTIF )
		{
			$num_inscrits = $row['num']; 
		}
		else
		{
			$num_temp = $row['num']; 
		}
	}
	$db->free_result($result);

	$sql = "SELECT COUNT(*) AS num_logs 
			FROM " . LOG_TABLE . " 
			WHERE send = " . SENDED . " 
			  AND liste_id IN($liste_in)";
	if( !($result = $db->query($sql)) )
	{
		message(ERROR, 'Impossible d\'obtenir le nombre de logs envoys', __FILE__, __LINE__, $sql);
	}

	$num_logs = $db->result($result, 0, "num_logs");
	$db->free_result($result);

	$sql = "SELECT MAX(date) AS last_log 
			FROM " . LOG_TABLE . " 
			WHERE send = " . SENDED . " 
			  AND liste_id IN($liste_in)";
	if( !($result = $db->query($sql)) )
	{
		message(ERROR, 'Impossible d\'obtenir la date du dernier log envoy', __FILE__, __LINE__, $sql);
	}

	$date_last_log = $db->result($result, 0, "last_log");
	$db->free_result($result); 	
}

$db->close_connexion(); 

$last_newsletter = convert_time($date_last_log);

define('MENU', true);
include('page_header.php');

$template->set_filenames( array(
	'body' => 'index.tpl'
));

$template->assign_vars( array(
	'TITLE' => $lang['title']['accueil'], 
	'WELCOME_ADMIN' => sprintf($lang['welcome_admin'], $admindata['user']), 
	'L_TOTAL_INSCRITS' => $lang['total_inscrits'], 
	'L_TOTAL_NEWSLETTER' => $lang['total_newsletter'], 	
	'L_TEMP_INSCRITS' => $lang['temp_inscrits'], 
	
	'DATE_LAST_NEWSLETTER' => sprintf($lang['last_newsletter'], $last_newsletter), 
	'NUM_INSCRITS' => $num_inscrits, 
	'NUM_NEWSLETTER' => $num_logs, 
	'NUM_TEMP_INSCRITS' => $num_temp 
));

$template->pparse('body'); 

include('page_footer.php'); 
?>