<?php
/*******************************************************************
 *			
 * 			Fichier			:	functions.stats.php 
 * 			Cr le			:	22 octobre 2002 
 * 			Dernire modif	:	31 janvier 2003 
 * 			Email			:	wascripts@phpcodeur.net 
 * 
 * 				 Copyright 2002-2003 PHPcodeur
 * 
 *******************************************************************/

/*******************************************************************
 *  This program is free software; you can redistribute it and/or 
 * 	modify it under the terms of the GNU General Public License as 
 * 	published by the Free Software Foundation; either version 2 of 
 *  the License, or (at your option) any later version. 
 *******************************************************************/


if( !defined('FUNCTIONS_STATS_INC') )
{

define('FUNCTIONS_STATS_INC', 1); 

//
// Conversion couleur hexadcimal => rvb 
//
function rvb_color($im, $color)
{
	$color = chunk_split($color, 2, "\n");
	$hex = explode("\n", $color);
	
 	$hex0 = hexdec($hex[0]);
	$hex1 = hexdec($hex[1]);
	$hex2 = hexdec($hex[2]); 
	
	return imagecolorallocate($im, $hex0, $hex1, $hex2);
}

//
// Coordonnes du rayon 
//
function xy_arc($degre, $diametre) 
{
	$x_arc = cos($degre * (pi()/180.0)) * ($diametre/2);
	$y_arc = sin($degre * (pi()/180.0)) * ($diametre/2);
	
	return array($x_arc, $y_arc);
} 
 
//
// Cration des fichiers de stats
//
function create_stats($liste)
{
	global $waroot, $db; 
	
	if( !@extension_loaded('gd') )
	{
		return;
	}
	
	$sql = "SELECT MIN(date) AS first_abo 
			FROM " . ABONNES_TABLE . " 
			WHERE liste_id = '$liste' 
			  AND actif = " . ABO_ACTIF; 
	if( !($result = $db->query($sql)) )
	{
		return; 
	} 
	
	if( !$db->num_rows($result) )
	{
		return; 
	} 
	
	$first_abo = $db->result($result, 0, "first_abo"); 
	
	$last_m = date("m"); 
	$last_y = date("Y"); 
	
	if( $first_abo == 0 )
	{
		$m = $last_m; 
		$y = $last_y; 
	}
	else
	{
		$m = date("m", $first_abo); 
		$y = date("Y", $first_abo); 
	}
	
	@chmod($waroot . "stats/", 0777); 
		
	do
	{
		$timestamp = mktime(0, 0, 0, $m, 1, $y); 
		
		$filename = date("Y_F", $timestamp) . "_list" . $liste . ".txt"; 
		if( !@file_exists($waroot . "stats/" . $filename) )
		{
			$fw = @fopen($waroot . "stats/" . $filename, "w"); 
			
			unset($stats); 
			$stats = array(); 
			
			if( $fw )
			{
				for( $day = 1; $day < 32; $day++ )
				{
					if( checkdate($m, $day, $y) )
					{
						$min_time = mktime(0, 0, 0, $m, $day, $y); 
						$max_time = mktime(23, 59, 59, $m, $day, $y); 
			
						$sql = "SELECT COUNT(id) AS num 
								FROM " . ABONNES_TABLE . " 
								WHERE liste_id = '$liste' 
								  AND actif = " . ABO_ACTIF . " 
								  AND date BETWEEN $min_time AND $max_time"; 
						if( !($result = $db->query($sql)) )
						{
							$stats[] = 0; 
						}
						else
						{
							$stats[] = $db->result($result, 0, "num"); 
						}
					}
				}
				
				$stats_string = implode("\r\n", $stats); 
				
				fwrite($fw, $stats_string); 
				fclose($fw); 
			}
		}
		
		$toc = ( $m == $last_m && $y == $last_y ) ? false : true; 
		
		$m++; 
		if( $m == 13 )
		{
			$m = 1; 
			$y++; 
		}
	}
	while( $toc ); 
}

//
// Mise  jour des donnes pour les statistiques 
//
function update_stats($liste)
{
	global $waroot; 
	
	if( !@extension_loaded('gd') )
	{
		return;
	}
	
	$filename = date("Y_F") . "_list" . $liste . ".txt"; 
	
	if( !@file_exists($waroot . "stats/" . $filename) )
	{
		create_stats($liste); 
	}
	else
	{
		$fp = @fopen($waroot . "stats/" . $filename, "r"); 
		$stats = @fread($fp, @filesize($waroot . "stats/" . $filename)); 
		@fclose($fp); 
	
		if( $stats != '' )
		{
			$days = explode("\r\n", $stats); 
		
			$offset = date("j")-1; 
			$days[$offset] += 1; 
		
			$new_stats = implode("\r\n", $days); 
		
			$fw = @fopen($waroot . "stats/" . $filename, "w"); 
			@fwrite($fw, $new_stats); 
			@fclose($fw); 
		}
	}
}

//
// Suppression de stats (lors de la suppression d'une liste) 
//
function remove_stats($liste_from, $liste_to = false)
{
	global $waroot; 
	
	if( !@extension_loaded('gd') )
	{
		return;
	}
	
	@set_time_limit(300); 
	
	$res = @opendir($waroot . "stats/"); 
	
	$old_stats = array(); 
	while( $stats_file = @readdir($res) ) 
	{
		if( preg_match("#^([0-9]{4})?_([a-z]+)?_list$liste_from\.txt$#is", $stats_file, $match) )
		{
			if( $liste_to )
			{
				$fp = @fopen($waroot . "stats/" . $match[0], "r"); 
				if( $fp )
				{
					$old_stats[$match[1] . "_" . $match[2]] = explode("\r\n", fread($fp, filesize($waroot . "stats/" . $match[0]))); 
					fclose($fp); 
				}
			}
			
			@unlink($waroot . "stats/" . $match[0]); 
		}
	}

	@closedir($res); 
	
	if( $liste_to && count($old_stats) )
	{
		reset($old_stats); 
		while( list($date, $num) = each($old_stats) )
		{
			$fp = @fopen($waroot . "stats/" . $date . "_list" . $liste_to . ".txt", "r"); 
			if( $fp )
			{
				$stats = explode("\r\n", fread($fp, filesize($waroot . "stats/" . $date . "_list" . $liste_to . ".txt"))); 
				
				for( $i = 0; $i < count($stats); $i++ )
				{
					$stats[$i] += ( !empty($num[$i]) ) ? $num[$i] : 0; 
				}
				
				$new_stats = implode("\r\n", $stats); 
				
				$fw = @fopen($waroot . "stats/" . $date . "_list" . $liste_to . ".txt", "w"); 
				@fwrite($fw, $new_stats); 
				@fclose($fw); 
			}
		}
	}
	
	return;
}

//
// Lecture des fichiers de statistiques pour le mois et l'anne donne 
//
function read_stats($liste_in, $mois, $annee)
{
	global $waroot; 
	
	$string_mois = date("F", mktime(0, 0, 0, $mois, 1, $annee)); 
	
	$list_array = explode(",", $liste_in); 
	
	$num_per_day =array(
		1 => 0, 2 => 0, 3 => 0, 4 => 0, 5 => 0, 6 => 0, 7 => 0, 8 => 0, 9 => 0, 10 => 0, 
		11 => 0, 12 => 0, 13 => 0, 14 => 0, 15 => 0, 16 => 0, 17 => 0, 18 => 0, 19 => 0, 20 => 0, 
		21 => 0, 22 => 0, 23 => 0, 24 => 0, 25 => 0, 26 => 0, 27 => 0, 28 => 0, 29 => 0, 30 => 0, 31 => 0 
	); 
	
	$max_value = 0; 
	while( list(, $liste) = each($list_array) )
	{
		$fp = @fopen($waroot . "stats/" . $annee . "_" . $string_mois . "_list" . $liste . ".txt", "r"); 
		if( $fp )
		{
			$elt = explode("\r\n", @fread($fp, filesize($waroot . "stats/" . $annee . "_" . $string_mois . "_list" . $liste . ".txt"))); 
			
			for( $i = 0; $i < count($elt); $i++ )
			{
				$num_per_day[$i+1] += $elt[$i]; 
				if( $elt[$i] > $max_value ) $max_value = $elt[$i]; 
			}
		}
	}
	
	return array('max' => $max_value, 'num' => $num_per_day); 
}

}
?>