<?php
/////////////////////////////
//  Php Country Detector by IP (RESTRICT VISITS) - Version 3.6 for Text File databases - advanced redirection
//	Copyright (C) 2003 Ionita Dragos Alexandru
//		
// This program is free software; you can redistribute it and/or modify it under the terms of 
// the GNU General Public License as published by the Free Software Foundation; either version 
// 2 of the License, or any later version. 
//
// This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
// without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
// See the GNU General Public License for more details.
//
//CONTACT:
//	http://rv.web-heaven.com
//	rv@web-heaven.com
//
//DOWNLOAD UPDATES AND REQUEST IP DATABASES FOR EACH COUNTRY FROM :
//	http://rv.web-heaven.com
/////////////////////////////

//DEFINE HERE YOUR OPTIONS
//$ip_files_type="tc"; //Uncomment this line in order to use IP database files, one/country with IP addresses (like 192.168.0.1)
//$ip_files_type="tcs";//Uncomment this line in order to use the IP database file with with IP addresses (like 192.168.0.1) and country code (like uk)
//$ip_files_type="to";//Uncomment this line in order to use IP database files, one/country with IP numbers (like 321234321)
$ip_files_type="tos";//Uncomment this line in order to use the IP database file with IP numbers (like 321234321)) and country code (like uk)
$ip_country_order="country_order.txt";//a text file to help you improuve performance. It tells the script which countries to be detected. It also sets the order in with the files will be scanned (for types tc and to).
$ip_reject_by_extension=false; //0 for false, 1 for true ; This rejects by host name extension. 
$ip_extensions="\\.ro|\\.RO"; // the character | is OR please do not replace it. Replace \\.ro AND \\.RO strings with your desired extension (\\.com|\\.net|\\.com\\.uk|yahoo\\.com) ; "\\." means DOT
$ip_use_3_groups_for_single=false;//0 for false, 1 for true ;if you want the single IP addresses to be compared with the user`s IP using only the first 3 groups of numbers -- 192.168.0.0(single ip in the list) equals 192.168.0.16(user`s IP) -- Available only for database type tc
define("_DEBUG_MODE","1"); //set to 1 to print runtime information, 0 for silent mode;

//////////////////////////
//REDIRECTION DIRECTIVES
$ip_not_in_database_link="";//This is the file where users not found in any database are redirected. If it equals to "" the page is loaded (no action is taken)
$ip_in_database_default_link="http://localhost";//This is the file where users found in a database who has no redirection link associated, or the users redirected by their host names are redirected to (the default redirect link). Leave blank (="") to take no action, and to load the page
//Edit country_order.txt and at the end of each line place the link where users from each country should be redirected. The link should be separated by ' - '. Leave blank to use the default redirect link ($ip_in_database_default_link)
//Example: AD - Country name, bla bla - http://link_to_redirect_users_to.com
//////////////////////////

///////////////////////////
//Do not edit starting this point
///////////////////////////

function actions($sw,$link="")
{
	global $fh,$dec_ip0;
	@fclose($fh);
	if ($sw){
		if(_DEBUG_MODE) echo "The user is in the database. ";
		else 
		{
			setcookie("ROM",1);
			setcookie("ROMLINK",$link);
			//your action if found in the database
		}
		if ($link!="") { if(_DEBUG_MODE) echo "Redirecting to $link<br>"; else header("Location: ".$link);die(); }
		else { if(_DEBUG_MODE) echo "Loading the page<br>"; else header("Location: ".self());die(); }
	}
	else 
	{
		if(_DEBUG_MODE) echo "The user is NOT in the database. ";
		else
		{
			setcookie("STR",1);
			//your default action is none-the page is loaded
		}
		if ($link!="") { if(_DEBUG_MODE) echo "Redirecting to $link<br>"; else header("Location: ".$link);die(); }
		else if(_DEBUG_MODE) echo "Loading the page<br>";		
	}
}

function self()
{
	global $HTTP_SERVER_VARS;	$path="http".($HTTP_SERVER_VARS["HTTPS"]=="on"?"s":"")."://".$HTTP_SERVER_VARS["SERVER_NAME"].$HTTP_SERVER_VARS["PHP_SELF"];
	if ($HTTP_SERVER_VARS["QUERY_STRING"]) $path.="?".$HTTP_SERVER_VARS["QUERY_STRING"];
	return ($path);
}

function DD_array_search($val,$ar)
{
	for($i=0;$i<sizeof($ar);$i++)
	{
		if (strtolower($ar[$i])==$val ) return ($i+1);
	}
	return (false);
}

function exceptions($ip)
{	
	global $ip_path;
	$gh=fopen($ip_path."exceptions.php","r");
	while(!feof($gh))
	{
		$line=trim(fgets($gh,35));
		if (strpos($line,"-")>1) 
		{
			list($i1,$i2)=explode("-",$line);
			if (is_in_ip_range($i1,$i2,0)) 
			{
				if(_DEBUG_MODE) echo "The user is in the exception list<br>";
				fclose($gh);
				return (1);

			}
		}
		else 
		{
			if ($ip==$line) 
			{
				if(_DEBUG_MODE) echo "The user is in the exception list<br>";
				fclose($gh);
				return (1);
			}
		}
	}
	fclose($gh);
	if(_DEBUG_MODE) echo "The user is NOT in the exception list<br>";
	return (0);
}

function is_in_ip_range($min,$max,$ip_files_optimized=1)
{
	global $dec_ip0;
	if ($ip_files_optimized)
	{
			$min=(float)$min;
			$max=(float)$max;
			if(_DEBUG_MODE)	echo ("Comparing: $min  << $dec_ip0 << $max <br>");
			if (($min <= $dec_ip0) && ($dec_ip0 <= $max)) 
			{
				if(_DEBUG_MODE) echo "The user is in an optimized file database<br>";
				return(1);
			}
			if(_DEBUG_MODE) echo "The user is NOT in an optimized file database<br>";
			return (0);
	}
	else
	{
			$ip1=explode(".",$min);
			$ip2=explode(".",$max);
			for ($j=0;$j<4;$j++)
			{
				$hex_ip1.=sprintf("%'02s",base_convert($ip1[$j],10,16));
				$hex_ip2.=sprintf("%'02s",base_convert($ip2[$j],10,16));
			}
			$dec_ip1=base_convert($hex_ip1,16,10);
			$dec_ip2=base_convert($hex_ip2,16,10);
			if(_DEBUG_MODE)	echo ("Comparing: $min = $dec_ip1 << $dec_ip0 << $max = $dec_ip2<br>");
			if (($dec_ip1 <= $dec_ip0) && ($dec_ip0 <= $dec_ip2))
			{
				if(_DEBUG_MODE) echo "The user is in an nonoptimized file database<br>";
				return(1);
			}
			if(_DEBUG_MODE) echo "The user is NOT in an nonoptimized file database<br>";
			return (0);
	}
}

if ($HTTP_COOKIE_VARS["ROM"])
{
	if (strlen($HTTP_COOKIE_VARS["ROMLINK"])>7) 
	{
		header("Location: ".$HTTP_COOKIE_VARS["ROMLINK"]);
		die();
	}
}
else 
if (!$HTTP_COOKIE_VARS["STR"])
{
	$ip=$HTTP_SERVER_VARS["REMOTE_ADDR"];
	$ip0=explode(".",$ip);
	unset($hex_ip0);
	for ($j=0;$j<4;$j++)
	{
		$hex_ip0.=sprintf("%'02s",base_convert($ip0[$j],10,16));
	}
	$dec_ip0=base_convert($hex_ip0,16,10);

	if (exceptions($ip)) actions(0,$ip_not_in_database_link);
	else
	{
		$ip_host=$HTTP_SERVER_VARS["REMOTE_HOST"];
		if ($ip_reject_by_extension)
		{
			if(_DEBUG_MODE)	echo ("Scaning user`s host name<br>");
			if (strlen($host)>2) if (ereg("(".$ip_extensions.")$",$ip_host)) actions(1,$ip_in_database_default_link);
		}
		$xh=fopen($ip_path.$ip_country_order,"r");
		while(!feof($xh))
		{
			list($c,$num,$rlink)=explode(" - ",fgets($xh,150));
			if (substr($c,0,1)!="#")
			{
				$ip_countries[]=$c;
				if (strlen($rlink)>7) $links[]=$rlink;
				else $links[]=$ip_in_database_default_link;
				if(_DEBUG_MODE)	echo ("Adding country $num ($c) from the country order list with redirection link: $rlink<br>");
			}
		}
		fclose($xh);
		if (($ip_files_type=="to") || ($ip_files_type=="tos") )
		{	$ip_files_optimized=true; $ip_chars=31; }
		else
		{	$ip_files_optimized=false; $ip_chars=42; }

		if (($ip_files_type=="to") || ($ip_files_type=="tc") )
		{
				for($y=0;$y<sizeof($ip_countries);$y++)
				{
					/////////////////
					if(_DEBUG_MODE)	echo ("Opening db file ".$ip_path."../ip_databases/$ip_files_type/restrict-visits-".$ip_countries[$y].".php<br>");
					$fh=fopen($ip_path."../ip_databases/$ip_files_type/restrict-visits-".$ip_countries[$y].".php","r");
					while (!feof($fh))
					{
						$line=trim(fgets($fh,$ip_chars));
						if(_DEBUG_MODE)	echo ("Reading the line: $line<br>");
						$single=0;
						if (strpos($line,"-")>1) 
						{ 
							list($i1,$i2)=explode("-",$line);
							if(_DEBUG_MODE)	echo ("Finding IP`s $i1 and $i2<br>");
							if ($i1!=$i2) {if (is_in_ip_range($i1,$i2,$ip_files_optimized)) actions(1,$links[$y]);}
							else $single=1;
						}
						else {$single=1;$i2=$line;}

						if ($single)
						{	
							if(_DEBUG_MODE)	echo ("Found a non IP range; Entering single IP mode;<br>");
							unset($sw);
							$sw[]=0;$sw[]=0;$sw[]=0;$sw[]=0;
							if (!$ip_files_optimized)
							{
								$ip2=explode(".",$i2);
								for ($j=0;$j<4;$j++)
										if ($ip0[$j]==$ip2[$j]) {$sw[$j]=1;}
								if ($ip_use_3_groups_for_single) {if ((array_sum($sw)==3)&&($sw[3]==0)) actions(1,$links[$y]);}
								else {if (array_sum($sw)==4) actions(1,$links[$y]);}
							}
							else {if ($i2==$dec_ip0) actions(1,$links[$y]);}
							if(_DEBUG_MODE)	echo ("The single IP from the database do not match the user`s IP<br>");
						}
					}
					///////////////////
					fclose($fh);
				}
		}
		else
		{
					if(_DEBUG_MODE)	echo ("Opening db file ".$ip_path."../ip_databases/$ip_files_type/_restrict-visits-all.php<br>");
					$fh=fopen($ip_path."../ip_databases/$ip_files_type/_restrict-visits-all.php","r");
					while (!feof($fh))
					{
						$line=trim(fgets($fh,$ip_chars));
						if(_DEBUG_MODE)	echo ("Reading the line: $line<br>");
						list($i1,$i2,$suf)=explode("-",$line);
						if(_DEBUG_MODE)	echo ("Finding IP`s $i1 and $i2<br>");
						if (is_in_ip_range($i1,$i2,$ip_files_optimized))
						{
							$y=DD_array_search($suf,$ip_countries);
							if ($y>0) actions(1,$links[($y-1)]);
						}
					}
					///////////////////
					fclose($fh);
		}
		actions(0,$ip_not_in_database_link);
	}
}
else actions(0,$ip_not_in_database_link);
?>