<?php

//next line is just for my bug finding....
ini_set("error_reporting",E_ERROR | E_WARNING | E_PARSE | E_NOTICE | E_ALL);
require_once('ltw_config.php');


//just a little class to do some database stuff	
class ltw_db {
	
	var $db_type;
	var $db_server;
	var $db_name;
	var $db_user;
	var $db_pass;
	var $db_persistent;
	var $dbh;
	
	function ltw_db() {
		
		global $ltw_config;
	
		$this->db_type = $ltw_config['db_type'];
		$this->db_server = $ltw_config['db_server'];
		$this->db_name = $ltw_config['db_name'];
		$this->db_user = $ltw_config['db_user'];
		$this->db_pass = $ltw_config['db_pass'];
		$this->db_persistent = $ltw_config['db_persistent'];
		$this->db_connect();
		
	} //end constructor
	
	function db_connect () {
		
		// mySQL 
		if($this->db_type == 1) {
			if ($this->db_persistent)
				$this->dbh = @mysql_pconnect($this->db_server, $this->db_user, $this->db_pass);
			else
				$this->dbh = @mysql_connect($this->db_server, $this->db_user, $this->db_pass);

			if (!$this->dbh) {
				printf("Error: Connection to MySQL server '%s' failed.<BR>\n", $this->db_server);
				return;
			}

			if (!@mysql_select_db($this->db_name, $this->dbh)) {
				printf("Error: Connection to MySQL database '%s' failed.<BR>\n>%s: %s<BR>\n", $this->db_name, @mysql_errno($this->dbh), @mysql_error($this->dbh));
				return;
			}
		}
		//end mySQL
	} //end db_connect()
	
	function db_query ($query) {
		
		// mySQL 
		if($this->db_type == 1) {
			$result = mysql_query($query, $this->dbh)
				or die ("Error: A problem was encountered while executing this query.");
			
			return $result;
		}
		//end mySQL
	} //end db_query()
	
	function db_numrows ($result) {
		
		switch($this->db_type) {
			case 1: //mySQL
				return mysql_num_rows($result);
		
		} //end switch
	} // end db_numrows()
	
	function db_fetch_array (&$result) {
		
		switch($this->db_type) {
			case 1: //mySQL
				return mysql_fetch_array($result);
		} //end switch
	} //end db_fetch_array()
	
			
} //end class ltw_db

class authenticate {
	
	var $db;
	var $salt;
	var $user_table;
	
	function authenticate() {
		
		global $ltw_config;
		
		$this->db = new ltw_db;
		$this->salt = $ltw_config['salt'];
		$this->user_table = $ltw_config['db_table_users'];
		
	} //end constructor
	
	function displayLogin() {
				
		echo "<HTML>\n";
		echo "<HEAD>\n";
		echo "<TITLE>Login</TITLE>\n";
		echo "</HEAD>\n";
		echo "<BODY>\n";
		echo "<FORM ACTION=\"calendar.php?display=admin&amp;task=login\" METHOD=\"POST\" name=\"\">\n";
		echo "Username:<BR>\n";
		echo "<input type=\"text\" size=15 name=\"uname\"><BR>\n";
		echo "Password:<BR>\n";
		echo "<input type=\"password\" size=15 name=\"pword\"><BR>\n";
		echo "<input type=\"submit\" name=\"submit\" value=\"Login\">\n";
		echo "</FORM>\n";
		echo "</BODY>\n";
		echo "</HTML>\n";
	} //end displayLogin()
	
	function login($uname, $pword) {
		
		$query = "SELECT username FROM $this->user_table WHERE username = '" . $uname . "' AND password = '" . crypt($pword, $this->salt) . "'";
		$result = $this->db->db_query($query);
		if($this->db->db_numrows($result) > 0) {
			$secret = crypt($uname,$this->salt);
			setcookie("ltw", "$uname:$secret");			
			return 1;
		} else {
			return 0;
		}
	} //end login()
	
	function logout() {
		
		setcookie("ltw");
	} //end logout()
	
	function checkLogin() {
		
		//the following lines are added for backwards compatibility for pre 4.1.0 PHP versions..
		if(!isset($_COOKIE)) {
			global $HTTP_COOKIE_VARS;
			$_COOKIE = $HTTP_COOKIE_VARS;
		}
		//end backward compatibility
		
		if(isset($_COOKIE['ltw'])) {
			$array = explode(":", $_COOKIE['ltw']);
			if(!isset($array[1])) $array[1] = "";
			if(crypt($array[0], $this->salt) == $array[1]) {
				return 1;
			} else {
				return 0;
			}
		} else {
			return 0;
		}
	} //end checkLogin()
	
		
} //end class authenticate

class ltwCategories {
	var $db;
	var $auth;
  var $cat_array;       // Array for holding Category Names & colors
  var $category_table;  // Table name
  var $cat_fgcolor;     // Default category color (failsafe)
  var $cat_bgcolor;     // Default category color (failsafe)
  
  function ltwCategories() {
		global $ltw_config;
		
		$this->db         = new ltw_db;
		$this->auth       = new authenticate;
    $this->cat_table  = $ltw_config['db_table_category'];
    $this->cat_fgcolor= $ltw_config['cat_fgcolor'];
    $this->cat_bgcolor= $ltw_config['cat_bgcolor'];

    // read the category table into an array
    $query = "SELECT * from ". $this->cat_table;
		$result = $this->db->db_query($query);
		while($row = $this->db->db_fetch_array($result)) {
      $this->cat_array[$row['id']] = array($row['name'],$row['fgcolor'],$row['bgcolor']);
    }
  }

  function manage() {
    global $_POST;

    $errflag = 0;

		header("Cache-control: no-cache");
		header("Expires: " . gmdate("D, d M Y H:i:s") . " GMT");
		echo "<HTML>\n";
		echo "<HEAD>\n";
		echo "<TITLE>Manage Categories</TITLE>\n";
		echo "</HEAD>\n";
		echo "<BODY>\n";


		if(!$this->auth->checkLogin()) {
			echo "You are not logged in!\n";
			return 0;
		}

    if ( (!isset($_POST['Submit'])) && (!isset($_POST['Done'])) ){
      //
      // display form if not a 'Submit' or 'Done'
      //
      echo "<form name=\"categories\" method=\"post\" action=\"/calendar.php?display=admin&task=categories\">\n";
      echo "<table border=\"1\">\n";
      echo "<tr><td align=\"center\"><b>Category</b></td>";
      echo     "<td align=\"center\"><b>FG Color</b></td>";
      echo     "<td align=\"center\"><b>BG Color</b></td>";
      echo     "<td align=\"center\"><b>Delete</b><td>";
      echo "</tr>\n";
      foreach ( $this->cat_array as $key => $value ){
        $name    = $this->cat_array[$key][0];
        $fgcolor = $this->cat_array[$key][1];
        $bgcolor = $this->cat_array[$key][2];
        echo "<tr><td align=\"left\"><input size=\"30\" maxlength=\"30\" type=\"text\" name=\"name".$key."\" value=\"".$name."\"></td>\n";
        echo     "<td align=\"left\"><input size=\"7\" maxlength=\"7\" type=\"text\" name=\"fgcolor".$key."\" value=\"".$fgcolor."\"></td>\n";
        echo     "<td align=\"left\"><input size=\"7\" maxlength=\"7\" type=\"text\" name=\"bgcolor".$key."\" value=\"".$bgcolor."\"></td>\n";
        echo     "<td align=\"center\"><input type=\"checkbox\" name=\"checkbox".$key."\" value=\"delete\"></td></tr>\n";
      }
      echo "<tr><td colspan=\"4\"><b>Add new category</b></td></tr>\n";
      echo "<tr><td align=\"left\"><input size=\"30\" maxlength=\"30\" type=\"text\" name=\"newname\"></td>\n";
      echo "<td align=\"left\"><input size=\"7\" maxlength=\"7\" type=\"text\" name=\"newfgcolor\"></td>\n";
      echo "<td align=\"left\"><input size=\"7\" maxlength=\"7\" type=\"text\" name=\"newbgcolor\"></td></tr>\n";
      echo "<tr><td colspan=\"4\">&nbsp</td></tr>\n";
      echo "<tr><td colspan=\"4\"><input type=\"submit\" name=\"Submit\" value=\"Submit\">\n";
      echo "&nbsp;&nbsp;&nbsp;<input type=\"submit\" name=\"Done\" value=\"Done\">\n";
      echo "</table>";

    }else{
      //
      // 'Submit' or 'Done' set, update existing categories
      //
      foreach( $this->cat_array as $id => $value ){
        // if delete box checked
        if ( (isset($_POST['checkbox'.$id]) && $_POST['checkbox'.$id] == 'delete') ){
          $query  = "DELETE FROM ".$this->cat_table." WHERE id=".$id;
          $result = $this->db->db_query($query);
    
        }else{
          // check if any changes have been made to the
          // name, fgcolor or bgcolor for this cat_id
          // (saves a db access if not)

          $updateit = 0;  // Set if any changes made
          $name     = $this->cat_array[$id][0];
          $fgcolor  = $this->cat_array[$id][1];
          $bgcolor  = $this->cat_array[$id][2];

          // see if the name set and is different
          if ( ("" != $_POST['name'.$id]) && ($_POST['name'.$id] != $name) ){
            $updateit = 1;
            $name = $_POST['name'.$id];
          }
 
          // see if the fgcolor changed
          if ( ("" != $_POST['fgcolor'.$id]) && ($_POST['fgcolor'.$id] != $fgcolor) ){
            if ( $this->checkColorString($name,'fgcolor',$_POST['fgcolor'.$id] ) ){
              $updateit = 1;
              $fgcolor = $_POST['fgcolor'.$id];
            }else{
              $errflag=1;
            }
          }
  
          // see if the bgcolor changed
          if ( ("" != $_POST['bgcolor'.$id]) && ($_POST['bgcolor'.$id] != $bgcolor) ){
            if ( $this->checkColorString($name,'bgcolor',$_POST['bgcolor'.$id] ) ){
              $updateit = 1;
              $bgcolor = $_POST['bgcolor'.$id];
            }else{
              $errflag=1;
            }
          }

          // if any of the three fields changed, update the database
          if ( $updateit != 0 ){
            $query  = "UPDATE ".$this->cat_table." set name='".$name."', fgcolor='".$fgcolor."',   bgcolor='".$bgcolor."' ";
            $query .= "WHERE id=".$id;
            $result = $this->db->db_query($query);
          }
        }
      } //end foreach

      // now check the new category
      // First the name
      if ( (isset($_POST['newname'])) && ($_POST['newname'] != '') ){
        $insertit = 0;
        $name = $_POST['newname'];
 
        // then the fgcolor
        if ( isset($_POST['newfgcolor']) && ($_POST['newfgcolor'] != "") ){
            if ( $this->checkColorString($name,'fgcolor',$_POST['newfgcolor'] ) ){
              $fgcolor = $_POST['newfgcolor'];
              $insertit = 1;
            }else{
              $errflag=1;
            }
        }else{
          $fgcolor = $this->cat_fgcolor;
          $insertit = 1;
        }

        // then the bgcolor
        if ( isset($_POST['newbgcolor']) && ($_POST['newbgcolor'] != "") ){
            if ( $this->checkColorString($name,'bgcolor',$_POST['newbgcolor'] ) ){
              $bgcolor = $_POST['newbgcolor'];
              $insertit = 1;
            }else{
              $errflag=1;
            }
        }else{
          $bgcolor = $this->cat_bgcolor;
          $insertit = 1;
        }

        if ( $insertit == 1 ){
          $query  = "INSERT INTO ".$this->cat_table." (name,fgcolor,bgcolor) VALUES ('".$name."','".$fgcolor."','".$bgcolor."')";
          $result = $this->db->db_query($query);
        }
      }  

      // Decide what to do with the page now that I'm done
      //
      if ( $errflag == 1 ){
        // An error, go back
        echo "<br><br>\n";
        echo "<FORM><INPUT onclick=history.go(-1) type=button value=Reload></form>\n";
      }else{
        if ( isset($_POST['Done']) ){
      
          // 'Done' clicked, Close it & update the calendar
          echo "<SCRIPT LANGUAGE=\"JavaScript\" type=\"text/javascript\">\n";
          echo "<!--\n";
          echo "opener.location.reload();\n";
          echo "self.close();\n";
          echo "// -->\n";
          echo "</SCRIPT>\n";

        }else{
          // 'Submit' clicked, reload it
          echo "<SCRIPT LANGUAGE=\"JavaScript\" type=\"text/javascript\">\n";
          echo "<!--\n";
          echo "opener.location.reload();\n";
          echo " window.location=\"/calendar.php?display=admin&task=categories\"";
          echo "// -->\n";
          echo "</SCRIPT>\n";
        }
      }
    }
    // close html page
    echo "</BODY></HTML>\n";
  }

  // checks a color string matches the format #xxxxxx
  // where xxxxxx are valid hex digits
  function checkColorString ($name = "",$which = "",$color = ""){
 
    if ( preg_match ('/^#[0-9a-f]{6}$/i',$color) ){
      return 1;
    }else{
      echo "Error: Category ".$name." has an invalid ".$which." specified: ".$color."<br>\n"; 
      return 0;
    }
  }
}//end class.ltwCategories


class ltwCalendar {
	
	var $db;
	var $auth;
	var $stamp;
	var $days_in_month;
	var $first_day_of_month;
	var $day_of_week;
	var $month;
	var $month_name;
	var $day;
	var $year;
	var $next_month;
	var $next_month_year;
	var $next_month_name;
	var $prev_month;
	var $prev_month_year;
	var $prev_month_name;
	var $table_bg;
	var $calendar_table;
	var $daynames;
	var $monthnames;
	var $bullets;

  var $cat_array;       // Array for holding Category Names & colors
  var $cat_fgcolor;     // Default category color (failsafe)
  var $cat_bgcolor;     // Default category color (failsafe)
  var $category_table;  // Table name
	
	function ltwCalendar($timestamp) {
		
		global $ltw_config;
		
		$this->db = new ltw_db;
		$this->auth = new authenticate;
		$this->stamp = $timestamp;
		$timepieces = getdate($timestamp);
		$this->month = $timepieces["mon"];
		$this->month_name = $timepieces["month"];
		$this->day = $timepieces["mday"];
		$this->year = $timepieces["year"];
		$this->first_day_of_month = $this->_firstDayOfMonth($timestamp);
		$this->days_in_month = $this->_daysInMonth();
		$this->day_of_week = $this->_dayOfWeek($timestamp);
		$this->next_month = $this->month +1;
		$this->next_month_year = $this->year;
		if ( $this->next_month > 12 ){
		  $this->next_month = 1 ;
		  $this->next_month_year = $this->year + 1;
		}
		$this->next_month_name = $ltw_config['monthnames'][$this->next_month];

    		$this->prev_month = $this->month -1;
		$this->prev_month_year = $this->year;
		if ( $this->prev_month == 0 ){
		  $this->prev_month = 12 ;
		  $this->prev_month_year = $this->year - 1;
		}
		$this->prev_month_name = $ltw_config['monthnames'][$this->prev_month];
		
		$this->calendar_table = $ltw_config['db_table_calendar'];
		$this->daynames = $ltw_config['daynames'];
		$this->monthnames = $ltw_config['monthnames'];
		$this->bullets = $ltw_config['bullets'];

    $this->start_hour = $ltw_config['start_hour'];
    $this->start_min  = $ltw_config['start_min'];
    $this->start_ampm = $ltw_config['start_ampm'];
    $this->end_hour   = $ltw_config['end_hour'];
    $this->end_min    = $ltw_config['end_min'];
    $this->end_ampm   = $ltw_config['end_ampm'];

    $this->cat_fgcolor    = $ltw_config['cat_fgcolor'];
    $this->cat_bgcolor    = $ltw_config['cat_bgcolor'];
    $this->cat_table      = $ltw_config['db_table_category'];

    // read the category table into an array
    $query = "SELECT * from ". $this->cat_table;
		$result = $this->db->db_query($query);
		while($row = $this->db->db_fetch_array($result)) {
      $this->cat_array[$row['id']] = array($row['name'],$row['fgcolor'],$row['bgcolor']);
    }
		
	} //end constructor

	function display() {
		
		$num_of_rows = ceil(($this->days_in_month + $this->first_day_of_month) / 7.0);
		$day = 1;
		echo "<TABLE class=\"cal\">\n";
		echo "<CAPTION class=\"cal\">\n";
		echo "<a class=\"prevnext\" href=\"calendar.php?month=" . $this->prev_month . "&amp;year=" . $this->prev_month_year ."\">". $this->monthnames[(int)$this->prev_month] . "</a>&nbsp;\n";
		echo $this->monthnames[(int)$this->month] . " " . $this->year . "\n";
		echo "&nbsp;<a class=\"prevnext\" href=\"calendar.php?month=" . $this->next_month . "&amp;year=" . $this->next_month_year ."\">". $this->monthnames[(int)$this->next_month] . "</a>\n";
		echo "</CAPTION>\n";
		echo "<THEAD class=\"cal\"><TR>\n";
		for($i = 0; $i < 7; $i++) {
			echo "<TD WIDTH=\"14%\">" . $this->daynames[$i] . "</TD>\n";
		}
		echo "</TR></THEAD>\n";
		echo "<TBODY>\n";
		for($i = 1; $i <= $num_of_rows; $i++) { 
		  echo "<TR>\n";
		  for ($j = 0; $j < 7; $j++) {
		    if(($i == 1 && $this->first_day_of_month <= $j) || ($i > 1 && $day <= $this->days_in_month)) {
		      echo "<TD class=\"cal\" WIDTH=\"14%\" HEIGHT=\"" . (100 / $num_of_rows) . "%\">";
		      echo "<a class=\"day\" href=\"javascript:launchbig('calendar.php?display=day&amp;stamp=" . $this->stamp . "&amp;day=" . $day ."')\">" . $day . "</a><BR>\n";
		      $query = "SELECT id, name, start_time, day_event,cat_id FROM $this->calendar_table WHERE (event_date = \"" . $this->year . "-" . $this->month . "-" . $day . "\" AND recurring = 0) OR (event_date <= \"" . $this->year . "-" . $this->month . "-" . $day . "\" AND recurring = 1 AND recur_dayofweek = " . $this->_dayOfWeek(mktime(12,12,12,$this->month,$day,$this->year)) . ") ORDER BY day_event DESC, start_time";
		      $result = $this->db->db_query($query);
                      echo "<table>\n";
		      if($this->bullets == 'TRUE') {
			echo "<ul class=\"cal\">\n";
		      }
		      while($row = $this->db->db_fetch_array($result)) {
			if($this->bullets == 'TRUE') {
		          echo "<li>";
			}
			$start_time = strftime("%I:%M %p",strtotime($row["start_time"]));
			if($start_time{0} == '0') {
			  $start_time = substr($start_time, 1);
			}
            		if ( isset($this->cat_array[$row['cat_id']]) ){
              		  $fgcolor = $this->cat_array[$row['cat_id']][1];
              		  $bgcolor = $this->cat_array[$row['cat_id']][2];
            		}else{
              		  $fgcolor = $this->cat_fgcolor; 
	                  $bgcolor = $this->cat_bgcolor; 
            		}
            		echo "<tr><td bgcolor=\"".$bgcolor."\">";
			echo "<a class=\"event\" href=\"javascript:launchsmall('calendar.php?display=event&amp;id=" . $row["id"] . "&amp;date=" . $this->year . "-" . $this->month . "-" . $day . "')\">" ;
            		echo  "<font color=".$fgcolor.">";
            		if ( $row["day_event"] == 0 ) echo $start_time . " ";
            		echo  $row["name"] . "</font></a></td></tr>\n";
		      }
		      if($this->bullets == 'TRUE') {
			echo "</ul>\n";
		      }
                      echo "</table>";
		      $day++;
					
		   } else {
		      echo "<TD class=\"cal\" WIDTH=\"14%\"  HEIGHT=\"" . (100 / $num_of_rows) . "%\">";
		   }
		   echo "</TD>\n";
		}
		echo "</TR>\n";
	      }
	      echo "</TBODY>\n";
	      echo "<TFOOT class=\"cal\"><TR>\n";
	      echo "<TD COLSPAN=\"7\">\n";
	      if($this->auth->checkLogin()) {
		echo "<font class=\"cal-admin-link\">admin</font>\n";
		echo "&nbsp;<a class=\"admin\" href=\"javascript:launchsmall('calendar.php?display=admin&amp;task=logout')\"><font class=\"cal-admin-link\">logout</font></a>\n";
		echo "&nbsp;<a class=\"admin\" href=\"javascript:launchbig('calendar.php?display=admin&amp;task=add')\"><font class=\"cal-admin-link\">add event</font></a>\n";
      		echo "&nbsp;<a class=\"admin\" href=\"javascript:launchbig('calendar.php?display=admin&amp;task=categories')\"><font class=\"cal-admin-link\">categories</font></a>\n";
	      } else {
		echo "<a class=\"admin\" href=\"javascript:launchsmall('calendar.php?display=admin&amp;task=login')\"><font class=\"cal-admin-link\">admin</font></a>\n";
	      }
	      echo "</TD>\n";
	      echo "</TR></TFOOT>\n";
	      echo "</TABLE>\n";	
	   }
	
	function displayDay($day) {
		
		$query = "SELECT * FROM $this->calendar_table WHERE ";
		$query .= "(event_date = \"" . $this->year . "-" . $this->month . "-" . $day . "\" AND recurring = 0) ";
		$query .= "OR (event_date <= \"" . $this->year . "-" . $this->month . "-" . $day . "\" AND recurring = 1 AND recur_dayofweek = " . $this->_dayOfWeek(mktime(12,12,12,$this->month,$day,$this->year)) . ") ORDER BY day_event DESC, start_time";
		$result = $this->db->db_query($query);
		$dateformatted = date("F j, Y", mktime(12,12,12,$this->month,$day,$this->year));
		
		header("Cache-control: no-cache");
		header("Expires: " . gmdate("D, d M Y H:i:s") . " GMT");
		echo "<HTML>\n";
		echo "<HEAD>\n";
		echo "<TITLE>" . $dateformatted . "</TITLE>\n";
		echo "</HEAD>\n";
		echo "<BODY>\n";
		echo "<b>Events for " . $dateformatted . "</b>";
		if($this->auth->checkLogin()) {
		  echo "<br><a href=\"calendar.php?display=admin&amp;task=add&amp;date=" . date("Y-m-d", mktime(12,12,12,$this->month,$day,$this->year)) . "\">add event</a>\n";
		}
    echo "<BR><HR>\n";
		if($this->db->db_numrows($result) == 0) {
			echo "No events for this date.\n";
		} else {
			while($row = $this->db->db_fetch_array($result)) {
				$start_time = strftime("%I:%M %p",strtotime($row["start_time"]));
				if($start_time{0} == '0') {
					$start_time = substr($start_time, 1);
				}
				$end_time = strftime("%I:%M %p",strtotime($row["end_time"]));
				if($end_time{0} == '0') {
					$end_time = substr($end_time, 1);
				}

        if ( isset($this->cat_array[$row['cat_id']]) ){
          $fgcolor = $this->cat_array[$row['cat_id']][1];
          $bgcolor = $this->cat_array[$row['cat_id']][2];
        }else{
          $fgcolor = $this->cat_fgcolor; 
          $bgcolor = $this->cat_bgcolor; 
        }

				echo "<table><tr><td bgcolor=\"".$bgcolor."\"><font color=\"".$fgcolor."\"><b>" . stripslashes($row["name"]) . "</b></font></td></tr></table>\n";
				if($this->auth->checkLogin()) {
					echo "<br><a href=\"calendar.php?display=admin&amp;task=edit&amp;id=" . $row["id"] . "\">edit</a>";
					echo "&nbsp;&nbsp;<a href=\"calendar.php?display=admin&amp;task=delete&amp;id=" . $row["id"] . "\">delete</a><BR>\n";
				}
				echo "<br>\n";
          if ( $row["day_event"] == 0 ){
				  echo $start_time . " - " . $end_time . "<br>\n";
          }else{
             echo "All day Event<br>\n";
          }
				echo nl2br(stripslashes($row["description"])) . "<BR>\n";
				echo "<HR>\n";
			}
		}
		echo "</BODY>\n";
		echo "</HTML>\n";
	} //end displayDay()
	
	function displayEvent($id, $date) {
		
		$query = "SELECT * FROM $this->calendar_table WHERE id=" . $id;
		$result = $this->db->db_query($query);
		$row = $this->db->db_fetch_array($result);
		$timestamp = strtotime($date);
		$dateformatted = date("F j, Y", $timestamp);
		$start_time = strftime("%I:%M %p",strtotime($row["start_time"]));
		if($start_time{0} == '0') {
			$start_time = substr($start_time, 1);
		}
		$end_time = strftime("%I:%M %p",strtotime($row["end_time"]));
		if($end_time{0} == '0') {
			$end_time = substr($end_time, 1);
		}
		header("Cache-control: no-cache");
		header("Expires: " . gmdate("D, d M Y H:i:s") . " GMT");
		echo "<HTML>\n";
		echo "<HEAD>\n";
		echo "<TITLE>" . $row["name"] . "</TITLE>\n";
		echo "</HEAD>\n";
		echo "<BODY>\n";

    if ( isset($this->cat_array[$row['cat_id']]) ){
      $fgcolor = $this->cat_array[$row['cat_id']][1];
      $bgcolor = $this->cat_array[$row['cat_id']][2];
    }else{
      $fgcolor = $this->cat_fgcolor; 
      $bgcolor = $this->cat_bgcolor; 
    }

		echo "<table><tr><td bgcolor=\"".$bgcolor."\"><font color=\"".$fgcolor."\"><b>" . stripslashes($row["name"]) . "</b></font></td></tr></table>\n";
		if($this->auth->checkLogin()) {
			echo "<br><a href=\"calendar.php?display=admin&amp;task=edit&amp;id=" . $row["id"] . "\">edit</a>";
			echo "&nbsp;&nbsp;<a href=\"calendar.php?display=admin&amp;task=delete&amp;id=" . $row["id"] . "\">delete event</a><BR><HR>\n";
		}
		echo "<br>\n";
		echo $dateformatted . "<br>\n";
     if  ( $row["day_event"]  == 0 ){
		  echo $start_time . " - " . $end_time . "<br>\n";
    }else{
      echo "All Day Event<br>\n";
    }
		echo nl2br(stripslashes($row["description"])) . "\n";
		echo "</BODY>\n";
		echo "</HTML>\n";
	} //end displayEvent()
	
	function deleteEvent($id) {
		if(!$this->auth->checkLogin()) {
			echo "You are not logged in!\n";
			return 0;
		}
		$query = "DELETE FROM $this->calendar_table WHERE id=\"" . $id . "\"";
		$this->db->db_query($query);
	} //end deleteEvent()
	
	function editEvent($id) {
		if(!$this->auth->checkLogin()) {
			echo "You are not logged in!\n";
			return 0;
		}
		$query = "SELECT * FROM $this->calendar_table WHERE id=\"" . $id . "\"";
		$result = $this->db->db_query($query);
		$row = $this->db->db_fetch_array($result);
		
		echo "<HTML>\n";
		echo "<HEAD>\n";
		echo "<TITLE>Edit Event</TITLE>\n";
		echo "</HEAD>\n";
		echo "<BODY>\n";
		echo "<FORM ACTION=\"calendar.php?display=admin&amp;task=adddone&amp;updateit=$id\" METHOD=\"POST\" name=\"\">\n";
		echo "Event Title:&nbsp;\n";
		echo "<INPUT type=\"text\" size=20 name=\"eName\" value=\"" . $row['name'] . "\"><BR>\n";
		$datearray = explode("-", $row['event_date']);
		echo "Date: (Start Date for recurring)<BR>\n";
		echo "<SELECT name=\"eYear\">\n";
		for($i = 2001; $i <= 2010; $i++) {
			if($i == (int)$datearray[0]) {
				echo "<OPTION VALUE=\"" . $i . "\" SELECTED>" . $i . "</OPTION>\n";
			} else {
				echo "<OPTION VALUE=\"" . $i . "\">" . $i . "</OPTION>\n";
			}
		}
		echo "</SELECT>\n";
		echo "<SELECT name=\"eMonth\">\n";
		for($i = 1; $i < 13; $i++) {
			if($i == (int)date("n",mktime(12,12,12,$datearray[1],1,2001))) {
				echo "<OPTION VALUE=\"" . $i . "\" SELECTED>" . $this->monthnames[$i] . "</OPTION>\n";
			} else {
				echo "<OPTION VALUE=\"" . $i . "\">" . $this->monthnames[$i] . "</OPTION>\n";
			}
		}
		echo "</SELECT>\n";
		echo "<SELECT name=\"eDay\">\n";
		for($i = 1; $i <= 31; $i++) {
			if($i ==  (int)$datearray[2]) {
				echo "<OPTION VALUE=\"" . $i . "\" SELECTED>" . $i . "</OPTION>\n";
			} else {
				echo "<OPTION VALUE=\"" . $i . "\">" . $i . "</OPTION>\n";
			}
		}
		echo "</SELECT><BR>\n";
		$timearray = explode(":", $row['start_time']);
		echo "Start Time:<BR>Hour:&nbsp;\n";
		echo "<SELECT name=\"eStartTimeHour\">\n";
		for($i = 1; $i <= 12; $i++) {
			if($i == (int)date("g",mktime($timearray[0],$timearray[1],0,$datearray[1],1,2001))) {
				echo "<OPTION VALUE=\"" . $i . "\" SELECTED>" . $i . "</OPTION>\n";
			} else {
				echo "<OPTION VALUE=\"" . $i . "\">" . $i . "</OPTION>\n";
			}
		}
		echo "</SELECT>\n";
		echo "Minutes:&nbsp;\n";
		echo "<SELECT name=\"eStartTimeMinute\">\n";
		for($i = 0; $i <= 45; $i = $i + 15) {
			if($i == (int)date("i",mktime($timearray[0],$timearray[1],0,$datearray[1],1,2001))) {
				echo "<OPTION VALUE=\"" . $i . "\" SELECTED>" . $i . "</OPTION>\n";
			} else {
				echo "<OPTION VALUE=\"" . $i . "\">" . $i . "</OPTION>\n";
			}
		}
		echo "</SELECT>\n";
		echo "<SELECT name=\"eStartTimeAMPM\">\n";
		if('AM' == date("A",mktime($timearray[0],$timearray[1],0,$datearray[1],1,2001))) {
			echo "<OPTION VALUE=\"AM\" SELECTED>AM</OPTION>\n";
		} else {
			echo "<OPTION VALUE=\"PM\">PM</OPTION>\n";
		}
		if('PM' == date("A",mktime($timearray[0],$timearray[1],0,$datearray[1],1,2001))) {
			echo "<OPTION VALUE=\"PM\" SELECTED>PM</OPTION>\n";
		} else {
			echo "<OPTION VALUE=\"PM\">PM</OPTION>\n";
		}
		echo "</SELECT><BR>\n";
		$timearray = explode(":", $row['end_time']);
		echo "End Time:<BR>Hour:&nbsp;\n";
		echo "<SELECT name=\"eEndTimeHour\">\n";
		for($i = 1; $i <= 12; $i++) {
			if($i == (int)date("g",mktime($timearray[0],$timearray[1],0,$datearray[1],1,2001))) {
				echo "<OPTION VALUE=\"" . $i . "\" SELECTED>" . $i . "</OPTION>\n";
			} else {
				echo "<OPTION VALUE=\"" . $i . "\">" . $i . "</OPTION>\n";
			}
		}
		echo "</SELECT>\n";
		echo "Minutes:&nbsp;\n";
		echo "<SELECT name=\"eEndTimeMinute\">\n";
		for($i = 0; $i <= 45;  $i = $i + 15) {
			if($i == (int)date("i",mktime($timearray[0],$timearray[1],0,$datearray[1],1,2001))) {
				echo "<OPTION VALUE=\"" . $i . "\" SELECTED>" . $i . "</OPTION>\n";
			} else {
				echo "<OPTION VALUE=\"" . $i . "\">" . $i . "</OPTION>\n";
			}
		}
		echo "</SELECT>\n";
		echo "<SELECT name=\"eEndTimeAMPM\">\n";
		if('AM' == date("A",mktime($timearray[0],$timearray[1],0,$datearray[1],1,2001))) {
			echo "<OPTION VALUE=\"AM\" SELECTED>AM</OPTION>\n";
		} else {
			echo "<OPTION VALUE=\"PM\">PM</OPTION>\n";
		}
		if('PM' == date("A",mktime($timearray[0],$timearray[1],0,$datearray[1],1,2001))) {
			echo "<OPTION VALUE=\"PM\" SELECTED>PM</OPTION>\n";
		} else {
			echo "<OPTION VALUE=\"PM\">PM</OPTION>\n";
		}
		echo "</SELECT><BR>\n";

    echo "Category:<br><select name=\"eCatId\">\n";
    foreach ( $this->cat_array as $key => $value ){
      echo "<option ";
      if ( $key == $row['cat_id'] ) echo "selected ";
      echo "value=\"".$key."\">".$value[0]."</option>\n";
    }
    echo "</select>\n";

		echo "<br>Description:<BR>\n";
		echo "<TEXTAREA NAME=\"eDescription\" ROWS=\"5\" COLS=\"30\">" . stripslashes($row['description']) . "</TEXTAREA><BR>\n";
		echo "Event recurs every week on this day:&nbsp;\n";
		echo "<INPUT type=\"checkbox\" name=\"eRecur\"";
		if($row['recurring'] == 1) {
			echo " checked=1";
		}
		echo "><BR>\n";
      echo "Event lasts all day: &nbsp;\n";
		echo "<INPUT type=\"checkbox\" name=\"eDayEvent\"";
		if($row['day_event'] == 1) {
			echo " checked=1";
		}
		echo "><BR>\n";
		echo "<INPUT type=\"submit\" name=\"submit\" value=\"Edit Event\">\n";
		echo "</FORM>\n";
		echo "</BODY>\n";
		echo "</HTML>\n";
}
	
	function addEvent($name = "0",$date = "0", $start_time = "0", $end_time = "0", $description = "0", $recurring = "0", $day_event = "0",$cat_id = "1",$updateit = 0){
		
		if(!$this->auth->checkLogin()) {
			echo "You are not logged in!\n";
			return 0;
		}
		if($name == "0") {
			echo "<HTML>\n";
			echo "<HEAD>\n";
			echo "<TITLE>Add Event</TITLE>\n";
			echo "</HEAD>\n";
			echo "<BODY>\n";
			echo "<FORM ACTION=\"calendar.php?display=admin&amp;task=adddone\" METHOD=\"POST\" name=\"\">\n";
			echo "Event Title:&nbsp;\n";
			echo "<INPUT type=\"text\" size=20 name=\"eName\"><BR>\n";
			if(!($date == "0")) {
				$datearray = explode("-", $date);
				echo "Date: (Start Date for recurring)<BR>\n";
				echo "<SELECT name=\"eYear\">\n";
				echo "<OPTION VALUE=\"" . $datearray[0] . "\" READONLY>" . $datearray[0] . "</OPTION>\n";
				echo "</SELECT>\n";
				echo "<SELECT name=\"eMonth\">\n";
				echo "<OPTION VALUE=\"" . $datearray[1] . "\" READONLY>" . strftime("%B",mktime(12,12,12,$datearray[1],1,2001)) . "</OPTION>\n";
				echo "</SELECT>\n";
				echo "<SELECT name=\"eDay\">\n";
				echo "<OPTION VALUE=\"" . $datearray[2] . "\" READONLY>" . $datearray[2] . "</OPTION>\n";
				echo "</SELECT><BR>\n";
			} else {
				$datearray = explode("-", date("Y-n-j"));
				echo "Date: (Start Date for recurring)<BR>\n";
				echo "<SELECT name=\"eYear\">\n";
				for($i = 2001; $i <= 2010; $i++) {
					if($i == (int)$datearray[0]) {
						echo "<OPTION VALUE=\"" . $i . "\" SELECTED>" . $i . "</OPTION>\n";
					} else {
						echo "<OPTION VALUE=\"" . $i . "\">" . $i . "</OPTION>\n";
					}
				}
				echo "</SELECT>\n";
				echo "<SELECT name=\"eMonth\">\n";
				for($i = 1; $i < 13; $i++) {
					if($i == (int)date("n",mktime(12,12,12,$datearray[1],1,2001))) {
						echo "<OPTION VALUE=\"" . $i . "\" SELECTED>" . $this->monthnames[$i] . "</OPTION>\n";
					} else {
						echo "<OPTION VALUE=\"" . $i . "\">" . $this->monthnames[$i] . "</OPTION>\n";
					}
				}
				echo "</SELECT>\n";
				echo "<SELECT name=\"eDay\">\n";
				for($i = 1; $i <= 31; $i++) {
					if($i ==  (int)$datearray[2]) {
						echo "<OPTION VALUE=\"" . $i . "\" SELECTED>" . $i . "</OPTION>\n";
					} else {
						echo "<OPTION VALUE=\"" . $i . "\">" . $i . "</OPTION>\n";
					}
				}
				echo "</SELECT><BR>\n";
			}
			echo "Start Time:<BR>Hour:&nbsp;\n";
			echo "<SELECT name=\"eStartTimeHour\">\n";
			for($i = 1; $i <= 12; $i++) {
				echo "<OPTION VALUE=\"" . $i . "\"";
        if ( $i == $this->start_hour ) echo " SELECTED";
        echo ">" . $i . "</OPTION>\n";
			}
			echo "</SELECT>\n";
			echo "Minutes:&nbsp;\n";
			echo "<SELECT name=\"eStartTimeMinute\">\n";
			for($i = 0; $i <= 45; $i = $i + 15) {
				echo "<OPTION VALUE=\"" . $i . "\"";
        if ( $i == $this->start_min ) echo " SELECTED";  
        echo ">" . $i . "</OPTION>\n";
			}
			echo "</SELECT>\n";
			echo "<SELECT name=\"eStartTimeAMPM\">\n";
			echo "<OPTION VALUE=\"AM\"";
      if ( $this->start_ampm == "AM" ) echo " SELECTED";
      echo ">AM</OPTION>\n";
			echo "<OPTION VALUE=\"PM\"";
      if ( $this->start_ampm == "PM" ) echo " SELECTED";
      echo ">PM</OPTION>\n";
			echo "</SELECT><BR>\n";
			echo "End Time:<BR>Hour:&nbsp;\n";
			echo "<SELECT name=\"eEndTimeHour\">\n";
			for($i = 1; $i <= 12; $i++) {
				echo "<OPTION VALUE=\"" . $i . "\"";
        if ( $i == $this->end_hour ) echo " SELECTED";  
        echo ">" . $i . "</OPTION>\n";
			}
			echo "</SELECT>\n";
			echo "Minutes:&nbsp;\n";
			echo "<SELECT name=\"eEndTimeMinute\">\n";
			for($i = 0; $i <= 45;  $i = $i + 15) {
				echo "<OPTION VALUE=\"" . $i . "\"";
        if ( $i == $this->end_min ) echo " SELECTED";  
        echo ">" . $i . "</OPTION>\n";
			}
			echo "</SELECT>\n";
			echo "<SELECT name=\"eEndTimeAMPM\">\n";
			echo "<OPTION VALUE=\"AM\"";
      if ( $this->end_ampm == "AM" ) echo " SELECTED";
      echo ">AM</OPTION>\n";
			echo "<OPTION VALUE=\"PM\"";
      if ( $this->end_ampm == "PM" ) echo " SELECTED";
      echo ">PM</OPTION>\n";
			echo "</SELECT><BR>\n";

      echo "Category:<br><select name=\"eCatId\">\n";
      foreach ( $this->cat_array as $key => $value ){
        echo "<option ";
        echo "value=\"".$key."\">".$value[0]."</option>\n";
      }
      echo "</select>\n";

			echo "<br>Description:<BR>\n";
			echo "<TEXTAREA NAME=\"eDescription\" ROWS=\"5\" COLS=\"30\"></TEXTAREA><BR>\n";
			echo "Event recurs every week on this day:&nbsp;\n";
			echo "<INPUT type=\"checkbox\" name=\"eRecur\"><BR>\n";
      echo "Event lasts all day: &nbsp;\n";
      echo "<INPUT type=\"checkbox\" name=\"eDayEvent\"><BR>\n";
			echo "<INPUT type=\"submit\" name=\"submit\" value=\"Add Event\">\n";
			echo "</FORM>\n";
			echo "</BODY>\n";
			echo "</HTML>\n";
		} else {
			if($recurring == 1) {
				$dayofweek = $this->_dayOfWeek(strtotime($date));
			} else {
				$dayofweek = -1;
			}
			if($updateit != 0) {
				$query = "UPDATE $this->calendar_table SET name='" . strip_tags($name) . "', event_date='" . $date . "',start_time='" . $start_time . ":00',end_time='" . $end_time . ":00',description='" . strip_tags($description,'<a><b><i><u>') . "',recurring=" . $recurring . ",recur_dayofweek=" . $dayofweek . ", day_event=" . $day_event . ",cat_id=". $cat_id . " WHERE id=$updateit";
			} else {
				$query = "INSERT $this->calendar_table VALUES('', '" . strip_tags($name) . "', '" . $date . "', '" . $start_time . ":00', '" . $end_time . ":00', '" . strip_tags($description,'<a><b><i><u>') . "', " . $recurring . ", " . $dayofweek . "," . $day_event . "," . $cat_id . ")";
			}			
			$this->db->db_query($query);
		}
	} //end addEvent()
			
	function _dayOfWeek($timestamp) { 
		return intval(strftime("%w",$timestamp));
	} 

	function _daysInMonth() {  
		for($thisDay = 1; checkdate($this->month,$thisDay,$this->year); $thisDay++);
		$thisDay--;
		return $thisDay; 
	} 

	function _firstDayOfMonth($timestamp) {  
		return $this->_dayOfWeek(mktime( 12, 12, 12, $this->month, 1, $this->year)); 
	} 


} //end class ltwCalendar

function decho($text = NULL){
  echo "<br><b>dbug:</b> ".$text."<br>";
}
?>
